/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.FilterUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.jsieve.parser.SieveNode;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.Node;

public abstract class SieveVisitor {
    private static final Set<String> RULE_NODE_NAMES;

    protected void visitNode(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitRule(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitTest(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitAction(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitHeaderTest(Node node, VisitPhase phase, RuleProperties props, String header, FilterUtil.StringComparison comparison, String value) throws ServiceException {
    }

    protected void visitHeaderExistsTest(Node node, VisitPhase phase, RuleProperties props, String header) throws ServiceException {
    }

    protected void visitSizeTest(Node node, VisitPhase phase, RuleProperties props, FilterUtil.NumberComparison comparison, int size, String sizeString) throws ServiceException {
    }

    protected void visitDateTest(Node node, VisitPhase phase, RuleProperties props, FilterUtil.DateComparison comparison, Date date) throws ServiceException {
    }

    protected void visitAddressBookTest(Node node, VisitPhase phase, RuleProperties props, String header, String folderPath) throws ServiceException {
    }

    protected void visitBodyTest(Node node, VisitPhase phase, RuleProperties props, String value) throws ServiceException {
    }

    protected void visitAttachmentTest(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitInviteTest(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitKeepAction(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitDiscardAction(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    protected void visitFileIntoAction(Node node, VisitPhase phase, RuleProperties props, String folderPath) throws ServiceException {
    }

    protected void visitFlagAction(Node node, VisitPhase phase, RuleProperties props, FilterUtil.Flag flag) throws ServiceException {
    }

    protected void visitTagAction(Node node, VisitPhase phase, RuleProperties props, String tagName) throws ServiceException {
    }

    protected void visitRedirectAction(Node node, VisitPhase phase, RuleProperties props, String address) throws ServiceException {
    }

    protected void visitStopAction(Node node, VisitPhase phase, RuleProperties props) throws ServiceException {
    }

    public void accept(Node node) throws ServiceException {
        this.accept(node, null);
    }

    private void accept(Node parent, RuleProperties props) throws ServiceException {
        this.visitNode(parent, VisitPhase.begin, props);
        int numChildren = parent.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            Node node = parent.jjtGetChild(i);
            if (this.isRuleNode(node)) {
                RuleProperties newProps = new RuleProperties();
                if ("disabled_if".equals(this.getNodeName(node))) {
                    newProps.isEnabled = false;
                }
                newProps.condition = this.getCondition(this.getNode(node, 0, 0));
                this.visitRule(node, VisitPhase.begin, newProps);
                this.accept(node, newProps);
                this.visitRule(node, VisitPhase.end, newProps);
                continue;
            }
            if (node instanceof ASTtest) {
                this.acceptTest(node, props);
                continue;
            }
            if (node instanceof ASTcommand) {
                this.acceptAction(node, props);
                continue;
            }
            this.accept(node, props);
        }
        this.visitNode(parent, VisitPhase.end, props);
    }

    private FilterUtil.Condition getCondition(Node node) {
        if (!(node instanceof ASTtest)) {
            return FilterUtil.Condition.allof;
        }
        String name = this.getNodeName(node);
        if ("anyof".equals(name)) {
            return FilterUtil.Condition.anyof;
        }
        return FilterUtil.Condition.allof;
    }

    private void acceptTest(Node node, RuleProperties props) throws ServiceException {
        this.visitTest(node, VisitPhase.begin, props);
        String nodeName = this.getNodeName(node);
        if ("not".equals(nodeName)) {
            props.isNegativeTest = true;
            this.accept(node, props);
        } else if ("allof".equals(nodeName) || "anyof".equals(nodeName)) {
            this.accept(node, props);
        } else if ("header".equals(nodeName)) {
            String s = this.stripLeadingColon(this.getValue(node, 0, 0));
            FilterUtil.StringComparison comparison = FilterUtil.StringComparison.fromString(s);
            String header = this.getValue(node, 0, 1, 0, 0);
            String value = this.getValue(node, 0, 2, 0, 0);
            this.visitHeaderTest(node, VisitPhase.begin, props, header, comparison, value);
            this.accept(node, props);
            this.visitHeaderTest(node, VisitPhase.end, props, header, comparison, value);
        } else if ("exists".equals(nodeName)) {
            String header = this.getValue(node, 0, 0, 0, 0);
            this.visitHeaderExistsTest(node, VisitPhase.begin, props, header);
            this.accept(node, props);
            this.visitHeaderExistsTest(node, VisitPhase.end, props, header);
        } else if ("size".equals(nodeName)) {
            String s = this.stripLeadingColon(this.getValue(node, 0, 0));
            FilterUtil.NumberComparison comparison = FilterUtil.NumberComparison.fromString(s);
            SieveNode sizeNode = (SieveNode)this.getNode(node, 0, 1);
            String sizeString = sizeNode.getFirstToken().toString();
            int size = 0;
            try {
                size = FilterUtil.parseSize(sizeString);
            }
            catch (NumberFormatException e) {
                throw ServiceException.INVALID_REQUEST("Invalid size value " + sizeString, e);
            }
            this.visitSizeTest(node, VisitPhase.begin, props, comparison, size, sizeString);
            this.accept(node, props);
            this.visitSizeTest(node, VisitPhase.end, props, comparison, size, sizeString);
        } else if ("date".equals(nodeName)) {
            String s = this.stripLeadingColon(this.getValue(node, 0, 0));
            FilterUtil.DateComparison comparison = FilterUtil.DateComparison.fromString(s);
            String dateString = this.getValue(node, 0, 1, 0, 0);
            Date date = FilterUtil.SIEVE_DATE_PARSER.parse(dateString);
            if (date == null) {
                throw ServiceException.PARSE_ERROR("Invalid date value: " + dateString, null);
            }
            this.visitDateTest(node, VisitPhase.begin, props, comparison, date);
            this.accept(node, props);
            this.visitDateTest(node, VisitPhase.end, props, comparison, date);
        } else if ("body".equals(nodeName)) {
            String value = this.getValue(node, 0, 1, 0, 0);
            this.visitBodyTest(node, VisitPhase.begin, props, value);
            this.accept(node, props);
            this.visitBodyTest(node, VisitPhase.end, props, value);
        } else if ("attachment".equals(nodeName)) {
            this.visitAttachmentTest(node, VisitPhase.begin, props);
            this.accept(node, props);
            this.visitAttachmentTest(node, VisitPhase.end, props);
        } else if ("addressbook".equals(nodeName)) {
            String header = this.getValue(node, 0, 1, 0, 0);
            String folderPath = this.getValue(node, 0, 2, 0, 0);
            this.visitAddressBookTest(node, VisitPhase.begin, props, header, folderPath);
            this.accept(node, props);
            this.visitAddressBookTest(node, VisitPhase.end, props, header, folderPath);
        } else if ("invite".equals(nodeName)) {
            this.visitInviteTest(node, VisitPhase.begin, props);
            this.accept(node, props);
            this.visitAttachmentTest(node, VisitPhase.end, props);
        } else {
            ZimbraLog.filter.debug("Ignoring unrecognized test type '%s'.", nodeName);
            this.accept(node, props);
        }
        this.visitTest(node, VisitPhase.end, props);
    }

    private void acceptAction(Node node, RuleProperties props) throws ServiceException {
        this.visitAction(node, VisitPhase.begin, props);
        String nodeName = this.getNodeName(node);
        if ("keep".equals(nodeName)) {
            this.visitKeepAction(node, VisitPhase.begin, props);
            this.accept(node, props);
            this.visitKeepAction(node, VisitPhase.end, props);
        } else if ("discard".equals(nodeName)) {
            this.visitDiscardAction(node, VisitPhase.begin, props);
            this.accept(node, props);
            this.visitDiscardAction(node, VisitPhase.end, props);
        } else if ("fileinto".equals(nodeName)) {
            String folderPath = this.getValue(node, 0, 0, 0, 0);
            this.visitFileIntoAction(node, VisitPhase.begin, props, folderPath);
            this.accept(node, props);
            this.visitFileIntoAction(node, VisitPhase.end, props, folderPath);
        } else if ("flag".equals(nodeName)) {
            String s = this.getValue(node, 0, 0, 0, 0);
            FilterUtil.Flag flag = FilterUtil.Flag.fromString(s);
            this.visitFlagAction(node, VisitPhase.begin, props, flag);
            this.accept(node, props);
            this.visitFlagAction(node, VisitPhase.end, props, flag);
        } else if ("tag".equals(nodeName)) {
            String tagName = this.getValue(node, 0, 0, 0, 0);
            this.visitTagAction(node, VisitPhase.begin, props, tagName);
            this.accept(node, props);
            this.visitTagAction(node, VisitPhase.end, props, tagName);
        } else if ("redirect".equals(nodeName)) {
            String address = this.getValue(node, 0, 0, 0, 0);
            this.visitRedirectAction(node, VisitPhase.begin, props, address);
            this.accept(node, props);
            this.visitRedirectAction(node, VisitPhase.end, props, address);
        } else if ("stop".equals(nodeName)) {
            this.visitStopAction(node, VisitPhase.begin, props);
            this.accept(node, props);
            this.visitStopAction(node, VisitPhase.end, props);
        } else {
            this.accept(node, props);
        }
        this.visitAction(node, VisitPhase.end, props);
    }

    private String getNodeName(Node node) {
        if (node == null || !(node instanceof SieveNode)) {
            return null;
        }
        String name = ((SieveNode)node).getName();
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }

    protected Node getNode(Node parent, int ... indexes) throws ServiceException {
        Node node = parent;
        for (int i = 0; i < indexes.length; ++i) {
            if (node.jjtGetNumChildren() == 0) {
                throw ServiceException.PARSE_ERROR("Subnode " + i + " has no children.", null);
            }
            if (indexes[i] >= node.jjtGetNumChildren()) {
                throw ServiceException.PARSE_ERROR("Subnode " + i + " has " + node.jjtGetNumChildren() + " children." + "  Requested child " + indexes[i] + ".", null);
            }
            node = node.jjtGetChild(indexes[i]);
        }
        return node;
    }

    private String getValue(Node parent, int ... indexes) throws ServiceException {
        Node child = this.getNode(parent, indexes);
        Object value = ((SieveNode)child).getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            value = FilterUtil.unescape(this.stripQuotes((String)value));
        }
        return value.toString();
    }

    private String stripLeadingColon(String s) {
        if (s == null || s.length() == 0 || s.charAt(0) != ':') {
            return s;
        }
        return s.substring(1, s.length());
    }

    private String stripQuotes(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int idxStart = s.charAt(0) == '\"' ? 1 : 0;
        int idxEnd = s.charAt(s.length() - 1) == '\"' ? s.length() - 1 : s.length();
        return s.substring(idxStart, idxEnd);
    }

    private boolean isRuleNode(Node node) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof ASTcommand)) {
            return false;
        }
        String name = this.getNodeName(node);
        return RULE_NODE_NAMES.contains(name);
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("if");
        names.add("disabled_if");
        RULE_NODE_NAMES = Collections.unmodifiableSet(names);
    }

    public class RuleProperties {
        boolean isEnabled = true;
        boolean isNegativeTest = false;
        FilterUtil.Condition condition = FilterUtil.Condition.allof;
        Node testNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum VisitPhase {
        begin,
        end;

    }
}

