/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.filter.SieveVisitor;
import java.util.Date;
import java.util.List;
import org.apache.jsieve.parser.generated.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SieveToSoap
extends SieveVisitor {
    private Element mRoot;
    private List<String> mRuleNames;
    private Element mCurrentRule;
    private int mCurrentRuleIndex = 0;

    public SieveToSoap(Element.ElementFactory factory, List<String> ruleNames) {
        this.mRoot = factory.createElement("filterRules");
        this.mRuleNames = ruleNames;
    }

    public Element getRootElement() {
        return this.mRoot;
    }

    @Override
    protected void visitRule(Node ruleNode, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) {
        if (phase == SieveVisitor.VisitPhase.end) {
            return;
        }
        this.mCurrentRule = this.mRoot.addElement("filterRule");
        String name = this.getCurrentRuleName();
        if (name != null) {
            this.mCurrentRule.addAttribute("name", name);
        }
        this.mCurrentRule.addAttribute("active", props.isEnabled);
        Element filterTests = this.mCurrentRule.addElement("filterTests");
        filterTests.addAttribute("condition", props.condition.toString());
        this.mCurrentRule.addElement("filterActions");
        ++this.mCurrentRuleIndex;
    }

    private Element addTest(String elementName, SieveVisitor.RuleProperties props) throws ServiceException {
        Element tests = this.mCurrentRule.getElement("filterTests");
        int index = tests.listElements().size();
        Element test = tests.addElement(elementName);
        if (props.isNegativeTest) {
            test.addAttribute("negative", "1");
        }
        test.addAttribute("index", index);
        return test;
    }

    private Element addAction(String elementName) throws ServiceException {
        Element actions = this.mCurrentRule.getElement("filterActions");
        int index = actions.listElements().size();
        Element action = actions.addElement(elementName);
        action.addAttribute("index", Integer.toString(index));
        return action;
    }

    @Override
    protected void visitAttachmentTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addTest("attachmentTest", props);
        }
    }

    @Override
    protected void visitBodyTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String value) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addTest("bodyTest", props).addAttribute("value", value);
        }
    }

    @Override
    protected void visitDateTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, FilterUtil.DateComparison comparison, Date date) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            Element test = this.addTest("dateTest", props);
            test.addAttribute("dateComparison", comparison.toString());
            test.addAttribute("d", date.getTime() / 1000L);
        }
    }

    @Override
    protected void visitHeaderExistsTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String header) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            Element test = this.addTest("headerExistsTest", props);
            test.addAttribute("header", header);
        }
    }

    @Override
    protected void visitHeaderTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String header, FilterUtil.StringComparison comparison, String value) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            Element test = this.addTest("headerTest", props);
            test.addAttribute("header", header);
            test.addAttribute("stringComparison", comparison.toString());
            test.addAttribute("value", value);
        }
    }

    @Override
    protected void visitSizeTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, FilterUtil.NumberComparison comparison, int size, String sizeString) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            Element test = this.addTest("sizeTest", props);
            test.addAttribute("numberComparison", comparison.toString());
            test.addAttribute("s", sizeString);
        }
    }

    @Override
    protected void visitAddressBookTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String header, String folderPath) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            Element test = this.addTest("addressBookTest", props);
            test.addAttribute("header", header);
            test.addAttribute("folderPath", folderPath);
        }
    }

    @Override
    protected void visitInviteTest(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addTest("inviteTest", props);
        }
    }

    private String getCurrentRuleName() {
        if (this.mRuleNames == null || this.mCurrentRuleIndex >= this.mRuleNames.size()) {
            return null;
        }
        return this.mRuleNames.get(this.mCurrentRuleIndex);
    }

    @Override
    protected void visitDiscardAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionDiscard");
        }
    }

    @Override
    protected void visitFileIntoAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String folderPath) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionFileInto").addAttribute("folderPath", folderPath);
        }
    }

    @Override
    protected void visitFlagAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, FilterUtil.Flag flag) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionFlag").addAttribute("flagName", flag.toString());
        }
    }

    @Override
    protected void visitKeepAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionKeep");
        }
    }

    @Override
    protected void visitRedirectAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String address) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionRedirect").addAttribute("a", address);
        }
    }

    @Override
    protected void visitStopAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionStop");
        }
    }

    @Override
    protected void visitTagAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String tagName) throws ServiceException {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.addAction("actionTag").addAttribute("tagName", tagName);
        }
    }
}

