/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.RuleRewriter;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.List;
import org.apache.jsieve.parser.generated.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleRewriterFactory {
    private static RuleRewriterFactory instance = null;

    RuleRewriterFactory() {
    }

    static synchronized RuleRewriterFactory getInstance() {
        if (instance == null) {
            String className = LC.zimbra_class_rulerewriterfactory.value();
            if (className != null && !className.equals("")) {
                try {
                    instance = (RuleRewriterFactory)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    ZimbraLog.filter.error((Object)("could not instantiate RuleRewriterFactory interface of class '" + className + "'; defaulting to RuleRewriterFactory"), e);
                }
            }
            if (instance == null) {
                instance = new RuleRewriterFactory();
            }
        }
        return instance;
    }

    RuleRewriter createRuleRewriter() {
        return new RuleRewriter();
    }

    RuleRewriter createRuleRewriter(Element.ElementFactory factory, Node node, List<String> ruleNames) {
        RuleRewriter rrw = this.createRuleRewriter();
        rrw.initialize(factory, node, ruleNames);
        return rrw;
    }

    RuleRewriter createRuleRewriter(Element eltRules, Mailbox mbox) {
        RuleRewriter rrw = this.createRuleRewriter();
        rrw.initialize(eltRules, mbox);
        return rrw;
    }
}

