/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jsieve.parser.SieveNode;
import org.apache.jsieve.parser.generated.ASTargument;
import org.apache.jsieve.parser.generated.ASTcommand;
import org.apache.jsieve.parser.generated.ASTstring;
import org.apache.jsieve.parser.generated.ASTstring_list;
import org.apache.jsieve.parser.generated.ASTtest;
import org.apache.jsieve.parser.generated.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRewriter {
    static final Set<String> MATCH_TYPES = new HashSet<String>();
    private Stack<String> mStack = new Stack();
    private Element mRoot;
    private List<String> mRuleNames;
    private Mailbox mMailbox;
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final char PARAM_PREFIX;
    private int x = 0;
    private static final Pattern PAT_BRACKET_QUOTES;
    private static final Pattern PAT_QUOTES;

    RuleRewriter() {
    }

    void initialize(Element.ElementFactory factory, Node node, List<String> ruleNames) {
        this.mRoot = factory.createElement("rules");
        this.mRuleNames = ruleNames;
        this.traverse(node);
    }

    void initialize(Element eltRules, Mailbox mbox) {
        this.mRoot = eltRules;
        this.mMailbox = mbox;
    }

    Element getElement() {
        return this.mRoot;
    }

    private void traverse(Node node) {
        int numChildren = node.jjtGetNumChildren();
        int nameIndex = 0;
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = node.jjtGetChild(i);
            String name = ((SieveNode)childNode).getName();
            if (childNode instanceof ASTcommand && ("if".equals(name) || "elsif".equals(name) || "disabled_if".equals(name))) {
                String ruleName = "";
                if (this.mRuleNames != null && nameIndex < this.mRuleNames.size()) {
                    ruleName = this.mRuleNames.get(nameIndex);
                    ++nameIndex;
                }
                Element ruleElem = this.mRoot.addElement("r").addAttribute("name", ruleName);
                ruleElem.addAttribute("active", !"disabled_if".equals(name));
                this.rule(ruleElem, childNode);
                continue;
            }
            this.traverse(childNode);
        }
    }

    private void rule(Element elem, Node parent) {
        int numChildren = parent.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            Node node = parent.jjtGetChild(i);
            String name = ((SieveNode)node).getName();
            if (node instanceof ASTtest) {
                if ("anyof".equals(name) || "allof".equals(name)) {
                    Element condsElem = elem.addElement("g").addAttribute("op", name);
                    this.rule(condsElem, node);
                    continue;
                }
                if ("not".equals(name)) {
                    this.mStack.push(name);
                    this.rule(elem, node);
                    continue;
                }
                if ("exists".equals(name) && !this.mStack.isEmpty()) {
                    name = this.mStack.pop() + " " + name;
                }
                Element cElem = elem.addElement("c").addAttribute("name", name);
                this.x = 0;
                this.test(cElem, node);
                continue;
            }
            if (node instanceof ASTcommand) {
                Element actionElem = elem.addElement("action").addAttribute("name", ((SieveNode)node).getName());
                this.action(actionElem, node);
                continue;
            }
            this.rule(elem, node);
        }
    }

    private void test(Element elem, Node node) {
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            String cname;
            List<Object> val;
            Node childNode = node.jjtGetChild(i);
            if (childNode instanceof ASTargument) {
                val = ((SieveNode)childNode).getValue();
                if (val != null) {
                    if (MATCH_TYPES.contains(val.toString())) {
                        if (!this.mStack.isEmpty()) {
                            val = this.mStack.pop() + " " + val;
                        }
                        elem.addAttribute("op", val.toString());
                    } else {
                        cname = elem.getAttribute("name", null);
                        if ("size".equals(cname)) {
                            elem.addAttribute("k1", this.getSize(val.toString()));
                        } else {
                            elem.addAttribute("mod", val.toString());
                        }
                    }
                }
            } else if (childNode instanceof ASTstring_list) {
                val = this.getStringList(childNode);
                cname = elem.getAttribute("name", null);
                String param = null;
                param = "date".equals(cname) || "body".equals(cname) ? "k1" : PARAM_PREFIX + String.valueOf(this.x++);
                elem.addAttribute(param, RuleRewriter.toString(val));
            }
            this.test(elem, childNode);
        }
    }

    private static String toString(List<Object> list) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (list != null) {
            boolean isFirst = true;
            for (Object val : list) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                String sVal = String.valueOf(val);
                if (val == null) {
                    buf.append(sVal);
                    continue;
                }
                if (!sVal.startsWith("\"")) {
                    buf.append('\"');
                }
                buf.append(sVal);
                if (sVal.endsWith("\"")) continue;
                buf.append('\"');
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private String getSize(String szStr) {
        int sz = Integer.parseInt(szStr);
        if (sz % 0x100000 == 0) {
            return sz / 0x100000 + "M";
        }
        if (sz % 1024 == 0) {
            return sz / 1024 + "K";
        }
        return szStr + "B";
    }

    private List<Object> getStringList(Node node) {
        int n = node.jjtGetNumChildren();
        ArrayList<Object> a = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Node cn = node.jjtGetChild(i);
            a.add(((SieveNode)cn).getValue());
        }
        return a;
    }

    private void action(Element elem, Node node) {
        int numChildren = node.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            Node childNode = node.jjtGetChild(i);
            if (childNode instanceof ASTstring) {
                String val = ((SieveNode)childNode).getValue().toString();
                if (val.startsWith("text:")) {
                    elem.addText(val.substring(5));
                    continue;
                }
                StringBuilder buf = new StringBuilder();
                if (!val.startsWith("\"")) {
                    buf.append('\"');
                }
                buf.append(val);
                if (!val.endsWith("\"")) {
                    buf.append('\"');
                }
                elem.addElement("arg").setText(buf.toString());
                continue;
            }
            this.action(elem, childNode);
        }
    }

    public static void sanitizeRules(Element element) throws ServiceException {
        if (element == null) {
            return;
        }
        for (Element child : element.listElements()) {
            RuleRewriter.sanitizeRules(child);
        }
        if (element.getName().equals("c")) {
            String k1;
            String k0 = element.getAttribute("k0", null);
            if (k0 != null) {
                element.addAttribute("k0", RuleRewriter.stripBracketsAndQuotes(k0));
            }
            if ((k1 = element.getAttribute("k1", null)) != null) {
                element.addAttribute("k1", RuleRewriter.stripBracketsAndQuotes(k1));
            }
        } else if (element.getName().equals("arg")) {
            element.setText(RuleRewriter.stripBracketsAndQuotes(element.getText()));
        }
    }

    public String getScript() throws ServiceException {
        StringBuffer sb = new StringBuffer();
        this.traverse(sb, this.mRoot);
        String script = sb.toString();
        if (script.trim().length() > 0) {
            script = "require [\"fileinto\", \"reject\", \"tag\", \"flag\"];\n\n" + script;
        }
        return script;
    }

    private void traverse(StringBuffer sb, Element element) throws ServiceException {
        Iterator<Element> it = element.elementIterator();
        while (it.hasNext()) {
            Element subnode = it.next();
            String nodeName = subnode.getName();
            if ("r".equals(nodeName)) {
                String ruleName = subnode.getAttribute("name");
                sb.append("# " + ruleName + "\n");
                boolean active = subnode.getAttributeBool("active", true);
                sb.append(active ? "if " : "disabled_if ");
                this.condition(sb, subnode, false, ruleName);
                continue;
            }
            this.traverse(sb, subnode);
        }
    }

    private void condition(StringBuffer sb, Element element, boolean group, String ruleName) throws ServiceException {
        boolean actionOpenBrace = false;
        boolean firstConditionInGroup = true;
        Iterator<Element> it = element.elementIterator();
        while (it.hasNext()) {
            Element subnode = it.next();
            String nodeName = subnode.getName();
            if ("g".equals(nodeName)) {
                if (!firstConditionInGroup) {
                    sb.append(", ");
                } else {
                    firstConditionInGroup = false;
                }
                sb.append(subnode.getAttribute("op")).append(" (");
                this.condition(sb, subnode, true, ruleName);
                sb.append(")\n");
                continue;
            }
            if ("c".equals(nodeName)) {
                if (group) {
                    if (!firstConditionInGroup) {
                        sb.append(",\n ");
                    } else {
                        firstConditionInGroup = false;
                    }
                }
                String testName = subnode.getAttribute("name");
                boolean isSize = "size".equals(testName);
                String op = subnode.getAttribute("op", null);
                if (op != null && op.startsWith("not")) {
                    testName = "not " + testName;
                    op = op.substring(3).trim();
                }
                sb.append(testName).append(" ");
                if (op != null) {
                    sb.append(op).append(" ");
                }
                String k0 = subnode.getAttribute("k0", null);
                this.checkValue(k0, ruleName);
                if (k0 != null) {
                    sb.append("\"").append(k0).append("\"").append(" ");
                }
                String k1 = subnode.getAttribute("k1", null);
                this.checkValue(k1, ruleName);
                if (k1 != null) {
                    if (!isSize) {
                        sb.append("\"");
                    }
                    sb.append(k1);
                    if (!isSize) {
                        sb.append("\"");
                    }
                }
                sb.append(" ");
                if (!":matches".equals(op) || k1 == null || !k1.contains("*****")) continue;
                throw ServiceException.INVALID_REQUEST("Wildcard match value cannot contain more than four asterisks in a row.", null);
            }
            if (!"action".equals(nodeName)) continue;
            if (!actionOpenBrace) {
                sb.append("{\n");
                actionOpenBrace = true;
            }
            String actionName = subnode.getAttribute("name");
            sb.append("    ").append(actionName);
            this.action(sb, actionName, subnode, ruleName);
        }
        if (actionOpenBrace) {
            sb.append("}\n");
        }
    }

    public static String stripBracketsAndQuotes(String s) {
        if (s != null) {
            Matcher matcher = PAT_BRACKET_QUOTES.matcher(s);
            if (matcher.matches()) {
                s = matcher.group(1);
            } else {
                matcher = PAT_QUOTES.matcher(s);
                if (matcher.matches()) {
                    s = matcher.group(1);
                }
            }
        }
        return s;
    }

    private void checkValue(String k, String ruleName) throws ServiceException {
        if (k == null) {
            return;
        }
        if (k.contains("\"")) {
            String msg = String.format("Doublequote not allowed for value '%s' in filter rule %s", k, ruleName);
            throw ServiceException.INVALID_REQUEST(msg, null);
        }
        if (k.contains("\\")) {
            String msg = String.format("Backslash not allowed for value '%s' in filter rule %s", k, ruleName);
            throw ServiceException.INVALID_REQUEST(msg, null);
        }
    }

    void action(StringBuffer sb, String actionName, Element element, String ruleName) throws ServiceException {
        Iterator<Element> it = element.elementIterator("arg");
        while (it.hasNext()) {
            Element subnode = it.next();
            String argVal = subnode.getText();
            if ("fileinto".equals(actionName)) {
                this.createFolderIfNecessary(argVal, ruleName);
            } else if ("tag".equals(actionName)) {
                try {
                    this.mMailbox.getTagByName(argVal);
                }
                catch (MailServiceException.NoSuchItemException e) {
                    this.mMailbox.createTag(null, argVal, (byte)0);
                    ZimbraLog.filter.info("Created tag " + argVal + " referenced in rule \"" + ruleName + "\"");
                }
            }
            sb.append(" \"").append(argVal).append("\"");
        }
        sb.append(";\n");
    }

    private void createFolderIfNecessary(String path, String ruleName) throws ServiceException {
        Pair<Folder, String> folderAndRemotePath = this.mMailbox.getFolderByPathLongestMatch(null, 1, path);
        Folder folder = folderAndRemotePath.getFirst();
        String remotePath = folderAndRemotePath.getSecond();
        if (StringUtil.isNullOrEmpty(remotePath)) {
            remotePath = null;
        }
        if (folder instanceof Mountpoint && remotePath != null) {
            String[] pathElements;
            Mountpoint mountpoint = (Mountpoint)folder;
            ZimbraLog.filter.info("Creating folder %s in remote folder %s for rule %s.", remotePath, folder.getPath(), ruleName);
            ZMailbox remoteMbox = FilterUtil.getRemoteZMailbox(this.mMailbox, (Mountpoint)folder);
            ItemId id = mountpoint.getTarget();
            ZFolder parent = remoteMbox.getFolderById(id.toString());
            if (parent == null) {
                String msg = String.format("Could not find folder with id %d in remote mailbox %s.", mountpoint.getRemoteId(), mountpoint.getOwnerId());
                throw ServiceException.FAILURE(msg, null);
            }
            for (String folderName : pathElements = remotePath.split("/")) {
                if (StringUtil.isNullOrEmpty(folderName)) continue;
                ZFolder currentFolder = parent.getSubFolderByPath(folderName);
                parent = currentFolder != null ? currentFolder : remoteMbox.createFolder(parent.getId(), folderName, ZFolder.View.message, null, null, null);
            }
        } else if (remotePath != null) {
            ZimbraLog.filter.info("Creating folder %s for rule %s.", path, ruleName);
            this.mMailbox.createFolder(null, path, (byte)0, (byte)5);
        }
    }

    static {
        MATCH_TYPES.add(":is");
        MATCH_TYPES.add(":contains");
        MATCH_TYPES.add(":matches");
        MATCH_TYPES.add(":over");
        MATCH_TYPES.add(":under");
        MATCH_TYPES.add(":in");
        MATCH_TYPES.add(":before");
        MATCH_TYPES.add(":after");
        PARAM_PREFIX = "k0".charAt(0);
        PAT_BRACKET_QUOTES = Pattern.compile("\\[\"(.*)\"\\]");
        PAT_QUOTES = Pattern.compile("\"(.*)\"");
    }
}

