/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.filter.DummyMailAdapter;
import com.zimbra.cs.filter.ExistingMessageHandler;
import com.zimbra.cs.filter.FolderRenamer;
import com.zimbra.cs.filter.IncomingMessageHandler;
import com.zimbra.cs.filter.RuleRewriter;
import com.zimbra.cs.filter.RuleRewriterFactory;
import com.zimbra.cs.filter.SieveToSoap;
import com.zimbra.cs.filter.SoapToSieve;
import com.zimbra.cs.filter.ZimbraMailAdapter;
import com.zimbra.cs.filter.jsieve.AddressBookTest;
import com.zimbra.cs.filter.jsieve.AttachmentTest;
import com.zimbra.cs.filter.jsieve.BodyTest;
import com.zimbra.cs.filter.jsieve.DateTest;
import com.zimbra.cs.filter.jsieve.DisabledIf;
import com.zimbra.cs.filter.jsieve.Flag;
import com.zimbra.cs.filter.jsieve.InviteTest;
import com.zimbra.cs.filter.jsieve.Reply;
import com.zimbra.cs.filter.jsieve.Tag;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.SpamHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.Node;
import org.apache.jsieve.parser.generated.ParseException;
import org.apache.jsieve.parser.generated.TokenMgrError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleManager {
    private static final String FILTER_RULES_CACHE_KEY = StringUtil.getSimpleClassName(RuleManager.class.getName()) + ".FILTER_RULES_CACHE";
    private static ConfigurationManager sConfigurationManager;
    private static SieveFactory sSieveFactory;
    private static final Pattern PAT_RULE_NAME;

    private RuleManager() {
    }

    public static SieveFactory getSieveFactory() {
        return sSieveFactory;
    }

    public static void setRules(Account account, String script) throws ServiceException {
        String accountId = account.getId();
        ZimbraLog.filter.debug("Setting filter rules for account %s:\n%s", accountId, script);
        if (script == null) {
            script = "";
        }
        try {
            Node node = RuleManager.parse(script);
            sSieveFactory.evaluate((MailAdapter)new DummyMailAdapter(), node);
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("zimbraMailSieveScript", script);
            Provisioning.getInstance().modifyAttrs(account, attrs);
            account.setCachedData(FILTER_RULES_CACHE_KEY, node);
        }
        catch (ParseException e) {
            ZimbraLog.filter.error("Unable to parse script:\n" + script);
            throw ServiceException.PARSE_ERROR("parsing Sieve script", e);
        }
        catch (TokenMgrError e) {
            ZimbraLog.filter.error("Unable to parse script:\n" + script);
            throw ServiceException.PARSE_ERROR("parsing Sieve script", e);
        }
        catch (SieveException e) {
            ZimbraLog.filter.error("Unable to evaluate script:\n" + script);
            throw ServiceException.PARSE_ERROR("evaluating Sieve script", e);
        }
    }

    public static void clearCachedRules(Account account) {
        account.setCachedData(FILTER_RULES_CACHE_KEY, null);
    }

    public static String getRules(Account account) {
        String script = account.getAttr("zimbraMailSieveScript");
        return script;
    }

    private static Node getRulesNode(Account account) throws ParseException {
        Node node = (Node)account.getCachedData(FILTER_RULES_CACHE_KEY);
        if (node == null) {
            String script = RuleManager.getRules(account);
            if (script == null) {
                script = "";
            }
            node = RuleManager.parse(script);
            account.setCachedData(FILTER_RULES_CACHE_KEY, node);
        }
        return node;
    }

    public static Element getRulesAsXML(Element.ElementFactory factory, Account account) throws ServiceException {
        return RuleManager.getRulesAsXML(factory, account, false);
    }

    public static Element getRulesAsXML(Element.ElementFactory factory, Account account, boolean useNewFormat) throws ServiceException {
        Node node = null;
        try {
            node = RuleManager.getRulesNode(account);
        }
        catch (ParseException e) {
            throw ServiceException.PARSE_ERROR("parsing Sieve script", e);
        }
        catch (TokenMgrError e) {
            throw ServiceException.PARSE_ERROR("parsing Sieve script", e);
        }
        String script = account.getAttr("zimbraMailSieveScript");
        List<String> ruleNames = RuleManager.getRuleNames(script);
        if (!useNewFormat) {
            RuleRewriter t = RuleRewriterFactory.getInstance().createRuleRewriter(factory, node, ruleNames);
            return t.getElement();
        }
        SieveToSoap sieveToSoap = new SieveToSoap(factory, ruleNames);
        sieveToSoap.accept(node);
        return sieveToSoap.getRootElement();
    }

    public static List<String> getRuleNames(String script) {
        ArrayList<String> names = new ArrayList<String>();
        if (script != null) {
            BufferedReader reader = new BufferedReader(new StringReader(script));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = PAT_RULE_NAME.matcher(line);
                    if (!matcher.matches()) continue;
                    names.add(matcher.group(1));
                }
            }
            catch (IOException e) {
                ZimbraLog.filter.warn((Object)"Unable to determine filter rule names.", e);
            }
        }
        return names;
    }

    public static String getRuleByName(String script, String ruleName) {
        if (script == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean found = false;
        BufferedReader reader = new BufferedReader(new StringReader(script));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                Matcher matcher = PAT_RULE_NAME.matcher(line);
                if (matcher.matches()) {
                    String currentName = matcher.group(1);
                    if (currentName.equals(ruleName)) {
                        found = true;
                    } else if (found) break;
                }
                if (!found) continue;
                buf.append(line).append("\n");
            }
        }
        catch (IOException e) {
            ZimbraLog.filter.warn("Unable to get rule %s from script:\n%s.", (Object)ruleName, (Object)script, e);
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    public static void setXMLRules(Account account, Element eltRules) throws ServiceException {
        RuleManager.setXMLRules(account, eltRules, false);
    }

    public static void setXMLRules(Account account, Element eltRules, boolean useNewFormat) throws ServiceException {
        if (!useNewFormat) {
            RuleRewriter t = RuleRewriterFactory.getInstance().createRuleRewriter(eltRules, MailboxManager.getInstance().getMailboxByAccount(account));
            String script = t.getScript();
            RuleManager.setRules(account, script);
        } else {
            SoapToSieve soapToSieve = new SoapToSieve(eltRules);
            String script = soapToSieve.getSieveScript();
            RuleManager.setRules(account, script);
        }
    }

    public static List<ItemId> applyRulesToIncomingMessage(Mailbox mailbox, ParsedMessage pm, String recipient, DeliveryContext sharedDeliveryCtxt, int incomingFolderId) throws ServiceException {
        return RuleManager.applyRulesToIncomingMessage(mailbox, pm, recipient, sharedDeliveryCtxt, incomingFolderId, true);
    }

    public static List<ItemId> applyRulesToIncomingMessage(Mailbox mailbox, ParsedMessage pm, String recipient, DeliveryContext sharedDeliveryCtxt, int incomingFolderId, boolean allowFilterToMountpoint) throws ServiceException {
        List<ItemId> addedMessageIds = null;
        IncomingMessageHandler handler = new IncomingMessageHandler(sharedDeliveryCtxt, mailbox, recipient, pm, incomingFolderId);
        ZimbraMailAdapter mailAdapter = new ZimbraMailAdapter(mailbox, handler);
        mailAdapter.setAllowFilterToMountpoint(allowFilterToMountpoint);
        try {
            Account account = mailbox.getAccount();
            Node node = RuleManager.getRulesNode(account);
            boolean applyRules = true;
            if (node == null) {
                applyRules = false;
            }
            if (SpamHandler.isSpam(handler.getMimeMessage()) && !account.getBooleanAttr("zimbraSpamApplyUserFilters", false)) {
                applyRules = false;
            }
            if (applyRules) {
                sSieveFactory.evaluate((MailAdapter)mailAdapter, node);
                addedMessageIds = mailAdapter.getAddedMessageIds();
            }
        }
        catch (Exception e) {
            ZimbraLog.filter.warn("An error occurred while processing filter rules. Filing message to %s.", (Object)handler.getDefaultFolderPath(), e);
        }
        catch (TokenMgrError e) {
            ZimbraLog.filter.warn("An error occurred while processing filter rules. Filing message to %s.", (Object)handler.getDefaultFolderPath(), e);
        }
        if (addedMessageIds == null) {
            Message msg = mailAdapter.doDefaultFiling();
            addedMessageIds = new ArrayList<ItemId>(1);
            addedMessageIds.add(new ItemId(msg));
        }
        return addedMessageIds;
    }

    public static boolean applyRulesToExistingMessage(Mailbox mbox, int messageId, Node node) throws ServiceException {
        ExistingMessageHandler handler = new ExistingMessageHandler(mbox, messageId);
        ZimbraMailAdapter mailAdapter = new ZimbraMailAdapter(mbox, handler);
        try {
            sSieveFactory.evaluate((MailAdapter)mailAdapter, node);
        }
        catch (SieveException e) {
            throw ServiceException.FAILURE("Unable to evaluate script", e);
        }
        return handler.filtered();
    }

    public static Node parse(String script) throws ParseException {
        ByteArrayInputStream sin = null;
        try {
            sin = new ByteArrayInputStream(script.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e.getMessage());
        }
        Node node = sSieveFactory.parse((InputStream)sin);
        return node;
    }

    public static void folderRenamed(Account account, String originalPath, String newPath) throws ServiceException {
        String script = RuleManager.getRules(account);
        if (script != null) {
            Node node = null;
            try {
                node = RuleManager.parse(script);
            }
            catch (ParseException e) {
                ZimbraLog.filter.warn((Object)"Unable to update filter rules with new folder path '%s'.", e);
                return;
            }
            FolderRenamer renamer = new FolderRenamer(originalPath, newPath);
            renamer.accept(node);
            if (renamer.renamed()) {
                List<String> ruleNames = RuleManager.getRuleNames(script);
                SieveToSoap sieveToSoap = new SieveToSoap(Element.XMLElement.mFactory, ruleNames);
                sieveToSoap.accept(node);
                SoapToSieve soapToSieve = new SoapToSieve(sieveToSoap.getRootElement());
                String newScript = soapToSieve.getSieveScript();
                RuleManager.setRules(account, newScript);
                ZimbraLog.filter.info("Updated filter rules due to folder move or rename from %s to %s.", originalPath, newPath);
                ZimbraLog.filter.debug("Old rules:\n%s, new rules:\n%s", script, newScript);
            }
        }
    }

    public static void tagRenamed(Account account, String originalName, String newName) throws ServiceException {
        String newRules;
        String rules = RuleManager.getRules(account);
        if (rules != null && !(newRules = rules.replace("tag \"" + originalName + "\"", "tag \"" + newName + "\"")).equals(rules)) {
            RuleManager.setRules(account, newRules);
            ZimbraLog.filter.info("Updated filter rules due to tag rename from %s to %s.", originalName, newName);
            ZimbraLog.filter.debug("Old rules:\n%s, new rules:\n%s", rules, newRules);
        }
    }

    static {
        try {
            sConfigurationManager = new ConfigurationManager();
            Map commandMap = sConfigurationManager.getCommandMap();
            commandMap.put("disabled_if", DisabledIf.class.getName());
            commandMap.put("tag", Tag.class.getName());
            commandMap.put("flag", Flag.class.getName());
            commandMap.put("reply", Reply.class.getName());
            Map testMap = sConfigurationManager.getTestMap();
            testMap.put("date", DateTest.class.getName());
            testMap.put("body", BodyTest.class.getName());
            testMap.put("attachment", AttachmentTest.class.getName());
            testMap.put("addressbook", AddressBookTest.class.getName());
            testMap.put("invite", InviteTest.class.getName());
            sSieveFactory = sConfigurationManager.build();
        }
        catch (SieveException e) {
            ZimbraLog.filter.error((Object)"Unable to initialize mail filtering extensions.", e);
        }
        PAT_RULE_NAME = Pattern.compile("# (.+)");
    }
}

