/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.FilterHandler;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.SpamHandler;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class IncomingMessageHandler
extends FilterHandler {
    private DeliveryContext mContext;
    private ParsedMessage mParsedMessage;
    private Mailbox mMailbox;
    private int mDefaultFolderId;
    private String mRecipientAddress;

    public IncomingMessageHandler(DeliveryContext context, Mailbox mbox, String recipientAddress, ParsedMessage pm, int defaultFolderId) {
        this.mContext = context;
        this.mMailbox = mbox;
        this.mRecipientAddress = recipientAddress;
        this.mParsedMessage = pm;
        this.mDefaultFolderId = defaultFolderId;
    }

    public MimeMessage getMimeMessage() {
        return this.mParsedMessage.getMimeMessage();
    }

    public ParsedMessage getParsedMessage() {
        return this.mParsedMessage;
    }

    public String getDefaultFolderPath() throws ServiceException {
        return this.mMailbox.getFolderById(null, this.mDefaultFolderId).getPath();
    }

    public int getDefaultFlagBitmask() {
        return Flag.BITMASK_UNREAD;
    }

    public Message explicitKeep(int flagBitmask, String tags) throws ServiceException {
        return this.addMessage(this.mDefaultFolderId, flagBitmask, tags);
    }

    public ItemId fileInto(String folderPath, int flagBitmask, String tags) throws ServiceException {
        ItemId id = FilterUtil.addMessage(this.mContext, this.mMailbox, this.mParsedMessage, this.mRecipientAddress, folderPath, flagBitmask, tags);
        try {
            Folder folder = this.mMailbox.getFolderByPath(null, folderPath);
            if (folder.getId() == 4 && id.isLocal()) {
                SpamHandler.getInstance().handle(null, this.mMailbox, id.getId(), (byte)5, true);
            }
        }
        catch (MailServiceException.NoSuchItemException e) {
            ZimbraLog.filter.debug("Unable to do spam training for message %s because folder path %s does not exist.", id, folderPath);
        }
        catch (ServiceException e) {
            ZimbraLog.filter.warn("Unable to do spam training for message %s.", (Object)id, e);
        }
        return id;
    }

    public Message implicitKeep(int flagBitmask, String tags) throws ServiceException {
        int folderId = SpamHandler.isSpam(this.getMimeMessage()) ? 4 : this.mDefaultFolderId;
        return this.addMessage(folderId, flagBitmask, tags);
    }

    private Message addMessage(int folderId, int flagBitmask, String tags) throws ServiceException {
        Message msg = null;
        try {
            msg = this.mMailbox.addMessage(null, this.mParsedMessage, folderId, false, flagBitmask, tags, this.mRecipientAddress, this.mContext);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to add incoming message", e);
        }
        return msg;
    }

    public void redirect(String destinationAddress) throws ServiceException, MessagingException {
        FilterUtil.redirect(this.mMailbox, this.mParsedMessage.getMimeMessage(), destinationAddress);
    }
}

