/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.filter.SieveVisitor;
import org.apache.jsieve.parser.SieveNode;
import org.apache.jsieve.parser.generated.Node;

class FolderRenamer
extends SieveVisitor {
    String mOldPath;
    String mNewPath;
    boolean mRenamed = false;

    FolderRenamer(String oldPath, String newPath) {
        this.mOldPath = this.prefixWithSlash(oldPath);
        this.mNewPath = this.prefixWithSlash(newPath);
    }

    boolean renamed() {
        return this.mRenamed;
    }

    protected void visitFileIntoAction(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props, String folderPath) throws ServiceException {
        if (phase != SieveVisitor.VisitPhase.begin || folderPath == null) {
            return;
        }
        if ((folderPath = this.prefixWithSlash(folderPath)).startsWith(this.mOldPath)) {
            String newPath = folderPath.replace(this.mOldPath, this.mNewPath);
            SieveNode folderNameNode = (SieveNode)this.getNode(node, 0, 0, 0, 0);
            String escapedName = "\"" + FilterUtil.escape(newPath) + "\"";
            folderNameNode.setValue((Object)escapedName);
            this.mRenamed = true;
        }
    }

    private String prefixWithSlash(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.charAt(0) != '/') {
            return "/" + path;
        }
        return path;
    }
}

