/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.DateParser;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZMailbox;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    public static final DateParser SIEVE_DATE_PARSER = new DateParser("yyyyMMdd");
    public static final String HEADER_FORWARDED = "X-Zimbra-Forwarded";

    public static String escape(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        return s;
    }

    public static String unescape(String s) {
        s = s.replace("\\\"", "\"");
        s = s.replace("\\\\", "\\");
        return s;
    }

    public static <T> int addToMap(Map<Integer, T> map, int initialKey, T value) {
        int i = initialKey;
        while (true) {
            if (!map.containsKey(i)) {
                map.put(i, value);
                return i;
            }
            ++i;
        }
    }

    public static int getIndex(Element actionElement) {
        String s = actionElement.getAttribute("index", "0");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            ZimbraLog.soap.warn("Unable to parse index value %s for element %s.  Ignoring order.", s, actionElement.getName());
            return 0;
        }
    }

    public static int parseSize(String sizeString) {
        if (sizeString == null || sizeString.length() == 0) {
            return 0;
        }
        sizeString = sizeString.toUpperCase();
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
            multiplier = 0x40000000;
        }
        return Integer.parseInt(sizeString) * multiplier;
    }

    public static ItemId addMessage(DeliveryContext context, Mailbox mbox, ParsedMessage pm, String recipient, String folderPath, int flags, String tags) throws ServiceException {
        Pair<Folder, String> folderAndPath = mbox.getFolderByPathLongestMatch(null, 1, folderPath);
        Folder folder = folderAndPath.getFirst();
        String remainingPath = folderAndPath.getSecond();
        ZimbraLog.filter.debug("Attempting to file to %s, remainingPath=%s.", folder, remainingPath);
        if (folder instanceof Mountpoint) {
            Mountpoint mountpoint = (Mountpoint)folder;
            ZMailbox remoteMbox = FilterUtil.getRemoteZMailbox(mbox, mountpoint);
            String remoteAccountId = mountpoint.getOwnerId();
            ItemId id = mountpoint.getTarget();
            ZFolder remoteFolder = remoteMbox.getFolderById(id.toString());
            if (remoteFolder != null && remainingPath != null && (remoteFolder = remoteFolder.getSubFolderByPath(remainingPath)) == null) {
                String msg = String.format("Subfolder %s of mountpoint %s does not exist.", remainingPath, mountpoint.getName());
                throw ServiceException.FAILURE(msg, null);
            }
            if (remoteFolder != null) {
                byte[] content = null;
                try {
                    content = pm.getRawData();
                }
                catch (Exception e) {
                    throw ServiceException.FAILURE("Unable to get message content", e);
                }
                String msgId = remoteMbox.addMessage(remoteFolder.getId(), com.zimbra.cs.mailbox.Flag.bitmaskToFlags(flags), null, 0L, content, false);
                return new ItemId(msgId, remoteAccountId);
            }
            String msg = String.format("Unable to find remote folder %s for mountpoint %s.", remainingPath, mountpoint.getName());
            throw ServiceException.FAILURE(msg, null);
        }
        if (!StringUtil.isNullOrEmpty(remainingPath)) {
            ZimbraLog.filter.info("Could not find folder %s.  Automatically creating it.", folderPath);
            folder = mbox.createFolder(null, folderPath, (byte)0, (byte)5);
        }
        try {
            com.zimbra.cs.mailbox.Message msg = mbox.addMessage(null, pm, folder.getId(), false, flags, tags, recipient, context);
            if (msg == null) {
                return null;
            }
            return new ItemId(msg);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("Unable to add message", e);
        }
    }

    public static ZMailbox getRemoteZMailbox(Mailbox localMbox, Mountpoint mountpoint) throws ServiceException {
        AuthToken authToken = null;
        OperationContext opCtxt = localMbox.getOperationContext();
        if (opCtxt != null) {
            authToken = opCtxt.getAuthToken();
        }
        if (authToken == null) {
            authToken = AuthProvider.getAuthToken(localMbox.getAccount());
        }
        Account account = Provisioning.getInstance().get(Provisioning.AccountBy.id, mountpoint.getOwnerId());
        ZMailbox.Options zoptions = new ZMailbox.Options(authToken.toZAuthToken(), AccountUtil.getSoapUri(account));
        zoptions.setNoSession(true);
        zoptions.setTargetAccount(account.getId());
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        return ZMailbox.getMailbox(zoptions);
    }

    public static void redirect(Mailbox sourceMbox, MimeMessage msg, String destinationAddress) throws ServiceException, MessagingException {
        SMTPMessage outgoingMsg = null;
        try {
            if (FilterUtil.isMailLoop(sourceMbox, msg)) {
                String error = String.format("Detected a mail loop for message %s.", Mime.getMessageID(msg));
                throw ServiceException.FAILURE(error, null);
            }
            outgoingMsg = new SMTPMessage(msg);
            outgoingMsg.setHeader(HEADER_FORWARDED, sourceMbox.getAccount().getName());
            outgoingMsg.saveChanges();
        }
        catch (MessagingException e) {
            try {
                outgoingMsg = new SMTPMessage(msg){

                    protected void updateHeaders() throws MessagingException {
                        this.setHeader("MIME-Version", "1.0");
                        if (this.getMessageID() == null) {
                            this.updateMessageID();
                        }
                    }
                };
                ZimbraLog.filter.info("Message format error detected.  Wrapper class in use.  %s", e.toString());
            }
            catch (MessagingException e2) {
                throw ServiceException.FAILURE("Message format error detected.  Workaround failed.", e2);
            }
        }
        if (Provisioning.getInstance().getLocalServer().isMailRedirectSetEnvelopeSender()) {
            Account account = sourceMbox.getAccount();
            outgoingMsg.setEnvelopeFrom(account.getName());
        }
        Transport.send((Message)outgoingMsg, (Address[])new Address[]{new InternetAddress(destinationAddress)});
    }

    private static boolean isMailLoop(Mailbox sourceMbox, MimeMessage msg) throws ServiceException {
        String[] forwards = Mime.getHeaders(msg, HEADER_FORWARDED);
        String userName = sourceMbox.getAccount().getName();
        for (String forward : forwards) {
            if (!StringUtil.equal(userName, forward)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateComparison {
        before,
        after;


        public static DateComparison fromString(String value) throws ServiceException {
            if (value == null) {
                return null;
            }
            try {
                return DateComparison.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("Invalid value: " + value + ", valid values: " + Arrays.asList(StringComparison.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberComparison {
        over,
        under;


        public static NumberComparison fromString(String value) throws ServiceException {
            if (value == null) {
                return null;
            }
            try {
                return NumberComparison.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("Invalid value: " + value + ", valid values: " + Arrays.asList(NumberComparison.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringComparison {
        is,
        contains,
        matches;


        public static StringComparison fromString(String value) throws ServiceException {
            if (value == null) {
                return null;
            }
            try {
                return StringComparison.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("Invalid value: " + value + ", valid values: " + Arrays.asList(StringComparison.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        read,
        flagged;


        public static Flag fromString(String value) throws ServiceException {
            if (value == null) {
                return null;
            }
            try {
                return Flag.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("Invalid value: " + value + ", valid values: " + Arrays.asList(Flag.values()), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Condition {
        allof,
        anyof;


        public static Condition fromString(String value) throws ServiceException {
            if (value == null) {
                return null;
            }
            try {
                return Condition.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("Invalid value: " + value + ", valid values: " + Arrays.asList(Condition.values()), e);
            }
        }
    }
}

