/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.filter.FilterHandler;
import com.zimbra.cs.filter.FilterUtil;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.mime.ParsedMessageOptions;
import com.zimbra.cs.service.util.ItemId;
import javax.mail.internet.MimeMessage;

public class ExistingMessageHandler
extends FilterHandler {
    private Mailbox mMailbox;
    private int mMessageId;
    private MimeMessage mMimeMessage;
    private ParsedMessage mParsedMessage;
    private boolean mKept = false;
    private boolean mFiled = false;
    private boolean mFiltered = false;

    public ExistingMessageHandler(Mailbox mbox, int messageId) {
        this.mMailbox = mbox;
        this.mMessageId = messageId;
    }

    public String getDefaultFolderPath() throws ServiceException {
        return this.getDefaultFolder().getPath();
    }

    private Folder getDefaultFolder() throws ServiceException {
        return this.mMailbox.getFolderById(null, 2);
    }

    public MimeMessage getMimeMessage() throws ServiceException {
        if (this.mMimeMessage == null) {
            Message msg = this.mMailbox.getMessageById(null, this.mMessageId);
            this.mMimeMessage = msg.getMimeMessage();
        }
        return this.mMimeMessage;
    }

    public ParsedMessage getParsedMessage() throws ServiceException {
        if (this.mParsedMessage == null) {
            Message msg = this.mMailbox.getMessageById(null, this.mMessageId);
            ParsedMessageOptions opt = new ParsedMessageOptions().setContent(msg.getMimeMessage()).setAttachmentIndexing(this.mMailbox.attachmentsIndexingEnabled()).setSize(msg.getSize()).setDigest(msg.getDigest());
            this.mParsedMessage = new ParsedMessage(opt);
        }
        return this.mParsedMessage;
    }

    public int getDefaultFlagBitmask() {
        return 0;
    }

    public boolean filtered() {
        return this.mFiltered;
    }

    public void discard() throws ServiceException {
        ZimbraLog.filter.info("Discarding existing message with id %d.", this.mMessageId);
        this.mMailbox.delete(null, this.mMessageId, (byte)5);
        this.mFiltered = true;
    }

    public Message implicitKeep(int flagBitmask, String tags) throws ServiceException {
        ZimbraLog.filter.debug("Implicitly keeping existing message %d.", this.mMessageId);
        Message msg = this.mMailbox.getMessageById(null, this.mMessageId);
        this.updateTagsAndFlagsIfNecessary(msg, flagBitmask, tags);
        this.mKept = true;
        return msg;
    }

    public Message explicitKeep(int flagBitmask, String tags) throws ServiceException {
        ZimbraLog.filter.debug("Explicitly keeping existing message %d.", this.mMessageId);
        Message msg = this.mMailbox.getMessageById(null, this.mMessageId);
        this.updateTagsAndFlagsIfNecessary(msg, flagBitmask, tags);
        this.mKept = true;
        return msg;
    }

    private void updateTagsAndFlagsIfNecessary(Message msg, int flagBitmask, String tags) throws ServiceException {
        long tagBitmask = Tag.tagsToBitmask(tags);
        if ((msg.getTagBitmask() & tagBitmask) != tagBitmask || (msg.getFlagBitmask() & flagBitmask) != flagBitmask) {
            ZimbraLog.filter.info("Updating flags to %d, tags to %d on message %d.", flagBitmask, tagBitmask, msg.getId());
            this.mMailbox.setTags(null, msg.getId(), (byte)5, flagBitmask, tagBitmask);
            this.mFiltered = true;
        }
    }

    public ItemId fileInto(String folderPath, int flagBitmask, String tags) throws ServiceException {
        Message source = this.mMailbox.getMessageById(null, this.mMessageId);
        Folder targetFolder = null;
        try {
            targetFolder = this.mMailbox.getFolderByPath(null, folderPath);
        }
        catch (MailServiceException.NoSuchItemException e) {
            // empty catch block
        }
        if (targetFolder != null && source.getFolderId() == targetFolder.getId()) {
            ZimbraLog.filter.debug("Ignoring fileinto action for message %d.  It is already in %s.", this.mMessageId, folderPath);
            return null;
        }
        ZimbraLog.filter.info("Copying existing message %d to folder %s.", this.mMessageId, folderPath);
        if (this.isLocalExistingFolder(folderPath)) {
            Folder target = this.mMailbox.getFolderByPath(null, folderPath);
            Message newMsg = (Message)this.mMailbox.copy(null, this.mMessageId, (byte)5, target.getId());
            this.mFiltered = true;
            this.mFiled = true;
            int flagBits = source.getFlagBitmask();
            long tagBits = Tag.tagsToBitmask(tags);
            this.mMailbox.setTags(null, newMsg.getId(), (byte)5, source.getFlagBitmask() | flagBits, source.getTagBitmask() | tagBits);
            return new ItemId(this.mMailbox, this.mMessageId);
        }
        ItemId id = FilterUtil.addMessage(new DeliveryContext(), this.mMailbox, this.getParsedMessage(), this.mMailbox.getAccount().getName(), folderPath, flagBitmask, tags);
        if (id != null) {
            this.mFiltered = true;
            this.mFiled = true;
        }
        return id;
    }

    private boolean isLocalExistingFolder(String folderPath) throws ServiceException {
        Pair<Folder, String> folderAndPath = this.mMailbox.getFolderByPathLongestMatch(null, 1, folderPath);
        Folder folder = folderAndPath.getFirst();
        String remainingPath = folderAndPath.getSecond();
        return !(folder instanceof Mountpoint) && StringUtil.isNullOrEmpty(remainingPath);
    }

    public void redirect(String destinationAddress) {
        ZimbraLog.filter.debug("Ignoring attempt to redirect existing message %d to %s.", this.mMessageId, destinationAddress);
    }

    public void afterFiltering() throws ServiceException {
        if (this.mFiled && !this.mKept) {
            ZimbraLog.filter.info("Deleting original message %d after filing to another folder.", this.mMessageId);
            this.mMailbox.delete(null, this.mMessageId, (byte)5);
        }
    }
}

