/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.filter;

import com.zimbra.cs.filter.SieveVisitor;
import org.apache.jsieve.parser.SieveNode;
import org.apache.jsieve.parser.generated.Node;

public class DumpSieveTree
extends SieveVisitor {
    private int mIndentLevel = 0;
    StringBuilder mBuf = new StringBuilder();

    protected void visitAction(Node actionNode, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) {
    }

    protected void visitNode(Node node, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) {
        if (phase == SieveVisitor.VisitPhase.begin) {
            this.indent();
            Object value = this.getValue(node);
            String valueClass = value == null ? "" : String.format(" (%s)", value.getClass().getSimpleName());
            this.mBuf.append(String.format("%s, %s=%s%s\n", node.getClass().getSimpleName(), this.getName(node), value, valueClass));
            ++this.mIndentLevel;
        } else {
            --this.mIndentLevel;
        }
    }

    protected void visitRule(Node ruleNode, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) {
    }

    protected void visitTest(Node testNode, SieveVisitor.VisitPhase phase, SieveVisitor.RuleProperties props) {
    }

    private String getName(Node node) {
        return ((SieveNode)node).getName();
    }

    private Object getValue(Node node) {
        return ((SieveNode)node).getValue();
    }

    private void indent() {
        for (int i = 0; i < this.mIndentLevel; ++i) {
            this.mBuf.append(" ");
        }
    }

    public String toString() {
        return this.mBuf.toString();
    }
}

