/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ProxyTarget;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFreeBusyProvider
extends FreeBusyProvider {
    private static final String REMOTE = "REMOTE";
    private Map<String, StringBuilder> mRemoteAccountMap = new HashMap<String, StringBuilder>();
    private ArrayList<FreeBusyProvider.Request> mRequestList = new ArrayList();
    private HttpServletRequest mHttpReq;
    private ZimbraSoapContext mSoapCtxt;
    private long mStart;
    private long mEnd;
    private String mExApptUid;

    public RemoteFreeBusyProvider(HttpServletRequest httpReq, ZimbraSoapContext zsc, long start, long end, String exApptUid) {
        this.mHttpReq = httpReq;
        this.mSoapCtxt = zsc;
        this.mStart = start;
        this.mEnd = end;
        this.mExApptUid = exApptUid;
    }

    @Override
    public FreeBusyProvider getInstance() {
        return null;
    }

    @Override
    public void addFreeBusyRequest(FreeBusyProvider.Request req) {
        Account account = (Account)req.data;
        if (account == null) {
            return;
        }
        String hostname = account.getAttr("zimbraMailHost");
        StringBuilder buf = this.mRemoteAccountMap.get(hostname);
        if (buf == null) {
            buf = new StringBuilder(req.email);
        } else {
            buf.append(",").append(req.email);
        }
        this.mRemoteAccountMap.put(hostname, buf);
        this.mRequestList.add(req);
    }

    public void addFreeBusyRequest(Account requestor, Account acct, String id, long start, long end, int folder) {
        FreeBusyProvider.Request req = new FreeBusyProvider.Request(requestor, id, start, end, folder);
        req.data = acct;
        this.addFreeBusyRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FreeBusy> getResults() {
        ArrayList<FreeBusy> fb = new ArrayList<FreeBusy>();
        for (FreeBusyProvider.Request req : this.mRequestList) {
            Object var12_16;
            HttpMethod method = null;
            Account acct = (Account)req.data;
            try {
                block18: {
                    try {
                        String fbMsg;
                        StringBuilder targetUrl = new StringBuilder();
                        targetUrl.append(UserServlet.getRestUrl(acct));
                        targetUrl.append("/Calendar?fmt=ifb");
                        targetUrl.append("&start=").append(this.mStart);
                        targetUrl.append("&end=").append(this.mEnd);
                        if (req.folder != -1) {
                            targetUrl.append("&").append("fbcal").append("=").append(req.folder);
                        }
                        try {
                            if (this.mExApptUid != null) {
                                targetUrl.append("&").append("exuid").append("=").append(URLEncoder.encode(this.mExApptUid, "UTF-8"));
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        String authToken = null;
                        try {
                            if (this.mSoapCtxt != null) {
                                authToken = this.mSoapCtxt.getAuthToken().getEncoded();
                            }
                        }
                        catch (AuthTokenException e) {
                            // empty catch block
                        }
                        if (authToken != null) {
                            targetUrl.append("&").append("zauthtoken").append("=");
                            try {
                                targetUrl.append(URLEncoder.encode(authToken, "UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                // empty catch block
                            }
                        }
                        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
                        HttpProxyUtil.configureProxy(client);
                        method = new GetMethod(targetUrl.toString());
                        try {
                            client.executeMethod(method);
                            byte[] buf = ByteUtil.getContent(method.getResponseBodyAsStream(), 0);
                            fbMsg = new String(buf, "UTF-8");
                        }
                        catch (IOException ex) {
                            fbMsg = null;
                        }
                        if (fbMsg == null) break block18;
                        fb.add(new FreeBusyString(req.email, this.mStart, this.mEnd, fbMsg));
                    }
                    catch (ServiceException e) {
                        ZimbraLog.fb.warn((Object)("can't get free/busy information for " + req.email), e);
                        var12_16 = null;
                        if (method == null) continue;
                        method.releaseConnection();
                        continue;
                    }
                }
                var12_16 = null;
                if (method == null) continue;
                method.releaseConnection();
            }
            catch (Throwable throwable) {
                var12_16 = null;
                if (method != null) {
                    method.releaseConnection();
                }
                throw throwable;
            }
        }
        return fb;
    }

    @Override
    public int registerForItemTypes() {
        return 0;
    }

    @Override
    public boolean registerForMailboxChanges() {
        return false;
    }

    @Override
    public long cachedFreeBusyStartTime() {
        return 0L;
    }

    @Override
    public long cachedFreeBusyEndTime() {
        return 0L;
    }

    @Override
    public boolean handleMailboxChange(String accountId) {
        return true;
    }

    @Override
    public String foreignPrincipalPrefix() {
        return "";
    }

    @Override
    public void addResults(Element response) {
        Provisioning prov = Provisioning.getInstance();
        for (Map.Entry<String, StringBuilder> entry : this.mRemoteAccountMap.entrySet()) {
            String paramStr = entry.getValue().toString();
            String[] idStrs = paramStr.split(",");
            try {
                Element req = this.mSoapCtxt.getRequestProtocol().getFactory().createElement(MailConstants.GET_FREE_BUSY_REQUEST);
                req.addAttribute("s", this.mStart);
                req.addAttribute("e", this.mEnd);
                req.addAttribute("uid", paramStr);
                Account acct = prov.get(Provisioning.AccountBy.name, idStrs[0], this.mSoapCtxt.getAuthToken());
                if (acct == null) {
                    acct = prov.get(Provisioning.AccountBy.id, idStrs[0], this.mSoapCtxt.getAuthToken());
                }
                if (acct != null) {
                    Element remoteResponse = this.proxyRequest(req, acct.getId(), this.mSoapCtxt);
                    for (Element thisElt : remoteResponse.listElements()) {
                        response.addElement(thisElt.detach());
                    }
                    continue;
                }
                ZimbraLog.fb.debug("Account " + idStrs[0] + " not found while searching free/busy");
            }
            catch (SoapFaultException e) {
                ZimbraLog.fb.error((Object)("cannot get free/busy for " + idStrs[0]), e);
                this.addFailedAccounts(response, idStrs);
            }
            catch (ServiceException e) {
                ZimbraLog.fb.error((Object)("cannot get free/busy for " + idStrs[0]), e);
                this.addFailedAccounts(response, idStrs);
            }
        }
    }

    @Override
    public String getName() {
        return REMOTE;
    }

    private void addFailedAccounts(Element response, String[] idStrs) {
        for (String id : idStrs) {
            ToXML.encodeFreeBusy(response, FreeBusy.emptyFreeBusy(id, this.mStart, this.mEnd));
        }
    }

    protected Element proxyRequest(Element request, String acctId, ZimbraSoapContext zsc) throws ServiceException {
        ZimbraSoapContext zscTarget = new ZimbraSoapContext(zsc, acctId);
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, acctId);
        Server server = prov.getServer(acct);
        ProxyTarget proxy = new ProxyTarget(server.getId(), zsc.getAuthToken(), this.mHttpReq);
        Element response = DocumentHandler.proxyWithNotification(request.detach(), proxy, zscTarget, zsc);
        return response;
    }

    private static class FreeBusyString
    extends FreeBusy {
        private String mFbStr;

        public FreeBusyString(String name, long start, long end, String fbStr) {
            super(name, start, end);
            this.mFbStr = fbStr;
        }

        public String toVCalendar(FreeBusy.Method m, String organizer, String attendee, String url) {
            String ret = this.mFbStr;
            String org = "ORGANIZER:" + organizer;
            if (attendee != null) {
                if (ret.indexOf("ATTENDEE") > 0) {
                    ret = ret.replaceAll("ATTENDEE:.*", "ATTENDEE:" + attendee);
                } else {
                    org = org + "\nATTENDEE:" + attendee;
                }
            }
            if (url != null && ret.indexOf("URL") < 0) {
                if (ret.indexOf("URL") > 0) {
                    ret = ret.replaceAll("URL:.*", "URL:" + url);
                } else {
                    org = org + "\nURL:" + url;
                }
            }
            ret = ret.replaceAll("METHOD:PUBLISH", "METHOD:" + m.toString());
            ret = ret.replaceAll("ORGANIZER:.*", org);
            return ret;
        }
    }
}

