/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.mailbox.calendar.cache.FullInstanceData;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalFreeBusyProvider {
    public static FreeBusy getFreeBusyList(Account authAcct, boolean asAdmin, Mailbox mbox, String name, long start, long end, int folder, Appointment exAppt) throws ServiceException {
        List<Object> calDataResultList;
        AccessManager accessMgr = AccessManager.getInstance();
        boolean accountAceAllowed = accessMgr.canDo(authAcct, (Entry)mbox.getAccount(), (Right)Rights.User.R_viewFreeBusy, asAdmin);
        int exApptId = exAppt == null ? -1 : exAppt.getId();
        FreeBusy.IntervalList intervals = new FreeBusy.IntervalList(start, end);
        if (folder == -1) {
            calDataResultList = mbox.getAllCalendarsSummaryForRange(null, (byte)11, start, end);
        } else {
            calDataResultList = new ArrayList<CalSummaryCache.CalendarDataResult>(1);
            calDataResultList.add(mbox.getCalendarSummaryForRange(null, folder, (byte)11, start, end));
        }
        for (CalSummaryCache.CalendarDataResult calendarDataResult : calDataResultList) {
            int folderId = calendarDataResult.data.getFolderId();
            Folder f = mbox.getFolderById(null, folderId);
            if ((f.getFlagBitmask() & Flag.BITMASK_EXCLUDE_FREEBUSY) != 0 || !CalendarItem.allowFreeBusyAccess(f, authAcct, asAdmin) && !accountAceAllowed) continue;
            Iterator<CalendarItemData> iter = calendarDataResult.data.calendarItemIterator();
            while (iter.hasNext()) {
                FullInstanceData defaultInstance;
                CalendarItemData appt = iter.next();
                int apptId = appt.getCalItemId();
                if (apptId == exApptId || (defaultInstance = appt.getDefaultData()) == null) continue;
                boolean isTransparent = false;
                String transp = defaultInstance.getTransparency();
                isTransparent = "T".equals(transp);
                long defaultDuration = 0L;
                if (defaultInstance.getDuration() != null) {
                    defaultDuration = defaultInstance.getDuration();
                }
                String defaultFreeBusy = defaultInstance.getFreeBusyActual();
                Iterator<InstanceData> instIter = appt.instanceIterator();
                while (instIter.hasNext()) {
                    String freeBusy;
                    long instStart;
                    InstanceData instance = instIter.next();
                    long l = instStart = instance.getDtStart() != null ? instance.getDtStart() : 0L;
                    if (instStart >= end) continue;
                    long dur = defaultDuration;
                    if (instance.getDuration() != null) {
                        dur = instance.getDuration();
                    }
                    long instEnd = instStart + dur;
                    long recurIdDt = 0L;
                    if (instance instanceof FullInstanceData) {
                        FullInstanceData fullInst = (FullInstanceData)instance;
                        String transpInst = fullInst.getTransparency();
                        recurIdDt = fullInst.getRecurrenceId();
                        if ("T".equals(transpInst)) {
                            continue;
                        }
                    } else if (isTransparent) continue;
                    if ((freeBusy = instance.getFreeBusyActual()) == null) {
                        freeBusy = defaultFreeBusy;
                    }
                    if ("F".equals(freeBusy)) continue;
                    FreeBusy.FBInstance fbInst = new FreeBusy.FBInstance(freeBusy, instStart, instEnd, apptId, recurIdDt);
                    FreeBusy.Interval ival = new FreeBusy.Interval(instStart, instEnd, freeBusy, fbInst);
                    intervals.addInterval(ival);
                }
            }
        }
        return new FreeBusy(name, intervals, start, end);
    }

    public static void main(String[] args) {
        FreeBusy.IntervalList l = new FreeBusy.IntervalList(0L, 100L);
        System.out.println("List: " + l.toString());
        FreeBusy.Interval toAdd = new FreeBusy.Interval(50L, 60L, "B");
        l.addInterval(toAdd);
        System.out.println("Added: " + toAdd + l.toString());
        toAdd = new FreeBusy.Interval(10L, 20L, "T");
        l.addInterval(toAdd);
        System.out.println("Added: " + toAdd + l.toString());
        toAdd = new FreeBusy.Interval(20L, 30L, "O");
        l.addInterval(toAdd);
        System.out.println("Added: " + toAdd + l.toString());
        toAdd = new FreeBusy.Interval(15L, 35L, "B");
        l.addInterval(toAdd);
        System.out.println("Added: " + toAdd + l.toString());
        try {
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(1L);
            FreeBusy fb = LocalFreeBusyProvider.getFreeBusyList(mbox.getAccount(), false, mbox, mbox.getAccount().getName(), 0L, Long.MAX_VALUE, -1, null);
            System.out.println(fb.toString());
        }
        catch (ServiceException e) {
            System.out.println("EXCEPTION: " + e);
            e.printStackTrace();
        }
    }
}

