/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.fb.RemoteFreeBusyProvider;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeBusyQuery {
    public static final int CALENDAR_FOLDER_ALL = -1;
    private Account mRequestor;
    private long mStart;
    private long mEnd;
    private String mExApptUid;
    private HashMap<String, Account> mTargets;
    private HashMap<String, Integer> mTargetFolder;
    private HttpServletRequest mReq;
    private ZimbraSoapContext mCtxt;

    public FreeBusyQuery(HttpServletRequest httpReq, ZimbraSoapContext zsc, Account requestor, long start, long end, String exApptUid) {
        this(httpReq, requestor, start, end, exApptUid);
        this.mCtxt = zsc;
    }

    public FreeBusyQuery(HttpServletRequest httpReq, Account requestor, long start, long end, String exApptUid) {
        this.mReq = httpReq;
        this.mRequestor = requestor;
        this.mStart = start;
        this.mEnd = end;
        this.mExApptUid = exApptUid;
        this.mTargets = new HashMap();
        this.mTargetFolder = new HashMap();
    }

    public void addAccountId(String accountId, int calFolderId) {
        this.addUser(accountId, this.getAccountFromId(accountId), calFolderId);
    }

    public void addEmailAddress(String emailAddr, int calFolderId) {
        this.addUser(emailAddr, this.getAccountFromName(emailAddr), calFolderId);
    }

    public void addId(String id, int calFolderId) {
        this.addUser(id, this.getAccountFromUid(id), calFolderId);
    }

    private void addUser(String id, Account acct, int calFolderId) {
        this.mTargets.put(id, acct);
        this.mTargetFolder.put(id, calFolderId);
    }

    private Account getAccountFromUid(String uid) {
        Provisioning prov = Provisioning.getInstance();
        Account acct = null;
        try {
            acct = Provisioning.isUUID(uid) ? prov.get(Provisioning.AccountBy.id, uid) : prov.get(Provisioning.AccountBy.name, uid);
        }
        catch (ServiceException e) {
            acct = null;
        }
        return acct;
    }

    private Account getAccountFromId(String id) {
        try {
            return Provisioning.getInstance().get(Provisioning.AccountBy.id, id);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    private Account getAccountFromName(String name) {
        try {
            return Provisioning.getInstance().get(Provisioning.AccountBy.name, name);
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    private void prepareRequests(ArrayList<FreeBusy> local, RemoteFreeBusyProvider remote, ArrayList<String> external) {
        for (String id : this.mTargets.keySet()) {
            Account acct = this.mTargets.get(id);
            if (acct == null || acct.getBooleanAttr("zimbraFreebusyLocalMailboxNotActive", false)) {
                external.add(id);
                continue;
            }
            int folder = this.mTargetFolder.get(id);
            try {
                if (Provisioning.onLocalServer(acct)) {
                    CalendarItem ci;
                    Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct);
                    OperationContext octxt = null;
                    octxt = this.mCtxt != null ? new OperationContext(this.mCtxt.getAuthToken()) : (this.mRequestor != null ? new OperationContext(this.mRequestor) : new OperationContext(ACL.ANONYMOUS_ACCT));
                    Appointment exAppt = null;
                    if (this.mExApptUid != null && (ci = mbox.getCalendarItemByUid(octxt, this.mExApptUid)) instanceof Appointment) {
                        exAppt = (Appointment)ci;
                    }
                    local.add(mbox.getFreeBusy(octxt, id, this.mStart, this.mEnd, folder, exAppt));
                    continue;
                }
                remote.addFreeBusyRequest(this.mRequestor, acct, id, this.mStart, this.mEnd, folder);
            }
            catch (ServiceException e) {
                ZimbraLog.fb.error((Object)("cannot get free/busy for " + id), e);
            }
        }
    }

    public Collection<FreeBusy> getResults() {
        RemoteFreeBusyProvider remote = new RemoteFreeBusyProvider(this.mReq, this.mCtxt, this.mStart, this.mEnd, this.mExApptUid);
        ArrayList<String> external = new ArrayList<String>();
        ArrayList<FreeBusy> fbList = new ArrayList<FreeBusy>();
        this.prepareRequests(fbList, remote, external);
        fbList.addAll(remote.getResults());
        if (external.size() > 0) {
            fbList.addAll(FreeBusyProvider.getRemoteFreeBusy(this.mRequestor, external, this.mStart, this.mEnd, -1));
        }
        return fbList;
    }

    public void getResults(Element response) {
        RemoteFreeBusyProvider remote = new RemoteFreeBusyProvider(this.mReq, this.mCtxt, this.mStart, this.mEnd, this.mExApptUid);
        ArrayList<String> external = new ArrayList<String>();
        ArrayList<FreeBusy> fbList = new ArrayList<FreeBusy>();
        this.prepareRequests(fbList, remote, external);
        for (FreeBusy fb : fbList) {
            ToXML.encodeFreeBusy(response, fb);
        }
        remote.addResults(response);
        if (external.size() > 0) {
            FreeBusyProvider.getRemoteFreeBusy(this.mRequestor, response, external, this.mStart, this.mEnd, -1);
        }
    }
}

