/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.ExchangeFreeBusyProvider;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.mail.ToXML;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeBusyProvider {
    private static HashSet<FreeBusyProvider> sPROVIDERS = new HashSet();
    private static HashMap<String, FreeBusySyncQueue> sPUSHQUEUES = new HashMap();

    public abstract FreeBusyProvider getInstance();

    public abstract String getName();

    public abstract void addFreeBusyRequest(Request var1) throws FreeBusyUserNotFoundException;

    public abstract List<FreeBusy> getResults();

    public abstract boolean registerForMailboxChanges();

    public abstract int registerForItemTypes();

    public abstract boolean handleMailboxChange(String var1);

    public abstract long cachedFreeBusyStartTime();

    public abstract long cachedFreeBusyEndTime();

    public abstract String foreignPrincipalPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(FreeBusyProvider p) {
        HashSet<FreeBusyProvider> hashSet = sPROVIDERS;
        synchronized (hashSet) {
            sPROVIDERS.add(p);
        }
    }

    private static FreeBusySyncQueue startConsumerThread(FreeBusyProvider p) {
        String name = p.getName();
        FreeBusySyncQueue queue = sPUSHQUEUES.get(name);
        if (queue != null) {
            ZimbraLog.fb.warn("free/busy provider " + name + " has been already registered.");
        }
        queue = new FreeBusySyncQueue(p);
        sPUSHQUEUES.put(name, queue);
        new Thread(queue).start();
        return queue;
    }

    public static void mailboxChanged(String accountId) {
        FreeBusyProvider.mailboxChanged(accountId, MailItem.typeToBitmask((byte)11));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mailboxChanged(String accountId, int changedType) {
        for (FreeBusyProvider prov : sPROVIDERS) {
            if (!prov.registerForMailboxChanges() || (changedType & prov.registerForItemTypes()) <= 0) continue;
            FreeBusySyncQueue queue = sPUSHQUEUES.get(prov.getName());
            if (queue == null) {
                queue = FreeBusyProvider.startConsumerThread(prov);
            }
            FreeBusySyncQueue freeBusySyncQueue = queue;
            synchronized (freeBusySyncQueue) {
                if (queue.contains(accountId)) {
                    continue;
                }
                queue.addLast(accountId);
                try {
                    queue.writeToDisk();
                }
                catch (IOException e) {
                    ZimbraLog.fb.error("can't write to the queue " + queue.getFilename());
                }
                queue.notify();
            }
        }
    }

    public void addResults(Element response) {
        for (FreeBusy fb : this.getResults()) {
            ToXML.encodeFreeBusy(response, fb);
        }
    }

    public static List<FreeBusy> getRemoteFreeBusy(Account requestor, List<String> remoteIds, long start, long end, int folder) {
        Set<FreeBusyProvider> providers = FreeBusyProvider.getProviders();
        ArrayList<FreeBusy> ret = new ArrayList<FreeBusy>();
        for (String emailAddr : remoteIds) {
            Request req = new Request(requestor, emailAddr, start, end, folder);
            boolean succeed = false;
            for (FreeBusyProvider prov : providers) {
                try {
                    prov.addFreeBusyRequest(req);
                    succeed = true;
                    break;
                }
                catch (FreeBusyUserNotFoundException e) {
                }
            }
            if (succeed) continue;
            ZimbraLog.fb.error("can't find free/busy provider for user " + emailAddr);
            ret.add(FreeBusy.emptyFreeBusy(emailAddr, start, end));
        }
        for (FreeBusyProvider prov : providers) {
            ret.addAll(prov.getResults());
        }
        return ret;
    }

    public static void getRemoteFreeBusy(Account requestor, Element response, List<String> remoteIds, long start, long end, int folder) {
        for (FreeBusy fb : FreeBusyProvider.getRemoteFreeBusy(requestor, remoteIds, start, end, folder)) {
            ToXML.encodeFreeBusy(response, fb);
        }
    }

    protected FreeBusy getFreeBusy(String accountId, int folderId) throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(accountId);
        if (mbox == null) {
            return null;
        }
        return mbox.getFreeBusy(null, this.cachedFreeBusyStartTime(), this.cachedFreeBusyEndTime(), folderId);
    }

    protected String getEmailAddress(String accountId) throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, accountId);
        if (acct == null) {
            return null;
        }
        return acct.getName();
    }

    public FreeBusySyncQueue getSyncQueue() {
        return sPUSHQUEUES.get(this.getName());
    }

    public static FreeBusyProvider getProvider(String name) {
        for (FreeBusyProvider p : sPROVIDERS) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static Set<FreeBusyProvider> getProviders() {
        HashSet<FreeBusyProvider> ret = new HashSet<FreeBusyProvider>();
        for (FreeBusyProvider p : sPROVIDERS) {
            ret.add(p.getInstance());
        }
        return ret;
    }

    public String getQueueFilename() {
        if (!this.registerForMailboxChanges()) {
            return "(none)";
        }
        return LC.freebusy_queue_directory.value() + "queue-" + this.getName();
    }

    static {
        new ExchangeFreeBusyProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeBusySyncQueue
    extends LinkedList<String>
    implements Runnable {
        private boolean mShutdown;
        private long mLastFailed;
        private static final int DEFAULT_RETRY_INTERVAL = 60000;
        private static final int MAX_FILE_SIZE = 10240;
        private String mFilename;
        private FreeBusyProvider mProvider;

        FreeBusySyncQueue(FreeBusyProvider prov) {
            this.mProvider = prov;
            this.mLastFailed = 0L;
            this.mShutdown = false;
            this.mFilename = prov.getQueueFilename();
            File f = new File(this.mFilename);
            if (!f.exists()) {
                f.getParentFile().mkdirs();
            }
            try {
                this.readFromDisk();
            }
            catch (IOException e) {
                ZimbraLog.fb.error((Object)"error reading from the queue", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(this.mProvider.getName() + " Free/Busy Sync Queue");
            while (!this.mShutdown) {
                try {
                    String acctId = null;
                    FreeBusySyncQueue freeBusySyncQueue = this;
                    synchronized (freeBusySyncQueue) {
                        if (this.size() > 0) {
                            long now = System.currentTimeMillis();
                            long retryInterval = 60000L;
                            try {
                                retryInterval = Provisioning.getInstance().getLocalServer().getFreebusyPropagationRetryInterval();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (now < this.mLastFailed + retryInterval) {
                                this.wait(retryInterval);
                                continue;
                            }
                            acctId = (String)this.getFirst();
                        } else {
                            this.wait();
                        }
                    }
                    if (acctId == null) continue;
                    boolean success = this.mProvider.handleMailboxChange(acctId);
                    FreeBusySyncQueue freeBusySyncQueue2 = this;
                    synchronized (freeBusySyncQueue2) {
                        this.removeFirst();
                    }
                    if (!success) {
                        freeBusySyncQueue2 = this;
                        synchronized (freeBusySyncQueue2) {
                            this.addLast(acctId);
                        }
                        this.mLastFailed = System.currentTimeMillis();
                    }
                    this.writeToDisk();
                }
                catch (Exception e) {
                    this.mLastFailed = System.currentTimeMillis();
                    ZimbraLog.fb.error((Object)("error while syncing freebusy for " + this.mProvider.getName()), e);
                }
            }
        }

        public void shutdown() {
            this.mShutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void writeToDisk() throws IOException {
            StringBuilder buf = new StringBuilder(Integer.toString(this.size() + 1));
            for (String id : this) {
                buf.append("\n").append(id);
            }
            if (buf.length() > 10240) {
                ZimbraLog.fb.error("The free/busy replication queue is too large. #elem=" + this.size());
                return;
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.mFilename);
                out.write(buf.toString().getBytes());
                out.getFD().sync();
                Object var5_4 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void readFromDisk() throws IOException {
            String[] tokens;
            block7: {
                long len;
                File f = new File(this.mFilename);
                if (!f.exists()) {
                    f.createNewFile();
                }
                if ((len = f.length()) > 10240L) {
                    ZimbraLog.fb.error("The free/busy replication queue is too large: " + this.mFilename + " (" + len + ")");
                    return;
                }
                FileInputStream in = null;
                tokens = null;
                try {
                    in = new FileInputStream(f);
                    byte[] buf = ByteUtil.readInput(in, (int)len, 10240);
                    tokens = new String(buf, "UTF-8").split("\n");
                    Object var8_7 = null;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            if (tokens.length < 2) {
                return;
            }
            int numTokens = Integer.parseInt(tokens[0]);
            if (numTokens != tokens.length) {
                ZimbraLog.fb.error("The free/busy replication queue is inconsistent: numTokens=" + numTokens + ", actual=" + tokens.length);
                return;
            }
            this.clear();
            Collections.addAll(this, tokens);
            this.removeFirst();
        }

        public String getFilename() {
            return this.mFilename;
        }
    }

    protected static class FreeBusyUserNotFoundException
    extends Exception {
        protected FreeBusyUserNotFoundException() {
        }
    }

    protected static class Request {
        Account requestor;
        String email;
        long start;
        long end;
        int folder;
        Object data;

        public Request(Account req, String em, long s, long e, int f) {
            this.requestor = req;
            this.email = em;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(s);
            cal.set(12, 0);
            cal.set(13, 0);
            this.start = cal.getTimeInMillis();
            cal.setTimeInMillis(e);
            cal.set(12, 0);
            cal.set(13, 0);
            this.end = cal.getTimeInMillis();
            this.folder = f;
        }
    }
}

