/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeBusy
implements Iterable<Interval> {
    private String mName;
    IntervalList mList;
    private long mStart;
    private long mEnd;
    public static final String FBTYPE_FREE = "FREE";
    public static final String FBTYPE_BUSY = "BUSY";
    public static final String FBTYPE_BUSY_TENTATIVE = "BUSY-TENTATIVE";
    public static final String FBTYPE_BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    public static final String FBTYPE_OUTLOOK_FREE = "FREE";
    public static final String FBTYPE_OUTLOOK_BUSY = "BUSY";
    public static final String FBTYPE_OUTLOOK_TENTATIVE = "TENTATIVE";
    public static final String FBTYPE_OUTLOOK_OUTOFOFFICE = "OOF";
    private static String[] sBusyOrder = new String[4];
    private static final String NL = "\n";
    private static final String MAILTO = "mailto:";
    private static final String HTTP = "http:";

    public static FreeBusy emptyFreeBusy(String name, long start, long end) {
        return new FreeBusy(name, start, end);
    }

    protected FreeBusy(String name, long start, long end) {
        this(name, new IntervalList(start, end), start, end);
    }

    protected FreeBusy(String name, IntervalList list, long start, long end) {
        this.mName = name;
        this.mList = list;
        this.mStart = start;
        this.mEnd = end;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Iterator<Interval> iterator() {
        return new IntervalIterator(this.mList);
    }

    public String getBusiest() {
        String val = "F";
        for (Interval interval : this) {
            val = FreeBusy.chooseBusier(val, interval.getStatus());
        }
        return val;
    }

    public static String chooseBusier(String freeBusy1, String freeBusy2) {
        for (int i = 0; i < sBusyOrder.length; ++i) {
            String busy = sBusyOrder[i];
            if (busy.equals(freeBusy1)) {
                return freeBusy1;
            }
            if (!busy.equals(freeBusy2)) continue;
            return freeBusy2;
        }
        if (freeBusy1 != null) {
            return freeBusy1;
        }
        return freeBusy2;
    }

    public String toVCalendar(Method m, String organizer, String attendee, String url) {
        if (m == null || organizer == null) {
            throw new IllegalArgumentException("missing method or organizer");
        }
        ParsedDateTime now = ParsedDateTime.fromUTCTime(System.currentTimeMillis());
        ParsedDateTime startTime = ParsedDateTime.fromUTCTime(this.mStart);
        ParsedDateTime endTime = ParsedDateTime.fromUTCTime(this.mEnd);
        StringBuffer toRet = new StringBuffer("BEGIN:VCALENDAR").append(NL);
        toRet.append("METHOD:").append(m.name()).append(NL);
        toRet.append("VERSION:").append("2.0").append(NL);
        toRet.append("PRODID:").append("Zimbra-Calendar-Provider").append(NL);
        toRet.append("BEGIN:VFREEBUSY").append(NL);
        toRet.append("ORGANIZER:");
        if (!organizer.toLowerCase().startsWith(MAILTO) && !organizer.toLowerCase().startsWith(HTTP)) {
            toRet.append(MAILTO);
        }
        toRet.append(organizer).append(NL);
        if (attendee != null) {
            toRet.append("ATTENDEE:");
            if (!attendee.toLowerCase().startsWith(MAILTO) && !attendee.toLowerCase().startsWith(HTTP)) {
                toRet.append(MAILTO);
            }
            toRet.append(attendee).append(NL);
        }
        toRet.append("DTSTAMP:").append(now.toString()).append(NL);
        toRet.append("DTSTART:").append(startTime.toString()).append(NL);
        toRet.append("DTEND:").append(endTime.toString()).append(NL);
        if (url != null) {
            toRet.append("URL:").append(url).append(NL);
        }
        for (Interval cur : this) {
            String status = cur.getStatus();
            if (status.equals("F")) continue;
            if (status.equals("B")) {
                toRet.append("FREEBUSY;FBTYPE=BUSY:");
            } else if (status.equals("T")) {
                toRet.append("FREEBUSY;FBTYPE=BUSY-TENTATIVE:");
            } else if (status.equals("O")) {
                toRet.append("FREEBUSY;FBTYPE=BUSY-UNAVAILABLE:");
            } else {
                assert (false);
                toRet.append(":");
            }
            ParsedDateTime curStart = ParsedDateTime.fromUTCTime(cur.getStart());
            ParsedDateTime curEnd = ParsedDateTime.fromUTCTime(cur.getEnd());
            toRet.append(curStart.toString()).append('/').append(curEnd.toString()).append(NL);
        }
        toRet.append("END:VFREEBUSY").append(NL);
        toRet.append("END:VCALENDAR").append(NL);
        return toRet.toString();
    }

    public String toString() {
        return this.mList.toString();
    }

    public long getStartTime() {
        return this.mStart;
    }

    public long getEndTime() {
        return this.mEnd;
    }

    static {
        FreeBusy.sBusyOrder[0] = "O";
        FreeBusy.sBusyOrder[1] = "B";
        FreeBusy.sBusyOrder[2] = "T";
        FreeBusy.sBusyOrder[3] = "F";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FBInstance
    implements Comparable<FBInstance> {
        private long mStartTime;
        private long mEndTime;
        private int mApptId;
        private long mRecurIdDt;
        private String mFreeBusy;

        public FBInstance(String fb, long start, long end, int apptId, long recurIdDt) {
            this.mFreeBusy = fb;
            this.mStartTime = start;
            this.mEndTime = end;
            this.mApptId = apptId;
            this.mRecurIdDt = recurIdDt;
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        public long getEndTime() {
            return this.mEndTime;
        }

        public int getApptId() {
            return this.mApptId;
        }

        public long getRecurIdDt() {
            return this.mRecurIdDt;
        }

        public String getFreeBusy() {
            return this.mFreeBusy;
        }

        @Override
        public int compareTo(FBInstance other) {
            long startDiff = this.mStartTime - other.mStartTime;
            if (startDiff != 0L) {
                return startDiff > 0L ? 1 : -1;
            }
            long endDiff = this.mEndTime - other.mEndTime;
            if (endDiff != 0L) {
                return endDiff > 0L ? 1 : -1;
            }
            int idDiff = this.mApptId - other.mApptId;
            if (idDiff != 0) {
                return idDiff;
            }
            long ridDiff = this.mRecurIdDt - other.mRecurIdDt;
            if (ridDiff != 0L) {
                return ridDiff > 0L ? 1 : -1;
            }
            return this.mFreeBusy.compareTo(other.mFreeBusy);
        }

        public boolean equals(Object o) {
            if (!(o instanceof FBInstance)) {
                return false;
            }
            FBInstance other = (FBInstance)o;
            return this.mStartTime == other.mStartTime && this.mEndTime == other.mEndTime && this.mApptId == other.mApptId && this.mRecurIdDt == other.mRecurIdDt && this.mFreeBusy.equals(other.mFreeBusy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        PUBLISH,
        REQUEST,
        REPLY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Interval {
        long mStart;
        long mEnd;
        Interval mNext = null;
        Interval mPrev = null;
        String mStatus;
        LinkedHashSet<FBInstance> mInstances;

        public Interval(long start, long end, String status) {
            this.mStart = start;
            this.mEnd = end;
            assert (end >= start);
            this.mStatus = status != null ? status : "F";
            this.mInstances = new LinkedHashSet();
        }

        public Interval(long start, long end, String status, FBInstance instance) {
            this(start, end, status);
            if (instance != null) {
                this.mInstances.add(instance);
            }
        }

        public Interval(long start, long end, String status, LinkedHashSet<FBInstance> instances) {
            this(start, end, status);
            this.addInstances(instances);
        }

        public String toString() {
            StringBuilder toRet = new StringBuilder();
            toRet.append("start=").append(this.mStart);
            toRet.append(", end=").append(this.mEnd);
            toRet.append(", status=").append(this.mStatus);
            toRet.append(", invites=[");
            int i = 0;
            for (FBInstance instance : this.mInstances) {
                if (i > 0) {
                    toRet.append(", ");
                }
                ++i;
                toRet.append(instance.toString());
            }
            toRet.append("]");
            return toRet.toString();
        }

        void insertAfter(Interval other) {
            other.mNext = this.mNext;
            other.mPrev = this;
            if (this.mNext != null) {
                this.mNext.mPrev = other;
            }
            this.mNext = other;
        }

        void removeNext() {
            this.mNext = this.mNext.getNext();
            if (this.mNext != null) {
                this.mNext.mPrev = this;
            }
        }

        void addInstances(LinkedHashSet<FBInstance> instances) {
            if (instances != null) {
                this.mInstances.addAll(instances);
            }
        }

        void combineStatus(String otherStatus) {
            this.mStatus = FreeBusy.chooseBusier(this.mStatus, otherStatus);
        }

        public long getStart() {
            return this.mStart;
        }

        public long getEnd() {
            return this.mEnd;
        }

        public String getStatus() {
            return this.mStatus;
        }

        public LinkedHashSet<FBInstance> getInstances() {
            return this.mInstances;
        }

        public boolean overlapsOrAbuts(Interval other) {
            return other.mEnd >= this.mStart && other.mStart < this.mEnd;
        }

        public boolean hasPrev() {
            return this.mPrev != null;
        }

        public Interval getPrev() {
            return this.mPrev;
        }

        public boolean hasNext() {
            return this.mNext != null;
        }

        public Interval getNext() {
            return this.mNext;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IntervalList
    implements Iterable<Interval> {
        long mStart;
        long mEnd;
        Interval mHead;

        @Override
        public Iterator<Interval> iterator() {
            return new IntervalIterator(this);
        }

        IntervalList(long start, long end) {
            this.mStart = start;
            this.mEnd = end;
            this.mHead = new Interval(start, end, "F");
        }

        void addInterval(Interval toAdd) {
            assert (toAdd.mStart <= toAdd.mEnd);
            if (toAdd.mStart < this.mStart) {
                toAdd.mStart = this.mStart;
            }
            if (toAdd.mEnd > this.mEnd) {
                toAdd.mEnd = this.mEnd;
            }
            Interval uberStart = this.mHead;
            while (uberStart.hasNext() && uberStart.getNext().mStart <= toAdd.mStart) {
                uberStart = uberStart.getNext();
            }
            assert (uberStart.mStart <= toAdd.mStart);
            assert (uberStart.overlapsOrAbuts(toAdd));
            Interval cur = uberStart;
            while (toAdd.mStart < toAdd.mEnd) {
                assert (cur.mEnd >= cur.mStart);
                assert (cur.mStart <= toAdd.mStart);
                if (toAdd.mStart > cur.mStart) {
                    Interval newInt = new Interval(toAdd.mStart, cur.mEnd, cur.mStatus, cur.getInstances());
                    cur.insertAfter(newInt);
                    cur.mEnd = newInt.mStart;
                    cur = newInt;
                }
                if (toAdd.mEnd < cur.mEnd) {
                    Interval afterUs = new Interval(toAdd.mEnd, cur.mEnd, cur.mStatus, cur.getInstances());
                    cur.insertAfter(afterUs);
                    cur.mEnd = toAdd.mEnd;
                }
                cur.combineStatus(toAdd.mStatus);
                cur.addInstances(toAdd.getInstances());
                toAdd.mStart = cur.mEnd;
                if (cur.mNext != null) {
                    cur = cur.mNext;
                    continue;
                }
                assert (toAdd.mStart == toAdd.mEnd);
            }
            cur = uberStart;
            if (cur.hasPrev()) {
                cur = cur.getPrev();
            }
            while (cur.getNext() != null) {
                assert (cur.getNext().mStart == cur.mEnd);
                if (cur.mStatus.equals(cur.getNext().mStatus)) {
                    cur.mEnd = cur.getNext().mEnd;
                    cur.mInstances.addAll(cur.getNext().mInstances);
                    cur.removeNext();
                    continue;
                }
                cur = cur.getNext();
            }
        }

        public String toString() {
            StringBuffer toRet = new StringBuffer(FreeBusy.NL);
            for (Interval cur = this.mHead; cur != null; cur = cur.getNext()) {
                toRet.append("\t").append(cur.toString()).append(FreeBusy.NL);
            }
            return toRet.toString();
        }

        public Interval getHead() {
            return this.mHead;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntervalIterator
    implements Iterator<Interval> {
        private Interval mCur;

        private IntervalIterator(IntervalList list) {
            this.mCur = list.getHead();
        }

        @Override
        public boolean hasNext() {
            return this.mCur != null;
        }

        @Override
        public Interval next() {
            Interval toRet = this.mCur;
            this.mCur = this.mCur.getNext();
            return toRet;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Unsupported");
        }
    }
}

