/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.cs.httpclient.URLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FbCli {
    private SoapHttpTransport mTransport;

    public FbCli() throws ServiceException {
        String server = LC.zimbra_zmprov_default_soap_server.value();
        String adminUrl = URLUtil.getAdminURL(server);
        this.mTransport = new SoapHttpTransport(adminUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FbProvider> getAllFreeBusyProviders() throws ServiceException, IOException {
        ArrayList<FbProvider> providers = new ArrayList<FbProvider>();
        try {
            this.auth();
            Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_ALL_FREE_BUSY_PROVIDERS_REQUEST);
            Element resp = this.mTransport.invoke(req);
            for (Element provElem : resp.listElements("provider")) {
                FbProvider prov = new FbProvider();
                prov.name = provElem.getAttribute("name", null);
                prov.propagate = provElem.getAttributeBool("propagate", false);
                prov.fbstart = provElem.getAttributeLong("start", 0L);
                prov.fbend = provElem.getAttributeLong("end", 0L);
                prov.queue = provElem.getAttribute("queue", null);
                prov.prefix = provElem.getAttribute("prefix", null);
                providers.add(prov);
            }
            Object var8_7 = null;
            this.mTransport.shutdown();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.mTransport.shutdown();
            throw throwable;
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FbQueue> getFreeBusyQueueInfo(String provider) throws ServiceException, IOException {
        ArrayList<FbQueue> queues = new ArrayList<FbQueue>();
        try {
            this.auth();
            Element.XMLElement req = new Element.XMLElement(AdminConstants.GET_FREE_BUSY_QUEUE_INFO_REQUEST);
            if (provider != null) {
                req.addElement("provider").addAttribute("name", provider);
            }
            Element resp = this.mTransport.invoke(req);
            for (Element provElem : resp.listElements("provider")) {
                FbQueue queue = new FbQueue();
                queue.name = provElem.getAttribute("name", null);
                for (Element acctElem : provElem.listElements("account")) {
                    queue.accounts.add(acctElem.getAttribute("id", null));
                }
                queues.add(queue);
            }
            Object var11_10 = null;
            this.mTransport.shutdown();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.mTransport.shutdown();
            throw throwable;
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFreeBusyForDomain(String domain) throws ServiceException, IOException {
        try {
            this.auth();
            Element.XMLElement req = new Element.XMLElement(AdminConstants.PUSH_FREE_BUSY_REQUEST);
            req.addElement("domain").addAttribute("name", domain);
            this.mTransport.invoke(req);
            Object var4_3 = null;
            this.mTransport.shutdown();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mTransport.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFreeBusyForAccounts(Collection<String> accounts) throws ServiceException, IOException {
        try {
            this.auth();
            Element.XMLElement req = new Element.XMLElement(AdminConstants.PUSH_FREE_BUSY_REQUEST);
            for (String acct : accounts) {
                req.addElement("account").addAttribute("id", acct);
            }
            this.mTransport.invoke(req);
            Object var6_5 = null;
            this.mTransport.shutdown();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mTransport.shutdown();
            throw throwable;
        }
    }

    private void auth() throws ServiceException, IOException {
        Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
        req.addElement("name").setText(LC.zimbra_ldap_user.value());
        req.addElement("password").setText(LC.zimbra_ldap_password.value());
        Element resp = this.mTransport.invoke(req);
        this.mTransport.setAuthToken(resp.getElement("authToken").getText());
    }

    public static class FbQueue {
        public String name;
        Collection<String> accounts = new ArrayList<String>();

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name).append("\n");
            for (String acct : this.accounts) {
                buf.append("\t").append(acct).append("\n");
            }
            return buf.toString();
        }
    }

    public static class FbProvider {
        public String name;
        public boolean propagate;
        public String queue;
        public String prefix;
        public long fbstart;
        public long fbend;

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name).append("\n");
            buf.append("\t").append("propagate: ").append(this.propagate).append("\n");
            buf.append("\t").append("queue:     ").append(this.queue).append("\n");
            buf.append("\t").append("prefix:    ").append(this.prefix).append("\n");
            buf.append("\t").append("start:     ").append(new Date(this.fbstart)).append("\n");
            buf.append("\t").append("end:       ").append(new Date(this.fbend)).append("\n");
            return buf.toString();
        }
    }
}

