/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.localconfig.KnownKey;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.dav.DomUtil;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.DefaultDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeMessage {
    public static final String PUBURL_FIRST_PART = "/public/NON_IPM_SUBTREE/SCHEDULE+ FREE BUSY/EX:";
    public static final String PUBURL_SECOND_PART = "USER-";
    public static final String PUBURL_RCPT = "/cn=RECIPIENTS/cn=";
    public static final String PUBURL_EML = ".EML";
    public static final String ENCODED_SLASH = "_xF8FF_";
    public static final String ENCODED_SPACE = "%20";
    public static final String ENCODED_PLUS = "%2B";
    public static final String MV_INT = "mv.int";
    public static final String MV_BIN = "mv.bin.base64";
    public static final int MINS_IN_DAY = 1440;
    public static final Namespace NS_DAV = Namespace.get("D", "DAV:");
    public static final Namespace NS_XML = Namespace.get("c", "xml:");
    public static final Namespace NS_MSFT = Namespace.get("b", "http://schemas.microsoft.com/mapi/proptag/");
    public static final Namespace NS_WEB_FOLDERS = Namespace.get("e", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
    public static final QName EL_SET = QName.get("set", NS_DAV);
    public static final QName EL_PROP = QName.get("prop", NS_DAV);
    public static final QName EL_PROPERTYUPDATE = QName.get("propertyupdate", NS_DAV);
    public static final QName EL_V = QName.get("v", NS_XML);
    public static final QName ATTR_DT = QName.get("dt", NS_WEB_FOLDERS);
    public static final QName PR_FREEBUSY_ALL_EVENTS = QName.get("0x68501102", NS_MSFT);
    public static final QName PR_FREEBUSY_ALL_MONTHS = QName.get("0x684F1003", NS_MSFT);
    public static final QName PR_FREEBUSY_BUSY_EVENTS = QName.get("0x68541102", NS_MSFT);
    public static final QName PR_FREEBUSY_BUSY_MONTHS = QName.get("0x68531003", NS_MSFT);
    public static final QName PR_FREEBUSY_EMAIL_ADDRESS = QName.get("0x6849001F", NS_MSFT);
    public static final QName PR_FREEBUSY_END_RANGE = QName.get("0x68480003", NS_MSFT);
    public static final QName PR_FREEBUSY_ENTRYIDS = QName.get("0x36E41102", NS_MSFT);
    public static final QName PR_FREEBUSY_LAST_MODIFIED = QName.get("0x68680040", NS_MSFT);
    public static final QName PR_FREEBUSY_NUM_MONTHS = QName.get("0x68690003", NS_MSFT);
    public static final QName PR_FREEBUSY_OOF_EVENTS = QName.get("0x68561102", NS_MSFT);
    public static final QName PR_FREEBUSY_OOF_MONTHS = QName.get("0x68551003", NS_MSFT);
    public static final QName PR_FREEBUSY_START_RANGE = QName.get("0x68470003", NS_MSFT);
    public static final QName PR_FREEBUSY_TENTATIVE_EVENTS = QName.get("0x68521102", NS_MSFT);
    public static final QName PR_FREEBUSY_TENTATIVE_MONTHS = QName.get("0x68511003", NS_MSFT);
    public static final QName PR_PROCESS_MEETING_REQUESTS = QName.get("0x686D000B", NS_MSFT);
    public static final QName PR_DECLINE_RECURRING_MEETING_REQUESTS = QName.get("0x686E000B", NS_MSFT);
    public static final QName PR_DECLINE_CONFLICTING_MEETING_REQUESTS = QName.get("0x686F000B", NS_MSFT);
    public static final QName PR_CAL_END_TIME = QName.get("0x10C40040", NS_MSFT);
    public static final QName PR_CAL_RECURRING_ID = QName.get("0x10C50040", NS_MSFT);
    public static final QName PR_CAL_REMINDER_NEXT_TIME = QName.get("0x10CA0040", NS_MSFT);
    public static final QName PR_CAL_START_TIME = QName.get("0x10C30040", NS_MSFT);
    public static final QName PR_SUBJECT_A = QName.get("0x0037001E", NS_MSFT);
    public static final QName PR_68410003 = QName.get("0x68410003", NS_MSFT);
    public static final QName PR_6842000B = QName.get("0x6842000B", NS_MSFT);
    public static final QName PR_6843000B = QName.get("0x6843000B", NS_MSFT);
    public static final QName PR_6846000B = QName.get("0x6846000B", NS_MSFT);
    public static final QName PR_684B000B = QName.get("0x684B000B", NS_MSFT);
    private static Pattern SLASH = Pattern.compile("\\/");
    private static Pattern SPACE = Pattern.compile(" ");
    private static Pattern PLUS = Pattern.compile("\\+");
    private String mOu;
    private String mCn;
    private String mMail;
    private static char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ExchangeMessage(String ou, String cn, String mail) {
        this.mOu = ou;
        this.mCn = cn;
        this.mMail = mail;
    }

    private String getRcpt(KnownKey override) {
        String value = override.value();
        if (value != null && value.length() > 0) {
            return "/cn=" + value + "/cn=";
        }
        return PUBURL_RCPT;
    }

    public String getUrl() {
        StringBuilder buf = new StringBuilder(PUBURL_FIRST_PART);
        buf.append(SLASH.matcher(this.mOu).replaceAll(ENCODED_SLASH));
        buf.append("/").append(PUBURL_SECOND_PART);
        buf.append(SLASH.matcher(this.getRcpt(LC.freebusy_exchange_cn1)).replaceAll(ENCODED_SLASH));
        buf.append(this.mCn);
        buf.append(PUBURL_EML);
        String ret = buf.toString();
        ret = SPACE.matcher(ret).replaceAll(ENCODED_SPACE);
        ret = PLUS.matcher(ret).replaceAll(ENCODED_PLUS);
        return ret;
    }

    public Document createRequest(FreeBusy fb) {
        Element root = DocumentHelper.createElement(EL_PROPERTYUPDATE);
        root.add(NS_XML);
        root.add(NS_MSFT);
        root.add(NS_WEB_FOLDERS);
        Element prop = root.addElement(EL_SET).addElement(EL_PROP);
        this.addElement(prop, PR_SUBJECT_A, PUBURL_SECOND_PART + this.getRcpt(LC.freebusy_exchange_cn2) + this.mCn);
        this.addElement(prop, PR_FREEBUSY_START_RANGE, this.minutesSinceMsEpoch(fb.getStartTime()));
        this.addElement(prop, PR_FREEBUSY_END_RANGE, this.minutesSinceMsEpoch(fb.getEndTime()));
        this.addElement(prop, PR_FREEBUSY_EMAIL_ADDRESS, this.mOu + this.getRcpt(LC.freebusy_exchange_cn3) + this.mCn);
        Element allMonths = this.addElement(prop, PR_FREEBUSY_ALL_MONTHS, null, ATTR_DT, MV_INT);
        Element allEvents = this.addElement(prop, PR_FREEBUSY_ALL_EVENTS, null, ATTR_DT, MV_BIN);
        Element busyMonths = this.addElement(prop, PR_FREEBUSY_BUSY_MONTHS, null, ATTR_DT, MV_INT);
        Element busyEvents = this.addElement(prop, PR_FREEBUSY_BUSY_EVENTS, null, ATTR_DT, MV_BIN);
        Element tentativeMonths = this.addElement(prop, PR_FREEBUSY_TENTATIVE_MONTHS, null, ATTR_DT, MV_INT);
        Element tentativeEvents = this.addElement(prop, PR_FREEBUSY_TENTATIVE_EVENTS, null, ATTR_DT, MV_BIN);
        Element oofMonths = this.addElement(prop, PR_FREEBUSY_OOF_MONTHS, null, ATTR_DT, MV_INT);
        Element oofEvents = this.addElement(prop, PR_FREEBUSY_OOF_EVENTS, null, ATTR_DT, MV_BIN);
        this.addElement(prop, PR_68410003, "0");
        this.addElement(prop, PR_6842000B, "1");
        this.addElement(prop, PR_6843000B, "1");
        this.addElement(prop, PR_6846000B, "1");
        this.addElement(prop, PR_684B000B, "1");
        this.addElement(prop, PR_PROCESS_MEETING_REQUESTS, "0");
        this.addElement(prop, PR_DECLINE_RECURRING_MEETING_REQUESTS, "0");
        this.addElement(prop, PR_DECLINE_CONFLICTING_MEETING_REQUESTS, "0");
        long startMonth = this.millisToMonths(fb.getStartTime());
        long endMonth = this.millisToMonths(fb.getEndTime());
        FreeBusy.IntervalList consolidated = new FreeBusy.IntervalList(fb.getStartTime(), fb.getEndTime());
        this.encodeIntervals(fb, startMonth, endMonth, "B", busyMonths, busyEvents, consolidated);
        this.encodeIntervals(fb, startMonth, endMonth, "T", tentativeMonths, tentativeEvents, consolidated);
        this.encodeIntervals(fb, startMonth, endMonth, "O", oofMonths, oofEvents, consolidated);
        this.encodeIntervals(consolidated, startMonth, endMonth, "B", allMonths, allEvents, null);
        return new DefaultDocument(root);
    }

    private void encodeIntervals(Iterable<FreeBusy.Interval> fb, long startMonth, long endMonth, String type, Element months, Element events, FreeBusy.IntervalList consolidated) {
        HashMap fbMap = new HashMap();
        for (long i = startMonth; i <= endMonth; ++i) {
            fbMap.put(i, new LinkedList());
        }
        for (FreeBusy.Interval interval : fb) {
            String status = interval.getStatus();
            if (!status.equals(type)) continue;
            long start = interval.getStart();
            long end = interval.getEnd();
            long fbMonth = this.millisToMonths(start);
            LinkedList buf = (LinkedList)fbMap.get(fbMonth);
            this.encodeFb(start, end, buf);
            if (consolidated == null) continue;
            consolidated.addInterval(new FreeBusy.Interval(start, end, "B"));
        }
        for (long m = startMonth; m <= endMonth; ++m) {
            String buf = "";
            LinkedList encodedList = (LinkedList)fbMap.get(m);
            if (encodedList.size() > 0) {
                try {
                    byte[] raw = new byte[encodedList.size()];
                    for (int i = 0; i < encodedList.size(); ++i) {
                        raw[i] = (Byte)encodedList.get(i);
                    }
                    byte[] encoded = Base64.encodeBase64((byte[])raw);
                    buf = new String(encoded, "UTF-8");
                }
                catch (IOException e) {
                    ZimbraLog.fb.warn((Object)("error converting millis to minutes for month " + m), e);
                    continue;
                }
            }
            this.addElement(months, EL_V, Long.toString(m));
            this.addElement(events, EL_V, buf);
        }
    }

    public HttpMethod createMethod(String uri, FreeBusy fb) throws IOException {
        PostMethod method = new PostMethod(uri){
            private String PROPPATCH;
            {
                this.PROPPATCH = "PROPPATCH";
            }

            public String getName() {
                return this.PROPPATCH;
            }
        };
        Document doc = this.createRequest(fb);
        byte[] buf = DomUtil.getBytes(doc);
        if (ZimbraLog.fb.isDebugEnabled()) {
            ZimbraLog.fb.debug(new String(buf, "UTF-8"));
        }
        ByteArrayRequestEntity re = new ByteArrayRequestEntity(buf, "text/xml");
        method.setRequestEntity(re);
        return method;
    }

    private Element addElement(Element parent, QName name, String text, QName attr, String attrVal) {
        Element el = parent.addElement(name);
        if (text != null) {
            el.setText(text);
        }
        if (attr != null && attrVal != null) {
            el.addAttribute(attr, attrVal);
        }
        return el;
    }

    private Element addElement(Element parent, QName name, String text) {
        return this.addElement(parent, name, text, null, null);
    }

    private void encodeFb(long s, long e, LinkedList<Byte> buf) {
        int start = this.millisToMinutes(s);
        int end = start + (int)((e - s) / 60000L);
        ZimbraLog.fb.debug("Start: %s %d", new Date(s).toGMTString(), start);
        ZimbraLog.fb.debug("End:   %s %d", new Date(e).toGMTString(), end);
        buf.addLast((byte)(start & 0xFF));
        buf.addLast((byte)(start >> 8 & 0xFF));
        buf.addLast((byte)(end & 0xFF));
        buf.addLast((byte)(end >> 8 & 0xFF));
    }

    private int millisToMinutes(long millis) {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).setTimeZone(ICalTimeZone.getUTC());
        c.setTime(new Date(millis));
        int days = c.get(5) - 1;
        int hours = 24 * days + c.get(11);
        int minutes = c.get(12);
        return 60 * hours + minutes;
    }

    private long millisToMonths(long millis) {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).setTimeZone(ICalTimeZone.getUTC());
        c.setTime(new Date(millis));
        return c.get(1) * 16 + c.get(2) + 1;
    }

    private String minutesSinceMsEpoch(long millis) {
        long mins = (millis / 1000L + 11644473600L) / 60L;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            int b = (int)(mins & 0xFL);
            buf.insert(0, HEX[b]);
            mins >>= 4;
        }
        buf.insert(0, "0x");
        return buf.toString();
    }

    public String toString() {
        return this.mMail + ", cn=" + this.mCn + ", ou=" + this.mOu;
    }
}

