/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.fb;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.ExchangeMessage;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyProvider;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.mailbox.MailItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeFreeBusyProvider
extends FreeBusyProvider {
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)";
    public static final String FORM_AUTH_PATH = "/exchweb/bin/auth/owaauth.dll";
    public static final int FB_INTERVAL = 30;
    public static final int MULTI_STATUS = 207;
    private static ArrayList<ExchangeUserResolver> sRESOLVERS = new ArrayList();
    private HashMap<String, ArrayList<FreeBusyProvider.Request>> mRequests = new HashMap();
    private static final String EXCHANGE = "EXCHANGE";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_TRANSLATE = "Translate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResolver(ExchangeUserResolver r, int priority) {
        ArrayList<ExchangeUserResolver> arrayList = sRESOLVERS;
        synchronized (arrayList) {
            sRESOLVERS.ensureCapacity(priority + 1);
            sRESOLVERS.add(priority, r);
        }
    }

    @Override
    public FreeBusyProvider getInstance() {
        return new ExchangeFreeBusyProvider();
    }

    @Override
    public void addFreeBusyRequest(FreeBusyProvider.Request req) throws FreeBusyProvider.FreeBusyUserNotFoundException {
        ServerInfo info = null;
        for (ExchangeUserResolver resolver : sRESOLVERS) {
            String email = req.email;
            if (req.requestor != null) {
                email = req.requestor.getName();
            }
            if ((info = resolver.getServerInfo(email)) == null) continue;
            break;
        }
        if (info == null) {
            throw new FreeBusyProvider.FreeBusyUserNotFoundException();
        }
        this.addRequest(info, req);
    }

    private void addRequest(ServerInfo info, FreeBusyProvider.Request req) {
        ArrayList<FreeBusyProvider.Request> r = this.mRequests.get(info.url);
        if (r == null) {
            r = new ArrayList();
            this.mRequests.put(info.url, r);
        }
        req.data = info;
        r.add(req);
    }

    @Override
    public List<FreeBusy> getResults() {
        ArrayList<FreeBusy> ret = new ArrayList<FreeBusy>();
        for (Map.Entry<String, ArrayList<FreeBusyProvider.Request>> entry : this.mRequests.entrySet()) {
            try {
                ret.addAll(this.getFreeBusyForHost(entry.getKey(), entry.getValue()));
            }
            catch (IOException e) {
                ZimbraLog.fb.error((Object)("error communicating to " + entry.getKey()), e);
                return this.getEmptyList(entry.getValue());
            }
        }
        return ret;
    }

    @Override
    public String foreignPrincipalPrefix() {
        return "ad:";
    }

    @Override
    public String getName() {
        return EXCHANGE;
    }

    @Override
    public int registerForItemTypes() {
        return MailItem.typeToBitmask((byte)11);
    }

    @Override
    public boolean registerForMailboxChanges() {
        if (sRESOLVERS.size() > 1) {
            return true;
        }
        Config config = null;
        try {
            config = Provisioning.getInstance().getConfig();
        }
        catch (ServiceException se) {
            ZimbraLog.fb.warn((Object)"cannot fetch config", se);
            return false;
        }
        String url = config.getAttr("zimbraFreebusyExchangeURL", null);
        String user = config.getAttr("zimbraFreebusyExchangeAuthUsername", null);
        String pass = config.getAttr("zimbraFreebusyExchangeAuthPassword", null);
        String scheme = config.getAttr("zimbraFreebusyExchangeAuthScheme", null);
        return url != null && user != null && pass != null && scheme != null;
    }

    @Override
    public long cachedFreeBusyStartTime() {
        Calendar cal = GregorianCalendar.getInstance();
        try {
            Config config = Provisioning.getInstance().getConfig();
            long dur = config.getTimeInterval("zimbraFreebusyExchangeCachedIntervalStart", 0L);
            cal.setTimeInMillis(System.currentTimeMillis() - dur);
        }
        catch (ServiceException se) {
            cal.setTimeInMillis(System.currentTimeMillis() - 604800000L);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis();
    }

    @Override
    public long cachedFreeBusyEndTime() {
        long duration = 5356800000L;
        Calendar cal = GregorianCalendar.getInstance();
        try {
            Config config = Provisioning.getInstance().getConfig();
            duration = config.getTimeInterval("zimbraFreebusyExchangeCachedInterval", duration);
        }
        catch (ServiceException se) {
            // empty catch block
        }
        cal.setTimeInMillis(this.cachedFreeBusyStartTime() + duration);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleMailboxChange(String accountId) {
        FreeBusy fb;
        String email;
        try {
            email = this.getEmailAddress(accountId);
            fb = this.getFreeBusy(accountId, -1);
        }
        catch (ServiceException se) {
            ZimbraLog.fb.warn((Object)("can't get freebusy for account " + accountId), se);
            if (se.isReceiversFault()) return false;
            return true;
        }
        if (email == null || fb == null) {
            ZimbraLog.fb.warn("can't get freebusy for account " + accountId);
            return true;
        }
        ServerInfo serverInfo = this.getServerInfo(email);
        if (serverInfo == null || serverInfo.org == null || serverInfo.cn == null) {
            ZimbraLog.fb.warn("no exchange server info for user " + email);
            return true;
        }
        ExchangeMessage msg = new ExchangeMessage(serverInfo.org, serverInfo.cn, email);
        String url = serverInfo.url + msg.getUrl();
        HttpMethod method = null;
        try {
            try {
                ZimbraLog.fb.debug("POST " + url);
                method = msg.createMethod(url, fb);
                method.setRequestHeader(HEADER_TRANSLATE, "f");
                int status = this.sendRequest(method, serverInfo);
                if (status == 207) {
                    Object var13_16 = null;
                    method.releaseConnection();
                    return true;
                }
                InputStream resp = method.getResponseBodyAsStream();
                String respStr = resp == null ? "" : new String(ByteUtil.readInput(resp, 1024, 1024), "UTF-8");
                ZimbraLog.fb.error("cannot modify resource at %s : http error %d, buf (%s)", url, status, respStr);
                boolean bl = false;
                Object var13_15 = null;
                method.releaseConnection();
                return bl;
            }
            catch (IOException ioe) {
                ZimbraLog.fb.error((Object)("error commucating to " + serverInfo.url), ioe);
                boolean bl = false;
                Object var13_17 = null;
                method.releaseConnection();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    private int sendRequest(HttpMethod method, ServerInfo info) throws IOException {
        method.setDoAuthentication(true);
        method.setRequestHeader(HEADER_USER_AGENT, USER_AGENT);
        HttpClient client = ZimbraHttpConnectionManager.getExternalHttpConnMgr().newHttpClient();
        HttpProxyUtil.configureProxy(client);
        switch (info.scheme) {
            case basic: {
                this.basicAuth(client, info);
                break;
            }
            case form: {
                this.formAuth(client, info);
            }
        }
        return client.executeMethod(method);
    }

    private boolean basicAuth(HttpClient client, ServerInfo info) {
        HttpState state = new HttpState();
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(info.authUsername, info.authPassword);
        state.setCredentials(AuthScope.ANY, cred);
        client.setState(state);
        ArrayList<String> authPrefs = new ArrayList<String>();
        authPrefs.add("Basic");
        client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formAuth(HttpClient client, ServerInfo info) throws IOException {
        PostMethod method;
        block3: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append("destination=");
            buf.append(URLEncoder.encode(info.url, "UTF-8"));
            buf.append("&username=");
            buf.append(info.authUsername);
            buf.append("&password=");
            buf.append(URLEncoder.encode(info.authPassword, "UTF-8"));
            buf.append("&flags=0");
            buf.append("&SubmitCreds=Log On");
            buf.append("&trusted=0");
            String url = info.url + FORM_AUTH_PATH;
            method = new PostMethod(url);
            ByteArrayRequestEntity re = new ByteArrayRequestEntity(buf.toString().getBytes(), "x-www-form-urlencoded");
            method.setRequestEntity(re);
            HttpState state = new HttpState();
            client.setState(state);
            try {
                int status = client.executeMethod(method);
                if (status < 400) break block3;
                ZimbraLog.fb.error("form auth to Exchange returned an error: " + status);
                bl = false;
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                method.releaseConnection();
                throw throwable;
            }
            method.releaseConnection();
            return bl;
        }
        Object var11_11 = null;
        method.releaseConnection();
        return true;
    }

    ExchangeFreeBusyProvider() {
    }

    private List<FreeBusy> getEmptyList(ArrayList<FreeBusyProvider.Request> req) {
        ArrayList<FreeBusy> ret = new ArrayList<FreeBusy>();
        for (FreeBusyProvider.Request r : req) {
            ret.add(FreeBusy.emptyFreeBusy(r.email, r.start, r.end));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FreeBusy> getFreeBusyForHost(String host, ArrayList<FreeBusyProvider.Request> req) throws IOException {
        Element response;
        GetMethod method;
        block11: {
            block10: {
                FreeBusyProvider.Request r = req.get(0);
                ServerInfo serverInfo = (ServerInfo)r.data;
                if (serverInfo == null) {
                    ZimbraLog.fb.warn("no exchange server info for user " + r.email);
                    return this.getEmptyList(req);
                }
                String url = this.constructGetUrl(serverInfo, req);
                ZimbraLog.fb.debug("fetching fb from url=" + url);
                method = new GetMethod(url);
                response = null;
                int status = this.sendRequest(method, serverInfo);
                if (status == 200) break block10;
                List<FreeBusy> list = this.getEmptyList(req);
                Object var11_16 = null;
                method.releaseConnection();
                return list;
            }
            try {
                if (ZimbraLog.fb.isDebugEnabled()) {
                    String buf = new String(ByteUtil.readInput(method.getResponseBodyAsStream(), 10240, 10240), "UTF-8");
                    ZimbraLog.fb.debug(buf);
                    response = Element.parseXML(buf);
                    break block11;
                }
                response = Element.parseXML(method.getResponseBodyAsStream());
            }
            catch (DocumentException e) {
                ZimbraLog.fb.warn((Object)"error parsing fb response from exchange", e);
                List<FreeBusy> buf = this.getEmptyList(req);
                Object var11_18 = null;
                method.releaseConnection();
                return buf;
            }
            catch (IOException e) {
                try {
                    ZimbraLog.fb.warn((Object)"error parsing fb response from exchange", e);
                    List<FreeBusy> buf = this.getEmptyList(req);
                    Object var11_19 = null;
                    method.releaseConnection();
                    return buf;
                }
                catch (Throwable throwable) {
                    Object var11_20 = null;
                    method.releaseConnection();
                    throw throwable;
                }
            }
        }
        Object var11_17 = null;
        method.releaseConnection();
        ArrayList<FreeBusy> ret = new ArrayList<FreeBusy>();
        for (FreeBusyProvider.Request re : req) {
            String fb = this.getFbString(response, re.email);
            ret.add(new ExchangeUserFreeBusy(fb, re.email, 30, re.start, re.end));
        }
        return ret;
    }

    private String constructGetUrl(ServerInfo info, ArrayList<FreeBusyProvider.Request> req) {
        StringBuilder buf = new StringBuilder(info.url);
        buf.append("/public/?cmd=freebusy");
        buf.append("&start=").append(DateUtil.toISO8601(new Date(req.get((int)0).start)));
        buf.append("&end=").append(DateUtil.toISO8601(new Date(req.get((int)0).end)));
        buf.append("&interval=").append(30);
        for (FreeBusyProvider.Request r : req) {
            buf.append("&u=SMTP:").append(r.email);
        }
        return buf.toString();
    }

    private String getFbString(Element fbxml, String emailAddr) {
        String ret = "";
        Element node = fbxml.getOptionalElement("recipients");
        if (node != null) {
            for (Element e : node.listElements("item")) {
                Element email = e.getOptionalElement("email");
                if (email == null || !email.getText().trim().equalsIgnoreCase(emailAddr)) continue;
                Element fb = e.getOptionalElement("fbdata");
                if (fb == null) break;
                ret = fb.getText();
                break;
            }
        }
        return ret;
    }

    public ServerInfo getServerInfo(String emailAddr) {
        ExchangeUserResolver r;
        ServerInfo serverInfo = null;
        Iterator<ExchangeUserResolver> i$ = sRESOLVERS.iterator();
        while (i$.hasNext() && (serverInfo = (r = i$.next()).getServerInfo(emailAddr)) == null) {
        }
        return serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkAuth(ServerInfo info, Account requestor) throws ServiceException, IOException {
        ExchangeFreeBusyProvider prov = new ExchangeFreeBusyProvider();
        ArrayList<FreeBusyProvider.Request> req = new ArrayList<FreeBusyProvider.Request>();
        req.add(new FreeBusyProvider.Request(requestor, requestor.getName(), prov.cachedFreeBusyStartTime(), prov.cachedFreeBusyEndTime(), -1));
        String url = prov.constructGetUrl(info, req);
        GetMethod method = new GetMethod(url);
        try {
            int n = prov.sendRequest(method, info);
            Object var8_7 = null;
            method.releaseConnection();
            return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    static {
        ExchangeFreeBusyProvider.registerResolver(new BasicUserResolver(), 0);
        ExchangeFreeBusyProvider.register(new ExchangeFreeBusyProvider());
    }

    public static class ExchangeUserFreeBusy
    extends FreeBusy {
        private final char FREE = (char)48;
        private final char TENTATIVE = (char)49;
        private final char BUSY = (char)50;
        private final char UNAVAILABLE = (char)51;
        private final char NODATA = (char)52;

        protected ExchangeUserFreeBusy(String fb, String emailAddr, int interval, long start, long end) {
            super(emailAddr, start, end);
            this.parseInterval(fb, emailAddr, interval, start, end);
        }

        private void parseInterval(String fb, String emailAddr, int interval, long start, long end) {
            long intervalInMillis = (long)interval * 60L * 1000L;
            for (int i = 0; i < fb.length(); ++i) {
                switch (fb.charAt(i)) {
                    case '1': {
                        this.mList.addInterval(new FreeBusy.Interval(start, start + intervalInMillis, "T"));
                        break;
                    }
                    case '2': {
                        this.mList.addInterval(new FreeBusy.Interval(start, start + intervalInMillis, "B"));
                        break;
                    }
                    case '3': {
                        this.mList.addInterval(new FreeBusy.Interval(start, start + intervalInMillis, "O"));
                        break;
                    }
                }
                start += intervalInMillis;
            }
        }
    }

    private static class BasicUserResolver
    implements ExchangeUserResolver {
        private BasicUserResolver() {
        }

        public ServerInfo getServerInfo(String emailAddr) {
            ServerInfo info;
            block4: {
                String url = BasicUserResolver.getAttr("zimbraFreebusyExchangeURL", emailAddr);
                String user = BasicUserResolver.getAttr("zimbraFreebusyExchangeAuthUsername", emailAddr);
                String pass = BasicUserResolver.getAttr("zimbraFreebusyExchangeAuthPassword", emailAddr);
                String scheme = BasicUserResolver.getAttr("zimbraFreebusyExchangeAuthScheme", emailAddr);
                if (url == null || user == null || pass == null || scheme == null) {
                    return null;
                }
                info = new ServerInfo();
                info.url = url;
                info.authUsername = user;
                info.authPassword = pass;
                info.scheme = AuthScheme.valueOf(scheme);
                info.org = BasicUserResolver.getAttr("zimbraFreebusyExchangeUserOrg", emailAddr);
                try {
                    String[] fps;
                    Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.name, emailAddr);
                    if (acct == null || (fps = acct.getMultiAttr("zimbraForeignPrincipal")) == null || fps.length <= 0) break block4;
                    for (String fp : fps) {
                        int idx;
                        if (!fp.startsWith("ad:") || (idx = fp.indexOf(58)) == -1) continue;
                        info.cn = fp.substring(idx + 1);
                        break;
                    }
                }
                catch (ServiceException se) {
                    info.cn = null;
                }
            }
            return info;
        }

        static String getAttr(String attr, String emailAddr) {
            String val = null;
            if (attr == null) {
                return val;
            }
            try {
                Account acct;
                Provisioning prov = Provisioning.getInstance();
                if (emailAddr != null && (acct = prov.get(Provisioning.AccountBy.name, emailAddr)) != null) {
                    val = acct.getAttr(attr, null);
                    if (val != null) {
                        return val;
                    }
                    Domain dom = prov.getDomain(acct);
                    val = dom.getAttr(attr, null);
                    if (val != null) {
                        return val;
                    }
                }
                val = prov.getConfig().getAttr(attr, null);
            }
            catch (ServiceException se) {
                ZimbraLog.fb.error((Object)("can't get attr " + attr), se);
            }
            return val;
        }
    }

    public static interface ExchangeUserResolver {
        public ServerInfo getServerInfo(String var1);
    }

    public static class ServerInfo {
        public String url;
        public String org;
        public String cn;
        public String authUsername;
        public String authPassword;
        public AuthScheme scheme;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthScheme {
        basic,
        form;

    }
}

