/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.extension;

import com.zimbra.common.util.ZimbraLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraExtensionClassLoader
extends URLClassLoader {
    public static final String ZIMBRA_EXTENSION_CLASS = "Zimbra-Extension-Class";
    private List<String> mExtensionClassNames = new ArrayList<String>();

    public ZimbraExtensionClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.findExtensions();
    }

    private void findExtensions() {
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            File entry = new File(urls[i].getFile());
            String className = this.getExtensionClassInManifest(entry);
            if (className == null) continue;
            this.mExtensionClassNames.add(className);
        }
    }

    public boolean hasExtensions() {
        return this.mExtensionClassNames.size() > 0;
    }

    public List<String> getExtensionClassNames() {
        return this.mExtensionClassNames;
    }

    private String getExtensionClassInManifest(File file) {
        String classname;
        Manifest man = null;
        if (file.isDirectory()) {
            File manifestFile = new File(file, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                block18: {
                    try {
                        man = new Manifest(new FileInputStream(manifestFile));
                    }
                    catch (IOException ioe) {
                        if (!ZimbraLog.extensions.isDebugEnabled()) break block18;
                        ZimbraLog.extensions.debug((Object)("exception looking for manifest in directory: " + file), ioe);
                    }
                }
                if (man == null) {
                    if (ZimbraLog.extensions.isDebugEnabled()) {
                        ZimbraLog.extensions.debug("no manifest for directory: " + file);
                    }
                    return null;
                }
            }
        } else if (file.isFile()) {
            block19: {
                try {
                    JarFile jarFile = new JarFile(file);
                    man = jarFile.getManifest();
                }
                catch (IOException ioe) {
                    if (!ZimbraLog.extensions.isDebugEnabled()) break block19;
                    ZimbraLog.extensions.debug((Object)("exception looking for manifest in jar file: " + file), ioe);
                }
            }
            if (man == null) {
                if (ZimbraLog.extensions.isDebugEnabled()) {
                    ZimbraLog.extensions.debug("no manifest for jar file: " + file);
                }
                return null;
            }
        } else {
            ZimbraLog.extensions.warn("entry in extension load path is not file or directory: " + file);
            return null;
        }
        Attributes attrs = man.getMainAttributes();
        if (ZimbraLog.extensions.isDebugEnabled()) {
            for (Attributes.Name name : attrs.keySet()) {
                ZimbraLog.extensions.debug("Manifest attribute=" + name + " value=" + attrs.getValue(name));
            }
        }
        if ((classname = attrs.getValue(ZIMBRA_EXTENSION_CLASS)) == null) {
            if (ZimbraLog.extensions.isDebugEnabled()) {
                ZimbraLog.extensions.debug("no extension class found in manifest of: " + file);
            }
        } else {
            ZimbraLog.extensions.info("extension " + classname + " found in " + file);
        }
        return classname;
    }
}

