/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.extension;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.extension.ZimbraExtension;
import com.zimbra.cs.extension.ZimbraExtensionClassLoader;
import com.zimbra.cs.extension.ZimbraExtensionPostInit;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.map.ListOrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtil {
    private static List<ZimbraExtensionClassLoader> sClassLoaders = new ArrayList<ZimbraExtensionClassLoader>();
    private static ClassLoader sExtParentClassLoader;
    private static ListOrderedMap sInitializedExtensions;

    public static URL[] dirListToURLs(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(files.length);
        for (int i = 0; i < files.length; ++i) {
            try {
                URL url = files[i].toURL();
                urls.add(url);
                if (!ZimbraLog.extensions.isDebugEnabled()) continue;
                ZimbraLog.extensions.debug("adding url: " + url);
                continue;
            }
            catch (MalformedURLException mue) {
                ZimbraLog.extensions.warn((Object)("ExtensionsUtil: exception creating url for " + files[i]), mue);
            }
        }
        return urls.toArray(new URL[0]);
    }

    private static synchronized void loadAll() {
        File extDir = new File(LC.zimbra_extensions_directory.value());
        if (extDir == null) {
            ZimbraLog.extensions.info(LC.zimbra_extensions_directory.key() + " is null, no extensions loaded");
            return;
        }
        ZimbraLog.extensions.info("Loading extensions from " + extDir.getPath());
        File[] extDirs = extDir.listFiles();
        if (extDirs == null) {
            return;
        }
        for (int i = 0; i < extDirs.length; ++i) {
            if (!extDirs[i].isDirectory()) {
                ZimbraLog.extensions.warn("ignored non-directory in extensions directory: " + extDirs[i]);
                continue;
            }
            ZimbraExtensionClassLoader zcl = new ZimbraExtensionClassLoader(ExtensionUtil.dirListToURLs(extDirs[i]), sExtParentClassLoader);
            if (!zcl.hasExtensions()) {
                ZimbraLog.extensions.warn("no Zimbra-Extension-Class found, ignored: " + extDirs[i]);
                continue;
            }
            sClassLoaders.add(zcl);
        }
    }

    public static synchronized void initAll() {
        ZimbraLog.extensions.info("Initializing extensions");
        for (ZimbraExtensionClassLoader zcl : sClassLoaders) {
            List<String> classes = zcl.getExtensionClassNames();
            for (String name : zcl.getExtensionClassNames()) {
                try {
                    Class<?> clz = zcl.loadClass(name);
                    ZimbraExtension ext = (ZimbraExtension)clz.newInstance();
                    try {
                        ext.init();
                        RedoableOp.registerClassLoader(ext.getClass().getClassLoader());
                        String extName = ext.getName();
                        ZimbraLog.extensions.info("Initialized extension " + extName + ": " + name + "@" + zcl);
                        sInitializedExtensions.put((Object)extName, (Object)ext);
                    }
                    catch (Exception e) {
                        ZimbraLog.extensions.warn((Object)("exception in " + name + ".init()"), e);
                    }
                }
                catch (InstantiationException e) {
                    ZimbraLog.extensions.warn((Object)("exception occurred initializing extension " + name), e);
                }
                catch (IllegalAccessException e) {
                    ZimbraLog.extensions.warn((Object)("exception occurred initializing extension " + name), e);
                }
                catch (ClassNotFoundException e) {
                    ZimbraLog.extensions.warn((Object)("exception occurred initializing extension " + name), e);
                }
            }
        }
    }

    public static synchronized void postInitAll() {
        ZimbraLog.extensions.info("Post-Initializing extensions");
        for (Object o : sInitializedExtensions.values()) {
            if (!(o instanceof ZimbraExtensionPostInit)) continue;
            ((ZimbraExtensionPostInit)o).postInit();
        }
    }

    public static synchronized void destroyAll() {
        ZimbraLog.extensions.info("Destroying extensions");
        List extNames = sInitializedExtensions.asList();
        ListIterator iter = extNames.listIterator(extNames.size());
        while (iter.hasPrevious()) {
            String extName = (String)iter.previous();
            ZimbraExtension ext = ExtensionUtil.getExtension(extName);
            try {
                RedoableOp.deregisterClassLoader(ext.getClass().getClassLoader());
                ext.destroy();
                ZimbraLog.extensions.info("Destroyed extension " + extName + ": " + ext.getClass().getName() + "@" + ext.getClass().getClassLoader());
            }
            catch (Exception e) {
                ZimbraLog.extensions.warn((Object)("exception in " + ext.getClass().getName() + ".destroy()"), e);
            }
        }
        sInitializedExtensions.clear();
    }

    public static synchronized Class loadClass(String extensionName, String className) throws ClassNotFoundException {
        if (extensionName == null) {
            return Class.forName(className);
        }
        ZimbraExtension ext = (ZimbraExtension)sInitializedExtensions.get((Object)extensionName);
        if (ext == null) {
            throw new ClassNotFoundException("extension " + extensionName + " not found");
        }
        ClassLoader loader = ext.getClass().getClassLoader();
        return loader.loadClass(className);
    }

    public static synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return ExtensionUtil.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            for (ZimbraExtensionClassLoader zcl : sClassLoaders) {
                try {
                    return zcl.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    public static synchronized ZimbraExtension getExtension(String name) {
        return (ZimbraExtension)sInitializedExtensions.get((Object)name);
    }

    static {
        File extCommonDir = new File(LC.zimbra_extensions_common_directory.value());
        URL[] extCommonURLs = ExtensionUtil.dirListToURLs(extCommonDir);
        sExtParentClassLoader = extCommonURLs == null ? ExtensionUtil.class.getClassLoader() : new URLClassLoader(extCommonURLs, ExtensionUtil.class.getClassLoader());
        ExtensionUtil.loadAll();
        sInitializedExtensions = new ListOrderedMap();
    }
}

