/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.extension;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.extension.ExtensionHttpHandler;
import com.zimbra.cs.extension.ZimbraExtension;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtensionDispatcherServlet
extends ZimbraServlet {
    private static Map sHandlers = Collections.synchronizedMap(new HashMap());
    public static final String EXTENSION_PATH = "/service/extension";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ZimbraExtension ext, ExtensionHttpHandler handler) throws ServiceException {
        handler.init(ext);
        String name = handler.getPath();
        Map map = sHandlers;
        synchronized (map) {
            if (sHandlers.containsKey(name)) {
                throw ServiceException.FAILURE("HTTP handler already registered: " + name, null);
            }
            sHandlers.put(name, handler);
            ZimbraLog.extensions.info("registered handler at " + name);
        }
    }

    public static ExtensionHttpHandler getHandler(String path) {
        ExtensionHttpHandler handler = null;
        int slash = -1;
        do {
            if ((handler = (ExtensionHttpHandler)sHandlers.get(path)) != null || (slash = path.lastIndexOf(47)) == -1) continue;
            path = path.substring(0, slash);
        } while (handler == null && slash > 0);
        return handler;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        block5: {
            ZimbraLog.clearContext();
            try {
                ExtensionHttpHandler handler = this.getHandler(req);
                String method = req.getMethod();
                if ("OPTIONS".equals(method)) {
                    handler.doOptions(req, resp);
                    break block5;
                }
                if ("GET".equals(method)) {
                    handler.doGet(req, resp);
                    break block5;
                }
                if ("POST".equals(method)) {
                    handler.doPost(req, resp);
                    break block5;
                }
                throw new ServletException("request method " + method + " not supported");
            }
            catch (ServiceException e) {
                throw new ServletException("failed to handle GET request", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(ZimbraExtension ext) {
        Map map = sHandlers;
        synchronized (map) {
            Iterator it = sHandlers.keySet().iterator();
            while (it.hasNext()) {
                Object var7_6;
                String path = (String)it.next();
                if (!path.startsWith("/" + ext.getName())) continue;
                ExtensionHttpHandler handler = (ExtensionHttpHandler)sHandlers.get(path);
                try {
                    try {
                        handler.destroy();
                    }
                    catch (Exception e) {
                        ZimbraLog.extensions.warn((Object)("Error in destroy for handler " + handler.getClass()), e);
                        var7_6 = null;
                        it.remove();
                        continue;
                    }
                    var7_6 = null;
                    it.remove();
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    it.remove();
                    throw throwable;
                }
            }
        }
    }

    private ExtensionHttpHandler getHandler(HttpServletRequest req) throws ServiceException {
        int pos;
        String uri = req.getRequestURI();
        String extPath = uri.substring((pos = uri.indexOf(EXTENSION_PATH)) + EXTENSION_PATH.length());
        if (extPath.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Invalid request: " + uri, null);
        }
        ZimbraLog.extensions.debug("getting handler registered at " + extPath);
        ExtensionHttpHandler handler = ExtensionDispatcherServlet.getHandler(extPath);
        if (handler == null) {
            throw ServiceException.FAILURE("Extension HTTP handler not found at " + extPath, null);
        }
        if (handler.hideFromDefaultPorts()) {
            Server server = Provisioning.getInstance().getLocalServer();
            int port = req.getLocalPort();
            int mailPort = server.getIntAttr("zimbraMailPort", 0);
            int mailSslPort = server.getIntAttr("zimbraMailSSLPort", 0);
            if (port == mailPort || port == mailSslPort) {
                throw ServiceException.FAILURE("extension not supported on this port", null);
            }
        }
        return handler;
    }
}

