/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.util.Config;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Versions {
    private static Log mLog = LogFactory.getLog(Versions.class);
    public static final String DB_VERSION = "63";
    public static final String INDEX_VERSION = "2";

    public static boolean checkVersions() {
        return Versions.checkDBVersion() && Versions.checkIndexVersion();
    }

    public static boolean checkDBVersion() {
        String val = Config.getString("db.version", "0");
        if (val.equals(DB_VERSION)) {
            return true;
        }
        mLog.error("DB Version Mismatch: ours=\"63\" from DB=\"" + val + "\"");
        return false;
    }

    public static boolean checkIndexVersion() {
        String val = Config.getString("index.version", "0");
        if (val.equals(INDEX_VERSION)) {
            return true;
        }
        mLog.error("Index Version Mismatch: ours=\"2\" from DB=\"" + val + "\"");
        return false;
    }

    public static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Versions.class.getName(), options);
        System.exit(1);
    }

    static CommandLine parseCmdlineArgs(String[] args, Options options) {
        GnuParser parser = new GnuParser();
        options.addOption("h", "help", false, "print usage");
        options.addOption("o", "outputdir", true, "output directory for version.sql");
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.println("error: " + pe.getMessage());
            err = true;
        }
        if (err || cl.hasOption("h")) {
            Versions.usage(options);
        }
        return cl;
    }
}

