/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagsetCache {
    private Set<Long> mTagsets = new HashSet<Long>();
    private String mName;

    TagsetCache(String name) {
        this.mName = name;
    }

    int size() {
        return this.mTagsets.size();
    }

    void addTagset(long tagset) {
        this.mTagsets.add(tagset);
    }

    void addTagsets(Collection<Long> tagsets) {
        this.mTagsets.addAll(tagsets);
    }

    Set<Long> getMatchingTagsets(long mask, long value) {
        HashSet<Long> matches = new HashSet<Long>();
        for (long tagset : this.mTagsets) {
            if ((tagset & mask) != value) continue;
            matches.add(tagset);
        }
        return matches.size() == this.mTagsets.size() ? null : matches;
    }

    Set<Long> getAllTagsets() {
        return new HashSet<Long>(this.mTagsets);
    }

    void applyMask(long mask, boolean add) {
        HashSet<Long> newTagsets = new HashSet<Long>();
        for (long tags : this.mTagsets) {
            long newTags = add ? tags | mask : tags & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            newTagsets.add(newTags);
        }
        this.addTagsets(newTagsets);
    }

    public String toString() {
        return "[TagsetCache " + this.mName + " (" + StringUtil.join(",", this.mTagsets) + ")]";
    }
}

