/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DebugConnection;
import com.zimbra.cs.db.Versions;
import com.zimbra.cs.redolog.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolingDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLite
extends Db {
    private Map<Db.Error, String> mErrorCodes = new HashMap<Db.Error, String>(6);
    private String cacheSize;
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 12;
    private static final int MAX_ATTACHED_DATABASES = SQLite.readConfigInt("sqlite_max_attached_databases", "max # of attached databases", 7);
    private static final HashMap<Connection, LinkedHashMap<String, String>> sAttachedDatabases = new HashMap(12);

    SQLite() {
        this.mErrorCodes.put(Db.Error.DUPLICATE_ROW, "column id is not unique");
        this.mErrorCodes.put(Db.Error.NO_SUCH_TABLE, "no such table");
    }

    @Override
    boolean supportsCapability(Db.Capability capability) {
        switch (capability) {
            case AVOID_OR_IN_WHERE_CLAUSE: {
                return false;
            }
            case BITWISE_OPERATIONS: {
                return true;
            }
            case BOOLEAN_DATATYPE: {
                return false;
            }
            case CASE_SENSITIVE_COMPARISON: {
                return true;
            }
            case CAST_AS_BIGINT: {
                return false;
            }
            case CLOB_COMPARISON: {
                return true;
            }
            case DISABLE_CONSTRAINT_CHECK: {
                return false;
            }
            case FILE_PER_DATABASE: {
                return true;
            }
            case FORCE_INDEX_EVEN_IF_NO_SORT: {
                return false;
            }
            case LIMIT_CLAUSE: {
                return true;
            }
            case MULTITABLE_UPDATE: {
                return false;
            }
            case ON_DUPLICATE_KEY: {
                return false;
            }
            case ON_UPDATE_CASCADE: {
                return false;
            }
            case READ_COMMITTED_ISOLATION: {
                return false;
            }
            case REPLACE_INTO: {
                return true;
            }
            case REQUEST_UTF8_UNICODE_COLLATION: {
                return false;
            }
            case ROW_LEVEL_LOCKING: {
                return false;
            }
            case UNIQUE_NAME_INDEX: {
                return false;
            }
        }
        return false;
    }

    @Override
    boolean compareError(SQLException e, Db.Error error) {
        String code = this.mErrorCodes.get((Object)error);
        return code != null && e.getMessage().contains(code);
    }

    @Override
    String forceIndexClause(String index) {
        return "";
    }

    @Override
    String getIFNULLClause(String expr1, String expr2) {
        return "IFNULL(" + expr1 + ", " + expr2 + ")";
    }

    @Override
    DbPool.PoolConfig getPoolConfig() {
        return new SQLiteConfig();
    }

    @Override
    void startup(PoolingDataSource pool, int poolSize) throws SQLException {
        this.cacheSize = LC.sqlite_cache_size.value();
        if (this.cacheSize.equals("0")) {
            this.cacheSize = null;
        }
        ZimbraLog.dbconn.info("sqlite driver running with " + (this.cacheSize == null ? "default" : this.cacheSize) + " page cache");
        super.startup(pool, poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postCreate(Connection conn) throws SQLException {
        try {
            conn.setAutoCommit(true);
            this.pragmas(conn, null);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            conn.setAutoCommit(false);
            throw throwable;
        }
        conn.setAutoCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pragma(Connection conn, String dbname, String key, String value) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("PRAGMA " + (dbname == null || dbname.equals("zimbra") ? "" : dbname + ".") + key + " = " + value);
            stmt.execute();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DbPool.quietCloseStatement(stmt);
            throw throwable;
        }
        DbPool.quietCloseStatement(stmt);
    }

    void pragmas(Connection conn, String dbname) throws SQLException {
        if (this.cacheSize != null) {
            this.pragma(conn, dbname, "cache_size", this.cacheSize);
        }
        this.pragma(conn, dbname, "encoding", "\"UTF-8\"");
        this.pragma(conn, dbname, "fullfsync", "OFF");
        this.pragma(conn, dbname, "journal_mode", "PERSIST");
        this.pragma(conn, dbname, "synchronous", "NORMAL");
    }

    private LinkedHashMap<String, String> getAttachedDatabases(DbPool.Connection conn) {
        return sAttachedDatabases.get(this.getInnermostConnection(conn.getConnection()));
    }

    private Connection getInnermostConnection(Connection conn) {
        Connection retVal = null;
        if (conn instanceof DebugConnection) {
            retVal = ((DebugConnection)((Object)conn)).getConnection();
        }
        if (conn instanceof DelegatingConnection) {
            retVal = ((DelegatingConnection)conn).getInnermostDelegate();
        }
        return retVal == null ? conn : retVal;
    }

    @Override
    public void registerDatabaseInterest(DbPool.Connection conn, String dbname) throws SQLException, ServiceException {
        LinkedHashMap<String, String> attachedDBs = this.getAttachedDatabases(conn);
        if (attachedDBs != null && attachedDBs.containsKey(dbname)) {
            return;
        }
        if (attachedDBs != null && attachedDBs.size() >= MAX_ATTACHED_DATABASES) {
            Iterator<String> it = attachedDBs.keySet().iterator();
            while (attachedDBs.size() >= MAX_ATTACHED_DATABASES && it.hasNext()) {
                String name = it.next();
                if (name.equals("zimbra") || !this.detachDatabase(conn, name)) continue;
                it.remove();
            }
        }
        this.attachDatabase(conn, dbname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void attachDatabase(DbPool.Connection conn, String dbname) throws SQLException, ServiceException {
        block8: {
            PreparedStatement stmt = null;
            try {
                block7: {
                    try {
                        boolean autocommit = conn.getConnection().getAutoCommit();
                        if (!autocommit) {
                            conn.getConnection().setAutoCommit(true);
                        }
                        stmt = conn.prepareStatement("ATTACH DATABASE \"" + this.getDatabaseFilename(dbname) + "\" AS " + dbname);
                        stmt.execute();
                        this.pragmas(conn.getConnection(), dbname);
                        if (autocommit) break block7;
                        conn.getConnection().setAutoCommit(autocommit);
                    }
                    catch (SQLException e) {
                        if (!"database is already attached".equals(e.getMessage())) {
                            Object var6_8 = null;
                            DbPool.quietCloseStatement(stmt);
                            return;
                        }
                        ZimbraLog.dbconn.error((Object)("database " + dbname + " attach failed"), e);
                        Object var6_9 = null;
                        DbPool.quietCloseStatement(stmt);
                        break block8;
                    }
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                DbPool.quietCloseStatement(stmt);
                throw throwable;
            }
            DbPool.quietCloseStatement(stmt);
        }
        LinkedHashMap<String, String> attachedDBs = this.getAttachedDatabases(conn);
        if (attachedDBs != null) {
            attachedDBs.put(dbname, null);
            return;
        }
        attachedDBs = new LinkedHashMap(MAX_ATTACHED_DATABASES * 3 / 2, 0.75f, true);
        attachedDBs.put(dbname, null);
        sAttachedDatabases.put(this.getInnermostConnection(conn.getConnection()), attachedDBs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachDatabase(DbPool.Connection conn, String dbname) {
        boolean bl;
        PreparedStatement stmt = null;
        try {
            boolean autocommit = conn.getConnection().getAutoCommit();
            if (!autocommit) {
                conn.getConnection().setAutoCommit(true);
            }
            stmt = conn.prepareStatement("DETACH DATABASE " + dbname);
            stmt.execute();
            if (!autocommit) {
                conn.getConnection().setAutoCommit(autocommit);
            }
            bl = true;
            Object var7_8 = null;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                ZimbraLog.dbconn.warn((Object)("database overflow autoclose failed for DB " + dbname), e);
                bl2 = false;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                DbPool.quietCloseStatement(stmt);
                throw throwable;
            }
            DbPool.quietCloseStatement(stmt);
            return bl2;
        }
        DbPool.quietCloseStatement(stmt);
        return bl;
    }

    @Override
    public boolean databaseExists(DbPool.Connection conn, String dbname) throws ServiceException {
        boolean bl;
        if (!new File(this.getDatabaseFilename(dbname)).exists()) {
            return false;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean complete;
            boolean autocommit = conn.getConnection().getAutoCommit();
            if (!autocommit) {
                conn.getConnection().setAutoCommit(true);
            }
            this.registerDatabaseInterest(conn, dbname);
            stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + (dbname.equals("zimbra") ? "" : dbname + ".") + "sqlite_master WHERE type='table'");
            rs = stmt.executeQuery();
            boolean bl2 = rs.next() ? rs.getInt(1) >= 1 : (complete = false);
            if (!autocommit) {
                conn.getConnection().setAutoCommit(autocommit);
            }
            bl = complete;
            Object var9_9 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("sqlite error", e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return bl;
    }

    @Override
    void deleteDatabaseFile(String dbname) {
        assert (dbname != null && !dbname.trim().equals(""));
        ZimbraLog.dbconn.info("deleting database file for DB '" + dbname + "'");
        new File(this.getDatabaseFilename(dbname)).delete();
    }

    public String getDatabaseFilename(String dbname) {
        return LC.zimbra_home.value() + File.separator + "sqlite" + File.separator + dbname + ".db";
    }

    static int readConfigInt(String keyname, String description, int defaultvalue) {
        int value = defaultvalue;
        try {
            String configvalue = LC.get(keyname);
            if (configvalue != null && !configvalue.trim().equals("")) {
                value = Math.max(1, Integer.parseInt(configvalue));
            }
        }
        catch (NumberFormatException nfe) {
            ZimbraLog.dbconn.warn((Object)("exception parsing '" + keyname + "' config; defaulting limit to " + defaultvalue), nfe);
        }
        ZimbraLog.dbconn.info("setting " + description + " to " + value);
        return value;
    }

    @Override
    public void flushToDisk() {
    }

    public String toString() {
        return "SQLite";
    }

    @Override
    protected int getInClauseBatchSize() {
        return 200;
    }

    public static void main(String[] args) {
        Options options = new Options();
        CommandLine cl = Versions.parseCmdlineArgs(args, options);
        String outputDir = cl.getOptionValue("o");
        File outFile = new File(outputDir, "versions-init.sql");
        outFile.delete();
        try {
            String redoVer = Version.latest().toString();
            String outStr = "-- AUTO-GENERATED .SQL FILE - Generated by the SQLite versions tool\nINSERT INTO config(name, value, description) VALUES\n\t('db.version', '63', 'db schema version');\nINSERT INTO config(name, value, description) VALUES\n\t('index.version', '2', 'index version');\nINSERT INTO config(name, value, description) VALUES\n\t('redolog.version', '" + redoVer + "', 'redolog version');\n";
            BufferedWriter output = new BufferedWriter(new FileWriter(outFile));
            output.write(outStr);
            ((Writer)output).close();
        }
        catch (IOException e) {
            System.out.println("ERROR - caught exception at\n");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    final class SQLiteConfig
    extends DbPool.PoolConfig {
        SQLiteConfig() {
            this.mDriverClassName = "org.sqlite.JDBC";
            this.mPoolSize = 12;
            this.mRootUrl = null;
            this.mConnectionUrl = "jdbc:sqlite:" + SQLite.this.getDatabaseFilename("zimbra");
            this.mLoggerUrl = null;
            this.mSupportsStatsCallback = false;
            this.mDatabaseProperties = this.getSQLiteProperties();
            this.mPoolSize = SQLite.readConfigInt("sqlite_pool_size", "connection pool size", 12);
        }

        private Properties getSQLiteProperties() {
            Properties props = new Properties();
            props.setProperty("shared_cache", "true");
            return props;
        }
    }
}

