/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.Versions;
import com.zimbra.cs.redolog.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class MySQL
extends Db {
    private Map<Db.Error, Integer> mErrorCodes = new HashMap<Db.Error, Integer>(6);
    private final String sTableName = "zimbra.flush_enforcer";
    private final String sCreateTable = "CREATE TABLE IF NOT EXISTS zimbra.flush_enforcer (dummy_column INTEGER) ENGINE = InnoDB";
    private final String sDropTable = "DROP TABLE IF EXISTS zimbra.flush_enforcer";

    MySQL() {
        this.mErrorCodes.put(Db.Error.DEADLOCK_DETECTED, 1213);
        this.mErrorCodes.put(Db.Error.DUPLICATE_ROW, 1062);
        this.mErrorCodes.put(Db.Error.FOREIGN_KEY_NO_PARENT, 1216);
        this.mErrorCodes.put(Db.Error.FOREIGN_KEY_CHILD_EXISTS, 1451);
        this.mErrorCodes.put(Db.Error.NO_SUCH_DATABASE, 1146);
        this.mErrorCodes.put(Db.Error.NO_SUCH_TABLE, 1146);
    }

    boolean supportsCapability(Db.Capability capability) {
        switch (capability) {
            case AVOID_OR_IN_WHERE_CLAUSE: {
                return false;
            }
            case BITWISE_OPERATIONS: {
                return true;
            }
            case BOOLEAN_DATATYPE: {
                return true;
            }
            case CASE_SENSITIVE_COMPARISON: {
                return false;
            }
            case CAST_AS_BIGINT: {
                return false;
            }
            case CLOB_COMPARISON: {
                return true;
            }
            case DISABLE_CONSTRAINT_CHECK: {
                return true;
            }
            case FILE_PER_DATABASE: {
                return false;
            }
            case LIMIT_CLAUSE: {
                return true;
            }
            case MULTITABLE_UPDATE: {
                return true;
            }
            case ON_DUPLICATE_KEY: {
                return true;
            }
            case ON_UPDATE_CASCADE: {
                return true;
            }
            case READ_COMMITTED_ISOLATION: {
                return true;
            }
            case REPLACE_INTO: {
                return true;
            }
            case REQUEST_UTF8_UNICODE_COLLATION: {
                return true;
            }
            case ROW_LEVEL_LOCKING: {
                return true;
            }
            case UNIQUE_NAME_INDEX: {
                return true;
            }
        }
        return false;
    }

    boolean compareError(SQLException e, Db.Error error) {
        Integer code = this.mErrorCodes.get((Object)error);
        return code != null && e.getErrorCode() == code.intValue();
    }

    String forceIndexClause(String index) {
        return " FORCE INDEX (" + index + ')';
    }

    String getIFNULLClause(String expr1, String expr2) {
        return "IFNULL(" + expr1 + ", " + expr2 + ")";
    }

    DbPool.PoolConfig getPoolConfig() {
        return new MySQLConfig();
    }

    public boolean databaseExists(DbPool.Connection conn, String dbname) throws ServiceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int numSchemas = 0;
        try {
            try {
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE schema_name = ?");
                stmt.setString(1, dbname);
                rs = stmt.executeQuery();
                rs.next();
                numSchemas = rs.getInt(1);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to determine whether database exists", e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return numSchemas > 0;
    }

    public void enableStreaming(Statement stmt) throws SQLException {
        if (LC.jdbc_results_streaming_enabled.booleanValue()) {
            stmt.setFetchSize(Integer.MIN_VALUE);
        }
    }

    public String toString() {
        return "MySQL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void flushToDisk() {
        DbPool.Connection conn = null;
        PreparedStatement createStmt = null;
        PreparedStatement dropStmt = null;
        boolean success = false;
        try {
            conn = DbPool.getMaintenanceConnection();
            createStmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS zimbra.flush_enforcer (dummy_column INTEGER) ENGINE = InnoDB");
            dropStmt = conn.prepareStatement("DROP TABLE IF EXISTS zimbra.flush_enforcer");
            createStmt.executeUpdate();
            dropStmt.executeUpdate();
            success = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbPool.quietCloseStatement(createStmt);
            DbPool.quietCloseStatement(dropStmt);
            if (conn != null) {
                conn.commit();
            }
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.quietCloseStatement(createStmt);
        DbPool.quietCloseStatement(dropStmt);
        if (conn != null) {
            conn.commit();
        }
        DbPool.quietClose(conn);
        Object var8_10 = null;
        if (success) return;
        try {
            Thread.sleep(3000L);
            return;
        }
        catch (InterruptedException e1) {}
        return;
        {
            catch (SQLException e) {
                ZimbraLog.dbconn.warn((Object)"ignoring error while forcing mysql to flush innodb log to disk", e);
                Object var8_11 = null;
                if (success) return;
                try {
                    Thread.sleep(3000L);
                    return;
                }
                catch (InterruptedException e1) {}
                return;
            }
            catch (ServiceException e) {
                ZimbraLog.dbconn.warn((Object)"ignoring error while forcing mysql to flush innodb log to disk", e);
                Object var8_12 = null;
                if (success) return;
                try {
                    Thread.sleep(3000L);
                    return;
                }
                catch (InterruptedException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (success) throw throwable;
            try {
                Thread.sleep(3000L);
                throw throwable;
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        Options options = new Options();
        CommandLine cl = Versions.parseCmdlineArgs(args, options);
        String outputDir = cl.getOptionValue("o");
        File outFile = new File(outputDir, "versions-init.sql");
        outFile.delete();
        try {
            String redoVer = Version.latest().toString();
            String outStr = "-- AUTO-GENERATED .SQL FILE - Generated by the MySQL versions tool\nUSE zimbra;\nINSERT INTO zimbra.config(name, value, description) VALUES\n\t('db.version', '63', 'db schema version'),\n\t('index.version', '2', 'index version'),\n\t('redolog.version', '" + redoVer + "', 'redolog version')\n" + ";\nCOMMIT;\n";
            BufferedWriter output = new BufferedWriter(new FileWriter(outFile));
            output.write(outStr);
            if (output != null) {
                ((Writer)output).close();
            }
        }
        catch (IOException e) {
            System.out.println("ERROR - caught exception at\n");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static final class MySQLConfig
    extends DbPool.PoolConfig {
        MySQLConfig() {
            this.mDriverClassName = "com.mysql.jdbc.Driver";
            this.mPoolSize = 100;
            this.mRootUrl = "jdbc:mysql://" + LC.mysql_bind_address.value() + ":" + LC.mysql_port.value() + "/";
            this.mConnectionUrl = this.mRootUrl + "zimbra";
            this.mLoggerUrl = "jdbc:mysql://" + LC.logger_mysql_bind_address.value() + ":" + LC.logger_mysql_port.value() + "/";
            this.mSupportsStatsCallback = true;
            this.mDatabaseProperties = MySQLConfig.getMySQLProperties();
            String maxActive = (String)this.mDatabaseProperties.get("maxActive");
            if (maxActive != null) {
                try {
                    this.mPoolSize = Integer.parseInt(maxActive);
                }
                catch (NumberFormatException nfe) {
                    ZimbraLog.system.warn((Object)("exception parsing 'maxActive' pref; defaulting pool size to " + this.mPoolSize), nfe);
                }
            }
            ZimbraLog.misc.debug("Setting connection pool size to " + this.mPoolSize);
        }

        private static Properties getMySQLProperties() {
            Properties props = new Properties();
            props.put("cacheResultSetMetadata", "true");
            props.put("cachePrepStmts", "true");
            props.put("prepStmtCacheSize", "25");
            props.put("autoReconnect", "true");
            props.put("useUnicode", "true");
            props.put("characterEncoding", "UTF-8");
            props.put("dumpQueriesOnException", "true");
            String prefix = "zimbra_mysql_connector_";
            for (String key : LC.getAllKeys()) {
                String prop;
                if (!key.startsWith("zimbra_mysql_connector_") || (prop = key.substring("zimbra_mysql_connector_".length())).length() <= 0 || prop.equalsIgnoreCase("logger")) continue;
                props.put(prop, LC.get(key));
                ZimbraLog.system.info("Setting mysql connector property: " + prop + "=" + LC.get(key));
            }
            props.put("user", LC.zimbra_mysql_user.value());
            props.put("password", LC.zimbra_mysql_password.value());
            return props;
        }
    }
}

