/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.Versions;
import com.zimbra.cs.redolog.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Derby
extends Db {
    private Map<Db.Error, String> mErrorCodes = new HashMap<Db.Error, String>(6);
    private Map<String, String> mIndexNames;

    Derby() {
        this.mErrorCodes.put(Db.Error.DEADLOCK_DETECTED, "40000");
        this.mErrorCodes.put(Db.Error.DUPLICATE_ROW, "23505");
        this.mErrorCodes.put(Db.Error.FOREIGN_KEY_NO_PARENT, "23503");
        this.mErrorCodes.put(Db.Error.FOREIGN_KEY_CHILD_EXISTS, "23503");
        this.mErrorCodes.put(Db.Error.NO_SUCH_DATABASE, "42Y07");
        this.mErrorCodes.put(Db.Error.NO_SUCH_TABLE, "42X05");
        this.mIndexNames = new HashMap<String, String>();
        this.mIndexNames.put("i_type", "i_mail_item_type");
        this.mIndexNames.put("i_parent_id", "fk_mail_item_parent_id");
        this.mIndexNames.put("i_folder_id_date", "i_mail_item_folder_id_date");
        this.mIndexNames.put("i_index_id", "i_mail_item_index_id");
        this.mIndexNames.put("i_unread", "i_mail_item_unread");
        this.mIndexNames.put("i_date", "i_mail_item_date");
        this.mIndexNames.put("i_mod_metadata", "i_mail_item_mod_metadata");
        this.mIndexNames.put("i_tags_date", "i_mail_item_tags_date");
        this.mIndexNames.put("i_flags_date", "i_mail_item_flags_date");
        this.mIndexNames.put("i_volume_id", "i_mail_item_volume_id");
        this.mIndexNames.put("i_change_mask", "i_mail_item_change_mask");
        this.mIndexNames.put("i_name_folder_id", "i_mail_item_name_folder_id");
    }

    boolean supportsCapability(Db.Capability capability) {
        switch (capability) {
            case AVOID_OR_IN_WHERE_CLAUSE: {
                return true;
            }
            case BITWISE_OPERATIONS: {
                return false;
            }
            case BOOLEAN_DATATYPE: {
                return false;
            }
            case CASE_SENSITIVE_COMPARISON: {
                return true;
            }
            case CAST_AS_BIGINT: {
                return true;
            }
            case CLOB_COMPARISON: {
                return false;
            }
            case DISABLE_CONSTRAINT_CHECK: {
                return false;
            }
            case FILE_PER_DATABASE: {
                return false;
            }
            case LIMIT_CLAUSE: {
                return false;
            }
            case MULTITABLE_UPDATE: {
                return false;
            }
            case ON_DUPLICATE_KEY: {
                return false;
            }
            case ON_UPDATE_CASCADE: {
                return false;
            }
            case READ_COMMITTED_ISOLATION: {
                return true;
            }
            case REPLACE_INTO: {
                return false;
            }
            case REQUEST_UTF8_UNICODE_COLLATION: {
                return false;
            }
            case ROW_LEVEL_LOCKING: {
                return true;
            }
            case UNIQUE_NAME_INDEX: {
                return false;
            }
            case FORCE_INDEX_EVEN_IF_NO_SORT: {
                return true;
            }
        }
        return false;
    }

    boolean compareError(SQLException e, Db.Error error) {
        String code = this.mErrorCodes.get((Object)error);
        return code != null && e.getSQLState().equals(code);
    }

    String forceIndexClause(String index) {
        String localIndex = this.mIndexNames.get(index);
        if (localIndex == null) {
            ZimbraLog.misc.warn("could not find derby equivalent from index " + index);
            return "";
        }
        return " -- DERBY-PROPERTIES " + (localIndex.startsWith("fk_") ? "constraint=" : "index=") + localIndex + '\n';
    }

    String getIFNULLClause(String expr1, String expr2) {
        return "CASE WHEN " + expr1 + " IS NULL THEN " + expr2 + " ELSE " + expr1 + " END";
    }

    DbPool.PoolConfig getPoolConfig() {
        return new DerbyConfig();
    }

    public boolean databaseExists(DbPool.Connection conn, String databaseName) throws ServiceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int numSchemas = 0;
        try {
            try {
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM SYS.SYSSCHEMAS WHERE schemaname = ?");
                stmt.setString(1, databaseName.toUpperCase());
                rs = stmt.executeQuery();
                rs.next();
                numSchemas = rs.getInt(1);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to determine whether database exists", e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return numSchemas > 0;
    }

    void shutdown() {
        try {
            DriverManager.getConnection("jdbc:derby:" + System.getProperty("derby.system.home", LC.zimbra_home.value() + File.separator + "derby") + ";shutdown=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static OutputStream disableDerbyLogFile() {
        return new OutputStream(){

            public void write(int b) {
            }
        };
    }

    public String toString() {
        return "derby";
    }

    protected int getInClauseBatchSize() {
        return 200;
    }

    public static void main(String[] args) {
        Options options = new Options();
        CommandLine cl = Versions.parseCmdlineArgs(args, options);
        String outputDir = cl.getOptionValue("o");
        File outFile = new File(outputDir, "versions-init.sql");
        outFile.delete();
        try {
            String redoVer = Version.latest().toString();
            String outStr = "-- AUTO-GENERATED .SQL FILE - Generated by the Derby versions tool\nINSERT INTO zimbra.config(name, value, description) VALUES\n\t('db.version', '63', 'db schema version'),\n\t('index.version', '2', 'index version'),\n\t('redolog.version', '" + redoVer + "', 'redolog version');\n";
            BufferedWriter output = new BufferedWriter(new FileWriter(outFile));
            output.write(outStr);
            if (output != null) {
                ((Writer)output).close();
            }
        }
        catch (IOException e) {
            System.out.println("ERROR - caught exception at\n");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void flushToDisk() {
    }

    static final class DerbyConfig
    extends DbPool.PoolConfig {
        DerbyConfig() {
            Properties props = new Properties();
            try {
                String propsfile = LC.get("zdesktop_derby_properties");
                if (propsfile == null || propsfile.equals("")) {
                    propsfile = LC.derby_properties.value();
                }
                props.load(new FileInputStream(propsfile));
            }
            catch (FileNotFoundException x) {
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.setProperty(key, props.getProperty(key));
            }
            this.mDriverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
            this.mPoolSize = 12;
            this.mRootUrl = null;
            this.mConnectionUrl = "jdbc:derby:" + System.getProperty("derby.system.home", LC.zimbra_home.value() + File.separator + "derby");
            this.mLoggerUrl = null;
            this.mSupportsStatsCallback = false;
            this.mDatabaseProperties = DerbyConfig.getDerbyProperties();
            ZimbraLog.misc.debug("Setting connection pool size to " + this.mPoolSize);
        }

        private static Properties getDerbyProperties() {
            Properties props = new Properties();
            props.put("cacheResultSetMetadata", "true");
            props.put("cachePrepStmts", "true");
            props.put("prepStmtCacheSize", "25");
            props.put("autoReconnect", "true");
            props.put("useUnicode", "true");
            props.put("characterEncoding", "UTF-8");
            props.put("dumpQueriesOnException", "true");
            props.put("user", LC.zimbra_mysql_user.value());
            props.put("password", LC.zimbra_mysql_password.value());
            return props;
        }
    }
}

