/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.util.ZimbraLog;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;

class DebugPreparedStatement
extends DelegatingPreparedStatement {
    private static final int MAX_STRING_LENGTH = 1024;
    private static long sSlowSqlThreshold = Long.MAX_VALUE;
    private final PreparedStatement mStmt;
    private String mSql;
    private long mStartTime;
    private List<Object> mParams = new AutoSizeList<Object>();

    DebugPreparedStatement(DelegatingConnection conn, PreparedStatement stmt, String sql) {
        super(conn, stmt);
        this.mStmt = stmt;
        this.mSql = sql;
    }

    public static void setSlowSqlThreshold(long millis) {
        ZimbraLog.sqltrace.info("Setting slow SQL threshold to %dms.", millis);
        sSlowSqlThreshold = millis;
    }

    private String getSql() {
        if (this.mSql == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int qPos = this.mSql.indexOf(63, start);
        int paramIndex = 1;
        while (qPos >= 0) {
            buf.append(this.mSql.substring(start, qPos));
            if (paramIndex == this.mParams.size()) {
                throw new IllegalStateException("Not enough parameters bound for SQL: " + this.mSql);
            }
            Object o = this.mParams.get(paramIndex);
            if (o == null) {
                o = "NULL";
            } else if (o instanceof String) {
                String s = (String)o;
                if (s.indexOf(39) >= 0) {
                    s = s.replaceAll("'", "''");
                }
                o = "'" + s + "'";
            }
            buf.append(o);
            start = qPos + 1;
            if (start >= this.mSql.length()) break;
            qPos = this.mSql.indexOf(63, start);
            ++paramIndex;
        }
        if (start < this.mSql.length()) {
            buf.append(this.mSql.substring(start, this.mSql.length()));
        }
        return buf.toString();
    }

    private void log() {
        long time = System.currentTimeMillis() - this.mStartTime;
        if (time > sSlowSqlThreshold) {
            String sql = this.getSql();
            ZimbraLog.sqltrace.info("Slow execution (%dms): %s", time, sql);
        } else if (ZimbraLog.sqltrace.isDebugEnabled()) {
            String sql = this.getSql();
            ZimbraLog.sqltrace.debug(sql + " - " + time + "ms" + this.getHashCodeString());
        }
    }

    private void logException(SQLException e) {
        if (ZimbraLog.sqltrace.isDebugEnabled()) {
            ZimbraLog.sqltrace.debug(e.toString() + ": " + this.getSql() + this.getHashCodeString());
        }
    }

    private String getHashCodeString() {
        String hashCodeString = "";
        try {
            hashCodeString = ", conn=" + this.mStmt.getConnection().hashCode();
        }
        catch (SQLException e) {
            ZimbraLog.sqltrace.warn((Object)"Unable to determine connection hashcode", e);
        }
        return hashCodeString;
    }

    private void startTimer() {
        this.mStartTime = System.currentTimeMillis();
    }

    public boolean isClosed() {
        return super.isClosed();
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs;
        this.startTimer();
        try {
            rs = this.mStmt.executeQuery();
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return rs;
    }

    public int executeUpdate() throws SQLException {
        int numRows;
        this.startTimer();
        try {
            numRows = this.mStmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return numRows;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.mParams.set(parameterIndex, null);
        this.mStmt.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.mParams.set(parameterIndex, Float.valueOf(x));
        this.mStmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        String loggedValue = x;
        if (x != null && x.length() > 1024) {
            loggedValue = loggedValue.substring(0, 1024) + "...";
        }
        this.mParams.set(parameterIndex, loggedValue);
        this.mStmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.mParams.set(parameterIndex, "<byte[]>");
        this.mStmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.mParams.set(parameterIndex, "<Ascii Stream>");
        this.mStmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.mParams.set(parameterIndex, "<Unicode Stream>");
        this.mStmt.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.mParams.set(parameterIndex, "<Binary Stream>");
        this.mStmt.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.mParams.clear();
        this.mStmt.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        boolean result;
        this.startTimer();
        try {
            result = this.mStmt.execute();
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.mParams.set(parameterIndex, "<Character Stream>");
        this.mStmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.mParams.set(i, "<Ref>");
        this.mStmt.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.mParams.set(i, "<Blob>");
        this.mStmt.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.mParams.set(i, "<Clob>");
        this.mStmt.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.mParams.set(i, "<Array>");
        this.mStmt.setArray(i, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.mParams.set(paramIndex, null);
        this.mStmt.setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.mParams.set(parameterIndex, x);
        this.mStmt.setURL(parameterIndex, x);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs;
        this.mSql = sql;
        this.startTimer();
        try {
            rs = this.mStmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return rs;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.mSql = sql;
        this.startTimer();
        int numRows = 0;
        try {
            this.mStmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return numRows;
    }

    public boolean execute(String sql) throws SQLException {
        this.mSql = sql;
        this.startTimer();
        boolean result = false;
        try {
            this.mStmt.execute(sql);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    public int[] executeBatch() throws SQLException {
        int[] result;
        this.startTimer();
        try {
            result = this.mStmt.executeBatch();
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int numRows;
        this.startTimer();
        try {
            numRows = this.mStmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return numRows;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int numRows;
        this.startTimer();
        try {
            numRows = this.mStmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return numRows;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int numRows;
        this.startTimer();
        try {
            numRows = this.mStmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return numRows;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result;
        this.startTimer();
        try {
            result = this.mStmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result;
        this.startTimer();
        try {
            result = this.mStmt.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result;
        this.startTimer();
        try {
            result = this.mStmt.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.logException(e);
            throw e;
        }
        this.log();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AutoSizeList<E>
    extends ArrayList<E> {
        private AutoSizeList() {
        }

        @Override
        public E set(int index, E element) {
            if (index >= this.size()) {
                for (int i = this.size(); i <= index; ++i) {
                    this.add(null);
                }
            }
            return super.set(index, element);
        }
    }
}

