/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DebugPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;

class DebugConnection
extends DelegatingConnection {
    private final Connection mConn;

    DebugConnection(Connection conn) {
        super(conn);
        this.mConn = conn;
    }

    Connection getConnection() {
        return this.mConn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql), sql);
    }

    public void commit() throws SQLException {
        ZimbraLog.sqltrace.debug("commit, conn=" + this.mConn.hashCode());
        this.mConn.commit();
    }

    public void rollback() throws SQLException {
        ZimbraLog.sqltrace.debug("rollback, conn=" + this.mConn.hashCode());
        this.mConn.rollback();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql, columnIndexes), sql);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DebugPreparedStatement(this, this.mConn.prepareStatement(sql, columnNames), sql);
    }
}

