/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.store.file.VolumeServiceException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbVolume {
    private static final String CN_ID = "id";
    private static final String CN_TYPE = "type";
    private static final String CN_NAME = "name";
    private static final String CN_PATH = "path";
    private static final String CN_FILE_BITS = "file_bits";
    private static final String CN_FILE_GROUP_BITS = "file_group_bits";
    private static final String CN_MAILBOX_BITS = "mailbox_bits";
    private static final String CN_MAILBOX_GROUP_BITS = "mailbox_group_bits";
    private static final String CN_COMPRESS_BLOBS = "compress_blobs";
    private static final String CN_COMPRESSION_THRESHOLD = "compression_threshold";

    public static synchronized Volume create(DbPool.Connection conn, short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        short nextId = id;
        if (nextId == -1) {
            nextId = DbVolume.getNextVolumeID(conn);
        }
        if (nextId <= 0 || nextId > 255) {
            throw VolumeServiceException.ID_OUT_OF_RANGE(nextId);
        }
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("INSERT INTO volume (id, type, name, path, mailbox_group_bits, mailbox_bits, file_group_bits, file_bits, compress_blobs, compression_threshold) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                int pos = 1;
                stmt.setShort(pos++, nextId);
                stmt.setShort(pos++, type);
                stmt.setString(pos++, name);
                stmt.setString(pos++, path);
                stmt.setShort(pos++, mboxGroupBits);
                stmt.setShort(pos++, mboxBits);
                stmt.setShort(pos++, fileGroupBits);
                stmt.setShort(pos++, fileBits);
                stmt.setBoolean(pos++, compressBlobs);
                stmt.setLong(pos++, compressionThreshold);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw VolumeServiceException.ALREADY_EXISTS(nextId, name, path, e);
                }
                throw ServiceException.FAILURE("inserting new volume " + nextId, e);
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        return DbVolume.get(conn, nextId);
    }

    public static Volume update(DbPool.Connection conn, short id, short type, String name, String path, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE volume SET type=?, name=?, path=?, mailbox_group_bits=?, mailbox_bits=?, file_group_bits=?, file_bits=?, compress_blobs=?, compression_threshold=? WHERE id=?");
                int pos = 1;
                stmt.setShort(pos++, type);
                stmt.setString(pos++, name);
                stmt.setString(pos++, path);
                stmt.setShort(pos++, mboxGroupBits);
                stmt.setShort(pos++, mboxBits);
                stmt.setShort(pos++, fileGroupBits);
                stmt.setShort(pos++, fileBits);
                stmt.setBoolean(pos++, compressBlobs);
                stmt.setLong(pos++, compressionThreshold);
                stmt.setShort(pos++, id);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw VolumeServiceException.ALREADY_EXISTS(id, name, path, e);
                }
                throw ServiceException.FAILURE("updating volume " + id, e);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        return DbVolume.get(conn, id);
    }

    public static boolean delete(DbPool.Connection conn, short id) throws ServiceException {
        boolean bl;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM volume WHERE id=?");
            stmt.setShort(1, id);
            int num = stmt.executeUpdate();
            bl = num == 1;
            Object var6_6 = null;
        }
        catch (SQLException e) {
            try {
                if (Db.errorMatches(e, Db.Error.FOREIGN_KEY_CHILD_EXISTS)) {
                    throw VolumeServiceException.CANNOT_DELETE_VOLUME_IN_USE(id, e);
                }
                throw ServiceException.FAILURE("deleting volume entry: " + id, e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeStatement(stmt);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static short getNextVolumeID(DbPool.Connection conn) throws ServiceException {
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            short s;
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
            stmt = null;
            rs = null;
            try {
                try {
                    stmt = conn.prepareStatement("SELECT MAX(id) FROM volume");
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block7;
                    short id = rs.getShort(1);
                    s = id = (short)(id + 1);
                    Object var6_6 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("getting max volume ID", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return s;
        }
        Object var6_7 = null;
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return 1;
    }

    public static Volume get(DbPool.Connection conn, short id) throws ServiceException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement("SELECT * FROM volume WHERE id=?");
            stmt.setShort(1, id);
            rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            Volume volume = DbVolume.constructVolume(rs);
            Object var6_6 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return volume;
        }
        try {
            try {
                throw VolumeServiceException.NO_SUCH_VOLUME(id);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting volume entry: " + id, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
    }

    public static Map<Short, Volume> getAll(DbPool.Connection conn) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<Short, Volume> result = new HashMap<Short, Volume>();
        try {
            try {
                stmt = conn.prepareStatement("SELECT * FROM volume");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Volume v = DbVolume.constructVolume(rs);
                    result.put(v.getId(), v);
                }
                Object var6_6 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting all volume entries", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return result;
    }

    public static CurrentVolumes getCurrentVolumes(DbPool.Connection conn) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        CurrentVolumes currVols = new CurrentVolumes();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            block7: {
                try {
                    stmt = conn.prepareStatement("SELECT message_volume_id, secondary_message_volume_id, index_volume_id FROM current_volumes");
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block7;
                    currVols.msgVolId = rs.getShort(1);
                    short s = rs.getShort(2);
                    if (!rs.wasNull()) {
                        currVols.secondaryMsgVolId = s;
                    }
                    currVols.indexVolId = rs.getShort(3);
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("getting current volumes", e);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        if (currVols.msgVolId != -2 && currVols.indexVolId != -2) {
            return currVols;
        }
        return null;
    }

    public static void updateCurrentVolume(DbPool.Connection conn, short volType, short volumeId) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        String colName = volType == 1 ? "message_volume_id" : (volType == 2 ? "secondary_message_volume_id" : "index_volume_id");
        PreparedStatement stmt = null;
        try {
            try {
                String sql = "UPDATE current_volumes SET " + colName + " = ?";
                stmt = conn.prepareStatement(sql);
                if (volumeId >= 0) {
                    stmt.setShort(1, volumeId);
                } else {
                    stmt.setNull(1, -6);
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating current volume", e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    private static Volume constructVolume(ResultSet rs) throws SQLException {
        short id = rs.getShort(CN_ID);
        short type = rs.getShort(CN_TYPE);
        String name = rs.getString(CN_NAME);
        String path = Volume.getAbsolutePath(rs.getString(CN_PATH));
        short mboxGroupBits = rs.getShort(CN_MAILBOX_GROUP_BITS);
        short mboxBits = rs.getShort(CN_MAILBOX_BITS);
        short fileGroupBits = rs.getShort(CN_FILE_GROUP_BITS);
        short fileBits = rs.getShort(CN_FILE_BITS);
        boolean compressBlobs = rs.getBoolean(CN_COMPRESS_BLOBS);
        long compressionThreshold = rs.getLong(CN_COMPRESSION_THRESHOLD);
        Volume v = new Volume(id, type, name, path, mboxGroupBits, mboxBits, fileGroupBits, fileBits, compressBlobs, compressionThreshold);
        return v;
    }

    public static class CurrentVolumes {
        public short msgVolId = (short)-2;
        public short secondaryMsgVolId = (short)-2;
        public short indexVolId = (short)-2;
    }
}

