/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUtil {
    public static final int INTEGER_TRUE = 1;
    public static final int INTEGER_FALSE = 0;
    private static final Pattern PAT_ESCAPED_QUOTES1 = Pattern.compile("\\\\'");
    private static final Pattern PAT_ESCAPED_QUOTES2 = Pattern.compile("''");
    private static final Pattern PAT_STRING_CONSTANT = Pattern.compile("'[^']+'");
    private static final Pattern PAT_INTEGER_CONSTANT = Pattern.compile("\\d+");
    private static final Pattern PAT_NULL_CONSTANT = Pattern.compile("NULL");
    private static final Pattern PAT_BEGIN_SPACE = Pattern.compile("^\\s+");
    private static final Pattern PAT_TRAILING_SPACE = Pattern.compile("\\s+$");
    private static final Pattern PAT_MULTIPLE_SPACES = Pattern.compile("\\s+");
    private static final Pattern PAT_IN_CLAUSE = Pattern.compile("IN \\([^\\)]+\\)", 32);

    public static final int getBooleanIntValue(boolean b) {
        return b ? 1 : 0;
    }

    public static Timestamp dateToTimestamp(Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static Date timestampToDate(Timestamp timestamp) {
        return timestamp == null ? null : new Date(timestamp.getTime());
    }

    public static String normalizeSql(String sql) {
        Matcher matcher = PAT_ESCAPED_QUOTES1.matcher(sql);
        sql = matcher.replaceAll("");
        matcher = PAT_ESCAPED_QUOTES2.matcher(sql);
        sql = matcher.replaceAll("XXX");
        matcher = PAT_STRING_CONSTANT.matcher(sql);
        sql = matcher.replaceAll("XXX");
        matcher = PAT_INTEGER_CONSTANT.matcher(sql);
        sql = matcher.replaceAll("XXX");
        matcher = PAT_NULL_CONSTANT.matcher(sql);
        sql = matcher.replaceAll("XXX");
        matcher = PAT_BEGIN_SPACE.matcher(sql);
        sql = matcher.replaceAll("");
        matcher = PAT_TRAILING_SPACE.matcher(sql);
        sql = matcher.replaceAll("");
        matcher = PAT_MULTIPLE_SPACES.matcher(sql);
        sql = matcher.replaceAll(" ");
        matcher = PAT_IN_CLAUSE.matcher(sql);
        sql = matcher.replaceAll("IN (...)");
        return sql;
    }

    public static DbResults executeQuery(DbPool.Connection conn, String query, Object[] params) throws ServiceException {
        PreparedStatement stmt = null;
        DbResults results = null;
        try {
            try {
                stmt = conn.prepareStatement(query);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                results = new DbResults(rs);
            }
            catch (SQLException e) {
                String message = "SQL: '" + query + "'";
                throw ServiceException.FAILURE(message, e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        return results;
    }

    public static DbResults executeQuery(DbPool.Connection conn, String query, Object param) throws ServiceException {
        Object[] params = new Object[]{param};
        return DbUtil.executeQuery(conn, query, params);
    }

    public static DbResults executeQuery(DbPool.Connection conn, String query) throws ServiceException {
        return DbUtil.executeQuery(conn, query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbResults executeQuery(String query, Object[] params) throws ServiceException {
        DbResults dbResults;
        DbPool.Connection conn = null;
        try {
            conn = DbPool.getConnection();
            dbResults = DbUtil.executeQuery(conn, query, params);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.quietClose(conn);
        return dbResults;
    }

    public static DbResults executeQuery(String query, Object param) throws ServiceException {
        Object[] params = new Object[]{param};
        return DbUtil.executeQuery(query, params);
    }

    public static DbResults executeQuery(String query) throws ServiceException {
        return DbUtil.executeQuery(query, null);
    }

    public static int executeUpdate(DbPool.Connection conn, String sql, Object[] params) throws ServiceException {
        PreparedStatement stmt = null;
        int numRows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                }
                numRows = stmt.executeUpdate();
            }
            catch (SQLException e) {
                String message = "SQL: '" + sql + "'";
                throw ServiceException.FAILURE(message, e);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        return numRows;
    }

    public static int executeUpdate(DbPool.Connection conn, String sql, Object param) throws ServiceException {
        Object[] params = new Object[]{param};
        return DbUtil.executeUpdate(conn, sql, params);
    }

    public static int executeUpdate(DbPool.Connection conn, String sql) throws ServiceException {
        return DbUtil.executeUpdate(conn, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params) throws ServiceException {
        int n;
        DbPool.Connection conn = DbPool.getConnection();
        try {
            int numRows = DbUtil.executeUpdate(conn, sql, params);
            conn.commit();
            n = numRows;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.quietClose(conn);
        return n;
    }

    public static int executeUpdate(String sql, Object param) throws ServiceException {
        Object[] params = new Object[]{param};
        return DbUtil.executeUpdate(sql, params);
    }

    public static int executeUpdate(String sql) throws ServiceException {
        return DbUtil.executeUpdate(sql, null);
    }

    public static String suitableNumberOfVariables(byte[] array) {
        return DbUtil.suitableNumberOfVariables(array.length);
    }

    public static String suitableNumberOfVariables(short[] array) {
        return DbUtil.suitableNumberOfVariables(array.length);
    }

    public static String suitableNumberOfVariables(int[] array) {
        return DbUtil.suitableNumberOfVariables(array.length);
    }

    public static String suitableNumberOfVariables(Object[] array) {
        return DbUtil.suitableNumberOfVariables(array.length);
    }

    public static String suitableNumberOfVariables(Collection<?> c) {
        return DbUtil.suitableNumberOfVariables(c.size());
    }

    public static String suitableNumberOfVariables(int size) {
        StringBuilder sb = new StringBuilder(" (");
        for (int i = 0; i < size; ++i) {
            sb.append(i == 0 ? "?" : ", ?");
        }
        return sb.append(")").toString();
    }

    public static void executeScript(DbPool.Connection conn, Reader scriptReader) throws IOException, ServiceException, SQLException {
        PreparedStatement stmt = null;
        String[] statements = DbUtil.parseScript(scriptReader);
        try {
            for (String sql : statements) {
                if (sql.length() == 0) continue;
                stmt = conn.prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
            conn.commit();
        }
        catch (SQLException e) {
            DbPool.quietRollback(conn);
            throw e;
        }
    }

    private static String[] addScript(String[] s1, String[] s2) {
        if (s1 == null) {
            return s2;
        }
        String[] temp = new String[s1.length + s2.length];
        System.arraycopy(s1, 0, temp, 0, s1.length);
        System.arraycopy(s2, 0, temp, s1.length, s2.length);
        return temp;
    }

    public static String[] parseScript(Reader scriptReader) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader br = new BufferedReader(scriptReader);
        String[] ret = null;
        while ((line = br.readLine()) != null) {
            if ((line = DbUtil.removeComments(line)).startsWith(".")) {
                if (line.endsWith(";")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (!line.startsWith(".read ")) continue;
                line = line.substring(".read".length());
                line = line.trim();
                line = line.replace("\"", "");
                String sql = new String(ByteUtil.getContent(new File(line)));
                ret = DbUtil.addScript(ret, DbUtil.parseScript(new StringReader(sql)));
                continue;
            }
            buf.append(line);
            line = line.trim();
            if (line.length() == 0) continue;
            buf.append('\n');
        }
        br.close();
        if (buf.length() != 0 || ret == null) {
            ret = DbUtil.addScript(ret, buf.toString().split("\\s*" + Db.getInstance().scriptCommandDelimiter() + "\\s*"));
        }
        for (int i = 0; i < ret.length; ++i) {
            if (!ret[i].startsWith("END")) continue;
            int n = i - 1;
            ret[n] = ret[n] + ";\n" + ret[i];
            ret[i] = "";
        }
        return ret;
    }

    public static String removeComments(String sqlLine) {
        int commentIndex = sqlLine.indexOf("--");
        int hashIndex = sqlLine.indexOf(35);
        if (hashIndex >= 0) {
            commentIndex = commentIndex >= 0 ? Math.min(commentIndex, hashIndex) : hashIndex;
        }
        if (commentIndex != -1) {
            sqlLine = sqlLine.substring(0, commentIndex);
        }
        return sqlLine;
    }

    public static String whereIn(String column, boolean in, int size) {
        if (size == 1) {
            return column + (in ? " = ?" : " <> ?");
        }
        if (size <= 3) {
            StringBuffer sb = new StringBuffer("(");
            do {
                sb.append(column).append(in ? " = ?" : " <> ?");
                if (size <= 1) continue;
                if (in) {
                    sb.append(" OR ");
                    continue;
                }
                sb.append(" AND ");
            } while (--size > 0);
            sb.append(')');
            return sb.toString();
        }
        return column + (in ? " IN" : " NOT IN") + DbUtil.suitableNumberOfVariables(size);
    }

    public static String whereIn(String column, int size) {
        return DbUtil.whereIn(column, true, size);
    }

    public static String whereNotIn(String column, int size) {
        return DbUtil.whereIn(column, false, size);
    }
}

