/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbStats
implements RealtimeStatsCallback {
    private static Log sLog = LogFactory.getLog(DbStats.class);
    private static final Pattern PATTERN_BP_HIT_RATE = Pattern.compile("hit rate (\\d+)");

    DbStats() {
    }

    @Override
    public Map<String, Object> getStatData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            data.put("db_pool_size", DbPool.getSize());
            DbResults results = DbUtil.executeQuery("SHOW INNODB STATUS");
            BufferedReader r = new BufferedReader(new StringReader(results.getString(1)));
            String line = null;
            while ((line = r.readLine()) != null) {
                Matcher m = PATTERN_BP_HIT_RATE.matcher(line);
                if (!m.find()) continue;
                data.put("innodb_bp_hit_rate", m.group(1));
            }
        }
        catch (Exception e) {
            sLog.warn((Object)"An error occurred while getting current database stats", e);
        }
        return data;
    }
}

