/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbSearch;
import com.zimbra.cs.db.DbSearchConstraintsNode;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSearchConstraints
implements DbSearchConstraintsNode,
Cloneable {
    public boolean noResults = false;
    public Set<Tag> tags = null;
    public Set<Tag> excludeTags = new HashSet<Tag>();
    public Boolean hasTags = null;
    public Set<Folder> folders = new HashSet<Folder>();
    public Set<Folder> excludeFolders = new HashSet<Folder>();
    public Set<RemoteFolderDescriptor> remoteFolders = new HashSet<RemoteFolderDescriptor>();
    public Set<RemoteFolderDescriptor> excludeRemoteFolders = new HashSet<RemoteFolderDescriptor>();
    public int convId = 0;
    public Set<Integer> prohibitedConvIds = new HashSet<Integer>();
    public ItemId remoteConvId = null;
    public Set<ItemId> prohibitedRemoteConvIds = new HashSet<ItemId>();
    public Set<Integer> itemIds = new HashSet<Integer>();
    public Set<Integer> prohibitedItemIds = new HashSet<Integer>();
    public Set<ItemId> remoteItemIds = new HashSet<ItemId>();
    public Set<ItemId> prohibitedRemoteItemIds = new HashSet<ItemId>();
    public Set<String> indexIds = new HashSet<String>();
    public Set<Byte> types = new HashSet<Byte>();
    public Set<Byte> excludeTypes = new HashSet<Byte>();
    public Collection<NumericRange> dates = new ArrayList<NumericRange>();
    public Collection<NumericRange> calStartDates = new ArrayList<NumericRange>();
    public Collection<NumericRange> calEndDates = new ArrayList<NumericRange>();
    public Collection<NumericRange> modified = new ArrayList<NumericRange>();
    public Collection<NumericRange> modifiedContent = new ArrayList<NumericRange>();
    public Collection<NumericRange> sizes = new ArrayList<NumericRange>();
    public Collection<NumericRange> convCounts = new ArrayList<NumericRange>();
    public Collection<StringRange> subjectRanges = new ArrayList<StringRange>();
    public Collection<StringRange> senderRanges = new ArrayList<StringRange>();
    DbSearch.TagConstraints tagConstraints;

    @Override
    public DbSearchConstraintsNode.NodeType getNodeType() {
        return DbSearchConstraintsNode.NodeType.LEAF;
    }

    public Iterable<DbSearchConstraintsNode> getSubNodes() {
        return null;
    }

    @Override
    public DbSearchConstraints getSearchConstraints() {
        return this;
    }

    private Set<Byte> calcTypes() {
        if (this.excludeTypes.size() == 0) {
            return this.types;
        }
        if (this.types.size() == 0) {
            for (byte i = 1; i < 16; i = (byte)(i + 1)) {
                this.types.add(i);
            }
        }
        for (Byte t : this.excludeTypes) {
            this.types.remove(t);
        }
        this.excludeTypes = new HashSet<Byte>();
        return this.types;
    }

    boolean hasNonAppointmentTypes() {
        Set<Byte> fullTypes = this.calcTypes();
        HashSet<Byte> temp = new HashSet<Byte>();
        temp.addAll(fullTypes);
        temp.remove((byte)11);
        temp.remove((byte)15);
        return !temp.isEmpty();
    }

    boolean hasAppointmentTableConstraints() {
        Set<Byte> fullTypes = this.calcTypes();
        return !(this.calStartDates.size() <= 0 && this.calEndDates.size() <= 0 || !fullTypes.contains((byte)11) && !fullTypes.contains((byte)15));
    }

    boolean isSimpleSingleFolderMessageQuery() {
        boolean typeListIncludesMessage = false;
        if (this.types.size() > 0) {
            for (Byte type : this.types) {
                if (type != 5) continue;
                typeListIncludesMessage = true;
                break;
            }
        }
        if (typeListIncludesMessage && this.excludeTypes.size() > 0) {
            for (Byte type : this.excludeTypes) {
                if (type != 5) continue;
                typeListIncludesMessage = false;
                break;
            }
        }
        return !(this.folders.size() != 1 || !this.excludeFolders.isEmpty() || !typeListIncludesMessage || this.hasTags != null || this.excludeTags != null && !this.excludeTags.isEmpty() || this.tags != null && !this.tags.isEmpty() || this.convId != 0 || !this.prohibitedConvIds.isEmpty() || !this.itemIds.isEmpty() || !this.prohibitedItemIds.isEmpty() || !this.indexIds.isEmpty() || !this.dates.isEmpty() || !this.calStartDates.isEmpty() || !this.calEndDates.isEmpty() || !this.modified.isEmpty() || !this.modifiedContent.isEmpty() || !this.sizes.isEmpty() || !this.convCounts.isEmpty() || !this.subjectRanges.isEmpty() || !this.senderRanges.isEmpty());
    }

    public Boolean getIsSoloPart() {
        if (this.convCounts.size() != 1) {
            return null;
        }
        NumericRange r = this.convCounts.iterator().next();
        if (r.highest == 1L && r.highestEqual && r.lowest == 1L && r.lowestEqual) {
            if (r.negated) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        DbSearchConstraints toRet = (DbSearchConstraints)super.clone();
        toRet.tags = SetHelper.cloneHashSet(this.tags);
        toRet.excludeTags = SetHelper.cloneHashSet(this.excludeTags);
        toRet.folders = SetHelper.cloneHashSet(this.folders);
        toRet.excludeFolders = SetHelper.cloneHashSet(this.excludeFolders);
        toRet.remoteFolders = SetHelper.cloneHashSet(this.remoteFolders);
        toRet.excludeRemoteFolders = SetHelper.cloneHashSet(this.excludeRemoteFolders);
        toRet.convId = this.convId;
        toRet.prohibitedConvIds = SetHelper.cloneHashSet(this.prohibitedConvIds);
        toRet.remoteConvId = this.remoteConvId;
        toRet.prohibitedRemoteConvIds = SetHelper.cloneHashSet(this.prohibitedRemoteConvIds);
        toRet.itemIds = SetHelper.cloneHashSet(this.itemIds);
        toRet.prohibitedItemIds = SetHelper.cloneHashSet(this.prohibitedItemIds);
        toRet.remoteItemIds = SetHelper.cloneHashSet(this.remoteItemIds);
        toRet.prohibitedRemoteItemIds = SetHelper.cloneHashSet(this.prohibitedRemoteItemIds);
        toRet.indexIds = SetHelper.cloneHashSet(this.indexIds);
        toRet.types = SetHelper.cloneHashSet(this.types);
        toRet.excludeTypes = SetHelper.cloneHashSet(this.excludeTypes);
        toRet.dates = SetHelper.cloneHashSet(this.dates);
        toRet.calStartDates = SetHelper.cloneHashSet(this.calStartDates);
        toRet.calEndDates = SetHelper.cloneHashSet(this.calEndDates);
        toRet.modified = SetHelper.cloneHashSet(this.modified);
        toRet.modifiedContent = SetHelper.cloneHashSet(this.modifiedContent);
        toRet.sizes = SetHelper.cloneHashSet(this.sizes);
        toRet.convCounts = SetHelper.cloneHashSet(this.convCounts);
        toRet.subjectRanges = SetHelper.cloneHashSet(this.subjectRanges);
        toRet.senderRanges = SetHelper.cloneHashSet(this.senderRanges);
        return toRet;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("");
        if (this.noResults) {
            retVal.append("-is:anywhere ");
        }
        Printer<Tag> tp = new Printer<Tag>(){

            @Override
            void printOne(StringBuilder s, Tag t) {
                s.append(t.getName());
            }
        };
        Printer<Integer> ip = new Printer<Integer>(){

            @Override
            void printOne(StringBuilder s, Integer i) {
                s.append(i);
            }
        };
        Printer<String> sp = new Printer<String>(){

            @Override
            void printOne(StringBuilder s, String in) {
                s.append(in);
            }
        };
        Printer<Byte> bp = new Printer<Byte>(){

            @Override
            void printOne(StringBuilder s, Byte b) {
                s.append(b);
            }
        };
        FolderPrinter fp = new FolderPrinter();
        RemoteFolderPrinter rfp = new RemoteFolderPrinter();
        ItemIdPrinter iip = new ItemIdPrinter();
        tp.run(retVal, this.tags, "TAG");
        tp.run(retVal, this.excludeTags, "-TAG");
        if (this.hasTags != null) {
            if (this.hasTags.booleanValue()) {
                retVal.append("HAS_TAG ");
            } else {
                retVal.append("-HAS_TAG ");
            }
        }
        fp.run(retVal, true, this.folders);
        fp.run(retVal, false, this.excludeFolders);
        rfp.run(retVal, true, this.remoteFolders);
        rfp.run(retVal, false, this.excludeRemoteFolders);
        if (this.convId != 0) {
            retVal.append("CONV:(").append(this.convId).append(") ");
        }
        ip.run(retVal, this.prohibitedConvIds, "-CONVID");
        if (this.remoteConvId != null) {
            retVal.append("CONV:\"").append(this.remoteConvId).append("\" ");
        }
        iip.run(retVal, false, this.prohibitedRemoteConvIds, "CONV");
        ip.run(retVal, this.itemIds, "ITEM");
        ip.run(retVal, this.prohibitedItemIds, "-ITEM");
        iip.run(retVal, true, this.remoteItemIds, "ITEM");
        iip.run(retVal, false, this.prohibitedRemoteItemIds, "ITEM");
        sp.run(retVal, this.indexIds, "INDEXID");
        bp.run(retVal, this.types, "TYPE");
        bp.run(retVal, this.excludeTypes, "-TYPE");
        if (!this.dates.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.dates, "DATE");
        }
        if (!this.calStartDates.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.calStartDates, "APPT-START");
        }
        if (!this.calEndDates.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.calEndDates, "APPT-END");
        }
        if (!this.modified.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.modified, "MOD");
        }
        if (!this.modifiedContent.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.modified, "MOD-CONTENT");
        }
        if (!this.sizes.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.sizes, "SIZE");
        }
        if (!this.convCounts.isEmpty()) {
            new ObjectPrinter<NumericRange>().run(retVal, this.convCounts, "CONV-COUNT");
        }
        if (!this.subjectRanges.isEmpty()) {
            new ObjectPrinter<StringRange>().run(retVal, this.subjectRanges, "SUBJECT");
        }
        if (!this.senderRanges.isEmpty()) {
            new ObjectPrinter<StringRange>().run(retVal, this.senderRanges, "FROM");
        }
        return retVal.toString();
    }

    public void andConstraints(DbSearchConstraints other) {
        if (this.noResults || other.noResults) {
            this.noResults = true;
            return;
        }
        this.tags = SetHelper.union(this.tags, other.tags);
        this.excludeTags = SetHelper.union(this.excludeTags, other.excludeTags);
        if (this.tags != null && this.excludeTags != null) {
            for (Tag t : this.tags) {
                if (!this.excludeTags.contains(t)) continue;
                this.noResults = true;
                return;
            }
        }
        if (this.hasTags == null) {
            this.hasTags = other.hasTags;
        } else if (other.hasTags != null && !this.hasTags.equals(other.hasTags)) {
            this.noResults = true;
            ZimbraLog.index.debug("Adding a HAS_NO_TAGS constraint to a HAS_TAGS one, this is a NO_RESULTS result");
            return;
        }
        if (this.folders.size() > 0 || other.folders.size() > 0) {
            this.folders = SetHelper.intersectIfNonempty(this.folders, other.folders);
            if (this.folders.size() == 0) {
                this.noResults = true;
            }
        }
        this.excludeFolders = SetHelper.union(this.excludeFolders, other.excludeFolders);
        this.remoteFolders = SetHelper.union(this.remoteFolders, other.remoteFolders);
        this.excludeRemoteFolders = SetHelper.union(this.excludeRemoteFolders, other.excludeRemoteFolders);
        if (other.convId != 0) {
            if (this.convId != 0) {
                if (this.convId != other.convId) {
                    ZimbraLog.index.debug("ANDING a constraint with incompatible convIds, this is a NO_RESULTS constraint now");
                    this.noResults = true;
                }
            } else {
                this.convId = other.convId;
            }
        }
        this.prohibitedConvIds = SetHelper.union(this.prohibitedConvIds, other.prohibitedConvIds);
        if (other.remoteConvId != null) {
            if (this.remoteConvId != null) {
                if (!this.remoteConvId.equals(other.remoteConvId)) {
                    ZimbraLog.index.debug("ANDING a constraint with incompatible remoteConvIds, this is a NO_RESULTS constraint now");
                    this.noResults = true;
                }
            } else {
                this.remoteConvId = other.remoteConvId;
            }
        }
        this.prohibitedRemoteConvIds = SetHelper.union(this.prohibitedRemoteConvIds, other.prohibitedRemoteConvIds);
        boolean prevNonempty = false;
        if (this.itemIds.size() > 0 || other.itemIds.size() > 0) {
            prevNonempty = true;
        }
        this.itemIds = SetHelper.intersectIfNonempty(this.itemIds, other.itemIds);
        if (this.itemIds.size() == 0 && prevNonempty) {
            this.noResults = true;
        }
        this.prohibitedItemIds = SetHelper.union(this.prohibitedItemIds, other.prohibitedItemIds);
        prevNonempty = false;
        if (this.remoteItemIds.size() > 0 || other.remoteItemIds.size() > 0) {
            prevNonempty = true;
        }
        this.remoteItemIds = SetHelper.intersectIfNonempty(this.remoteItemIds, other.remoteItemIds);
        if (this.itemIds.size() == 0 && prevNonempty) {
            this.noResults = true;
        }
        this.prohibitedRemoteItemIds = SetHelper.union(this.prohibitedRemoteItemIds, other.prohibitedRemoteItemIds);
        if (this.indexIds.size() > 0 || other.indexIds.size() > 0) {
            this.indexIds = SetHelper.intersectIfNonempty(this.indexIds, other.indexIds);
            if (this.indexIds.size() == 0) {
                this.noResults = true;
            }
        }
        if (this.types.size() > 0 || other.types.size() > 0) {
            this.types = SetHelper.intersectIfNonempty(this.types, other.types);
            if (this.types.size() == 0) {
                this.noResults = true;
            }
        }
        this.excludeTypes = SetHelper.union(this.excludeTypes, other.excludeTypes);
        if (other.dates != null) {
            if (this.dates == null) {
                this.dates = new ArrayList<NumericRange>();
            }
            this.dates.addAll(other.dates);
        }
        if (other.calStartDates != null) {
            if (this.calStartDates == null) {
                this.calStartDates = new ArrayList<NumericRange>();
            }
            this.calStartDates.addAll(other.calStartDates);
        }
        if (other.calEndDates != null) {
            if (this.calEndDates == null) {
                this.calEndDates = new ArrayList<NumericRange>();
            }
            this.calEndDates.addAll(other.calEndDates);
        }
        if (other.modified != null) {
            if (this.modified == null) {
                this.modified = new ArrayList<NumericRange>();
            }
            this.modified.addAll(other.modified);
        }
        if (other.modifiedContent != null) {
            if (this.modifiedContent == null) {
                this.modifiedContent = new ArrayList<NumericRange>();
            }
            this.modifiedContent.addAll(other.modifiedContent);
        }
        if (other.sizes != null) {
            if (this.sizes == null) {
                this.sizes = new ArrayList<NumericRange>();
            }
            this.sizes.addAll(other.sizes);
        }
        if (other.convCounts != null) {
            if (this.convCounts == null) {
                this.convCounts = new ArrayList<NumericRange>();
            }
            this.convCounts.addAll(other.convCounts);
        }
        if (other.subjectRanges != null) {
            if (this.subjectRanges == null) {
                this.subjectRanges = new ArrayList<StringRange>();
            }
            this.subjectRanges.addAll(other.subjectRanges);
        }
        if (other.senderRanges != null) {
            if (this.senderRanges == null) {
                this.senderRanges = new ArrayList<StringRange>();
            }
            this.senderRanges.addAll(other.senderRanges);
        }
    }

    boolean automaticEmptySet() {
        HashSet<Integer> s = new HashSet<Integer>();
        SetHelper.addIdsToSet(s, this.tags);
        SetHelper.addIdsToSet(s, this.folders);
        if (Boolean.FALSE.equals(this.hasTags) && this.tags != null && this.tags.size() != 0) {
            return true;
        }
        if (!ListUtil.isEmpty(this.dates)) {
            for (NumericRange r : this.dates) {
                if (r.lowest < -1L && r.negated) {
                    return true;
                }
                if (r.highest >= -1L || r.negated) continue;
                return true;
            }
        }
        if (!ListUtil.isEmpty(this.modified)) {
            for (NumericRange r : this.modified) {
                if (r.lowest < -1L && r.negated) {
                    return true;
                }
                if (r.highest >= -1L || r.negated) continue;
                return true;
            }
        }
        return false;
    }

    void checkDates() {
        this.checkIntervals(this.dates);
        this.checkIntervals(this.calStartDates);
        this.checkIntervals(this.calEndDates);
        this.checkIntervals(this.modified);
        this.checkIntervals(this.modifiedContent);
        this.checkIntervals(this.convCounts);
    }

    void checkIntervals(Collection<? extends NumericRange> intervals) {
        if (!ListUtil.isEmpty(intervals)) {
            Iterator<? extends NumericRange> iter = intervals.iterator();
            while (iter.hasNext()) {
                NumericRange r = iter.next();
                if (r.isValid()) continue;
                iter.remove();
            }
        }
    }

    public static final class RemoteFolderDescriptor {
        private ItemId folderId;
        private String subfolderPath;
        private boolean includeSubfolders;

        public RemoteFolderDescriptor(ItemId iidFolder, String subpath, boolean includeSubfolders) {
            this.includeSubfolders = includeSubfolders;
            this.folderId = iidFolder;
            this.subfolderPath = subpath;
            if (this.subfolderPath == null) {
                this.subfolderPath = "";
            }
        }

        public ItemId getFolderId() {
            return this.folderId;
        }

        public String getSubfolderPath() {
            return this.subfolderPath;
        }

        public boolean getIncludeSubfolders() {
            return this.includeSubfolders;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.folderId == null ? 0 : this.folderId.hashCode());
            result = 31 * result + (this.subfolderPath == null ? 0 : this.subfolderPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteFolderDescriptor other = (RemoteFolderDescriptor)obj;
            if (other.includeSubfolders != this.includeSubfolders) {
                return false;
            }
            if (this.folderId == null ? other.folderId != null : !this.folderId.equals(other.folderId)) {
                return false;
            }
            return !(this.subfolderPath == null ? other.subfolderPath != null : !this.subfolderPath.equals(other.subfolderPath));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetHelper {
        private SetHelper() {
        }

        static <T> HashSet<T> cloneHashSet(Collection<T> current) {
            if (current == null) {
                return null;
            }
            HashSet<T> toRet = new HashSet<T>();
            toRet.addAll(current);
            return toRet;
        }

        static void addIdsToSet(Set<Integer> s, Collection<?> items) {
            if (items != null) {
                for (Object obj : items) {
                    s.add(((MailItem)obj).getId());
                }
            }
        }

        static <T> Set<T> clone(Set<T> s) {
            HashSet<T> toRet = null;
            if (s != null) {
                toRet = new HashSet<T>();
                toRet.addAll(s);
            }
            return toRet;
        }

        static <T> Set<T> intersectIfNonempty(Set<T> lhs, Set<T> rhs) {
            assert (lhs != null && rhs != null);
            if (lhs.size() == 0) {
                return SetHelper.clone(rhs);
            }
            if (rhs.size() == 0) {
                return lhs;
            }
            if (rhs == null) {
                return lhs;
            }
            if (lhs == null) {
                return SetHelper.clone(rhs);
            }
            HashSet<T> newSet = new HashSet<T>();
            for (T t : rhs) {
                if (!lhs.contains(t)) continue;
                newSet.add(t);
            }
            return newSet;
        }

        static <T> Set<T> union(Set<T> lhs, Set<T> rhs) {
            if (rhs == null) {
                return lhs;
            }
            if (lhs == null) {
                return SetHelper.clone(rhs);
            }
            lhs.addAll(rhs);
            return lhs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectPrinter<T>
    extends Printer<T> {
        private ObjectPrinter() {
        }

        @Override
        void printOne(StringBuilder s, T t) {
            s.append(t.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoteFolderPrinter {
        private RemoteFolderPrinter() {
        }

        void run(StringBuilder str, boolean truthiness, Collection<RemoteFolderDescriptor> collect) {
            if (!ListUtil.isEmpty(collect)) {
                str.append("(");
                boolean atFirst = true;
                for (RemoteFolderDescriptor rf : collect) {
                    if (!atFirst) {
                        str.append(" ");
                    }
                    if (!truthiness) {
                        str.append("-");
                    }
                    String intro = rf.getIncludeSubfolders() ? "UNDERID" : "INID";
                    str.append(intro).append(":\"").append(rf.getFolderId().toString());
                    if (rf.getSubfolderPath() != null && rf.getSubfolderPath().length() > 0) {
                        str.append('/').append(rf.getSubfolderPath());
                    }
                    str.append("\"");
                    atFirst = false;
                }
                str.append(") ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemIdPrinter {
        private ItemIdPrinter() {
        }

        void run(StringBuilder str, boolean truthiness, Collection<ItemId> collect, String intro) {
            if (!ListUtil.isEmpty(collect)) {
                str.append("(");
                boolean atFirst = true;
                for (ItemId iid : collect) {
                    if (!atFirst) {
                        str.append(" ");
                    }
                    if (!truthiness) {
                        str.append("-");
                    }
                    str.append(intro).append(":\"").append(iid.toString()).append("\"");
                    atFirst = false;
                }
                str.append(") ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderPrinter {
        private FolderPrinter() {
        }

        void run(StringBuilder str, boolean truthiness, Collection<Folder> collect) {
            if (!ListUtil.isEmpty(collect)) {
                str.append("(");
                boolean atFirst = true;
                for (Folder f : collect) {
                    if (!atFirst) {
                        str.append(" ");
                    }
                    if (!truthiness) {
                        str.append("-");
                    }
                    if (f instanceof Mountpoint) {
                        str.append("INID:");
                        Mountpoint mpt = (Mountpoint)f;
                        str.append(mpt.getRemoteId());
                    } else {
                        str.append("IN:").append(f.getPath());
                    }
                    atFirst = false;
                }
                str.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Printer<T> {
        private Printer() {
        }

        void run(StringBuilder str, Collection<T> collect, String intro) {
            if (!ListUtil.isEmpty(collect)) {
                str.append(intro).append(":(");
                boolean atFirst = true;
                for (T elt : collect) {
                    if (!atFirst) {
                        str.append(", ");
                    }
                    this.printOne(str, elt);
                    atFirst = false;
                }
                str.append(")");
            }
        }

        abstract void printOne(StringBuilder var1, T var2);
    }

    public static class NumericRange {
        public boolean negated = false;
        public long lowest = -1L;
        public boolean lowestEqual = false;
        public long highest = -1L;
        public boolean highestEqual = false;

        public boolean equals(Object o) {
            NumericRange other = (NumericRange)o;
            return other.negated == this.negated && other.lowest == this.lowest && other.highest == this.highest && other.lowestEqual == this.lowestEqual && other.highestEqual == this.highestEqual;
        }

        boolean isValid() {
            return this.lowest > 0L || this.highest > 0L;
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder();
            if (this.negated) {
                retVal.append("NOT (");
            }
            if (this.lowest > -1L && this.lowestEqual && this.highestEqual && this.lowest == this.highest) {
                retVal.append(this.lowest);
            } else {
                boolean hasLowest = false;
                if (this.lowest > -1L) {
                    retVal.append(">");
                    if (this.lowestEqual) {
                        retVal.append('=');
                    }
                    retVal.append(this.lowest);
                    hasLowest = true;
                }
                if (this.highest > -1L) {
                    if (hasLowest) {
                        retVal.append(' ');
                    }
                    retVal.append("<");
                    if (this.highestEqual) {
                        retVal.append('=');
                    }
                    retVal.append(this.highest);
                }
            }
            if (this.negated) {
                retVal.append(")");
            }
            return retVal.toString();
        }
    }

    public static class StringRange {
        public boolean negated = false;
        public String lowest = null;
        public boolean lowestEqual = false;
        public String highest = null;
        public boolean highestEqual = false;

        public boolean equals(Object o) {
            StringRange other = (StringRange)o;
            return StringUtil.equal(other.lowest, this.lowest) && other.lowestEqual == this.lowestEqual && StringUtil.equal(other.highest, this.highest) && other.highestEqual == this.highestEqual && other.negated == this.negated;
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder();
            if (this.negated) {
                retVal.append("NOT (");
            }
            if (this.lowest != null) {
                retVal.append("\">");
                if (this.lowestEqual) {
                    retVal.append('=');
                }
                retVal.append(this.lowest);
                retVal.append("\" ");
            }
            if (this.highest != null) {
                retVal.append("\"<");
                if (this.highestEqual) {
                    retVal.append('=');
                }
                retVal.append(this.highest);
                retVal.append("\" ");
            }
            if (this.negated) {
                retVal.append(")");
            }
            return retVal.toString();
        }

        boolean isValid() {
            return true;
        }
    }
}

