/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbSearchConstraints;
import com.zimbra.cs.db.DbSearchConstraintsInnerNode;
import com.zimbra.cs.db.DbSearchConstraintsNode;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.db.TagsetCache;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Tag;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSearch {
    private static Log sLog = LogFactory.getLog(DbSearch.class);
    public static final String SORT_COLUMN_ALIAS = "sortcol";
    private static final String MI_I_MBOX_FOLDER_DATE = "i_folder_id_date";
    private static final String MI_I_MBOX_PARENT = "i_parent_id";
    private static final String MI_I_MBOX_INDEX = "i_index_id";
    private static final String NO_HINT = "";
    private static final int COLUMN_ID = 1;
    private static final int COLUMN_INDEXID = 2;
    private static final int COLUMN_TYPE = 3;
    private static final int COLUMN_SORTKEY = 4;
    static final byte[] APPOINTMENT_TABLE_TYPES = new byte[]{11, 15};

    private static boolean isCaseSensitiveField(String fieldName) {
        int periodOffset = fieldName.lastIndexOf(46);
        String colNameAfterPeriod = periodOffset <= 0 && periodOffset < fieldName.length() + 1 ? fieldName : fieldName.substring(periodOffset + 1);
        return colNameAfterPeriod.equals("sender") || colNameAfterPeriod.equals("subject") || colNameAfterPeriod.equals("name");
    }

    private static String sortField(SortBy sort, boolean useAlias, boolean includeCollation) {
        String str;
        boolean stringVal = false;
        switch (sort.getCriterion()) {
            case SENDER: {
                str = "mi.sender";
                stringVal = true;
                break;
            }
            case SUBJECT: {
                str = "mi.subject";
                stringVal = true;
                break;
            }
            case NAME: 
            case NAME_NATURAL_ORDER: {
                str = "mi.name";
                stringVal = true;
                break;
            }
            case ID: {
                str = "mi.id";
                break;
            }
            case SIZE: {
                str = "mi.size";
                break;
            }
            default: {
                str = "mi.date";
                break;
            }
            case NONE: {
                return null;
            }
        }
        if (useAlias) {
            str = SORT_COLUMN_ALIAS;
        } else if (stringVal && Db.supports(Db.Capability.CASE_SENSITIVE_COMPARISON)) {
            str = "UPPER(" + str + ")";
        }
        return str;
    }

    static String sortKey(SortBy sort) {
        String field = DbSearch.sortField(sort, false, false);
        if (field == null) {
            return NO_HINT;
        }
        return ", " + field + " AS " + SORT_COLUMN_ALIAS;
    }

    static String sortQuery(SortBy sort) {
        return DbSearch.sortQuery(sort, false);
    }

    static String sortQuery(SortBy sort, boolean useAlias) {
        if (sort.getCriterion() == SortBy.SortCriterion.NONE) {
            return NO_HINT;
        }
        StringBuilder statement = new StringBuilder(" ORDER BY ");
        statement.append(DbSearch.sortField(sort, useAlias, true));
        if (sort.getDirection() == SortBy.SortDirection.DESCENDING) {
            statement.append(" DESC");
        }
        return statement.toString();
    }

    public static int countResults(DbPool.Connection conn, DbSearchConstraintsNode node, Mailbox mbox) throws ServiceException {
        int n;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        StringBuilder statement = new StringBuilder("SELECT count(*) ");
        statement.append(" FROM " + DbMailItem.getMailItemTableName(mbox, " mi"));
        statement.append(" WHERE ").append(DbMailItem.IN_THIS_MAILBOX_AND);
        int num = DebugConfig.disableMailboxGroups ? 0 : 1;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            num += DbSearch.encodeConstraint(mbox, node, null, false, statement, conn);
            stmt = conn.prepareStatement(statement.toString());
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            pos = DbSearch.setSearchVars(stmt, node, pos, null, false);
            if (sLog.isDebugEnabled()) {
                sLog.debug("SQL: " + statement);
            }
            assert (pos == num + 1);
            rs = stmt.executeQuery();
            rs.next();
            n = rs.getInt(1);
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching search metadata", e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return n;
    }

    private static String getForceIndexClause(DbSearchConstraintsNode node, SortBy sort, boolean hasLimit) {
        if (LC.search_disable_database_hints.booleanValue()) {
            return NO_HINT;
        }
        if (!Db.supports(Db.Capability.FORCE_INDEX_EVEN_IF_NO_SORT) && sort.getCriterion() == SortBy.SortCriterion.NONE) {
            return NO_HINT;
        }
        String index = null;
        DbSearchConstraintsNode.NodeType ntype = node.getNodeType();
        DbSearchConstraints constraints = node.getSearchConstraints();
        if (ntype == DbSearchConstraintsNode.NodeType.LEAF) {
            if (!constraints.itemIds.isEmpty()) {
                return NO_HINT;
            }
            if (constraints.convId > 0) {
                index = MI_I_MBOX_PARENT;
            } else if (!constraints.indexIds.isEmpty()) {
                index = MI_I_MBOX_INDEX;
            } else if (sort.getCriterion() == SortBy.SortCriterion.DATE && hasLimit && constraints.isSimpleSingleFolderMessageQuery()) {
                index = MI_I_MBOX_FOLDER_DATE;
            }
        }
        return Db.forceIndex(index);
    }

    private static final String encodeSelect(Mailbox mbox, SortBy sort, SearchResult.ExtraData extra, boolean includeCalTable, DbSearchConstraintsNode node, boolean validLIMIT) {
        StringBuilder select = new StringBuilder("SELECT mi.id, mi.index_id, mi.type").append(DbSearch.sortKey(sort));
        if (extra == SearchResult.ExtraData.MAIL_ITEM) {
            select.append(", mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content");
        } else if (extra == SearchResult.ExtraData.IMAP_MSG) {
            select.append(", mi.imap_id, mi.unread, mi.flags, mi.tags");
        } else if (extra == SearchResult.ExtraData.MODSEQ) {
            select.append(", mi.mod_metadata");
        } else if (extra == SearchResult.ExtraData.PARENT) {
            select.append(", mi.parent_id");
        } else if (extra == SearchResult.ExtraData.MODCONTENT) {
            select.append(", mi.mod_content");
        }
        select.append(" FROM " + DbMailItem.getMailItemTableName(mbox, "mi"));
        if (includeCalTable) {
            select.append(", ").append(DbMailItem.getCalendarItemTableName(mbox, "ap"));
        }
        if (!includeCalTable) {
            select.append(DbSearch.getForceIndexClause(node, sort, validLIMIT));
        }
        select.append(" WHERE ");
        select.append(DbMailItem.getInThisMailboxAnd(mbox.getId(), "mi", includeCalTable ? "ap" : null));
        if (includeCalTable) {
            select.append(" mi.id = ap.item_id AND ");
        }
        return select.toString();
    }

    private static final int encodeConstraint(Mailbox mbox, DbSearchConstraintsNode node, byte[] calTypes, boolean inCalTable, StringBuilder statement, DbPool.Connection conn) throws ServiceException {
        int num = 0;
        DbSearchConstraintsNode.NodeType ntype = node.getNodeType();
        if (ntype == DbSearchConstraintsNode.NodeType.AND || ntype == DbSearchConstraintsNode.NodeType.OR) {
            boolean first = true;
            boolean and = ntype == DbSearchConstraintsNode.NodeType.AND;
            statement.append('(');
            for (DbSearchConstraintsNode dbSearchConstraintsNode : node.getSubNodes()) {
                if (!first) {
                    statement.append(and ? " AND " : " OR ");
                }
                num += DbSearch.encodeConstraint(mbox, dbSearchConstraintsNode, calTypes, inCalTable, statement, conn);
                first = false;
            }
            statement.append(") ");
            return num;
        }
        DbSearchConstraints c = node.getSearchConstraints();
        assert (ntype == DbSearchConstraintsNode.NodeType.LEAF && c != null);
        c.checkDates();
        TagConstraints tc = TagConstraints.getTagContraints(mbox, c, conn);
        if (c.automaticEmptySet() || tc.noMatches) {
            statement.append(Db.supports(Db.Capability.BOOLEAN_DATATYPE) ? "FALSE" : "0=1");
            return num;
        }
        statement.append('(');
        if (ListUtil.isEmpty(c.types)) {
            statement.append("type NOT IN (1,2,13,3,4)");
        } else {
            statement.append(DbUtil.whereIn("type", c.types.size()));
            num += c.types.size();
        }
        num += DbSearch.encode(statement, "mi.type", false, c.excludeTypes);
        num += DbSearch.encode(statement, "mi.type", inCalTable, calTypes);
        if (c.hasTags != null) {
            if (c.hasTags.booleanValue()) {
                statement.append(" AND mi.tags != 0");
            } else {
                statement.append(" AND mi.tags = 0");
            }
        }
        num += DbSearch.encode(statement, "mi.tags", true, tc.searchTagsets);
        num += DbSearch.encode(statement, "mi.flags", true, tc.searchFlagsets);
        num += DbSearch.encode(statement, "unread", true, tc.unread);
        num += DbSearch.encode(statement, "mi.folder_id", true, c.folders);
        num += DbSearch.encode(statement, "mi.folder_id", false, c.excludeFolders);
        num = c.convId > 0 ? (num += DbSearch.encode(statement, "mi.parent_id", true)) : (num += DbSearch.encode(statement, "mi.parent_id", false, c.prohibitedConvIds));
        num += DbSearch.encode(statement, "mi.id", true, c.itemIds);
        num += DbSearch.encode(statement, "mi.id", false, c.prohibitedItemIds);
        num += DbSearch.encode(statement, "mi.index_id", true, c.indexIds);
        num += DbSearch.encodeRangeWithMinimum(statement, "mi.date", c.dates, 1L);
        num += DbSearch.encodeRangeWithMinimum(statement, "mi.mod_metadata", c.modified, 1L);
        num += DbSearch.encodeRangeWithMinimum(statement, "mi.mod_content", c.modifiedContent, 1L);
        num += DbSearch.encodeRangeWithMinimum(statement, "mi.size", c.sizes, 0L);
        num += DbSearch.encodeRange(statement, "mi.subject", c.subjectRanges);
        num += DbSearch.encodeRange(statement, "mi.sender", c.senderRanges);
        Boolean isSoloPart = node.getSearchConstraints().getIsSoloPart();
        if (isSoloPart != null) {
            if (isSoloPart.booleanValue()) {
                statement.append(" AND mi.parent_id is NULL ");
            } else {
                statement.append(" AND mi.parent_id is NOT NULL ");
            }
        }
        if (inCalTable) {
            num += DbSearch.encodeRangeWithMinimum(statement, "ap.start_time", c.calStartDates, 1L);
            num += DbSearch.encodeRangeWithMinimum(statement, "ap.end_time", c.calEndDates, 1L);
        }
        statement.append(')');
        return num;
    }

    private static final boolean hasMailItemOnlyConstraints(DbSearchConstraintsNode node) {
        DbSearchConstraintsNode.NodeType ntype = node.getNodeType();
        if (ntype == DbSearchConstraintsNode.NodeType.AND || ntype == DbSearchConstraintsNode.NodeType.OR) {
            for (DbSearchConstraintsNode dbSearchConstraintsNode : node.getSubNodes()) {
                if (!DbSearch.hasMailItemOnlyConstraints(dbSearchConstraintsNode)) continue;
                return true;
            }
            return false;
        }
        return node.getSearchConstraints().hasNonAppointmentTypes();
    }

    private static final boolean hasAppointmentTableConstraints(DbSearchConstraintsNode node) {
        DbSearchConstraintsNode.NodeType ntype = node.getNodeType();
        if (ntype == DbSearchConstraintsNode.NodeType.AND || ntype == DbSearchConstraintsNode.NodeType.OR) {
            for (DbSearchConstraintsNode dbSearchConstraintsNode : node.getSubNodes()) {
                if (!DbSearch.hasAppointmentTableConstraints(dbSearchConstraintsNode)) continue;
                return true;
            }
            return false;
        }
        return node.getSearchConstraints().hasAppointmentTableConstraints();
    }

    public static List<SearchResult> search(List<SearchResult> result, DbPool.Connection conn, DbSearchConstraints c, Mailbox mbox, SortBy sort, SearchResult.ExtraData extra) throws ServiceException {
        return DbSearch.search(result, conn, c, mbox, sort, -1, -1, extra);
    }

    private static <T> List<T> mergeSortedLists(List<T> toRet, List<List<T>> lists, Comparator<? super T> comparator) {
        int totalNumValues = 0;
        for (List<T> l : lists) {
            totalNumValues += l.size();
        }
        for (List<T> l : lists) {
            toRet.addAll(l);
        }
        Collections.sort(toRet, comparator);
        return toRet;
    }

    public static List<SearchResult> search(List<SearchResult> result, DbPool.Connection conn, DbSearchConstraintsNode node, Mailbox mbox, SortBy sort, int offset, int limit, SearchResult.ExtraData extra) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        if (!Db.supports(Db.Capability.AVOID_OR_IN_WHERE_CLAUSE) || sort.getCriterion() != SortBy.SortCriterion.DATE && sort.getCriterion() != SortBy.SortCriterion.SIZE || DbSearchConstraintsNode.NodeType.OR != node.getNodeType()) {
            return DbSearch.searchInternal(result, conn, node, mbox, sort, offset, limit, extra);
        }
        ArrayList resultLists = new ArrayList();
        for (DbSearchConstraintsNode dbSearchConstraintsNode : node.getSubNodes()) {
            ArrayList<SearchResult> subNodeResults = new ArrayList<SearchResult>();
            DbSearch.search(subNodeResults, conn, dbSearchConstraintsNode, mbox, sort, offset, limit, extra);
            resultLists.add(subNodeResults);
        }
        Comparator<SearchResult> comp = SearchResult.getComparator(sort);
        result = DbSearch.mergeSortedLists(result, resultLists, comp);
        return result;
    }

    public static List<SearchResult> searchInternal(List<SearchResult> result, DbPool.Connection conn, DbSearchConstraintsNode node, Mailbox mbox, SortBy sort, int offset, int limit, SearchResult.ExtraData extra) throws ServiceException {
        List<SearchResult> list;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        boolean hasValidLIMIT = offset >= 0 && limit >= 0;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuilder statement = new StringBuilder();
        int numParams = 0;
        boolean hasMailItemOnlyConstraints = true;
        boolean hasAppointmentTableConstraints = DbSearch.hasAppointmentTableConstraints(node);
        if (hasAppointmentTableConstraints) {
            hasMailItemOnlyConstraints = DbSearch.hasMailItemOnlyConstraints(node);
        }
        boolean requiresUnion = hasMailItemOnlyConstraints && hasAppointmentTableConstraints;
        try {
            if (hasMailItemOnlyConstraints) {
                if (requiresUnion) {
                    statement.append("(");
                }
                statement.append(DbSearch.encodeSelect(mbox, sort, extra, false, node, hasValidLIMIT));
                numParams += DbSearch.encodeConstraint(mbox, node, (byte[])(hasAppointmentTableConstraints ? APPOINTMENT_TABLE_TYPES : null), false, statement, conn);
                if (requiresUnion) {
                    statement.append(DbSearch.sortQuery(sort, true));
                    if (hasValidLIMIT && Db.supports(Db.Capability.LIMIT_CLAUSE)) {
                        statement.append(" LIMIT ").append(offset).append(',').append(limit);
                    }
                }
            }
            if (requiresUnion) {
                statement.append(" ) UNION ALL (");
            }
            if (hasAppointmentTableConstraints) {
                statement.append(DbSearch.encodeSelect(mbox, sort, extra, true, node, hasValidLIMIT));
                numParams += DbSearch.encodeConstraint(mbox, node, APPOINTMENT_TABLE_TYPES, true, statement, conn);
                if (requiresUnion) {
                    statement.append(DbSearch.sortQuery(sort, true));
                    if (hasValidLIMIT && Db.supports(Db.Capability.LIMIT_CLAUSE)) {
                        statement.append(" LIMIT ").append(offset).append(',').append(limit);
                    }
                    if (requiresUnion) {
                        statement.append(")");
                    }
                }
            }
            statement.append(DbSearch.sortQuery(sort, true));
            if (hasValidLIMIT && Db.supports(Db.Capability.LIMIT_CLAUSE)) {
                statement.append(" LIMIT ").append(offset).append(',').append(limit);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug("SQL: (" + numParams + " parameters): " + statement.toString());
            }
            stmt = conn.prepareStatement(statement.toString());
            int param = 1;
            if (hasMailItemOnlyConstraints) {
                param = DbSearch.setSearchVars(stmt, node, param, (byte[])(hasAppointmentTableConstraints ? APPOINTMENT_TABLE_TYPES : null), false);
            }
            if (hasAppointmentTableConstraints) {
                param = DbSearch.setSearchVars(stmt, node, param, APPOINTMENT_TABLE_TYPES, true);
            }
            if (hasValidLIMIT && !Db.supports(Db.Capability.LIMIT_CLAUSE)) {
                stmt.setMaxRows(offset + limit + 1);
            }
            assert (param == numParams + 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (hasValidLIMIT && !Db.supports(Db.Capability.LIMIT_CLAUSE)) {
                    if (offset-- > 0) continue;
                    if (limit-- <= 0) break;
                }
                result.add(SearchResult.createResult(rs, sort, extra));
            }
            list = result;
            Object var19_19 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching search metadata", e);
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return list;
    }

    private static final int setBytes(PreparedStatement stmt, int param, byte[] c) throws SQLException {
        if (c != null && c.length > 0) {
            for (byte b : c) {
                stmt.setByte(param++, b);
            }
        }
        return param;
    }

    private static final int setBytes(PreparedStatement stmt, int param, Collection<Byte> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (byte b : c) {
                stmt.setByte(param++, b);
            }
        }
        return param;
    }

    private static final int setIntegers(PreparedStatement stmt, int param, Collection<Integer> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (int i : c) {
                stmt.setInt(param++, i);
            }
        }
        return param;
    }

    private static final int setStrings(PreparedStatement stmt, int param, Collection<String> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (String s : c) {
                stmt.setString(param++, s);
            }
        }
        return param;
    }

    private static final int setDateRange(PreparedStatement stmt, int param, Collection<DbSearchConstraints.NumericRange> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (DbSearchConstraints.NumericRange date : c) {
                if (date.lowest >= 1L) {
                    stmt.setInt(param++, (int)Math.min(date.lowest / 1000L, Integer.MAX_VALUE));
                }
                if (date.highest < 1L) continue;
                stmt.setInt(param++, (int)Math.min(date.highest / 1000L, Integer.MAX_VALUE));
            }
        }
        return param;
    }

    private static final int setTimestampRange(PreparedStatement stmt, int param, Collection<DbSearchConstraints.NumericRange> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (DbSearchConstraints.NumericRange date : c) {
                if (date.lowest >= 1L) {
                    stmt.setTimestamp(param++, new Timestamp(date.lowest));
                }
                if (date.highest < 1L) continue;
                stmt.setTimestamp(param++, new Timestamp(date.highest));
            }
        }
        return param;
    }

    private static final int setLongRangeWithMinimum(PreparedStatement stmt, int param, Collection<DbSearchConstraints.NumericRange> c, int minimum) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (DbSearchConstraints.NumericRange r : c) {
                if (r.lowest >= (long)minimum) {
                    stmt.setLong(param++, r.lowest);
                }
                if (r.highest < (long)minimum) continue;
                stmt.setLong(param++, r.highest);
            }
        }
        return param;
    }

    private static final int setIntRangeWithMinimum(PreparedStatement stmt, int param, Collection<DbSearchConstraints.NumericRange> c, int minimum) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (DbSearchConstraints.NumericRange r : c) {
                if (r.lowest >= (long)minimum) {
                    stmt.setInt(param++, (int)r.lowest);
                }
                if (r.highest < (long)minimum) continue;
                stmt.setInt(param++, (int)r.highest);
            }
        }
        return param;
    }

    private static final int setStringRange(PreparedStatement stmt, int param, Collection<DbSearchConstraints.StringRange> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (DbSearchConstraints.StringRange r : c) {
                if (r.lowest != null) {
                    stmt.setString(param++, r.lowest.replace("\\\"", "\""));
                }
                if (r.highest == null) continue;
                stmt.setString(param++, r.highest.replace("\\\"", "\""));
            }
        }
        return param;
    }

    private static final int setLongs(PreparedStatement stmt, int param, Collection<Long> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (long l : c) {
                stmt.setLong(param++, l);
            }
        }
        return param;
    }

    private static final int setFolders(PreparedStatement stmt, int param, Collection<Folder> c) throws SQLException {
        if (!ListUtil.isEmpty(c)) {
            for (Folder f : c) {
                stmt.setInt(param++, f.getId());
            }
        }
        return param;
    }

    private static final int setBooleanAsInt(PreparedStatement stmt, int param, Boolean b) throws SQLException {
        if (b != null) {
            stmt.setInt(param++, b != false ? 1 : 0);
        }
        return param;
    }

    private static final int encode(StringBuilder statement, String column, boolean truthiness) {
        statement.append(" AND ").append(column).append(truthiness ? " = ?" : " != ?");
        return 1;
    }

    private static final int encode(StringBuilder statement, String column, boolean truthiness, Object o) {
        if (o != null) {
            statement.append(" AND ").append(column).append(truthiness ? " = ?" : " != ?");
            return 1;
        }
        return 0;
    }

    private static final int encode(StringBuilder statement, String column, boolean truthiness, Collection<?> c) {
        if (!ListUtil.isEmpty(c)) {
            statement.append(" AND ").append(DbUtil.whereIn(column, truthiness, c.size()));
            return c.size();
        }
        return 0;
    }

    private static final int encode(StringBuilder statement, String column, boolean truthiness, byte[] c) {
        if (c != null && c.length > 0) {
            statement.append(" AND ").append(DbUtil.whereIn(column, truthiness, c.length));
            return c.length;
        }
        return 0;
    }

    private static final int encodeRangeWithMinimum(StringBuilder statement, String column, Collection<? extends DbSearchConstraints.NumericRange> ranges, long lowestValue) {
        if (ListUtil.isEmpty(ranges)) {
            return 0;
        }
        if (Db.supports(Db.Capability.CASE_SENSITIVE_COMPARISON) && DbSearch.isCaseSensitiveField(column)) {
            column = "UPPER(" + column + ")";
        }
        int params = 0;
        for (DbSearchConstraints.NumericRange numericRange : ranges) {
            boolean highValid;
            boolean lowValid = numericRange.lowest >= lowestValue;
            boolean bl = highValid = numericRange.highest >= lowestValue;
            if (!lowValid && !highValid) continue;
            statement.append(numericRange.negated ? " AND NOT (" : " AND (");
            if (lowValid) {
                if (numericRange.lowestEqual) {
                    statement.append(" " + column + " >= ?");
                } else {
                    statement.append(" " + column + " > ?");
                }
                ++params;
            }
            if (highValid) {
                if (lowValid) {
                    statement.append(" AND");
                }
                if (numericRange.highestEqual) {
                    statement.append(" " + column + " <= ?");
                } else {
                    statement.append(" " + column + " < ?");
                }
                ++params;
            }
            statement.append(')');
        }
        return params;
    }

    private static final int encodeRange(StringBuilder statement, String column, Collection<? extends DbSearchConstraints.StringRange> ranges) {
        int retVal = 0;
        if (Db.supports(Db.Capability.CASE_SENSITIVE_COMPARISON) && DbSearch.isCaseSensitiveField(column)) {
            column = "UPPER(" + column + ")";
        }
        if (!ListUtil.isEmpty(ranges)) {
            for (DbSearchConstraints.StringRange stringRange : ranges) {
                statement.append(stringRange.negated ? " AND NOT (" : " AND (");
                if (stringRange.lowest != null) {
                    ++retVal;
                    if (stringRange.lowestEqual) {
                        statement.append(" " + column + " >= ?");
                    } else {
                        statement.append(" " + column + " > ?");
                    }
                }
                if (stringRange.highest != null) {
                    if (stringRange.lowest != null) {
                        statement.append(" AND");
                    }
                    ++retVal;
                    if (stringRange.highestEqual) {
                        statement.append(" " + column + " <= ?");
                    } else {
                        statement.append(" " + column + " < ?");
                    }
                }
                statement.append(')');
            }
        }
        return retVal;
    }

    private static int setSearchVars(PreparedStatement stmt, DbSearchConstraintsNode node, int param, byte[] calTypes, boolean inCalTable) throws SQLException {
        DbSearchConstraintsNode.NodeType ntype = node.getNodeType();
        if (ntype == DbSearchConstraintsNode.NodeType.AND || ntype == DbSearchConstraintsNode.NodeType.OR) {
            for (DbSearchConstraintsNode dbSearchConstraintsNode : node.getSubNodes()) {
                param = DbSearch.setSearchVars(stmt, dbSearchConstraintsNode, param, calTypes, inCalTable);
            }
            return param;
        }
        DbSearchConstraints c = node.getSearchConstraints();
        assert (ntype == DbSearchConstraintsNode.NodeType.LEAF && c != null);
        if (c.automaticEmptySet() || c.tagConstraints.noMatches) {
            return param;
        }
        param = DbSearch.setBytes(stmt, param, c.types);
        param = DbSearch.setBytes(stmt, param, c.excludeTypes);
        param = DbSearch.setBytes(stmt, param, calTypes);
        param = DbSearch.setLongs(stmt, param, c.tagConstraints.searchTagsets);
        param = DbSearch.setLongs(stmt, param, c.tagConstraints.searchFlagsets);
        param = DbSearch.setBooleanAsInt(stmt, param, c.tagConstraints.unread);
        param = DbSearch.setFolders(stmt, param, c.folders);
        param = DbSearch.setFolders(stmt, param, c.excludeFolders);
        if (c.convId > 0) {
            stmt.setInt(param++, c.convId);
        } else {
            param = DbSearch.setIntegers(stmt, param, c.prohibitedConvIds);
        }
        param = DbSearch.setIntegers(stmt, param, c.itemIds);
        param = DbSearch.setIntegers(stmt, param, c.prohibitedItemIds);
        param = DbSearch.setStrings(stmt, param, c.indexIds);
        param = DbSearch.setDateRange(stmt, param, c.dates);
        param = DbSearch.setLongRangeWithMinimum(stmt, param, c.modified, 1);
        param = DbSearch.setLongRangeWithMinimum(stmt, param, c.modifiedContent, 1);
        param = DbSearch.setIntRangeWithMinimum(stmt, param, c.sizes, 0);
        param = DbSearch.setStringRange(stmt, param, c.subjectRanges);
        param = DbSearch.setStringRange(stmt, param, c.senderRanges);
        if (inCalTable) {
            param = DbSearch.setTimestampRange(stmt, param, c.calStartDates);
            param = DbSearch.setTimestampRange(stmt, param, c.calEndDates);
        }
        return param;
    }

    public static void main(String[] args) throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(1L);
        DbSearchConstraints hasTags = new DbSearchConstraints();
        hasTags.hasTags = true;
        DbSearchConstraints inTrash = new DbSearchConstraints();
        HashSet<Folder> folders = new HashSet<Folder>();
        folders.add(mbox.getFolderById(null, 3));
        inTrash.folders = folders;
        DbSearchConstraints isUnread = new DbSearchConstraints();
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(mbox.getFlagById(-10));
        isUnread.tags = tags;
        DbSearchConstraintsInnerNode orClause = DbSearchConstraintsInnerNode.OR();
        orClause.addSubNode(hasTags);
        DbSearchConstraintsInnerNode andClause = DbSearchConstraintsInnerNode.AND();
        andClause.addSubNode(inTrash);
        andClause.addSubNode(isUnread);
        orClause.addSubNode(andClause);
    }

    static class TagConstraints {
        Set<Long> searchTagsets;
        Set<Long> searchFlagsets;
        Boolean unread;
        boolean noMatches;

        TagConstraints() {
        }

        static TagConstraints getTagContraints(Mailbox mbox, DbSearchConstraints c, DbPool.Connection conn) throws ServiceException {
            TagConstraints tc = c.tagConstraints = new TagConstraints();
            if (ListUtil.isEmpty(c.tags) && ListUtil.isEmpty(c.excludeTags)) {
                return tc;
            }
            int setFlagMask = 0;
            long setTagMask = 0L;
            if (!ListUtil.isEmpty(c.tags)) {
                for (Tag curTag : c.tags) {
                    if (curTag.getId() == -10) {
                        tc.unread = Boolean.TRUE;
                        continue;
                    }
                    if (curTag instanceof Flag) {
                        setFlagMask = (int)((long)setFlagMask | curTag.getBitmask());
                        continue;
                    }
                    setTagMask |= curTag.getBitmask();
                }
            }
            int flagMask = setFlagMask;
            long tagMask = setTagMask;
            if (!ListUtil.isEmpty(c.excludeTags)) {
                for (Tag t : c.excludeTags) {
                    if (t.getId() == -10) {
                        tc.unread = Boolean.FALSE;
                        continue;
                    }
                    if (t instanceof Flag) {
                        flagMask = (int)((long)flagMask | t.getBitmask());
                        continue;
                    }
                    tagMask |= t.getBitmask();
                }
            }
            TagsetCache tcFlags = DbMailItem.getFlagsetCache(conn, mbox);
            TagsetCache tcTags = DbMailItem.getTagsetCache(conn, mbox);
            if (setTagMask != 0L || tagMask != 0L) {
                tc.searchTagsets = tcTags.getMatchingTagsets(tagMask, setTagMask);
                if (tc.searchTagsets != null && tc.searchTagsets.isEmpty()) {
                    tc.noMatches = true;
                    tc.searchTagsets = null;
                }
            }
            if (setFlagMask != 0 || flagMask != 0) {
                tc.searchFlagsets = tcFlags.getMatchingTagsets(flagMask, setFlagMask);
                if (tc.searchFlagsets != null && tc.searchFlagsets.isEmpty()) {
                    tc.noMatches = true;
                    tc.searchFlagsets = null;
                }
            }
            return tc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SearchResult {
        public int id;
        public String indexId;
        public byte type;
        public Object sortkey;
        public Object extraData;

        public static SearchResult createResult(ResultSet rs, SortBy sort) throws SQLException {
            return SearchResult.createResult(rs, sort, ExtraData.NONE);
        }

        public static SearchResult createResult(ResultSet rs, SortBy sort, ExtraData extra) throws SQLException {
            int offset;
            SearchResult result = new SearchResult();
            result.id = rs.getInt(1);
            result.indexId = rs.getString(2);
            result.type = rs.getByte(3);
            switch (sort.getCriterion()) {
                case SUBJECT: 
                case SENDER: 
                case NAME: 
                case NAME_NATURAL_ORDER: {
                    result.sortkey = rs.getString(4);
                    break;
                }
                case SIZE: {
                    result.sortkey = new Long(rs.getInt(4));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    result.sortkey = new Long((long)rs.getInt(4) * 1000L);
                }
            }
            int n = offset = sort.getCriterion() == SortBy.SortCriterion.NONE ? 3 : 4;
            if (extra == ExtraData.MAIL_ITEM) {
                result.extraData = DbMailItem.constructItem(rs, offset);
            } else if (extra == ExtraData.IMAP_MSG) {
                int flags = rs.getBoolean(offset + 2) ? Flag.BITMASK_UNREAD | rs.getInt(offset + 3) : rs.getInt(offset + 3);
                result.extraData = new ImapMessage(result.id, result.type, rs.getInt(offset + 1), flags, rs.getLong(offset + 4));
            } else if (extra == ExtraData.MODSEQ || extra == ExtraData.PARENT || extra == ExtraData.MODCONTENT) {
                int value = rs.getInt(offset + 1);
                result.extraData = rs.wasNull() ? -1 : value;
            }
            return result;
        }

        public String toString() {
            return this.sortkey + " => (" + this.id + "," + this.type + ")";
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            SearchResult other = (SearchResult)obj;
            return other.id == this.id;
        }

        public static Comparator<SearchResult> getComparator(SortBy sort) {
            return new SearchResultComparator(sort);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class SearchResultComparator
        implements Comparator<SearchResult> {
            private SortBy mSort;

            SearchResultComparator(SortBy sort) {
                this.mSort = sort;
            }

            @Override
            public int compare(SearchResult o1, SearchResult o2) {
                switch (this.mSort.getCriterion()) {
                    case SIZE: 
                    case DATE: {
                        long date1 = (Long)o1.sortkey;
                        long date2 = (Long)o2.sortkey;
                        if (date1 == date2) break;
                        long diff = this.mSort.getDirection() == SortBy.SortDirection.DESCENDING ? date2 - date1 : date1 - date2;
                        return diff > 0L ? 1 : -1;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("SearchResultComparator not implemented  for anything except for DATE and SIZE right now.  Feel free to fix it!");
                    }
                }
                if (this.mSort.getDirection() == SortBy.SortDirection.DESCENDING) {
                    return o2.id - o1.id;
                }
                return o1.id - o2.id;
            }
        }

        public static class SizeEstimate {
            public int mSizeEstimate;

            public SizeEstimate() {
            }

            public SizeEstimate(int initialval) {
                this.mSizeEstimate = initialval;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ExtraData {
            NONE,
            MAIL_ITEM,
            IMAP_MSG,
            MODSEQ,
            PARENT,
            MODCONTENT;

        }
    }
}

