/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.ScheduledTask;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbScheduledTask {
    public static String TABLE_SCHEDULED_TASK = "scheduled_task";

    public static void createTask(DbPool.Connection conn, ScheduledTask task) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        ZimbraLog.scheduler.debug("Creating %s", task);
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("INSERT INTO " + TABLE_SCHEDULED_TASK + " (class_name, name, mailbox_id, exec_time, interval_millis, metadata) " + "VALUES (?, ?, ?, ?, ?, ?)");
                stmt.setString(1, task.getClass().getName());
                stmt.setString(2, task.getName());
                stmt.setLong(3, task.getMailboxId());
                stmt.setTimestamp(4, DbUtil.dateToTimestamp(task.getExecTime()));
                if (task.getIntervalMillis() > 0L) {
                    stmt.setLong(5, task.getIntervalMillis());
                } else {
                    stmt.setNull(5, 4);
                }
                stmt.setString(6, DbScheduledTask.getEncodedMetadata(task));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to create " + task, e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ScheduledTask> getTasks(String className, long mailboxId) throws ServiceException {
        ZimbraLog.scheduler.debug("Retrieving tasks for class %s, mailbox %d", className, mailboxId);
        ArrayList<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DbPool.getConnection();
                    String sql = "SELECT class_name, name, mailbox_id, exec_time, interval_millis, metadata FROM " + TABLE_SCHEDULED_TASK;
                    if (className != null) {
                        sql = sql + " WHERE class_name = ?";
                    }
                    if (mailboxId > 0L) {
                        sql = className == null ? sql + " WHERE mailbox_id = ?" : sql + " AND mailbox_id = ?";
                    }
                    stmt = conn.prepareStatement(sql);
                    int i = 1;
                    if (className != null) {
                        stmt.setString(i++, className);
                    }
                    if (mailboxId > 0L) {
                        stmt.setLong(i++, mailboxId);
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        ScheduledTask task;
                        block17: {
                            className = rs.getString("class_name");
                            String name = rs.getString("name");
                            task = null;
                            try {
                                Object obj = Class.forName(className).newInstance();
                                if (obj instanceof ScheduledTask) {
                                    task = (ScheduledTask)obj;
                                    break block17;
                                }
                                ZimbraLog.scheduler.warn("Class %s is not an instance of ScheduledTask for task %s", className, name);
                            }
                            catch (Exception e) {
                                ZimbraLog.scheduler.warn("Unable to instantiate class %s for task %s.  Class must be an instance of %s and have a constructor with no arguments.", (Object)className, (Object)name, (Object)ScheduledTask.class.getSimpleName(), e);
                            }
                            continue;
                        }
                        task.setMailboxId(rs.getLong("mailbox_id"));
                        task.setExecTime(DbUtil.timestampToDate(rs.getTimestamp("exec_time")));
                        task.setIntervalMillis(rs.getLong("interval_millis"));
                        try {
                            DbScheduledTask.setProperties(task, rs.getString("metadata"));
                        }
                        catch (ServiceException e) {
                            ZimbraLog.scheduler.warn("Unable to read metadata for %s.  Not scheduling this task.", (Object)task, e);
                            continue;
                        }
                        tasks.add(task);
                    }
                    Object var14_15 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("Unable to get all DataSourceTasks", e);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
        }
        ZimbraLog.scheduler.info("Loaded %d scheduled data source tasks", tasks.size());
        return tasks;
    }

    public static void updateTask(DbPool.Connection conn, ScheduledTask task) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        ZimbraLog.scheduler.debug("Updating %s", task);
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE  " + TABLE_SCHEDULED_TASK + " SET mailbox_id = ?, exec_time = ?, interval_millis = ?, metadata = ? " + "WHERE class_name = ? AND name = ?");
                stmt.setLong(1, task.getMailboxId());
                stmt.setTimestamp(2, DbUtil.dateToTimestamp(task.getExecTime()));
                if (task.getIntervalMillis() > 0L) {
                    stmt.setLong(3, task.getIntervalMillis());
                } else {
                    stmt.setNull(3, 4);
                }
                stmt.setString(4, DbScheduledTask.getEncodedMetadata(task));
                stmt.setString(5, task.getClass().getName());
                stmt.setString(6, task.getName());
                int numRows = stmt.executeUpdate();
                if (numRows != 1) {
                    String msg = String.format("Unexpected number of rows (%d) updated for %s", numRows, task);
                    throw ServiceException.FAILURE(msg, null);
                }
                Object var6_6 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to update " + task, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTask(String className, String taskName) throws ServiceException {
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                DbScheduledTask.deleteTask(conn, className, taskName);
                conn.commit();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
    }

    public static void deleteTask(DbPool.Connection conn, String className, String taskName) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        ZimbraLog.scheduler.debug("Deleting scheduled task from the database.  className=%s, taskName=%s", className, taskName);
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM " + TABLE_SCHEDULED_TASK + " WHERE class_name = ? AND name = ?");
                stmt.setString(1, className);
                stmt.setString(2, taskName);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to delete scheduled task: className=" + className + ", taskName=" + taskName, e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    private static String getEncodedMetadata(ScheduledTask task) {
        boolean hasProperties = false;
        Metadata metadata = new Metadata();
        for (String key : task.getPropertyNames()) {
            hasProperties = true;
            metadata.put(key, task.getProperty(key));
        }
        if (!hasProperties) {
            return null;
        }
        return metadata.toString();
    }

    private static void setProperties(ScheduledTask task, String encodedMetadata) throws ServiceException {
        if (StringUtil.isNullOrEmpty(encodedMetadata)) {
            return;
        }
        Metadata metadata = new Metadata(encodedMetadata);
        Map map = metadata.asMap();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            task.setProperty((String)key, (String)value);
        }
    }
}

