/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbResults {
    private List<Object[]> mData = new ArrayList<Object[]>();
    private Map<String, Integer> mColumnIndexes = new HashMap<String, Integer>();
    private int mRowNum = 0;

    public DbResults(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet cannot be null");
        }
        boolean isFirst = true;
        int numCols = 0;
        while (resultSet.next()) {
            int i;
            if (isFirst) {
                ResultSetMetaData md = resultSet.getMetaData();
                numCols = md.getColumnCount();
                for (i = 1; i <= numCols; ++i) {
                    this.mColumnIndexes.put(md.getColumnName(i), new Integer(i));
                }
                isFirst = false;
            }
            Object[] row = new Object[numCols];
            for (i = 0; i < numCols; ++i) {
                row[i] = resultSet.getObject(i + 1);
            }
            this.mData.add(row);
        }
        resultSet.close();
    }

    public int size() {
        return this.mData.size();
    }

    public boolean next() {
        if (this.mRowNum == this.mData.size()) {
            return false;
        }
        ++this.mRowNum;
        return true;
    }

    public Object[] getRow(int row) {
        return this.mData.get(row - 1);
    }

    public boolean isNull(int row, int col) {
        Object[] rowData = this.getRow(row);
        return rowData[col - 1] == null;
    }

    public boolean isNull(int col) {
        return this.isNull(this.getRowNum(), col);
    }

    public boolean isNull(int row, String colName) {
        return this.isNull(row, this.getIndex(colName));
    }

    public boolean isNull(String colName) {
        return this.isNull(this.getRowNum(), colName);
    }

    public Object getObject(int row, int col) {
        Object[] rowData = this.getRow(row);
        return rowData[col - 1];
    }

    public Object getObject(int col) {
        return this.getObject(this.getRowNum(), col);
    }

    public Object getObject(int row, String colName) {
        return this.getObject(row, this.getIndex(colName));
    }

    public Object getObject(String colName) {
        return this.getObject(this.getRowNum(), this.getIndex(colName));
    }

    public String getString(int row, int col) {
        return (String)this.getObject(row, col);
    }

    public String getString(int col) {
        return this.getString(this.getRowNum(), col);
    }

    public String getString(int row, String colName) {
        return this.getString(row, this.getIndex(colName));
    }

    public String getString(String colName) {
        return this.getString(this.getRowNum(), colName);
    }

    public int getInt(int row, int col) {
        Number i = (Number)this.getObject(row, col);
        if (i == null) {
            throw new IllegalStateException("null value at (" + row + ", " + col + ")");
        }
        return i.intValue();
    }

    public int getInt(int col) {
        return this.getInt(this.getRowNum(), col);
    }

    public int getInt(int row, String colName) {
        return this.getInt(row, this.getIndex(colName));
    }

    public int getInt(String colName) {
        return this.getInt(this.getRowNum(), colName);
    }

    public boolean getBoolean(int row, int col) {
        Object o = this.getObject(row, col);
        if (o == null) {
            throw new IllegalStateException("null value at (" + row + ", " + col + ")");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        int i = ((Number)o).intValue();
        return i != 0;
    }

    public boolean getBoolean(int col) {
        return this.getBoolean(this.getRowNum(), col);
    }

    public boolean getBoolean(int row, String colName) {
        return this.getBoolean(row, this.getIndex(colName));
    }

    public boolean getBoolean(String colName) {
        return this.getBoolean(this.getRowNum(), colName);
    }

    private int getIndex(String colName) {
        Integer i = this.mColumnIndexes.get(colName);
        if (i == null) {
            throw new IllegalArgumentException("Column '" + colName + "' does not exist");
        }
        return i;
    }

    private int getRowNum() {
        if (this.mRowNum < 1) {
            this.mRowNum = 1;
        }
        return this.mRowNum;
    }
}

