/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ListUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Mailbox;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbPop3Message {
    public static final String TABLE_POP3_MESSAGE = "pop3_message";

    public static void storeUid(Mailbox mbox, String dataSourceId, String uid, int itemId) throws ServiceException {
        if (StringUtil.isNullOrEmpty(uid)) {
            return;
        }
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("INSERT INTO " + DbPop3Message.getTableName(mbox) + " (" + DbMailItem.MAILBOX_ID + "data_source_id, uid, item_id) " + "VALUES (" + DbMailItem.MAILBOX_ID_VALUE + "?, ?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, dataSourceId);
                stmt.setString(pos++, uid);
                stmt.setInt(pos++, itemId);
                stmt.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to store UID", e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
    }

    public static void deleteUids(Mailbox mbox, String dataSourceId) throws ServiceException {
        ZimbraLog.mailbox.debug("Deleting UID's for %s", dataSourceId);
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("DELETE FROM " + DbPop3Message.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "data_source_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, dataSourceId);
                int numRows = stmt.executeUpdate();
                conn.commit();
                ZimbraLog.mailbox.debug("Deleted %d UID's", numRows);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to delete UID's", e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
    }

    public static Map<Integer, String> getMappings(Mailbox mbox, String dataSourceId) throws ServiceException {
        HashMap<Integer, String> mappings = new HashMap<Integer, String>();
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ZimbraLog.mailbox.debug("get all POP mappings for %s", dataSourceId);
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("SELECT item_id, uid FROM " + DbPop3Message.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + " data_source_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, dataSourceId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    mappings.put(rs.getInt(1), rs.getString(2));
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to get UID's", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
        ZimbraLog.mailbox.debug("Found %d POP mappings for %s", mappings.size(), dataSourceId);
        return mappings;
    }

    public static Set<String> getMatchingUids(Mailbox mbox, DataSource ds, Collection<String> uids) throws ServiceException {
        ZimbraLog.mailbox.debug("%s: looking for uids that match a set of size %d", ds, uids.size());
        List<List<String>> splitIds = ListUtil.split(uids, Db.getINClauseBatchSize());
        HashSet<String> matchingUids = new HashSet<String>();
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                for (List<String> curIds : splitIds) {
                    stmt = conn.prepareStatement("SELECT uid FROM " + DbPop3Message.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "data_source_id = ?" + " AND " + DbUtil.whereIn("uid", curIds.size()));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setString(pos++, ds.getId());
                    for (String uid : curIds) {
                        stmt.setString(pos++, uid);
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        matchingUids.add(rs.getString(1));
                    }
                    rs.close();
                    rs = null;
                    stmt.close();
                    stmt = null;
                }
                Object var14_14 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to get UID's", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
        ZimbraLog.mailbox.debug("Found %d matching UID's", matchingUids.size());
        return matchingUids;
    }

    public static String getTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_POP3_MESSAGE);
    }

    public static String getTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_POP3_MESSAGE);
    }
}

