/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SystemUtil;
import com.zimbra.common.util.ValueCounter;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbStats;
import com.zimbra.cs.db.DebugConnection;
import com.zimbra.cs.db.DebugPreparedStatement;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.stats.ZimbraPerf;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DbPool {
    private static PoolingDataSource sPoolingDataSource;
    private static String sRootUrl;
    private static String sLoggerRootUrl;
    private static GenericObjectPool sConnectionPool;
    private static boolean sIsInitialized;
    private static boolean isShutdown;
    static ValueCounter<String> sConnectionStackCounter;

    public static synchronized void startup() {
        if (DbPool.isInitialized()) {
            return;
        }
        PoolConfig pconfig = Db.getInstance().getPoolConfig();
        String drivers = System.getProperty("jdbc.drivers");
        if (drivers == null) {
            System.setProperty("jdbc.drivers", pconfig.mDriverClassName);
        }
        sRootUrl = pconfig.mRootUrl;
        sLoggerRootUrl = pconfig.mLoggerUrl;
        sIsInitialized = true;
        DbPool.waitForDatabase();
    }

    private static void waitForDatabase() {
        Connection conn = null;
        int RETRY_SECONDS = 5;
        while (conn == null) {
            try {
                conn = DbPool.getConnection();
            }
            catch (ServiceException e) {
                ZimbraLog.misc.warn("Could not establish a connection to the database.  Retrying in %d seconds.", (Object)5, e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        DbPool.quietClose(conn);
    }

    private static boolean isInitialized() {
        return sIsInitialized;
    }

    public static void loadSettings() {
        try {
            long slowThreshold = Provisioning.getInstance().getLocalServer().getDatabaseSlowSqlThreshold();
            DebugPreparedStatement.setSlowSqlThreshold(slowThreshold);
        }
        catch (ServiceException e) {
            ZimbraLog.system.warn((Object)"Unable to set slow SQL threshold.", e);
        }
    }

    private static synchronized PoolingDataSource getPool() {
        if (isShutdown) {
            throw new RuntimeException("DbPool permanently shutdown");
        }
        if (sPoolingDataSource != null) {
            return sPoolingDataSource;
        }
        PoolConfig pconfig = Db.getInstance().getPoolConfig();
        sConnectionPool = new GenericObjectPool(null, pconfig.mPoolSize, 1, -1L, pconfig.mPoolSize);
        ZimbraConnectionFactory cfac = new ZimbraConnectionFactory(pconfig.mConnectionUrl, pconfig.mDatabaseProperties);
        boolean defAutoCommit = false;
        boolean defReadOnly = false;
        new PoolableConnectionFactory((ConnectionFactory)cfac, (ObjectPool)sConnectionPool, null, null, defReadOnly, defAutoCommit);
        try {
            Class.forName(pconfig.mDriverClassName).newInstance();
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (Exception e) {
            ZimbraLog.system.fatal((Object)"can't instantiate DB driver/pool class", e);
            System.exit(1);
        }
        try {
            PoolingDataSource pds = new PoolingDataSource((ObjectPool)sConnectionPool);
            pds.setAccessToUnderlyingConnectionAllowed(true);
            Db.getInstance().startup(pds, pconfig.mPoolSize);
            sPoolingDataSource = pds;
        }
        catch (SQLException e) {
            ZimbraLog.system.fatal((Object)"can't initialize connection pool", e);
            System.exit(1);
        }
        if (pconfig.mSupportsStatsCallback) {
            ZimbraPerf.addStatsCallback(new DbStats());
        }
        return sPoolingDataSource;
    }

    public static Connection getConnection() throws ServiceException {
        return DbPool.getConnection(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(Mailbox mbox) throws ServiceException {
        if (!DbPool.isInitialized()) {
            throw ServiceException.FAILURE("Database connection pool not initialized.", null);
        }
        long start = ZimbraPerf.STOPWATCH_DB_CONN.start();
        PoolingDataSource pool = DbPool.getPool();
        DbPool.checkPoolUsage();
        java.sql.Connection dbconn = null;
        Connection conn = null;
        try {
            dbconn = pool.getConnection();
            if (dbconn.getAutoCommit()) {
                dbconn.setAutoCommit(false);
            }
            if (Db.supports(Db.Capability.READ_COMMITTED_ISOLATION)) {
                dbconn.setTransactionIsolation(2);
            }
            conn = new Connection(dbconn);
            Db.getInstance().postOpen(conn);
        }
        catch (SQLException e) {
            try {
                if (dbconn != null && !dbconn.isClosed()) {
                    dbconn.close();
                }
            }
            catch (SQLException e2) {
                ZimbraLog.sqltrace.warn((Object)"DB connection close caught exception", e);
            }
            throw ServiceException.FAILURE("getting database connection", e);
        }
        if (ZimbraLog.dbconn.isDebugEnabled()) {
            Throwable t = new Throwable();
            conn.setStackTrace(t);
            String stackTrace = SystemUtil.getStackTrace(t);
            ValueCounter<String> valueCounter = sConnectionStackCounter;
            synchronized (valueCounter) {
                sConnectionStackCounter.increment(stackTrace);
            }
        }
        if (mbox != null) {
            Db.registerDatabaseInterest(conn, mbox);
        }
        ZimbraPerf.STOPWATCH_DB_CONN.stop(start);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPoolUsage() {
        int maxActive;
        int numActive = sConnectionPool.getNumActive();
        if ((double)numActive <= (double)(maxActive = sConnectionPool.getMaxActive()) * 0.75) {
            return;
        }
        String stackTraceMsg = "Turn on debug logging for zimbra.dbconn to see stack traces of connections not returned to the pool.";
        if (ZimbraLog.dbconn.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            ValueCounter<String> valueCounter = sConnectionStackCounter;
            synchronized (valueCounter) {
                Iterator<String> i = sConnectionStackCounter.iterator();
                while (i.hasNext()) {
                    String stackTrace = i.next();
                    int count = sConnectionStackCounter.getCount(stackTrace);
                    if (count == 0) {
                        i.remove();
                        continue;
                    }
                    buf.append(count + " connections allocated at " + stackTrace + "\n");
                }
            }
            stackTraceMsg = buf.toString();
        }
        ZimbraLog.dbconn.warn("Connection pool is 75%% utilized (%d connections out of a maximum of %d in use).  %s", numActive, maxActive, stackTraceMsg);
    }

    public static Connection getMaintenanceConnection() throws ServiceException {
        try {
            String user = LC.zimbra_mysql_user.value();
            String pwd = LC.zimbra_mysql_password.value();
            java.sql.Connection conn = DriverManager.getConnection(sRootUrl + "?user=" + user + "&password=" + pwd);
            conn.setAutoCommit(false);
            return new Connection(conn);
        }
        catch (SQLException e) {
            throw ServiceException.FAILURE("getting database maintenance connection", e);
        }
    }

    public static Connection getLoggerConnection() throws ServiceException {
        try {
            String user = LC.zimbra_mysql_user.value();
            String pwd = LC.zimbra_logger_mysql_password.value();
            java.sql.Connection conn = DriverManager.getConnection(sLoggerRootUrl + "?user=" + user + "&password=" + pwd);
            return new Connection(conn);
        }
        catch (SQLException e) {
            throw ServiceException.FAILURE("getting database logger connection", e);
        }
    }

    public static void quietClose(Connection conn) {
        if (conn != null) {
            try {
                if (conn.getConnection() != null && !conn.getConnection().isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                ZimbraLog.sqltrace.warn((Object)"quietClose caught exception", e);
            }
            catch (ServiceException e) {
                ZimbraLog.sqltrace.warn((Object)"quietClose caught exception", e);
            }
        }
    }

    public static void quietRollback(Connection conn) {
        if (conn != null) {
            try {
                if (conn.getConnection() != null && !conn.getConnection().isClosed()) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                ZimbraLog.sqltrace.warn((Object)"quietRollback caught exception", e);
            }
            catch (ServiceException e) {
                ZimbraLog.sqltrace.warn((Object)"quietRollback caught exception", e);
            }
        }
    }

    public static void closeStatement(Statement stmt) throws ServiceException {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("closing statement", e);
            }
        }
    }

    public static void quietCloseStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResults(ResultSet rs) throws ServiceException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("closing statement", e);
            }
        }
    }

    public static int getSize() {
        return sConnectionPool.getNumActive();
    }

    static synchronized void close() throws Exception {
        if (sConnectionPool != null) {
            sConnectionPool.close();
            sConnectionPool = null;
        }
        sPoolingDataSource = null;
        Db.getInstance().shutdown();
    }

    public static synchronized void shutdown() throws Exception {
        isShutdown = true;
        DbPool.close();
    }

    static {
        sConnectionStackCounter = new ValueCounter();
    }

    private static class ZimbraConnectionFactory
    extends DriverManagerConnectionFactory {
        ZimbraConnectionFactory(String connectUri, Properties props) {
            super(connectUri, props);
        }

        public java.sql.Connection createConnection() throws SQLException {
            java.sql.Connection conn = super.createConnection();
            Db.getInstance().postCreate(conn);
            return new DebugConnection(conn);
        }
    }

    static abstract class PoolConfig {
        String mDriverClassName;
        int mPoolSize;
        String mRootUrl;
        String mConnectionUrl;
        String mLoggerUrl;
        boolean mSupportsStatsCallback;
        Properties mDatabaseProperties;

        PoolConfig() {
        }
    }

    public static class Connection {
        private java.sql.Connection mConnection;
        private Throwable mStackTrace;

        Connection(java.sql.Connection conn) {
            this.mConnection = conn;
        }

        public java.sql.Connection getConnection() {
            return this.mConnection;
        }

        public void setTransactionIsolation(int level) throws ServiceException {
            try {
                this.mConnection.setTransactionIsolation(level);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("setting database connection isolation level", e);
            }
        }

        public void disableForeignKeyConstraints() throws ServiceException {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.mConnection.prepareStatement("SET FOREIGN_KEY_CHECKS=0");
                    stmt.execute();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("disabling foreign key constraints", e);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
        }

        public void enableForeignKeyConstraints() throws ServiceException {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.mConnection.prepareStatement("SET FOREIGN_KEY_CHECKS=1");
                    stmt.execute();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("disabling foreign key constraints", e);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            ZimbraPerf.incrementPrepareCount();
            return this.mConnection.prepareStatement(sql);
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            ZimbraPerf.incrementPrepareCount();
            return this.mConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        public void rollback() throws ServiceException {
            try {
                this.mConnection.rollback();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("rolling back database transaction", e);
            }
        }

        public void commit() throws ServiceException {
            try {
                this.mConnection.commit();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("committing database transaction", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws ServiceException {
            try {
                Db.getInstance().preClose(this);
            }
            catch (SQLException e) {
                ZimbraLog.sqltrace.warn((Object)"DB connection pre-close processing caught exception", e);
            }
            try {
                try {
                    this.mConnection.close();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("closing database connection", e);
                }
                Object var3_3 = null;
                if (this.mStackTrace == null) return;
                if (!ZimbraLog.dbconn.isDebugEnabled()) return;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.mStackTrace == null) throw throwable;
                if (!ZimbraLog.dbconn.isDebugEnabled()) throw throwable;
                String stackTrace = SystemUtil.getStackTrace(this.mStackTrace);
                ValueCounter<String> valueCounter = sConnectionStackCounter;
                synchronized (valueCounter) {
                    sConnectionStackCounter.decrement(stackTrace);
                    throw throwable;
                }
            }
            String stackTrace = SystemUtil.getStackTrace(this.mStackTrace);
            ValueCounter<String> valueCounter = sConnectionStackCounter;
            synchronized (valueCounter) {
                sConnectionStackCounter.decrement(stackTrace);
                return;
            }
        }

        void setStackTrace(Throwable t) {
            this.mStackTrace = t;
        }
    }
}

