/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class DbOutOfOffice {
    public static String TABLE_NAME = "out_of_office";
    private static Log mLog = LogFactory.getLog(DbOutOfOffice.class);

    public static boolean alreadySent(DbPool.Connection conn, Mailbox mbox, String sentTo, long cacheDurationMillis) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        sentTo = sentTo.toLowerCase();
        boolean result = false;
        Timestamp cutoff = new Timestamp(System.currentTimeMillis() - cacheDurationMillis);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_NAME) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "sent_to = ? AND sent_on > ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, sentTo);
                stmt.setTimestamp(pos++, cutoff);
                rs = stmt.executeQuery();
                rs.next();
                int count = rs.getInt(1);
                result = count > 0;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("DbOutOfOffice.getSentTime: sql exception (mailbox_id=" + mbox.getId() + " sent_to=" + sentTo + ")", e);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        if (mLog.isDebugEnabled()) {
            mLog.debug("DbOutOfOffice.alreadySent() returning " + result + ".  mailbox_id=" + mbox.getId() + ", sent_to='" + sentTo + "'");
        }
        return result;
    }

    public static void setSentTime(DbPool.Connection conn, Mailbox mbox, String sentTo) throws ServiceException {
        DbOutOfOffice.setSentTime(conn, mbox, sentTo, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSentTime(DbPool.Connection conn, Mailbox mbox, String sentTo, long sentOn) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        Timestamp ts = new Timestamp(sentOn);
        Statement stmt = null;
        try {
            block9: {
                try {
                    String command = Db.supports(Db.Capability.REPLACE_INTO) ? "REPLACE" : "INSERT";
                    stmt = conn.prepareStatement(command + " INTO " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_NAME) + "(" + DbMailItem.MAILBOX_ID + "sent_to, sent_on)" + " VALUES (" + DbMailItem.MAILBOX_ID_VALUE + " ?, ?) ");
                    int pos = 1;
                    pos = DbMailItem.setMailboxId((PreparedStatement)stmt, mbox, pos);
                    stmt.setString(pos++, sentTo.toLowerCase());
                    stmt.setTimestamp(pos++, ts);
                    int num = stmt.executeUpdate();
                    if (num > 0) {
                        if (mLog.isDebugEnabled()) {
                            mLog.debug("DbOutOfOffice.setSentTime: ok (mailbox_id=" + mbox.getId() + " sent_to=" + sentTo + " sent_on=" + sentOn + " rows=" + num + ")");
                        }
                        break block9;
                    }
                    mLog.error("DbOutOfOffice.setSentTime: no rows updated (mailbox_id=" + mbox.getId() + " sent_to=" + sentTo + " sent_on=" + sentOn + " rows=" + num + ")");
                }
                catch (SQLException e) {
                    if (!Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) throw ServiceException.FAILURE("DbOutOfOffice.setSentTime: sql exception (mailbox_id=" + mbox.getId() + " sent_to" + sentTo + " sent_on=" + sentOn + ")", e);
                    try {
                        stmt.close();
                        stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_NAME) + " SET sent_on = ?" + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "sent_to = ?");
                        int pos = 1;
                        stmt.setTimestamp(pos++, ts);
                        pos = DbMailItem.setMailboxId((PreparedStatement)stmt, mbox, pos);
                        stmt.setString(pos++, sentTo.toLowerCase());
                        stmt.executeUpdate();
                    }
                    catch (SQLException nested) {
                        throw ServiceException.FAILURE("DbOutOfOffice.setSentTime: sql exception (mailbox_id=" + mbox.getId() + " sent_to" + sentTo + " sent_on=" + sentOn + ")", nested);
                    }
                    Object var11_13 = null;
                    DbPool.closeStatement(stmt);
                    return;
                }
            }
            Object var11_12 = null;
            DbPool.closeStatement(stmt);
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
    }

    public static void clear(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_NAME) + (DebugConfig.disableMailboxGroups ? "" : " WHERE mailbox_id = ?"));
                DbMailItem.setMailboxId(stmt, mbox, 1);
                int num = stmt.executeUpdate();
                mLog.debug("DbOutOfOffice.clear() mbox=" + mbox.getId() + " rows=" + num);
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("DbOutOfOffice.clear acctId=" + mbox.getAccountId(), e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
    }

    public static void prune(DbPool.Connection conn, long cacheDurationMillis) throws ServiceException {
        if (DebugConfig.disableMailboxGroups) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        try {
            block6: {
                try {
                    Timestamp cutoff = new Timestamp(System.currentTimeMillis() - cacheDurationMillis);
                    stmt = conn.prepareStatement("DELETE FROM " + TABLE_NAME + " WHERE sent_on <= ?");
                    stmt.setTimestamp(1, cutoff);
                    int num = stmt.executeUpdate();
                    if (!mLog.isDebugEnabled()) break block6;
                    mLog.debug("DbOutOfOffice.prune() deleted " + num + " rows");
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("DbOutOfOffice.prune()", e);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }
}

