/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.service.util.SyncToken;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMailbox {
    public static final int CI_ID;
    public static final int CI_GROUP_ID;
    public static final int CI_ACCOUNT_ID;
    public static final int CI_INDEX_VOLUME_ID;
    public static final int CI_ITEM_ID_CHECKPOINT;
    public static final int CI_CONTACT_COUNT;
    public static final int CI_SIZE_CHECKPOINT;
    public static final int CI_CHANGE_CHECKPOINT;
    public static final int CI_TRACKING_SYNC;
    public static final int CI_TRACKING_IMAP;
    public static final int CI_LAST_BACKUP_AT;
    public static final int CI_COMMENT;
    public static final int CI_LAST_SOAP_ACCESS;
    public static final int CI_NEW_MESSAGES;
    public static final int CI_IDX_DEFERRED_COUNT;
    public static final int CI_HIGHEST_INDEXED;
    public static final int CI_METADATA_MAILBOX_ID = 1;
    public static final int CI_METADATA_SECTION = 2;
    public static final int CI_METADATA_METADATA = 3;
    public static final int CI_SCHEDULED_TASK_MAILBOX_ID = 3;
    public static final int CI_OUT_OF_OFFICE_MAILBOX_ID = 1;
    static final String DB_PREFIX_MAILBOX_GROUP = "mboxgroup";
    static final String TABLE_MAILBOX = "mailbox";
    static final String TABLE_METADATA = "mailbox_metadata";
    static final String TABLE_OUT_OF_OFFICE = "out_of_office";
    private static int MAX_COMMENT_LENGTH;
    static final List<String> sTables;
    public static final int CHANGE_CHECKPOINT_INCREMENT;
    public static final int ITEM_CHECKPOINT_INCREMENT = 20;

    public static synchronized MailboxIdentifier getNextMailboxId(DbPool.Connection conn, long mailboxId) throws ServiceException {
        MailboxIdentifier mailboxIdentifier;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        boolean explicitId = mailboxId != -1L;
        ZimbraLog.mailbox.debug("Getting next mailbox id.  requested mailboxId=%d.", mailboxId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (explicitId) {
                stmt = conn.prepareStatement("UPDATE current_volumes SET next_mailbox_id = ? WHERE next_mailbox_id <= ?");
                stmt.setLong(1, mailboxId + 1L);
                stmt.setLong(2, mailboxId);
                stmt.executeUpdate();
            } else {
                stmt = conn.prepareStatement("UPDATE current_volumes SET next_mailbox_id = next_mailbox_id + 1");
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                stmt = conn.prepareStatement("SELECT next_mailbox_id - 1 FROM current_volumes");
                rs = stmt.executeQuery();
                if (rs.next()) {
                    mailboxId = rs.getLong(1);
                } else {
                    throw ServiceException.FAILURE("Unable to assign next new mailbox id", null);
                }
            }
            MailboxIdentifier newId = new MailboxIdentifier(mailboxId, DbMailbox.calculateMailboxGroupId(mailboxId));
            ZimbraLog.mailbox.debug("Returning mailboxId=%d, groupId=%d.", newId.id, newId.groupId);
            mailboxIdentifier = newId;
            Object var9_8 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting next mailbox id, mailboxId=" + mailboxId, e);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return mailboxIdentifier;
    }

    public static synchronized Mailbox.MailboxData createMailbox(DbPool.Connection conn, long requestedMailboxId, String accountId, String comment, int lastBackupAt) throws ServiceException {
        Mailbox.MailboxData mailboxData;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        String limitClause = Db.supports(Db.Capability.LIMIT_CLAUSE) ? " ORDER BY index_volume_id LIMIT 1" : "";
        MailboxIdentifier newMboxId = DbMailbox.getNextMailboxId(conn, requestedMailboxId);
        long mailboxId = newMboxId.id;
        long groupId = newMboxId.groupId;
        DbMailbox.createMailboxDatabase(conn, mailboxId, groupId);
        if (comment != null && comment.length() > MAX_COMMENT_LENGTH) {
            comment = comment.substring(0, MAX_COMMENT_LENGTH);
        }
        if (comment != null) {
            DbMailbox.removeFromDeletedAccount(conn, comment);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT index_volume_id FROM current_volumes" + limitClause);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw ServiceException.FAILURE("cannot create mailbox: no rows in database table ZIMBRA.CURRENT_VOLUME", null);
            }
            short indexVolume = rs.getShort(1);
            if (rs.next()) {
                ZimbraLog.mbxmgr.warn("bad state: too many rows in database table ZIMBRA.CURRENT_VOLUME");
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (DebugConfig.disableMailboxGroups) {
                Db.getInstance().registerDatabaseInterest(conn, DbMailbox.getDatabaseName(groupId));
                if (!DebugConfig.externalMailboxDirectory) {
                    stmt = conn.prepareStatement("INSERT INTO mailbox (account_id, id, last_backup_at, comment) VALUES (?, ?, ?, ?)");
                    stmt.setString(1, accountId);
                    stmt.setLong(2, mailboxId);
                    if (lastBackupAt >= 0) {
                        stmt.setInt(3, lastBackupAt);
                    } else {
                        stmt.setNull(3, 4);
                    }
                    stmt.setString(4, comment);
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                stmt = conn.prepareStatement("INSERT INTO " + DbMailbox.qualifyTableName(groupId, TABLE_MAILBOX) + "(id, account_id, index_volume_id, item_id_checkpoint)" + " VALUES (?, ?, ?, " + 255 + ")");
                stmt.setLong(1, mailboxId);
                stmt.setString(2, accountId);
                stmt.setShort(3, indexVolume);
                stmt.executeUpdate();
            } else {
                stmt = conn.prepareStatement("INSERT INTO mailbox(account_id, id, group_id, index_volume_id, item_id_checkpoint, last_backup_at, comment) VALUES (?, ?, ?, ?, 255, ?, ?)");
                stmt.setString(1, accountId);
                stmt.setLong(2, mailboxId);
                stmt.setLong(3, groupId);
                stmt.setInt(4, indexVolume);
                if (lastBackupAt >= 0) {
                    stmt.setInt(5, lastBackupAt);
                } else {
                    stmt.setNull(5, 4);
                }
                stmt.setString(6, comment);
                stmt.executeUpdate();
            }
            Mailbox.MailboxData data = new Mailbox.MailboxData();
            data.accountId = accountId;
            data.id = mailboxId;
            data.lastItemId = 255;
            data.schemaGroupId = groupId;
            data.indexVolumeId = indexVolume;
            mailboxData = data;
            Object var18_15 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("writing new mailbox row for account " + accountId, e);
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return mailboxData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createMailboxDatabase(DbPool.Connection conn, long mailboxId, long groupId) throws ServiceException {
        Statement stmt;
        block8: {
            block7: {
                ZimbraLog.mailbox.debug("createMailboxDatabase(" + mailboxId + ")");
                File file = new File(LC.mailboxd_directory.value() + "/../db/create_database.sql");
                stmt = null;
                try {
                    try {
                        String dbname = DbMailbox.getDatabaseName(groupId);
                        if (Db.getInstance().databaseExists(conn, dbname)) {
                            conn.commit();
                            Object var12_8 = null;
                            break block7;
                        }
                        Db.getInstance().precreateDatabase(dbname);
                        ZimbraLog.mailbox.info("Creating database " + dbname);
                        Db.getInstance().registerDatabaseInterest(conn, dbname);
                        String template = new String(ByteUtil.getContent(file));
                        HashMap<String, String> vars = new HashMap<String, String>();
                        vars.put("DATABASE_NAME", dbname);
                        String script = StringUtil.fillTemplate(template, vars);
                        DbUtil.executeScript(conn, new StringReader(script));
                        break block8;
                    }
                    catch (IOException e) {
                        throw ServiceException.FAILURE("unable to read SQL statements from " + file.getPath(), e);
                    }
                    catch (SQLException e) {
                        throw ServiceException.FAILURE("createMailboxDatabase(" + mailboxId + ")", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    DbPool.closeStatement(stmt);
                    throw throwable;
                }
            }
            DbPool.closeStatement(stmt);
            return;
        }
        Object var12_9 = null;
        DbPool.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void dropMailboxFromGroup(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        block16: {
            long mailboxId = mbox.getId();
            ZimbraLog.mailbox.info("clearing contents of mailbox " + mailboxId + ", group " + mbox.getSchemaGroupId());
            if (DebugConfig.disableMailboxGroups && Db.supports(Db.Capability.FILE_PER_DATABASE)) {
                Db.getInstance().deleteDatabaseFile(DbMailbox.getDatabaseName(mbox));
                return;
            }
            if (conn == null) {
                conn = mbox.getOperationConnection();
            } else {
                Db.registerDatabaseInterest(conn, mbox);
            }
            if (Db.supports(Db.Capability.DISABLE_CONSTRAINT_CHECK)) {
                conn.disableForeignKeyConstraints();
            }
            for (int i = sTables.size() - 1; i >= 0; --i) {
                Object var8_7;
                String tableName = sTables.get(i);
                if (tableName == null) continue;
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("DELETE FROM " + DbMailbox.qualifyTableName(mbox, tableName) + (DebugConfig.disableMailboxGroups ? "" : " WHERE mailbox_id = " + mailboxId));
                    stmt.executeUpdate();
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    DbPool.closeStatement(stmt);
                    throw throwable;
                }
                DbPool.closeStatement(stmt);
                {
                    continue;
                }
            }
            Object var10_9 = null;
            try {
                if (Db.supports(Db.Capability.DISABLE_CONSTRAINT_CHECK)) {
                    conn.enableForeignKeyConstraints();
                }
                break block16;
            }
            catch (ServiceException e) {
                ZimbraLog.mailbox.error((Object)"error enabling foreign key constraints during mailbox deletion", e);
            }
            break block16;
            {
                catch (SQLException e) {
                    throw ServiceException.FAILURE("dropMailboxFromGroup(" + mailboxId + ")", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (Db.supports(Db.Capability.DISABLE_CONSTRAINT_CHECK)) {
                        conn.enableForeignKeyConstraints();
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.error((Object)"error enabling foreign key constraints during mailbox deletion", e);
                }
                throw throwable;
            }
        }
    }

    public static void clearMailboxContent(Mailbox mbox) throws ServiceException {
        DbMailbox.clearMailboxContent(null, mbox);
    }

    public static void clearMailboxContent(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        DbMailbox.dropMailboxFromGroup(conn, mbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameMailbox(Mailbox mbox, String newName) throws ServiceException {
        if (DebugConfig.externalMailboxDirectory) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        long mailboxId = mbox.getId();
        ZimbraLog.mailbox.info("Renaming email/comment of mailbox " + mailboxId + " to " + newName);
        DbPool.Connection conn = mbox.getOperationConnection();
        try {
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("UPDATE mailbox SET comment = ?, last_backup_at = NULL WHERE id = ?");
                stmt.setString(1, newName);
                stmt.setLong(2, mailboxId);
                stmt.executeUpdate();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
            {
            }
        }
        catch (SQLException e) {
            throw ServiceException.FAILURE("renameMailbox(" + mailboxId + ")", e);
        }
    }

    public static void clearMailboxContactCount(Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_MAILBOX) + " SET contact_count = NULL WHERE id = ?");
                stmt.setLong(1, mbox.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("clearing contact count for mailbox " + mbox.getId(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void recordLastSoapAccess(Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_MAILBOX) + " SET last_soap_access = ? WHERE id = ?");
                stmt.setInt(1, (int)(mbox.getLastSoapAccessTime() / 1000L));
                stmt.setLong(2, mbox.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating last SOAP access time for mailbox " + mbox.getId(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void updateMailboxStats(Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_MAILBOX) + " SET item_id_checkpoint = ?, contact_count = ?, change_checkpoint = ?," + "  size_checkpoint = ?, new_messages = ?, idx_deferred_count = ?, highest_indexed = ?" + " WHERE id = ?");
                int pos = 1;
                stmt.setInt(pos++, mbox.getLastItemId());
                stmt.setInt(pos++, mbox.getContactCount());
                stmt.setInt(pos++, mbox.getLastChangeID());
                stmt.setLong(pos++, mbox.getSize());
                stmt.setInt(pos++, mbox.getRecentMessageCount());
                stmt.setInt(pos++, mbox.getIndexDeferredCount());
                stmt.setString(pos++, mbox.getHighestFlushedToIndex().toString());
                stmt.setLong(pos++, mbox.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating mailbox statistics for mailbox " + mbox.getId(), e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void startTrackingSync(Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_MAILBOX) + " SET tracking_sync = ? WHERE id = ? AND tracking_sync <= 0");
                stmt.setInt(1, mbox.getLastChangeID());
                stmt.setLong(2, mbox.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("turning on sync tracking for mailbox " + mbox.getId(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void startTrackingImap(Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_MAILBOX) + " SET tracking_imap = 1 WHERE id = ?");
                stmt.setLong(1, mbox.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("turning on imap tracking for mailbox " + mbox.getId(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static String getConfig(Mailbox mbox, String section) throws ServiceException {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
            DbPool.Connection conn = mbox.getOperationConnection();
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement("SELECT metadata FROM " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_METADATA) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "section = ?");
            int pos = 1;
            if (!DebugConfig.disableMailboxGroups) {
                stmt.setLong(pos++, mbox.getId());
            }
            stmt.setString(pos++, section);
            rs = stmt.executeQuery();
            if (!rs.next()) break block7;
            String string2 = rs.getString(1);
            Object var8_9 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return string2;
        }
        try {
            string = null;
            Object var8_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting metadata section '" + section + "' in mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return string;
    }

    public static void updateConfig(Mailbox mbox, String section, Metadata config) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                block12: {
                    if (config == null) {
                        stmt = conn.prepareStatement("DELETE FROM " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_METADATA) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "section = ?");
                        int pos = 1;
                        if (!DebugConfig.disableMailboxGroups) {
                            stmt.setLong(pos++, mbox.getId());
                        }
                        stmt.setString(pos++, section.toUpperCase());
                        stmt.executeUpdate();
                        stmt.close();
                    } else {
                        try {
                            String command = Db.supports(Db.Capability.REPLACE_INTO) ? "REPLACE" : "INSERT";
                            stmt = conn.prepareStatement(command + " INTO " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_METADATA) + " (" + (DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ") + "section, metadata)" + " VALUES (" + (DebugConfig.disableMailboxGroups ? "" : "?, ") + "?, ?)");
                            int pos = 1;
                            if (!DebugConfig.disableMailboxGroups) {
                                stmt.setLong(pos++, mbox.getId());
                            }
                            stmt.setString(pos++, section);
                            stmt.setString(pos++, config.toString());
                            stmt.executeUpdate();
                        }
                        catch (SQLException e) {
                            if (!Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) break block12;
                            stmt = conn.prepareStatement("UPDATE " + DbMailbox.qualifyZimbraTableName(mbox, TABLE_METADATA) + " SET metadata = ? WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "section = ?");
                            int pos = 1;
                            stmt.setString(pos++, config.toString());
                            if (!DebugConfig.disableMailboxGroups) {
                                stmt.setLong(pos++, mbox.getId());
                            }
                            stmt.setString(pos++, section);
                            int numRows = stmt.executeUpdate();
                            if (numRows == 1) break block12;
                            String msg = String.format("Unexpected number of rows (%d) updated for section %s", numRows, section);
                            throw ServiceException.FAILURE(msg, e);
                        }
                    }
                }
                Object var10_13 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("setting metadata section '" + section + "' in mailbox " + mbox.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static Map<String, Long> listMailboxes(DbPool.Connection conn) throws ServiceException {
        return DbMailbox.listMailboxes(conn, MailboxManager.getInstance());
    }

    public static Map<String, Long> listMailboxes(DbPool.Connection conn, MailboxManager mmgr) throws ServiceException {
        HashMap<String, Long> hashMap;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mmgr));
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (DebugConfig.externalMailboxDirectory) {
            return result;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT account_id, id FROM mailbox");
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(1), rs.getLong(2));
            }
            hashMap = result;
            Object var7_7 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching mailboxes", e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return hashMap;
    }

    public static Map<String, Long> getMailboxSizes(DbPool.Connection conn, List<Long> mailboxIds) throws ServiceException {
        Object i$;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        if (DebugConfig.externalMailboxDirectory) {
            return sizes;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (!DebugConfig.disableMailboxGroups) {
                stmt = conn.prepareStatement("SELECT account_id, size_checkpoint FROM mailbox");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    sizes.put(rs.getString(1), rs.getLong(2));
                }
            } else {
                i$ = mailboxIds.iterator();
                while (i$.hasNext()) {
                    long mailboxId = i$.next();
                    Db.getInstance().registerDatabaseInterest(conn, DbMailbox.getDatabaseName(mailboxId));
                    stmt = conn.prepareStatement("SELECT account_id, size_checkpoint FROM " + DbMailbox.qualifyZimbraTableName(mailboxId, TABLE_MAILBOX));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        sizes.put(rs.getString(1), rs.getLong(2));
                    }
                    rs.close();
                    rs = null;
                    stmt.close();
                    stmt = null;
                    conn.commit();
                }
            }
            i$ = sizes;
            Object var9_8 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching mailboxes", e);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return i$;
    }

    public static Mailbox.MailboxData getMailboxStats(DbPool.Connection conn, long mailboxId) throws ServiceException {
        Mailbox.MailboxData mailboxData;
        ResultSet rs;
        PreparedStatement stmt;
        block18: {
            stmt = null;
            rs = null;
            if (DebugConfig.disableMailboxGroups) {
                Db.getInstance().registerDatabaseInterest(conn, DbMailbox.getDatabaseName(mailboxId));
            }
            stmt = conn.prepareStatement("SELECT account_id," + (DebugConfig.disableMailboxGroups ? Long.valueOf(mailboxId) : " group_id") + "," + " size_checkpoint, contact_count, item_id_checkpoint, change_checkpoint, tracking_sync," + " tracking_imap, index_volume_id, last_soap_access, new_messages, idx_deferred_count, highest_indexed " + "FROM " + DbMailbox.qualifyZimbraTableName(mailboxId, TABLE_MAILBOX) + " WHERE id = ?");
            stmt.setLong(1, mailboxId);
            rs = stmt.executeQuery();
            if (rs.next()) break block18;
            Mailbox.MailboxData mailboxData2 = null;
            Object var12_7 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return mailboxData2;
        }
        try {
            String highestModContentIndexed;
            int pos = 1;
            Mailbox.MailboxData mbd = new Mailbox.MailboxData();
            mbd.id = mailboxId;
            mbd.accountId = rs.getString(pos++);
            mbd.schemaGroupId = rs.getLong(pos++);
            mbd.size = rs.getLong(pos++);
            if (rs.wasNull()) {
                mbd.size = -1L;
            }
            mbd.contacts = rs.getInt(pos++);
            if (rs.wasNull()) {
                mbd.contacts = -1;
            }
            mbd.lastItemId = rs.getInt(pos++);
            mbd.lastChangeId = rs.getInt(pos++);
            mbd.trackSync = rs.getInt(pos++);
            mbd.trackImap = rs.getBoolean(pos++);
            mbd.indexVolumeId = rs.getShort(pos++);
            mbd.lastWriteDate = rs.getInt(pos++);
            mbd.recentMessages = rs.getInt(pos++);
            mbd.idxDeferredCount = rs.getInt(pos++);
            if ((highestModContentIndexed = rs.getString(pos++)) == null || highestModContentIndexed.length() == 0) {
                mbd.highestModContentIndexed = new SyncToken(mbd.lastChangeId);
            } else {
                try {
                    mbd.highestModContentIndexed = new SyncToken(highestModContentIndexed);
                }
                catch (MailServiceException e) {
                    ZimbraLog.mailbox.warn((Object)("Exception loading index high water mark from DB.  Using current mod_content value: " + mbd.lastChangeId), e);
                    mbd.highestModContentIndexed = new SyncToken(mbd.lastChangeId);
                }
            }
            mbd.lastBackupDate = -1;
            mbd.lastItemId += 19;
            mbd.lastChangeId += CHANGE_CHECKPOINT_INCREMENT - 1;
            long rounding = mbd.lastItemId % 20;
            if (rounding != 19L) {
                mbd.lastItemId = (int)((long)mbd.lastItemId - (rounding + 1L));
            }
            if ((rounding = (long)(mbd.lastChangeId % CHANGE_CHECKPOINT_INCREMENT)) != (long)(CHANGE_CHECKPOINT_INCREMENT - 1)) {
                mbd.lastChangeId = (int)((long)mbd.lastChangeId - (rounding + 1L));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            stmt = conn.prepareStatement("SELECT section FROM " + DbMailbox.qualifyZimbraTableName(mailboxId, TABLE_METADATA) + (DebugConfig.disableMailboxGroups ? "" : " WHERE mailbox_id = ?"));
            if (!DebugConfig.disableMailboxGroups) {
                stmt.setLong(1, mailboxId);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (mbd.configKeys == null) {
                    mbd.configKeys = new HashSet<String>();
                }
                mbd.configKeys.add(rs.getString(1));
            }
            mailboxData = mbd;
            Object var12_8 = null;
        }
        catch (SQLException e) {
            block19: {
                Mailbox.MailboxData mailboxData3;
                try {
                    if (!Db.errorMatches(e, Db.Error.NO_SUCH_TABLE)) break block19;
                    mailboxData3 = null;
                    Object var12_9 = null;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    DbPool.closeResults(rs);
                    DbPool.closeStatement(stmt);
                    throw throwable;
                }
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                return mailboxData3;
            }
            throw ServiceException.FAILURE("fetching stats on mailbox " + mailboxId, e);
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return mailboxData;
    }

    public static Object getSynchronizer() {
        try {
            if (!Db.supports(Db.Capability.ROW_LEVEL_LOCKING)) {
                return MailboxManager.getInstance();
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return new Object();
    }

    public static Object getZimbraSynchronizer(Mailbox mbox) throws ServiceException {
        return DebugConfig.disableMailboxGroups ? mbox : MailboxManager.getInstance();
    }

    public static long calculateMailboxGroupId(long mailboxId) {
        int groups = DebugConfig.numMailboxGroups;
        return (mailboxId - 1L) % (long)groups + 1L;
    }

    public static String getDatabaseName(Mailbox mbox) {
        return DbMailbox.getDatabaseName(mbox.getSchemaGroupId());
    }

    public static String getDatabaseName(long groupId) {
        return DB_PREFIX_MAILBOX_GROUP + groupId;
    }

    public static String qualifyZimbraTableName(Mailbox mbox, String tableName) {
        return DebugConfig.disableMailboxGroups ? DbMailbox.qualifyTableName(mbox, tableName) : tableName;
    }

    public static String qualifyZimbraTableName(long mailboxId, String tableName) {
        return DebugConfig.disableMailboxGroups ? DbMailbox.qualifyTableName(mailboxId, tableName) : tableName;
    }

    public static String qualifyTableName(Mailbox mbox, String tableName) {
        return DbMailbox.qualifyTableName(mbox.getSchemaGroupId(), tableName);
    }

    public static String qualifyTableName(long groupId, String tableName) {
        return DB_PREFIX_MAILBOX_GROUP + groupId + '.' + tableName;
    }

    public static void removeFromDeletedAccount(DbPool.Connection conn, String email) throws ServiceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM deleted_account WHERE email = ?");
                stmt.setString(1, email.toLowerCase());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("deleting row for " + email + " from deleted_account table", e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    private static void addToDeletedAccount(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        if (DebugConfig.externalMailboxDirectory) {
            return;
        }
        String email = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT comment FROM mailbox WHERE id = ?");
                stmt.setLong(1, mbox.getId());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw ServiceException.FAILURE("no email address found for mailbox " + mbox.getId(), null);
                }
                email = rs.getString(1);
                Object var7_5 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting email address for mailbox " + mbox.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        DbMailbox.removeFromDeletedAccount(conn, email);
        try {
            try {
                stmt = conn.prepareStatement("INSERT INTO deleted_account (email, account_id, mailbox_id, deleted_at) SELECT ?, account_id, id, ? FROM mailbox WHERE id = ?");
                stmt.setString(1, email.toLowerCase());
                stmt.setLong(2, System.currentTimeMillis() / 1000L);
                stmt.setLong(3, mbox.getId());
                stmt.executeUpdate();
                stmt.close();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("marking mailbox " + mbox.getId() + " as deleted", e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static DeletedAccount getDeletedAccount(DbPool.Connection conn, String email) throws ServiceException {
        DeletedAccount emailCol2;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement("SELECT email, account_id, mailbox_id, deleted_at FROM deleted_account WHERE email = ?");
            stmt.setString(1, email.toLowerCase());
            rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            String emailCol2 = rs.getString(1);
            String accountId = rs.getString(2);
            long mailboxId = rs.getLong(3);
            long deletedAt = rs.getLong(4) * 1000L;
            DeletedAccount deletedAccount = new DeletedAccount(emailCol2, accountId, mailboxId, deletedAt);
            Object var12_11 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return deletedAccount;
        }
        try {
            emailCol2 = null;
            Object var12_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("checking if account " + email + " is deleted", e);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return emailCol2;
    }

    public static void deleteMailbox(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(DbMailbox.getZimbraSynchronizer(mbox)));
        DbMailbox.addToDeletedAccount(conn, mbox);
        PreparedStatement stmt = null;
        try {
            block7: {
                try {
                    if (DebugConfig.disableMailboxGroups) {
                        stmt = conn.prepareStatement("DELETE FROM " + DbMailbox.qualifyTableName(mbox, TABLE_MAILBOX) + " WHERE id = ?");
                        stmt.setLong(1, mbox.getId());
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    if (DebugConfig.externalMailboxDirectory) break block7;
                    stmt = conn.prepareStatement("DELETE FROM mailbox WHERE id = ?");
                    stmt.setLong(1, mbox.getId());
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("deleting mailbox " + mbox.getId(), e);
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    static Set<Long> getDistinctTagsets(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        HashSet<Long> tagsets = new HashSet<Long>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT DISTINCT(tags) FROM " + DbMailItem.getMailItemTableName(mbox) + (DebugConfig.disableMailboxGroups ? "" : " WHERE mailbox_id = ?"));
                if (!DebugConfig.disableMailboxGroups) {
                    stmt.setLong(1, mbox.getId());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    tagsets.add(rs.getLong(1));
                }
                Object var7_5 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting distinct tagsets", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return tagsets;
    }

    static Set<Long> getDistinctFlagsets(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        HashSet<Long> flagsets = new HashSet<Long>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT DISTINCT(flags) FROM " + DbMailItem.getMailItemTableName(mbox) + (DebugConfig.disableMailboxGroups ? "" : " WHERE mailbox_id = ?"));
                if (!DebugConfig.disableMailboxGroups) {
                    stmt.setLong(1, mbox.getId());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    flagsets.add(rs.getLong(1));
                }
                Object var7_5 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting distinct flagsets", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return flagsets;
    }

    public static Set<String> listAccountIds(DbPool.Connection conn) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        HashSet<String> accountIds = new HashSet<String>();
        if (DebugConfig.externalMailboxDirectory) {
            return accountIds;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT account_id FROM mailbox");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    accountIds.add(rs.getString(1));
                }
                Object var6_4 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting distinct account ids", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return accountIds;
    }

    public static List<Mailbox.MailboxData> getMailboxRawData(DbPool.Connection conn) throws ServiceException {
        ArrayList<Mailbox.MailboxData> results = new ArrayList<Mailbox.MailboxData>();
        if (DebugConfig.externalMailboxDirectory) {
            return results;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (!DebugConfig.disableMailboxGroups) {
                    assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
                    stmt = conn.prepareStatement("SELECT id, group_id, account_id, index_volume_id, item_id_checkpoint, contact_count, size_checkpoint, change_checkpoint, tracking_sync, tracking_imap, last_backup_at, last_soap_access, new_messages, idx_deferred_count, highest_indexed FROM mailbox");
                    rs = stmt.executeQuery();
                    DbMailbox.readMailboxRawData(results, rs);
                } else {
                    long[] mailboxIds;
                    for (long mailboxId : mailboxIds = MailboxManager.getInstance().getMailboxIds()) {
                        Db.getInstance().registerDatabaseInterest(conn, DbMailbox.getDatabaseName(mailboxId));
                        stmt = conn.prepareStatement("SELECT id, id, account_id, index_volume_id, item_id_checkpoint, contact_count, size_checkpoint, change_checkpoint, tracking_sync, tracking_imap, -1, last_soap_access, new_messages, idx_deferred_count, highest_indexedFROM " + DbMailbox.qualifyZimbraTableName(mailboxId, TABLE_MAILBOX));
                        rs = stmt.executeQuery();
                        DbMailbox.readMailboxRawData(results, rs);
                        rs.close();
                        rs = null;
                        stmt.close();
                        stmt = null;
                        conn.commit();
                    }
                }
                Object var11_10 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting distinct account id's", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return results;
    }

    private static void readMailboxRawData(List<Mailbox.MailboxData> results, ResultSet rs) throws SQLException {
        while (rs.next()) {
            String highestModContentIndexed;
            Mailbox.MailboxData data = new Mailbox.MailboxData();
            int pos = 1;
            data.id = rs.getLong(pos++);
            data.schemaGroupId = rs.getLong(pos++);
            data.accountId = rs.getString(pos++);
            data.indexVolumeId = rs.getShort(pos++);
            data.lastItemId = rs.getInt(pos++);
            data.contacts = rs.getInt(pos++);
            data.size = rs.getLong(pos++);
            data.lastChangeId = rs.getInt(pos++);
            data.trackSync = rs.getInt(pos++);
            data.trackImap = rs.getBoolean(pos++);
            data.lastBackupDate = rs.getInt(pos++);
            data.lastWriteDate = rs.getInt(pos++);
            data.recentMessages = rs.getInt(pos++);
            data.idxDeferredCount = rs.getInt(pos++);
            if ((highestModContentIndexed = rs.getString(pos++)) == null || highestModContentIndexed.length() == 0) {
                data.highestModContentIndexed = new SyncToken(data.lastChangeId);
            } else {
                try {
                    data.highestModContentIndexed = new SyncToken(highestModContentIndexed);
                }
                catch (ServiceException e) {
                    ZimbraLog.mailbox.warn((Object)("Exception loading index high water mark from DB.  Using current mod_content value: " + data.lastChangeId), e);
                    data.highestModContentIndexed = new SyncToken(data.lastChangeId);
                }
            }
            results.add(data);
        }
    }

    static {
        int pos = 1;
        CI_ID = pos++;
        CI_GROUP_ID = pos++;
        CI_ACCOUNT_ID = pos++;
        CI_INDEX_VOLUME_ID = pos++;
        CI_ITEM_ID_CHECKPOINT = pos++;
        CI_CONTACT_COUNT = pos++;
        CI_SIZE_CHECKPOINT = pos++;
        CI_CHANGE_CHECKPOINT = pos++;
        CI_TRACKING_SYNC = pos++;
        CI_TRACKING_IMAP = pos++;
        CI_LAST_BACKUP_AT = pos++;
        CI_COMMENT = pos++;
        CI_LAST_SOAP_ACCESS = pos++;
        CI_NEW_MESSAGES = pos++;
        CI_IDX_DEFERRED_COUNT = pos++;
        CI_HIGHEST_INDEXED = pos++;
        MAX_COMMENT_LENGTH = 255;
        sTables = new ArrayList<String>();
        if (DebugConfig.disableMailboxGroups) {
            sTables.add(TABLE_MAILBOX);
            sTables.add(TABLE_METADATA);
            sTables.add(TABLE_OUT_OF_OFFICE);
        }
        sTables.add("mail_item");
        sTables.add("open_conversation");
        sTables.add("appointment");
        sTables.add("revision");
        sTables.add("tombstone");
        sTables.add("imap_folder");
        sTables.add("imap_message");
        sTables.add("pop3_message");
        sTables.add("data_source_item");
        CHANGE_CHECKPOINT_INCREMENT = Math.max(1, LC.zimbra_mailbox_change_checkpoint_frequency.intValue());
    }

    public static class DeletedAccount {
        private String mEmail;
        private String mAccountId;
        private long mMailboxId;
        private long mDeletedAt;

        public DeletedAccount(String email, String accountId, long mailboxId, long deletedAt) {
            this.mEmail = email;
            this.mAccountId = accountId;
            this.mMailboxId = mailboxId;
            this.mDeletedAt = deletedAt;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public String getAccountId() {
            return this.mAccountId;
        }

        public long getMailboxId() {
            return this.mMailboxId;
        }

        public long getDeletedAt() {
            return this.mDeletedAt;
        }
    }

    public static class MailboxIdentifier {
        public final long id;
        public final long groupId;

        public MailboxIdentifier(long mbox_id, long group_id) {
            this.id = mbox_id;
            this.groupId = group_id;
        }

        public String toString() {
            return "[mailbox " + this.id + ", group " + this.groupId + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Number) {
                return (long)((Number)obj).intValue() == this.id;
            }
            if (obj instanceof MailboxIdentifier) {
                return ((MailboxIdentifier)obj).id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.id % Integer.MAX_VALUE);
        }
    }
}

