/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.TimeoutMap;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbSearch;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.db.TagsetCache;
import com.zimbra.cs.imap.ImapMessage;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.mailbox.VirtualConversation;
import com.zimbra.cs.mailbox.util.TypedIdList;
import com.zimbra.cs.pop3.Pop3Message;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMailItem {
    public static final String TABLE_MAIL_ITEM = "mail_item";
    public static final String TABLE_REVISION = "revision";
    public static final String TABLE_APPOINTMENT = "appointment";
    public static final String TABLE_OPEN_CONVERSATION = "open_conversation";
    public static final String TABLE_TOMBSTONE = "tombstone";
    private static Log sLog = LogFactory.getLog(DbMailItem.class);
    private static final Map<Long, TagsetCache> sTagsetCache = new TimeoutMap<Long, TagsetCache>(0x6DDD00L);
    private static final Map<Long, TagsetCache> sFlagsetCache = new TimeoutMap<Long, TagsetCache>(0x6DDD00L);
    public static final int MAX_SENDER_LENGTH = 128;
    public static final int MAX_SUBJECT_LENGTH = 1024;
    public static final int MAX_TEXT_LENGTH = 65534;
    public static final int MAX_MEDIUMTEXT_LENGTH = 0x1000000;
    public static final String IN_THIS_MAILBOX_AND = DebugConfig.disableMailboxGroups ? "" : "mailbox_id = ? AND ";
    public static final String MAILBOX_ID = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
    public static final String MAILBOX_ID_VALUE = DebugConfig.disableMailboxGroups ? "" : "?, ";
    private static final int RESULTS_STREAMING_MIN_ROWS = 10000;
    private static final String FOLDER_TYPES = "(1,2,13)";
    private static final String FOLDER_AND_TAG_TYPES = "(1,2,13,3)";
    private static final String MESSAGE_TYPES = "(5,16)";
    private static final String DOCUMENT_TYPES = "(8,14)";
    private static final String CALENDAR_TYPES = "(11,15)";
    static final String NON_SEARCHABLE_TYPES = "(1,2,13,3,4)";
    private static final String LEAF_NODE_FIELDS = "id, size, type, unread, folder_id, parent_id, blob_digest, mod_content, mod_metadata, flags, index_id, volume_id";
    private static final int LEAF_CI_ID = 1;
    private static final int LEAF_CI_SIZE = 2;
    private static final int LEAF_CI_TYPE = 3;
    private static final int LEAF_CI_IS_UNREAD = 4;
    private static final int LEAF_CI_FOLDER_ID = 5;
    private static final int LEAF_CI_PARENT_ID = 6;
    private static final int LEAF_CI_BLOB_DIGEST = 7;
    private static final int LEAF_CI_MOD_CONTENT = 8;
    private static final int LEAF_CI_MOD_METADATA = 9;
    private static final int LEAF_CI_FLAGS = 10;
    private static final int LEAF_CI_INDEX_ID = 11;
    private static final int LEAF_CI_VOLUME_ID = 12;
    private static final String IMAP_FIELDS = "mi.id, mi.type, mi.imap_id, mi.unread, mi.flags, mi.tags";
    private static final String IMAP_TYPES = "(5,16,6)";
    private static final String POP3_FIELDS = "mi.id, mi.size, mi.blob_digest";
    private static final String POP3_TYPES = "(5)";
    public static final int CI_ID = 1;
    public static final int CI_TYPE = 2;
    public static final int CI_PARENT_ID = 3;
    public static final int CI_FOLDER_ID = 4;
    public static final int CI_INDEX_ID = 5;
    public static final int CI_IMAP_ID = 6;
    public static final int CI_DATE = 7;
    public static final int CI_SIZE = 8;
    public static final int CI_VOLUME_ID = 9;
    public static final int CI_BLOB_DIGEST = 10;
    public static final int CI_UNREAD = 11;
    public static final int CI_FLAGS = 12;
    public static final int CI_TAGS = 13;
    public static final int CI_SUBJECT = 14;
    public static final int CI_NAME = 15;
    public static final int CI_METADATA = 16;
    public static final int CI_MODIFIED = 17;
    public static final int CI_MODIFY_DATE = 18;
    public static final int CI_SAVED = 19;
    static final String DB_FIELDS = "mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content";
    private static final String REVISION_FIELDS = "date, size, volume_id, blob_digest, name, metadata, mod_metadata, change_date, mod_content";
    private static long MAX_DATE = new GregorianCalendar(9999, 1, 1).getTimeInMillis();

    public static final int setMailboxId(PreparedStatement stmt, Mailbox mbox, int pos) throws SQLException {
        if (!DebugConfig.disableMailboxGroups) {
            stmt.setLong(pos++, mbox.getId());
        }
        return pos;
    }

    public static final String getInThisMailboxAnd(long mboxId, String miAlias, String apAlias) {
        if (DebugConfig.disableMailboxGroups) {
            return "";
        }
        StringBuilder sb = new StringBuilder(miAlias).append(".mailbox_id = ").append(mboxId).append(" AND ");
        if (apAlias != null) {
            sb.append(apAlias).append(".mailbox_id = ").append(mboxId).append(" AND ");
        }
        return sb.toString();
    }

    public static void create(Mailbox mbox, MailItem.UnderlyingData data, String sender) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        if (data == null || data.id <= 0 || data.folderId <= 0 || data.parentId == 0) {
            throw ServiceException.FAILURE("invalid data for DB item create", null);
        }
        DbMailItem.checkNamingConstraint(mbox, data.folderId, data.name, data.id);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block21: {
                try {
                    String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                    stmt = conn.prepareStatement("INSERT INTO " + DbMailItem.getMailItemTableName(mbox) + "(" + mailbox_id + " id, type, parent_id, folder_id, index_id, imap_id, date, size, volume_id, blob_digest," + " unread, flags, tags, sender, subject, name, metadata, mod_metadata, change_date, mod_content) " + "VALUES (" + MAILBOX_ID_VALUE + " ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, data.id);
                    stmt.setByte(pos++, data.type);
                    if (data.parentId <= 0) {
                        stmt.setNull(pos++, 4);
                    } else {
                        stmt.setInt(pos++, data.parentId);
                    }
                    stmt.setInt(pos++, data.folderId);
                    if (data.indexId == null) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, data.indexId);
                    }
                    if (data.imapId <= 0) {
                        stmt.setNull(pos++, 4);
                    } else {
                        stmt.setInt(pos++, data.imapId);
                    }
                    stmt.setInt(pos++, data.date);
                    stmt.setLong(pos++, data.size);
                    if (data.locator != null) {
                        stmt.setString(pos++, data.locator);
                    } else {
                        stmt.setNull(pos++, 12);
                    }
                    stmt.setString(pos++, data.getBlobDigest());
                    if (data.type == 5 || data.type == 16 || data.type == 1) {
                        stmt.setInt(pos++, data.unreadCount);
                    } else {
                        stmt.setNull(pos++, 16);
                    }
                    stmt.setInt(pos++, data.flags);
                    stmt.setLong(pos++, data.tags);
                    stmt.setString(pos++, DbMailItem.checkSenderLength(sender));
                    stmt.setString(pos++, DbMailItem.checkSubjectLength(data.subject));
                    stmt.setString(pos++, data.name);
                    stmt.setString(pos++, DbMailItem.checkMetadataLength(data.metadata));
                    stmt.setInt(pos++, data.modMetadata);
                    if (data.dateChanged > 0) {
                        stmt.setInt(pos++, data.dateChanged);
                    } else {
                        stmt.setNull(pos++, 4);
                    }
                    stmt.setInt(pos++, data.modContent);
                    int num = stmt.executeUpdate();
                    if (num != 1) {
                        throw ServiceException.FAILURE("failed to create object", null);
                    }
                    if (DbMailItem.areTagsetsLoaded(mbox)) {
                        DbMailItem.getTagsetCache(conn, mbox).addTagset(data.tags);
                    }
                    if (!DbMailItem.areFlagsetsLoaded(mbox)) break block21;
                    DbMailItem.getFlagsetCache(conn, mbox).addTagset(data.flags);
                }
                catch (SQLException e) {
                    if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                        throw MailServiceException.ALREADY_EXISTS(data.id, e);
                    }
                    throw ServiceException.FAILURE("writing new object of type " + data.type, e);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    private static void checkNamingConstraint(Mailbox mbox, int folderId, String name, int modifiedItemId) throws ServiceException {
        if (name == null || name.equals("")) {
            return;
        }
        if (Db.supports(Db.Capability.UNIQUE_NAME_INDEX) && !Db.supports(Db.Capability.CASE_SENSITIVE_COMPARISON)) {
            return;
        }
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND id <> ? AND " + Db.equalsSTRING("name"));
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, folderId);
                stmt.setInt(pos++, modifiedItemId);
                stmt.setString(pos++, StringUtil.trimTrailingSpaces(name.toUpperCase()));
                rs = stmt.executeQuery();
                if (!rs.next() || rs.getInt(1) > 0) {
                    throw MailServiceException.ALREADY_EXISTS(name, new ServiceException.Argument[0]);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("checking for naming conflicts", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
    }

    public static void copy(MailItem item, int id, Folder folder, String indexId, int parentId, String locator, String metadata) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        if (id <= 0 || indexId == null || folder == null || parentId == 0) {
            throw ServiceException.FAILURE("invalid data for DB item copy", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbMailItem.checkNamingConstraint(mbox, folder.getId(), item.getName(), id);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String table = DbMailItem.getMailItemTableName(mbox);
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement("INSERT INTO " + table + "(" + mailbox_id + " id, type, parent_id, folder_id, index_id, imap_id, date, size, volume_id, blob_digest," + " unread, flags, tags, sender, subject, name, metadata, mod_metadata, change_date, mod_content) " + "SELECT " + MAILBOX_ID_VALUE + " ?, type, ?, ?, ?, ?, date, size, ?, blob_digest, unread," + " flags, tags, sender, subject, name, ?, ?, ?, ? FROM " + table + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, id);
                if (parentId <= 0) {
                    stmt.setNull(pos++, 4);
                } else {
                    stmt.setInt(pos++, parentId);
                }
                stmt.setInt(pos++, folder.getId());
                stmt.setString(pos++, indexId);
                stmt.setInt(pos++, id);
                if (locator != null) {
                    stmt.setString(pos++, locator);
                } else {
                    stmt.setNull(pos++, 12);
                }
                stmt.setString(pos++, DbMailItem.checkMetadataLength(metadata));
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                stmt.setInt(pos++, mbox.getOperationChangeID());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                int num = stmt.executeUpdate();
                if (num != 1) {
                    throw ServiceException.FAILURE("failed to create object", null);
                }
                Object var15_15 = null;
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw MailServiceException.ALREADY_EXISTS(id, e);
                }
                throw ServiceException.FAILURE("copying " + MailItem.getNameForType(item) + ": " + item.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void icopy(MailItem source, MailItem.UnderlyingData data, boolean shared) throws ServiceException {
        Mailbox mbox = source.getMailbox();
        if (data == null || data.id <= 0 || data.folderId <= 0 || data.parentId == 0) {
            throw ServiceException.FAILURE("invalid data for DB item i-copy", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbMailItem.checkNamingConstraint(mbox, data.folderId, source.getName(), data.id);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block12: {
                try {
                    boolean needsTag;
                    String mailbox_id;
                    String table = DbMailItem.getMailItemTableName(mbox);
                    String string = mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                    String flags = !shared ? "flags" : (Db.supports(Db.Capability.BITWISE_OPERATIONS) ? "flags | " + Flag.BITMASK_COPIED : "CASE WHEN " + Db.bitmaskAND("flags", Flag.BITMASK_COPIED) + " THEN flags ELSE flags + " + Flag.BITMASK_COPIED + " END");
                    stmt = conn.prepareStatement("INSERT INTO " + table + "(" + mailbox_id + " id, type, parent_id, folder_id, index_id, imap_id, date, size, volume_id, blob_digest," + " unread, flags, tags, sender, subject, name, metadata, mod_metadata, change_date, mod_content) " + "SELECT " + mailbox_id + " ?, type, parent_id, ?, ?, ?, date, size, ?, blob_digest," + " unread, " + flags + ", tags, sender, subject, name, metadata, ?, ?, ? FROM " + table + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                    int pos = 1;
                    stmt.setInt(pos++, data.id);
                    stmt.setInt(pos++, data.folderId);
                    stmt.setString(pos++, data.indexId);
                    stmt.setInt(pos++, data.imapId);
                    if (data.locator != null) {
                        stmt.setString(pos++, data.locator);
                    } else {
                        stmt.setNull(pos++, -6);
                    }
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, source.getId());
                    stmt.executeUpdate();
                    stmt.close();
                    boolean bl = needsTag = shared && !source.isTagged(-5);
                    if (needsTag && DbMailItem.areFlagsetsLoaded(mbox)) {
                        DbMailItem.getFlagsetCache(conn, mbox).addTagset(source.getInternalFlagBitmask() | Flag.BITMASK_COPIED);
                    }
                    if (needsTag || source.getParentId() > 0) {
                        boolean altersMODSEQ = source.getParentId() > 0;
                        String updateChangeID = altersMODSEQ ? ", mod_metadata = ?, change_date = ?" : "";
                        stmt = conn.prepareStatement("UPDATE " + table + " SET parent_id = NULL, flags = " + flags + updateChangeID + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                        pos = 1;
                        if (altersMODSEQ) {
                            stmt.setInt(pos++, mbox.getOperationChangeID());
                            stmt.setInt(pos++, mbox.getOperationTimestamp());
                        }
                        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                        stmt.setInt(pos++, source.getId());
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    if (!(source instanceof Message) || source.getParentId() > 0) break block12;
                    DbMailItem.changeOpenTarget(Mailbox.getHash(((Message)source).getNormalizedSubject()), source, data.id);
                }
                catch (SQLException e) {
                    if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                        throw MailServiceException.ALREADY_EXISTS(data.id, e);
                    }
                    throw ServiceException.FAILURE("i-copying " + MailItem.getNameForType(source) + ": " + source.getId(), e);
                }
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void snapshotRevision(MailItem item, int version) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (version >= 1);
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String command = Db.supports(Db.Capability.REPLACE_INTO) ? "REPLACE" : "INSERT";
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement(command + " INTO " + DbMailItem.getRevisionTableName(mbox) + "(" + mailbox_id + "item_id, version, date, size, volume_id, blob_digest," + " name, metadata, mod_metadata, change_date, mod_content) " + "SELECT " + mailbox_id + "id, ?, date, size, volume_id, blob_digest," + " name, metadata, mod_metadata, change_date, mod_content" + " FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, version);
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw MailServiceException.ALREADY_EXISTS(item.getId(), e);
                }
                throw ServiceException.FAILURE("saving revision info for " + MailItem.getNameForType(item) + ": " + item.getId(), e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void purgeRevisions(MailItem item, int highestPurged) throws ServiceException {
        if (highestPurged <= 0) {
            return;
        }
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getRevisionTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "item_id = ? AND version <= ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.setInt(pos++, highestPurged);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("purging revisions for " + MailItem.getNameForType(item) + ": " + item.getId(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void changeType(MailItem item, byte type) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET type = ? WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, type);
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing new type for item " + item.getId(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void setFolder(MailItem item, Folder folder) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        if (mbox != folder.getMailbox()) {
            throw MailServiceException.WRONG_MAILBOX();
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbMailItem.checkNamingConstraint(mbox, folder.getId(), item.getName(), item.getId());
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String imapRenumber = mbox.isTrackingImap() ? ", imap_id = CASE WHEN imap_id IS NULL THEN NULL ELSE 0 END" : "";
                int pos = 1;
                boolean hasIndexId = false;
                if (item instanceof Folder) {
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET parent_id = ?, folder_id = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                    stmt.setInt(pos++, folder.getId());
                } else if (item instanceof Conversation && !(item instanceof VirtualConversation)) {
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET folder_id = ?, mod_metadata = ?, change_date = ?" + imapRenumber + " WHERE " + IN_THIS_MAILBOX_AND + "parent_id = ?");
                } else {
                    hasIndexId = true;
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET folder_id = ?, index_id = ?, mod_metadata = ?, change_date = ? " + imapRenumber + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                }
                stmt.setInt(pos++, folder.getId());
                if (hasIndexId) {
                    if (item.getIndexId() == null) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, item.getIndexId());
                    }
                }
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item instanceof VirtualConversation ? ((VirtualConversation)item).getMessageId() : item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw MailServiceException.ALREADY_EXISTS(item.getName(), e, new ServiceException.Argument[0]);
                }
                throw ServiceException.FAILURE("writing new folder data for item " + item.getId(), e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void setFolder(List<Message> msgs, Folder folder) throws ServiceException {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String imapRenumber = mbox.isTrackingImap() ? ", imap_id = CASE WHEN imap_id IS NULL THEN NULL ELSE 0 END" : "";
                for (int i = 0; i < msgs.size(); i += Db.getINClauseBatchSize()) {
                    int count = Math.min(Db.getINClauseBatchSize(), msgs.size() - i);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(folder) + " SET folder_id = ?, mod_metadata = ?, change_date = ?" + imapRenumber + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                    int pos = 1;
                    stmt.setInt(pos++, folder.getId());
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, msgs.get(index).getId());
                    }
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                Object var11_11 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing new folder data for messages", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void setIndexIds(Mailbox mbox, List<Message> msgs) throws ServiceException {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                for (int i = 0; i < msgs.size(); i += Db.getINClauseBatchSize()) {
                    int count = Math.min(Db.getINClauseBatchSize(), msgs.size() - i);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET index_id = id" + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, msgs.get(index).getId());
                    }
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing new folder data for messages", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void setParent(MailItem child, MailItem parent) throws ServiceException {
        DbMailItem.setParent(new MailItem[]{child}, parent);
    }

    public static void setParent(MailItem[] children, MailItem parent) throws ServiceException {
        if (children == null || children.length == 0) {
            return;
        }
        Mailbox mbox = children[0].getMailbox();
        if (mbox != parent.getMailbox()) {
            throw MailServiceException.WRONG_MAILBOX();
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                for (int i = 0; i < children.length; i += Db.getINClauseBatchSize()) {
                    int count = Math.min(Db.getINClauseBatchSize(), children.length - i);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET parent_id = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                    int pos = 1;
                    if (parent == null || parent instanceof VirtualConversation) {
                        stmt.setNull(pos++, 4);
                    } else {
                        stmt.setInt(pos++, parent.getId());
                    }
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, children[index].getId());
                    }
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("adding children to parent " + (parent == null ? "NULL" : parent.getId() + ""), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void reparentChildren(MailItem oldParent, MailItem newParent) throws ServiceException {
        if (oldParent == newParent) {
            return;
        }
        Mailbox mbox = oldParent.getMailbox();
        if (mbox != newParent.getMailbox()) {
            throw MailServiceException.WRONG_MAILBOX();
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String relation = oldParent instanceof VirtualConversation ? "id = ?" : "parent_id = ?";
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(oldParent) + " SET parent_id = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + relation);
                int pos = 1;
                if (newParent instanceof VirtualConversation) {
                    stmt.setNull(pos++, 4);
                } else {
                    stmt.setInt(pos++, newParent.getId());
                }
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, oldParent instanceof VirtualConversation ? ((VirtualConversation)oldParent).getMessageId() : oldParent.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing new parent for children of item " + oldParent.getId(), e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveMetadata(MailItem item, String metadata) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET date = ?, size = ?, metadata = ?, mod_metadata = ?, change_date = ?, mod_content = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, (int)(item.getDate() / 1000L));
                stmt.setLong(pos++, item.getSize());
                stmt.setString(pos++, DbMailItem.checkMetadataLength(metadata));
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                stmt.setInt(pos++, item.getSavedSequence());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing metadata for mailbox " + item.getMailboxId() + ", item " + item.getId(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void persistCounts(MailItem item, String metadata) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET size = ?, unread = ?, metadata = ?, mod_metadata = ?, change_date = ?, mod_content = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setLong(pos++, item.getSize());
                stmt.setInt(pos++, item.getUnreadCount());
                stmt.setString(pos++, DbMailItem.checkMetadataLength(metadata));
                stmt.setInt(pos++, item.getModifiedSequence());
                if (item.getChangeDate() > 0L) {
                    stmt.setInt(pos++, (int)(item.getChangeDate() / 1000L));
                } else {
                    stmt.setNull(pos++, 4);
                }
                stmt.setInt(pos++, item.getSavedSequence());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing metadata for mailbox " + item.getMailboxId() + ", item " + item.getId(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveSubject(Note note) throws ServiceException {
        Mailbox mbox = note.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(note) + " SET date = ?, size = ?, subject = ?, mod_metadata = ?, change_date = ?, mod_content = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, (int)(note.getDate() / 1000L));
                stmt.setLong(pos++, note.getSize());
                stmt.setString(pos++, DbMailItem.checkSubjectLength(note.getSubject()));
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                stmt.setInt(pos++, mbox.getOperationChangeID());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, note.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing subject for mailbox " + note.getMailboxId() + ", note " + note.getId(), e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveName(MailItem item, int folderId, String metadata) throws ServiceException {
        String name;
        Mailbox mbox = item.getMailbox();
        String string = name = item.getName().equals("") ? null : item.getName();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbMailItem.checkNamingConstraint(mbox, folderId, name, item.getId());
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                boolean isFolder = item instanceof Folder;
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET date = ?, size = ?, flags = ?, name = ?, subject = ?," + "  folder_id = ?," + (isFolder ? " parent_id = ?," : "") + "  metadata = ?, mod_metadata = ?, change_date = ?, mod_content = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, (int)(item.getDate() / 1000L));
                stmt.setLong(pos++, item.getSize());
                stmt.setInt(pos++, item.getInternalFlagBitmask());
                stmt.setString(pos++, name);
                stmt.setString(pos++, name);
                stmt.setInt(pos++, folderId);
                if (isFolder) {
                    stmt.setInt(pos++, folderId);
                }
                stmt.setString(pos++, metadata);
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                stmt.setInt(pos++, mbox.getOperationChangeID());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                    throw MailServiceException.ALREADY_EXISTS(name, e, new ServiceException.Argument[0]);
                }
                throw ServiceException.FAILURE("writing name for mailbox " + item.getMailboxId() + ", item " + item.getId(), e);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveData(MailItem item, String subject, String sender, String metadata) throws ServiceException {
        String name;
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        String string = name = item.getName().equals("") ? null : item.getName();
        if (item instanceof Conversation) {
            subject = ((Conversation)item).getNormalizedSubject();
        } else if (item instanceof Message) {
            subject = ((Message)item).getNormalizedSubject();
        }
        DbMailItem.checkNamingConstraint(mbox, item.getFolderId(), name, item.getId());
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block15: {
                try {
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET type = ?, imap_id = ?, parent_id = ?, date = ?, size = ?, flags = ?," + "  blob_digest = ?, sender = ?, subject = ?, name = ?, metadata = ?," + "  mod_metadata = ?, change_date = ?, mod_content = ?, volume_id = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                    int pos = 1;
                    stmt.setByte(pos++, item.getType());
                    if (item.getImapUid() >= 0) {
                        stmt.setInt(pos++, item.getImapUid());
                    } else {
                        stmt.setNull(pos++, 4);
                    }
                    if (item.getParentId() <= 0) {
                        stmt.setNull(pos++, 4);
                    } else {
                        stmt.setInt(pos++, item.getParentId());
                    }
                    stmt.setInt(pos++, (int)(item.getDate() / 1000L));
                    stmt.setLong(pos++, item.getSize());
                    stmt.setInt(pos++, item.getInternalFlagBitmask());
                    stmt.setString(pos++, item.getDigest());
                    stmt.setString(pos++, DbMailItem.checkSenderLength(sender));
                    stmt.setString(pos++, DbMailItem.checkSubjectLength(subject));
                    stmt.setString(pos++, name);
                    stmt.setString(pos++, DbMailItem.checkMetadataLength(metadata));
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    stmt.setInt(pos++, item.getSavedSequence());
                    if (item.getLocator() != null) {
                        stmt.setString(pos++, item.getLocator());
                    } else {
                        stmt.setNull(pos++, -6);
                    }
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, item.getId());
                    stmt.executeUpdate();
                    if (!DbMailItem.areFlagsetsLoaded(mbox)) break block15;
                    DbMailItem.getFlagsetCache(conn, mbox).addTagset(item.getInternalFlagBitmask());
                }
                catch (SQLException e) {
                    if (Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) {
                        throw MailServiceException.ALREADY_EXISTS(item.getName(), e, new ServiceException.Argument[0]);
                    }
                    throw ServiceException.FAILURE("rewriting row data for mailbox " + item.getMailboxId() + ", item " + item.getId(), e);
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveBlobInfo(MailItem item) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET size = ?, blob_digest = ?, volume_id = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setLong(pos++, item.getSize());
                stmt.setString(pos++, item.getDigest());
                if (item.getLocator() != null) {
                    stmt.setString(pos++, item.getLocator());
                } else {
                    stmt.setNull(pos++, -6);
                }
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating blob info for mailbox " + mbox.getId() + ", item " + item.getId(), e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void openConversation(String hash, MailItem item) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String command = Db.supports(Db.Capability.REPLACE_INTO) ? "REPLACE" : "INSERT";
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement(command + " INTO " + DbMailItem.getConversationTableName(item) + "(" + mailbox_id + "hash, conv_id)" + " VALUES (" + (DebugConfig.disableMailboxGroups ? "" : "?, ") + "?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, hash);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (!Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) throw ServiceException.FAILURE("writing open conversation association for hash " + hash, e);
                try {
                    DbPool.closeStatement(stmt);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getConversationTableName(item) + " SET conv_id = ? WHERE " + IN_THIS_MAILBOX_AND + "hash = ?");
                    int pos = 1;
                    stmt.setInt(pos++, item.getId());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setString(pos++, hash);
                    stmt.executeUpdate();
                }
                catch (SQLException nested) {
                    throw ServiceException.FAILURE("updating open conversation association for hash " + hash, nested);
                }
                Object var9_12 = null;
                DbPool.closeStatement(stmt);
                return;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void closeConversation(String hash, MailItem item) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getConversationTableName(item) + " WHERE " + IN_THIS_MAILBOX_AND + "hash = ? AND conv_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, hash);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("closing open conversation association for hash " + hash, e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void closeOldConversations(Mailbox mbox, int beforeDate) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ZimbraLog.purge.debug("Closing conversations dated before %d.", beforeDate);
        try {
            block5: {
                try {
                    String mailboxJoin = DebugConfig.disableMailboxGroups ? "" : " AND mi.mailbox_id = open_conversation.mailbox_id";
                    stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getConversationTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "conv_id IN (" + "  SELECT id FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + "  WHERE mi.id = open_conversation.conv_id" + mailboxJoin + "  AND date < ?)");
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, beforeDate);
                    int numRows = stmt.executeUpdate();
                    if (numRows <= 0) break block5;
                    ZimbraLog.purge.info("Closed %d conversations dated before %d.", numRows, beforeDate);
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("closing open conversations dated before " + beforeDate, e);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void changeOpenTarget(String hash, MailItem oldTarget, int newTargetId) throws ServiceException {
        Mailbox mbox = oldTarget.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getConversationTableName(oldTarget) + " SET conv_id = ? WHERE " + IN_THIS_MAILBOX_AND + "hash = ? AND conv_id = ?");
                int pos = 1;
                stmt.setInt(pos++, newTargetId);
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, hash);
                stmt.setInt(pos++, oldTarget.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("switching open conversation association for item " + oldTarget.getId(), e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveDate(MailItem item) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET date = ?, mod_metadata = ?, change_date = ? WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, (int)(item.getDate() / 1000L));
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("setting IMAP UID for item " + item.getId(), e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void saveImapUid(MailItem item) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET imap_id = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                stmt.setInt(pos++, item.getImapUid());
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("setting IMAP UID for item " + item.getId(), e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void alterTag(MailItem item, Tag tag, boolean add) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        if (mbox != tag.getMailbox()) {
            throw MailServiceException.WRONG_MAILBOX();
        }
        if (tag.getId() == -10) {
            throw ServiceException.FAILURE("unread state must be updated with alterUnread()", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block13: {
                try {
                    boolean isFlag = tag instanceof Flag;
                    boolean altersModseq = !isFlag || (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) == 0L;
                    String column = isFlag ? "flags" : "tags";
                    String primaryUpdate = column + " = " + column + (add ? " + ?" : " - ?");
                    String updateChangeID = altersModseq ? ", mod_metadata = ?, change_date = ?" : "";
                    String precondition = (add ? "NOT " : "") + Db.bitmaskAND(column);
                    String relation = item instanceof VirtualConversation ? "id = ?" : (item instanceof Conversation ? "parent_id = ?" : (item instanceof Folder ? "folder_id = ?" : (item instanceof Flag ? Db.bitmaskAND("flags") : (item instanceof Tag ? Db.bitmaskAND("tags") : "id = ?"))));
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET " + primaryUpdate + updateChangeID + " WHERE " + IN_THIS_MAILBOX_AND + precondition + " AND " + relation);
                    int pos = 1;
                    stmt.setLong(pos++, tag.getBitmask());
                    if (altersModseq) {
                        stmt.setInt(pos++, mbox.getOperationChangeID());
                        stmt.setInt(pos++, mbox.getOperationTimestamp());
                    }
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setLong(pos++, tag.getBitmask());
                    if (item instanceof Tag) {
                        stmt.setLong(pos++, ((Tag)item).getBitmask());
                    } else if (item instanceof VirtualConversation) {
                        stmt.setInt(pos++, ((VirtualConversation)item).getMessageId());
                    } else {
                        stmt.setInt(pos++, item.getId());
                    }
                    stmt.executeUpdate();
                    if (tag instanceof Flag && DbMailItem.areFlagsetsLoaded(mbox)) {
                        DbMailItem.getFlagsetCache(conn, mbox).addTagset(item.getInternalFlagBitmask());
                        break block13;
                    }
                    if (!DbMailItem.areTagsetsLoaded(mbox)) break block13;
                    DbMailItem.getTagsetCache(conn, mbox).addTagset(item.getTagBitmask());
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("updating tag data for item " + item.getId(), e);
                }
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void alterTag(Tag tag, List<Integer> itemIDs, boolean add) throws ServiceException {
        if (itemIDs == null || itemIDs.isEmpty()) {
            return;
        }
        Mailbox mbox = tag.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block10: {
                try {
                    boolean isFlag = tag instanceof Flag;
                    boolean altersModseq = !isFlag || (tag.getBitmask() & (long)Flag.FLAG_SYSTEM) == 0L;
                    String column = isFlag ? "flags" : "tags";
                    String primaryUpdate = column + " = " + column + (add ? " + ?" : " - ?");
                    String updateChangeID = altersModseq ? ", mod_metadata = ?, change_date = ?" : "";
                    String precondition = (add ? "NOT " : "") + Db.bitmaskAND(column);
                    for (int i = 0; i < itemIDs.size(); i += Db.getINClauseBatchSize()) {
                        int count = Math.min(Db.getINClauseBatchSize(), itemIDs.size() - i);
                        stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(tag) + " SET " + primaryUpdate + updateChangeID + " WHERE " + IN_THIS_MAILBOX_AND + precondition + " AND " + DbUtil.whereIn("id", count));
                        int pos = 1;
                        stmt.setLong(pos++, tag.getBitmask());
                        if (altersModseq) {
                            stmt.setInt(pos++, mbox.getOperationChangeID());
                            stmt.setInt(pos++, mbox.getOperationTimestamp());
                        }
                        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                        stmt.setLong(pos++, tag.getBitmask());
                        for (int index = i; index < i + count; ++index) {
                            stmt.setInt(pos++, itemIDs.get(index));
                        }
                        stmt.executeUpdate();
                        stmt.close();
                        stmt = null;
                    }
                    if (tag instanceof Flag && DbMailItem.areFlagsetsLoaded(mbox)) {
                        DbMailItem.getFlagsetCache(conn, mbox).applyMask(tag.getBitmask(), add);
                        break block10;
                    }
                    if (!DbMailItem.areTagsetsLoaded(mbox)) break block10;
                    DbMailItem.getTagsetCache(conn, mbox).applyMask(tag.getBitmask(), add);
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("updating tag data for " + itemIDs.size() + " items: " + DbMailItem.getIdListForLogging(itemIDs), e);
                }
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void clearTag(Tag tag) throws ServiceException {
        Mailbox mbox = tag.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            block5: {
                try {
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(tag) + " SET tags = tags - ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + Db.bitmaskAND("tags"));
                    int pos = 1;
                    stmt.setLong(pos++, tag.getBitmask());
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setLong(pos++, tag.getBitmask());
                    stmt.executeUpdate();
                    if (!DbMailItem.areTagsetsLoaded(mbox)) break block5;
                    DbMailItem.getTagsetCache(conn, mbox).applyMask(tag.getTagBitmask(), false);
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("clearing all references to tag " + tag.getId(), e);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void alterUnread(MailItem item, boolean unread) throws ServiceException {
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String relation = item instanceof VirtualConversation ? "id = ?" : (item instanceof Conversation ? "parent_id = ?" : (item instanceof Folder ? "folder_id = ?" : (item instanceof Flag ? Db.bitmaskAND("flags") : (item instanceof Tag ? Db.bitmaskAND("tags") : "id = ?"))));
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(item) + " SET unread = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "unread = ? AND " + relation + "  AND " + DbMailItem.typeIn((byte)5));
                int pos = 1;
                stmt.setInt(pos++, unread ? 1 : 0);
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, unread ? 0 : 1);
                if (item instanceof Tag) {
                    stmt.setLong(pos++, ((Tag)item).getBitmask());
                } else if (item instanceof VirtualConversation) {
                    stmt.setInt(pos++, ((VirtualConversation)item).getMessageId());
                } else {
                    stmt.setInt(pos++, item.getId());
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating unread state for item " + item.getId(), e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void alterUnread(Mailbox mbox, List<Integer> itemIDs, boolean unread) throws ServiceException {
        if (itemIDs == null || itemIDs.isEmpty()) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                for (int i = 0; i < itemIDs.size(); i += Db.getINClauseBatchSize()) {
                    int count = Math.min(Db.getINClauseBatchSize(), itemIDs.size() - i);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET unread = ?, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "unread = ?" + "  AND " + DbUtil.whereIn("id", count) + "  AND " + DbMailItem.typeIn((byte)5));
                    int pos = 1;
                    stmt.setInt(pos++, unread ? 1 : 0);
                    stmt.setInt(pos++, mbox.getOperationChangeID());
                    stmt.setInt(pos++, mbox.getOperationTimestamp());
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, unread ? 0 : 1);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, itemIDs.get(index));
                    }
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("updating unread state for " + itemIDs.size() + " items: " + DbMailItem.getIdListForLogging(itemIDs), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static List<Integer> markDeletionTargets(Folder folder, Set<Integer> candidates) throws ServiceException {
        List<Integer> pos2;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int pos2;
            if (Db.supports(Db.Capability.MULTITABLE_UPDATE)) {
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(folder) + ", " + "(SELECT parent_id pid, COUNT(*) count FROM " + DbMailItem.getMailItemTableName(folder) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND parent_id IS NOT NULL GROUP BY parent_id) AS x" + " SET size = size - count, metadata = NULL, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = pid AND type = " + 4);
                pos2 = 1;
                pos2 = DbMailItem.setMailboxId(stmt, mbox, pos2);
                stmt.setInt(pos2++, folder.getId());
                stmt.setInt(pos2++, mbox.getOperationChangeID());
                stmt.setInt(pos2++, mbox.getOperationTimestamp());
                pos2 = DbMailItem.setMailboxId(stmt, mbox, pos2);
                stmt.executeUpdate();
                stmt.close();
            } else {
                stmt = conn.prepareStatement("SELECT parent_id, COUNT(*) FROM " + DbMailItem.getMailItemTableName(folder) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND parent_id IS NOT NULL" + " GROUP BY parent_id");
                pos2 = 1;
                pos2 = DbMailItem.setMailboxId(stmt, mbox, pos2);
                stmt.setInt(pos2++, folder.getId());
                rs = stmt.executeQuery();
                HashMap<Integer, ArrayList<Integer>> counts = new HashMap<Integer, ArrayList<Integer>>();
                while (rs.next()) {
                    int convId = rs.getInt(1);
                    int count = rs.getInt(2);
                    ArrayList<Integer> targets = (ArrayList<Integer>)counts.get(count);
                    if (targets == null) {
                        targets = new ArrayList<Integer>();
                        counts.put(count, targets);
                    }
                    targets.add(convId);
                }
                rs.close();
                stmt.close();
                for (Map.Entry update : counts.entrySet()) {
                    List convIDs = (List)update.getValue();
                    for (int i = 0; i < convIDs.size(); i += Db.getINClauseBatchSize()) {
                        int count = Math.min(Db.getINClauseBatchSize(), convIDs.size() - i);
                        stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(folder) + " SET size = size - ?, metadata = NULL, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count) + "  AND type = " + 4);
                        pos2 = 1;
                        stmt.setInt(pos2++, (Integer)update.getKey());
                        stmt.setInt(pos2++, mbox.getOperationChangeID());
                        stmt.setInt(pos2++, mbox.getOperationTimestamp());
                        pos2 = DbMailItem.setMailboxId(stmt, mbox, pos2);
                        for (int index = i; index < i + count; ++index) {
                            stmt.setInt(pos2++, (Integer)convIDs.get(index));
                        }
                        stmt.executeUpdate();
                        stmt.close();
                    }
                }
            }
            pos2 = DbMailItem.getPurgedConversations(mbox, candidates);
            Object var15_18 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("marking deletions for conversations crossing folder " + folder.getId(), e);
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return pos2;
    }

    public static List<Integer> markDeletionTargets(Mailbox mbox, List<Integer> ids, Set<Integer> candidates) throws ServiceException {
        if (ids == null) {
            return null;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String table = DbMailItem.getMailItemTableName(mbox);
                if (Db.supports(Db.Capability.MULTITABLE_UPDATE)) {
                    for (int i = 0; i < ids.size(); i += Db.getINClauseBatchSize()) {
                        int count = Math.min(Db.getINClauseBatchSize(), ids.size() - i);
                        stmt = conn.prepareStatement("UPDATE " + table + ", " + "(SELECT parent_id pid, COUNT(*) count FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count) + " AND parent_id IS NOT NULL GROUP BY parent_id) AS x" + " SET size = size - count, metadata = NULL, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + "id = pid AND type = " + 4);
                        int pos = 1;
                        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                        for (int index = i; index < i + count; ++index) {
                            stmt.setInt(pos++, ids.get(index));
                        }
                        stmt.setInt(pos++, mbox.getOperationChangeID());
                        stmt.setInt(pos++, mbox.getOperationTimestamp());
                        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                } else {
                    stmt = conn.prepareStatement("SELECT parent_id, COUNT(*) FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", ids.size()) + "AND parent_id IS NOT NULL" + " GROUP BY parent_id");
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int id : ids) {
                        stmt.setInt(pos++, id);
                    }
                    rs = stmt.executeQuery();
                    HashMap<Integer, ArrayList<Integer>> counts = new HashMap<Integer, ArrayList<Integer>>();
                    while (rs.next()) {
                        int convId = rs.getInt(1);
                        int count = rs.getInt(2);
                        ArrayList<Integer> targets = (ArrayList<Integer>)counts.get(count);
                        if (targets == null) {
                            targets = new ArrayList<Integer>();
                            counts.put(count, targets);
                        }
                        targets.add(convId);
                    }
                    rs.close();
                    stmt.close();
                    for (Map.Entry update : counts.entrySet()) {
                        stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET size = size - ?, metadata = NULL, mod_metadata = ?, change_date = ?" + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", ((List)update.getValue()).size()) + " AND type = " + 4);
                        pos = 1;
                        stmt.setInt(pos++, (Integer)update.getKey());
                        stmt.setInt(pos++, mbox.getOperationChangeID());
                        stmt.setInt(pos++, mbox.getOperationTimestamp());
                        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                        Iterator i$ = ((List)update.getValue()).iterator();
                        while (i$.hasNext()) {
                            int convId = (Integer)i$.next();
                            stmt.setInt(pos++, convId);
                        }
                        stmt.executeUpdate();
                        stmt.close();
                    }
                }
                Object var14_21 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("marking deletions for conversations touching " + ids.size() + " items: " + DbMailItem.getIdListForLogging(ids), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return DbMailItem.getPurgedConversations(mbox, candidates);
    }

    private static List<Integer> getPurgedConversations(Mailbox mbox, Set<Integer> candidates) throws ServiceException {
        ArrayList<Integer> arrayList;
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        ArrayList<Integer> purgedConvs = new ArrayList<Integer>();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Iterator<Integer> it = candidates.iterator();
            for (int i = 0; i < candidates.size(); i += Db.getINClauseBatchSize()) {
                int count = Math.min(Db.getINClauseBatchSize(), candidates.size() - i);
                stmt = conn.prepareStatement("SELECT id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count) + " AND size <= 0");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                for (int index = i; index < i + count; ++index) {
                    stmt.setInt(pos++, it.next());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    purgedConvs.add(rs.getInt(1));
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            arrayList = purgedConvs;
            Object var12_13 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting list of purged conversations", e);
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static void delete(MailItem item) throws ServiceException {
        DbMailItem.deleteContents(item);
        if (item instanceof VirtualConversation) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(item.getId());
        DbMailItem.delete(item.getMailbox(), ids);
    }

    public static void delete(Mailbox mbox, List<Integer> ids) throws ServiceException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        ArrayList<Integer> targets = new ArrayList<Integer>();
        for (int id : ids) {
            if (id <= 0) continue;
            targets.add(id);
        }
        if (targets.size() == 0) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        for (int i = 0; i < targets.size(); i += Db.getINClauseBatchSize()) {
            Object var10_11;
            try {
                try {
                    int count = Math.min(Db.getINClauseBatchSize(), targets.size() - i);
                    stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, (Integer)targets.get(index));
                    }
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("deleting " + ids.size() + " item(s): " + DbMailItem.getIdListForLogging(ids), e);
                }
                var10_11 = null;
            }
            catch (Throwable throwable) {
                var10_11 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
        }
    }

    public static void deleteContents(MailItem item) throws ServiceException {
        String target;
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        if (item instanceof VirtualConversation) {
            target = "id = ?";
        } else if (item instanceof Conversation) {
            target = "parent_id = ?";
        } else {
            if (item instanceof SearchFolder) {
                return;
            }
            if (item instanceof Folder) {
                target = "folder_id = ?";
            } else {
                return;
            }
        }
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getMailItemTableName(item) + " WHERE " + IN_THIS_MAILBOX_AND + target + " AND type NOT IN " + FOLDER_TYPES);
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item instanceof VirtualConversation ? ((VirtualConversation)item).getMessageId() : item.getId());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("deleting contents for " + MailItem.getNameForType(item) + " " + item.getId(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static void writeTombstones(Mailbox mbox, TypedIdList tombstones) throws ServiceException {
        if (tombstones == null || tombstones.isEmpty()) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        for (Map.Entry<Byte, List<Integer>> entry : tombstones) {
            byte type = entry.getKey();
            if (type == 4 || type == 12) continue;
            StringBuilder ids = new StringBuilder();
            for (Integer id : entry.getValue()) {
                ids.append(ids.length() == 0 ? "" : ",").append(id);
                if (ids.length() <= 65484) continue;
                DbMailItem.writeTombstone(mbox, type, ids.toString());
                ids.setLength(0);
            }
            DbMailItem.writeTombstone(mbox, type, ids.toString());
        }
    }

    private static void writeTombstone(Mailbox mbox, byte type, String ids) throws ServiceException {
        if (ids == null || ids.equals("")) {
            return;
        }
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement("INSERT INTO " + DbMailItem.getTombstoneTableName(mbox) + "(" + mailbox_id + "sequence, date, type, ids)" + " VALUES (" + MAILBOX_ID_VALUE + "?, ?, ?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, mbox.getOperationChangeID());
                stmt.setInt(pos++, mbox.getOperationTimestamp());
                stmt.setByte(pos++, type);
                stmt.setString(pos++, ids);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing tombstones for " + MailItem.getNameForType(type) + "(s): " + ids, e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static TypedIdList readTombstones(Mailbox mbox, long lastSync) throws ServiceException {
        TypedIdList typedIdList;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        TypedIdList tombstones = new TypedIdList();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT type, ids FROM " + DbMailItem.getTombstoneTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "sequence > ? AND ids IS NOT NULL" + " ORDER BY sequence");
            Db.getInstance().enableStreaming(stmt);
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setLong(pos++, lastSync);
            rs = stmt.executeQuery();
            while (rs.next()) {
                byte type = rs.getByte(1);
                String row = rs.getString(2);
                if (row == null || row.equals("")) continue;
                for (String entry : row.split(",")) {
                    try {
                        tombstones.add(type, Integer.parseInt(entry));
                    }
                    catch (NumberFormatException nfe) {
                        ZimbraLog.sync.warn("unparseable TOMBSTONE entry: " + entry);
                    }
                }
            }
            typedIdList = tombstones;
            Object var16_16 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("reading tombstones since change: " + lastSync, e);
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return typedIdList;
    }

    public static int purgeTombstones(Mailbox mbox, int beforeDate) throws ServiceException {
        int n;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM " + DbMailItem.getTombstoneTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "date < ?");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setLong(pos++, beforeDate);
            int numRows = stmt.executeUpdate();
            if (numRows > 0) {
                ZimbraLog.mailbox.info("Purged %d tombstones dated before %d.", numRows, beforeDate);
            }
            n = numRows;
            Object var8_8 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("purging tombstones with date before " + beforeDate, null);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeStatement(stmt);
        return n;
    }

    private static String typeIn(byte type) {
        if (type == 1) {
            return "type IN (1,2,13)";
        }
        if (type == 5) {
            return "type IN (5,16)";
        }
        if (type == 8) {
            return "type IN (8,14)";
        }
        return "type = " + type;
    }

    public static Mailbox.MailboxData getFoldersAndTags(Mailbox mbox, Map<MailItem.UnderlyingData, Long> folderData, Map<MailItem.UnderlyingData, Long> tagData, boolean reload) throws ServiceException {
        Mailbox.MailboxData mailboxData;
        String table;
        ResultSet rs;
        PreparedStatement stmt;
        DbPool.Connection conn;
        block20: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            conn = mbox.getOperationConnection();
            stmt = null;
            rs = null;
            table = DbMailItem.getMailItemTableName(mbox, "mi");
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + table + " WHERE " + IN_THIS_MAILBOX_AND + "type IN " + FOLDER_AND_TAG_TYPES);
            DbMailItem.setMailboxId(stmt, mbox, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
                if (MailItem.isAcceptableType((byte)1, data.type)) {
                    folderData.put(data, -1L);
                } else if (MailItem.isAcceptableType((byte)3, data.type)) {
                    tagData.put(data, -1L);
                }
                rs.getInt(11);
                reload |= rs.wasNull();
            }
            rs.close();
            for (MailItem.UnderlyingData data : folderData.keySet()) {
                if (data.parentId == data.folderId) continue;
                stmt.close();
                stmt = conn.prepareStatement("UPDATE " + table + " SET parent_id = folder_id" + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, data.id);
                stmt.executeUpdate();
                data.parentId = data.folderId;
                ZimbraLog.mailbox.info("correcting PARENT_ID column for " + MailItem.getNameForType(data.type) + " " + data.id);
            }
            if (reload) break block20;
            Iterator<MailItem.UnderlyingData> i$ = null;
            Object var21_18 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return i$;
        }
        try {
            HashMap<Integer, MailItem.UnderlyingData> lookup = new HashMap<Integer, MailItem.UnderlyingData>(folderData.size() + tagData.size());
            for (Map.Entry<MailItem.UnderlyingData, Long> entry : folderData.entrySet()) {
                MailItem.UnderlyingData data = entry.getKey();
                lookup.put(data.id, data);
                data.unreadCount = 0;
                data.size = 0;
                entry.setValue(0L);
            }
            for (MailItem.UnderlyingData data : tagData.keySet()) {
                lookup.put(data.id, data);
                data.unreadCount = 0;
                data.size = 0;
            }
            rs.close();
            stmt.close();
            Mailbox.MailboxData mbd = new Mailbox.MailboxData();
            stmt = conn.prepareStatement("SELECT folder_id, type, tags, COUNT(*), SUM(unread), SUM(size) FROM " + table + " WHERE " + IN_THIS_MAILBOX_AND + "type NOT IN " + NON_SEARCHABLE_TYPES + " GROUP BY folder_id, type, tags");
            DbMailItem.setMailboxId(stmt, mbox, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                byte type = rs.getByte(2);
                int count = rs.getInt(4);
                int unread = rs.getInt(5);
                long size = rs.getLong(6);
                if (type == 6) {
                    mbd.contacts += count;
                }
                mbd.size += size;
                MailItem.UnderlyingData data = (MailItem.UnderlyingData)lookup.get(rs.getInt(1));
                assert (data != null);
                data.unreadCount += unread;
                data.size += (long)count;
                Long folderSize = folderData.get(data);
                folderData.put(data, folderSize == null ? size : folderSize + size);
                long tags = rs.getLong(3);
                for (int i = 0; tags != 0L && i < 62; ++i) {
                    if ((tags & 1L << i) == 0L) continue;
                    data = (MailItem.UnderlyingData)lookup.get(i + 64);
                    if (data != null) {
                        data.unreadCount += unread;
                    }
                    tags &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            rs.close();
            stmt.close();
            stmt = conn.prepareStatement("SELECT mi.folder_id, SUM(rev.size) FROM " + table + ", " + DbMailItem.getRevisionTableName(mbox, "rev") + " WHERE mi.id = rev.item_id" + (DebugConfig.disableMailboxGroups ? "" : " AND rev.mailbox_id = ? AND mi.mailbox_id = rev.mailbox_id") + " GROUP BY folder_id");
            DbMailItem.setMailboxId(stmt, mbox, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                MailItem.UnderlyingData data = (MailItem.UnderlyingData)lookup.get(rs.getInt(1));
                assert (data != null);
                Long folderSize = folderData.get(data);
                folderData.put(data, folderSize == null ? rs.getLong(2) : folderSize + rs.getLong(2));
            }
            mailboxData = mbd;
            Object var21_19 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching folder data for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return mailboxData;
    }

    public static List<MailItem.UnderlyingData> getByType(Mailbox mbox, byte type, SortBy sort) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, " mi") + " WHERE " + IN_THIS_MAILBOX_AND + DbMailItem.typeIn(type) + DbSearch.sortQuery(sort));
            if (type == 5) {
                Db.getInstance().enableStreaming(stmt);
            }
            DbMailItem.setMailboxId(stmt, mbox, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(DbMailItem.constructItem(rs));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (type == 4) {
                DbMailItem.completeConversations(mbox, result);
            }
            arrayList = result;
            Object var9_9 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching items of type " + type, e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<MailItem.UnderlyingData> getByParent(MailItem parent) throws ServiceException {
        return DbMailItem.getByParent(parent, SortBy.DATE_DESCENDING);
    }

    public static List<MailItem.UnderlyingData> getByParent(MailItem parent, SortBy sort) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        Mailbox mbox = parent.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(parent.getMailbox(), " mi") + " WHERE " + IN_THIS_MAILBOX_AND + "parent_id = ? " + DbSearch.sortQuery(sort));
            if (parent.getSize() > 10000L) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, parent.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
                if (Mailbox.isCachedType(data.type)) {
                    throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
                }
                result.add(data);
            }
            arrayList = result;
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching children of item " + parent.getId(), e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<MailItem.UnderlyingData> getUnreadMessages(MailItem relativeTo) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        Mailbox mbox = relativeTo.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String relation = relativeTo instanceof VirtualConversation ? "id = ?" : (relativeTo instanceof Conversation ? "parent_id = ?" : (relativeTo instanceof Folder ? "folder_id = ?" : (relativeTo instanceof Flag ? Db.bitmaskAND("flags") : (relativeTo instanceof Tag ? Db.bitmaskAND("tags") : "id = ?"))));
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(relativeTo.getMailbox(), " mi") + " WHERE " + IN_THIS_MAILBOX_AND + "unread > 0 AND " + relation + " AND type NOT IN " + NON_SEARCHABLE_TYPES);
            if (relativeTo.getUnreadCount() > 10000) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            if (relativeTo instanceof Tag) {
                stmt.setLong(pos++, ((Tag)relativeTo).getBitmask());
            } else if (relativeTo instanceof VirtualConversation) {
                stmt.setInt(pos++, ((VirtualConversation)relativeTo).getMessageId());
            } else {
                stmt.setInt(pos++, relativeTo.getId());
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
                if (Mailbox.isCachedType(data.type)) {
                    throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
                }
                result.add(data);
            }
            arrayList = result;
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching unread messages for item " + relativeTo.getId(), e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<MailItem.UnderlyingData> getByFolder(Folder folder, byte type, SortBy sort) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(folder.getMailbox(), " mi") + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND " + DbMailItem.typeIn(type) + DbSearch.sortQuery(sort));
            if (folder.getSize() > 10000L && type == 5) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folder.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(DbMailItem.constructItem(rs));
            }
            arrayList = result;
            Object var11_11 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching items in folder " + folder.getId(), e);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static MailItem.UnderlyingData getById(Mailbox mbox, int id, byte type) throws ServiceException {
        MailItem.UnderlyingData underlyingData;
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw MailItem.noSuchItem(id, type);
            }
            MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
            if (!MailItem.isAcceptableType(type, data.type)) {
                throw MailItem.noSuchItem(id, type);
            }
            if (data.type == 4) {
                DbMailItem.completeConversation(mbox, data);
            }
            underlyingData = data;
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching item " + id, e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return underlyingData;
    }

    public static MailItem.UnderlyingData getByImapId(Mailbox mbox, int imapId, int folderId) throws ServiceException {
        MailItem.UnderlyingData underlyingData;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND imap_id = ?");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, imapId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw MailServiceException.NO_SUCH_ITEM(imapId);
            }
            MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
            if (data.type == 4) {
                throw MailServiceException.NO_SUCH_ITEM(imapId);
            }
            underlyingData = data;
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching item " + imapId, e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return underlyingData;
    }

    public static List<MailItem.UnderlyingData> getById(Mailbox mbox, Collection<Integer> ids, byte type) throws ServiceException {
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        if (ids.isEmpty()) {
            return result;
        }
        ArrayList<MailItem.UnderlyingData> conversations = new ArrayList<MailItem.UnderlyingData>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Iterator<Integer> it = ids.iterator();
        for (int i = 0; i < ids.size(); i += Db.getINClauseBatchSize()) {
            Object var14_15;
            try {
                try {
                    int count = Math.min(Db.getINClauseBatchSize(), ids.size() - i);
                    stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setInt(pos++, it.next());
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
                        if (!MailItem.isAcceptableType(type, data.type)) {
                            throw MailItem.noSuchItem(data.id, type);
                        }
                        if (Mailbox.isCachedType(data.type)) {
                            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
                        }
                        if (data.type == 4) {
                            conversations.add(data);
                        }
                        result.add(data);
                    }
                    var14_15 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("fetching " + ids.size() + " items: " + DbMailItem.getIdListForLogging(ids), e);
                }
            }
            catch (Throwable throwable) {
                var14_15 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
        }
        if (!conversations.isEmpty()) {
            DbMailItem.completeConversations(mbox, conversations);
        }
        return result;
    }

    public static MailItem.UnderlyingData getByName(Mailbox mbox, int folderId, String name, byte type) throws ServiceException {
        MailItem.UnderlyingData underlyingData;
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND " + DbMailItem.typeIn(type) + " AND " + Db.equalsSTRING("name"));
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folderId);
            stmt.setString(pos++, name.toUpperCase());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw MailItem.noSuchItem(-1, type);
            }
            MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
            if (!MailItem.isAcceptableType(type, data.type)) {
                throw MailItem.noSuchItem(data.id, type);
            }
            if (data.type == 4) {
                DbMailItem.completeConversation(mbox, data);
            }
            underlyingData = data;
            Object var11_11 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching item by name ('" + name + "' in folder " + folderId + ")", e);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return underlyingData;
    }

    public static MailItem.UnderlyingData getByHash(Mailbox mbox, String hash) throws ServiceException {
        MailItem.UnderlyingData underlyingData;
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            DbPool.Connection conn = mbox.getOperationConnection();
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + ", " + DbMailItem.getConversationTableName(mbox, "oc") + " WHERE oc.hash = ? AND mi.id = oc.conv_id" + (DebugConfig.disableMailboxGroups ? "" : " AND oc.mailbox_id = ? AND mi.mailbox_id = oc.mailbox_id"));
            int pos = 1;
            stmt.setString(pos++, hash);
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            rs = stmt.executeQuery();
            if (rs.next()) break block7;
            MailItem.UnderlyingData underlyingData2 = null;
            Object var9_9 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return underlyingData2;
        }
        try {
            MailItem.UnderlyingData data = DbMailItem.constructItem(rs);
            if (data.type == 4) {
                DbMailItem.completeConversation(mbox, data);
            }
            underlyingData = data;
            Object var9_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching conversation for hash " + hash, e);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return underlyingData;
    }

    public static Pair<List<Integer>, TypedIdList> getModifiedItems(Mailbox mbox, byte type, long lastSync, Set<Integer> visible) throws ServiceException {
        Pair<List<Integer>, TypedIdList> pair;
        if (Mailbox.isCachedType(type)) {
            throw ServiceException.INVALID_REQUEST("folders and tags must be retrieved from cache", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<Integer> modified = new ArrayList<Integer>();
        TypedIdList missed = new TypedIdList();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String typeConstraint = type == -1 ? "type NOT IN (1,2,13,3,4)" : DbMailItem.typeIn(type);
            stmt = conn.prepareStatement("SELECT id, type, folder_id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "mod_metadata > ? AND " + typeConstraint + " ORDER BY mod_metadata, id");
            if (type == 5) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setLong(pos++, lastSync);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (visible == null || visible.contains(rs.getInt(3))) {
                    modified.add(rs.getInt(1));
                    continue;
                }
                missed.add(rs.getByte(2), rs.getInt(1));
            }
            pair = new Pair<List<Integer>, TypedIdList>(modified, missed);
            Object var14_13 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting items modified since " + lastSync, e);
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return pair;
    }

    public static void completeConversation(Mailbox mbox, MailItem.UnderlyingData data) throws ServiceException {
        DbMailItem.completeConversations(mbox, Arrays.asList(data));
    }

    private static void completeConversations(Mailbox mbox, List<MailItem.UnderlyingData> convData) throws ServiceException {
        if (convData == null || convData.isEmpty()) {
            return;
        }
        for (MailItem.UnderlyingData data : convData) {
            if (data.type == 4) continue;
            throw ServiceException.FAILURE("attempting to complete a non-conversation", null);
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        HashMap<Integer, MailItem.UnderlyingData> conversations = new HashMap<Integer, MailItem.UnderlyingData>(Db.getINClauseBatchSize() * 3 / 2);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (int i = 0; i < convData.size(); i += Db.getINClauseBatchSize()) {
            Object var12_13;
            try {
                try {
                    int count = Math.min(Db.getINClauseBatchSize(), convData.size() - i);
                    stmt = conn.prepareStatement("SELECT parent_id, unread, flags, tags FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("parent_id", count));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        MailItem.UnderlyingData data = convData.get(index);
                        stmt.setInt(pos++, data.id);
                        conversations.put(data.id, data);
                        data.unreadCount = 0;
                        data.flags = 0;
                        data.tags = 0;
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        MailItem.UnderlyingData data = (MailItem.UnderlyingData)conversations.get(rs.getInt(1));
                        assert (data != null);
                        data.unreadCount += rs.getInt(2);
                        data.flags |= rs.getInt(3);
                        data.tags |= rs.getLong(4);
                    }
                    var12_13 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("completing conversation data", e);
                }
            }
            catch (Throwable throwable) {
                var12_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            conversations.clear();
        }
    }

    public static MailItem.PendingDelete getLeafNodes(Folder folder) throws ServiceException {
        MailItem.PendingDelete pendingDelete;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        MailItem.PendingDelete info = new MailItem.PendingDelete();
        int folderId = folder.getId();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT id, size, type, unread, folder_id, parent_id, blob_digest, mod_content, mod_metadata, flags, index_id, volume_id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND type NOT IN " + FOLDER_TYPES);
            if (folder.getSize() > 10000L) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folderId);
            rs = stmt.executeQuery();
            info.rootId = folderId;
            info.size = 0L;
            List<Integer> versionedIds = DbMailItem.accumulateLeafNodes(info, mbox, rs);
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            DbMailItem.accumulateLeafRevisions(info, mbox, versionedIds);
            info.itemIds.add(folder.getType(), folderId);
            pendingDelete = info;
            Object var11_11 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching list of items within item " + folder.getId(), e);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return pendingDelete;
    }

    public static MailItem.PendingDelete getLeafNodes(Mailbox mbox, List<Folder> folders, int before, boolean globalMessages, Boolean unread, boolean useChangeDate) throws ServiceException {
        MailItem.PendingDelete pendingDelete;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        MailItem.PendingDelete info = new MailItem.PendingDelete();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dateColumn = useChangeDate ? "change_date" : "date";
            String constraint = globalMessages ? dateColumn + " < ? AND " + DbMailItem.typeIn((byte)5) : dateColumn + " < ? AND type NOT IN " + NON_SEARCHABLE_TYPES + " AND " + DbUtil.whereIn("folder_id", folders.size());
            if (unread != null) {
                constraint = constraint + " AND unread = ?";
            }
            stmt = conn.prepareStatement("SELECT id, size, type, unread, folder_id, parent_id, blob_digest, mod_content, mod_metadata, flags, index_id, volume_id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + constraint);
            if (globalMessages || DbMailItem.getTotalFolderSize(folders) > 10000) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, before);
            if (!globalMessages) {
                for (Folder folder : folders) {
                    stmt.setInt(pos++, folder.getId());
                }
            }
            if (unread != null) {
                stmt.setBoolean(pos++, unread);
            }
            rs = stmt.executeQuery();
            info.rootId = 0;
            info.size = 0L;
            List<Integer> versionedIds = DbMailItem.accumulateLeafNodes(info, mbox, rs);
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            DbMailItem.accumulateLeafRevisions(info, mbox, versionedIds);
            pendingDelete = info;
            Object var16_16 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching list of items for purge", e);
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return pendingDelete;
    }

    private static int getTotalFolderSize(Collection<Folder> folders) {
        int totalSize = 0;
        if (folders != null) {
            for (Folder folder : folders) {
                totalSize = (int)((long)totalSize + folder.getSize());
            }
        }
        return totalSize;
    }

    public static MailItem.PendingDelete getImapDeleted(Mailbox mbox, Set<Folder> folders) throws ServiceException {
        MailItem.PendingDelete pendingDelete;
        Set<Long> flagsets;
        ResultSet rs;
        PreparedStatement stmt;
        DbPool.Connection conn;
        MailItem.PendingDelete info;
        block12: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            info = new MailItem.PendingDelete();
            if (folders != null && folders.isEmpty()) {
                return info;
            }
            conn = mbox.getOperationConnection();
            stmt = null;
            rs = null;
            flagsets = DbMailItem.getFlagsetCache(conn, mbox).getMatchingTagsets(Flag.BITMASK_DELETED, Flag.BITMASK_DELETED);
            if (flagsets == null || !flagsets.isEmpty()) break block12;
            MailItem.PendingDelete pendingDelete2 = info;
            Object var14_10 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return pendingDelete2;
        }
        try {
            String flagconstraint = flagsets == null ? "" : " AND " + DbUtil.whereIn("flags", flagsets.size());
            String folderconstraint = folders == null ? "" : " AND " + DbUtil.whereIn("folder_id", folders.size());
            stmt = conn.prepareStatement("SELECT id, size, type, unread, folder_id, parent_id, blob_digest, mod_content, mod_metadata, flags, index_id, volume_id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "type IN " + IMAP_TYPES + flagconstraint + folderconstraint);
            if (DbMailItem.getTotalFolderSize(folders) > 10000) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            if (flagsets != null) {
                Iterator<Comparable<Long>> i$ = flagsets.iterator();
                while (i$.hasNext()) {
                    long flags = (Long)i$.next();
                    stmt.setInt(pos++, (int)flags);
                }
            }
            if (folders != null) {
                for (Folder folder : folders) {
                    stmt.setInt(pos++, folder.getId());
                }
            }
            rs = stmt.executeQuery();
            info.rootId = 0;
            info.size = 0L;
            List<Integer> versionedIds = DbMailItem.accumulateLeafNodes(info, mbox, rs);
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            DbMailItem.accumulateLeafRevisions(info, mbox, versionedIds);
            pendingDelete = info;
            Object var14_11 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching list of \\Deleted items for purge", e);
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return pendingDelete;
    }

    private static List<Integer> accumulateLeafNodes(MailItem.PendingDelete info, Mailbox mbox, ResultSet rs) throws SQLException, ServiceException {
        StoreManager sm = StoreManager.getInstance();
        ArrayList<Integer> versioned = new ArrayList<Integer>();
        while (rs.next()) {
            boolean shared;
            int flags;
            Integer folderId;
            LocationCount count;
            int revision = rs.getInt(8);
            int modMetadata = rs.getInt(9);
            if (!mbox.checkItemChangeID(modMetadata, revision)) {
                info.incomplete = true;
                continue;
            }
            int id = rs.getInt(1);
            long size = rs.getLong(2);
            byte type = rs.getByte(3);
            Integer item = new Integer(id);
            info.itemIds.add(type, item);
            info.size += size;
            if (rs.getBoolean(4)) {
                info.unreadIds.add(item);
            }
            boolean isMessage = false;
            switch (type) {
                case 6: {
                    ++info.contacts;
                    break;
                }
                case 5: 
                case 16: {
                    isMessage = true;
                }
            }
            if (isMessage) {
                int parentId = rs.getInt(6);
                if (rs.wasNull() || parentId <= 0) {
                    info.itemIds.add((byte)12, -id);
                } else {
                    info.modifiedIds.add(parentId);
                }
            }
            if ((count = info.messages.get(folderId = Integer.valueOf(rs.getInt(5)))) == null) {
                info.messages.put(folderId, new LocationCount(1, size));
            } else {
                count.increment(1, size);
            }
            String blobDigest = rs.getString(7);
            if (blobDigest != null) {
                info.blobDigests.add(blobDigest);
                String locator = rs.getString(12);
                try {
                    MailboxBlob mblob = sm.getMailboxBlob(mbox, id, revision, locator);
                    if (mblob == null) {
                        sLog.warn("missing blob for id: " + id + ", change: " + revision);
                    } else {
                        info.blobs.add(mblob);
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (((flags = rs.getInt(10)) & Flag.BITMASK_VERSIONED) != 0) {
                versioned.add(id);
            }
            String indexId = rs.getString(11);
            boolean indexed = !rs.wasNull();
            if (!indexed) continue;
            if (info.sharedIndex == null) {
                info.sharedIndex = new HashSet<String>();
            }
            boolean bl = shared = (flags & Flag.BITMASK_COPIED) != 0;
            if (!shared) {
                info.indexIds.add(indexId);
                continue;
            }
            info.sharedIndex.add(indexId);
        }
        return versioned;
    }

    private static void accumulateLeafRevisions(MailItem.PendingDelete info, Mailbox mbox, List<Integer> versioned) throws ServiceException {
        if (versioned == null || versioned.size() == 0) {
            return;
        }
        DbPool.Connection conn = mbox.getOperationConnection();
        StoreManager sm = StoreManager.getInstance();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT mi.id, mi.folder_id, rev.size, rev.mod_content, rev.volume_id, rev.blob_digest  FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + ", " + DbMailItem.getRevisionTableName(mbox, "rev") + " WHERE mi.id = rev.item_id AND " + DbUtil.whereIn("mi.id", versioned.size()) + (DebugConfig.disableMailboxGroups ? "" : " AND mi.mailbox_id = ? AND mi.mailbox_id = rev.mailbox_id"));
                int pos = 1;
                for (int vid : versioned) {
                    stmt.setInt(pos++, vid);
                }
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String blobDigest;
                    Integer folderId = rs.getInt(2);
                    LocationCount count = info.messages.get(folderId);
                    if (count == null) {
                        info.messages.put(folderId, new LocationCount(0, rs.getLong(3)));
                    } else {
                        count.increment(0, rs.getLong(3));
                    }
                    if ((blobDigest = rs.getString(6)) == null) continue;
                    info.blobDigests.add(blobDigest);
                    try {
                        MailboxBlob mblob = sm.getMailboxBlob(mbox, rs.getInt(1), rs.getInt(4), rs.getString(5));
                        if (mblob == null) {
                            sLog.error("missing blob for id: " + rs.getInt(1) + ", change: " + rs.getInt(4));
                            continue;
                        }
                        info.blobs.add(mblob);
                    }
                    catch (Exception e1) {}
                }
                Object var13_15 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting version deletion info for items: " + versioned, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
    }

    public static String getBlobDigest(Mailbox mbox, int itemId) throws ServiceException {
        String string;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT blob_digest  FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, itemId);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
            Object var8_8 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("unable to get blob digest for id " + itemId, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return string;
    }

    public static void resolveSharedIndex(Mailbox mbox, MailItem.PendingDelete info) throws ServiceException {
        if (info.sharedIndex == null || info.sharedIndex.isEmpty()) {
            return;
        }
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<String> indexIDs = new ArrayList<String>(info.sharedIndex);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                for (int i = 0; i < indexIDs.size(); i += Db.getINClauseBatchSize()) {
                    int count = Math.min(Db.getINClauseBatchSize(), indexIDs.size() - i);
                    stmt = conn.prepareStatement("SELECT index_id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("index_id", count));
                    int pos = 1;
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    for (int index = i; index < i + count; ++index) {
                        stmt.setString(pos++, (String)indexIDs.get(index));
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        info.sharedIndex.remove(rs.getString(1));
                    }
                    rs.close();
                    rs = null;
                    stmt.close();
                    stmt = null;
                }
                info.indexIds.addAll(info.sharedIndex);
                info.sharedIndex.clear();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("resolving shared index entries: " + info.rootId, e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
    }

    public static List<ImapMessage> loadImapFolder(Folder folder) throws ServiceException {
        ArrayList<ImapMessage> arrayList;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<ImapMessage> result = new ArrayList<ImapMessage>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.imap_id, mi.unread, mi.flags, mi.tags FROM " + DbMailItem.getMailItemTableName(folder.getMailbox(), " mi") + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND type IN " + IMAP_TYPES);
            if (folder.getSize() > 10000L) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folder.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                int flags = rs.getBoolean(4) ? Flag.BITMASK_UNREAD | rs.getInt(5) : rs.getInt(5);
                result.add(new ImapMessage(rs.getInt(1), rs.getByte(2), rs.getInt(3), flags, rs.getLong(6)));
            }
            arrayList = result;
            Object var9_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("loading IMAP folder data: " + folder.getPath(), e);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static int countImapRecent(Folder folder, int uidCutoff) throws ServiceException {
        int n;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + DbMailItem.getMailItemTableName(folder.getMailbox()) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND type IN " + IMAP_TYPES + " AND (imap_id IS NULL OR imap_id = 0 OR imap_id > ?)");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folder.getId());
            stmt.setInt(pos++, uidCutoff);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : 0;
            Object var9_9 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("counting IMAP \\Recent messages: " + folder.getPath(), e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return n;
    }

    public static List<Pop3Message> loadPop3Folder(Folder folder, Date popSince) throws ServiceException {
        ArrayList<Pop3Message> arrayList;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        long popDate = popSince == null ? -1L : Math.max(popSince.getTime(), -1L);
        ArrayList<Pop3Message> result = new ArrayList<Pop3Message>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dateConstraint = popDate < 0L ? "" : " AND date > ?";
            stmt = conn.prepareStatement("SELECT mi.id, mi.size, mi.blob_digest FROM " + DbMailItem.getMailItemTableName(mbox, " mi") + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ? AND type IN " + POP3_TYPES + " AND NOT " + Db.bitmaskAND("flags", Flag.BITMASK_DELETED) + dateConstraint);
            if (folder.getSize() > 10000L) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folder.getId());
            if (popDate >= 0L) {
                stmt.setInt(pos++, (int)(popDate / 1000L));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(new Pop3Message(rs.getInt(1), rs.getLong(2), rs.getString(3)));
            }
            arrayList = result;
            Object var13_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("loading POP3 folder data: " + folder.getPath(), e);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<MailItem.UnderlyingData> getRevisionInfo(MailItem item) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<MailItem.UnderlyingData> dlist = new ArrayList<MailItem.UnderlyingData>();
        if (!item.isTagged(-13)) {
            return dlist;
        }
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT date, size, volume_id, blob_digest, name, metadata, mod_metadata, change_date, mod_content FROM " + DbMailItem.getRevisionTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + "item_id = ?" + " ORDER BY version");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, item.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                dlist.add(DbMailItem.constructRevision(rs, item));
            }
            arrayList = dlist;
            Object var9_9 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting old revisions for item: " + item.getId(), e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<Integer> listByFolder(Folder folder, byte type, boolean descending) throws ServiceException {
        ArrayList<Integer> arrayList;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        boolean allTypes = type == -1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String typeConstraint = allTypes ? "" : "type = ? AND ";
            stmt = conn.prepareStatement("SELECT id FROM " + DbMailItem.getMailItemTableName(folder) + " WHERE " + IN_THIS_MAILBOX_AND + typeConstraint + "folder_id = ?" + " ORDER BY date" + (descending ? " DESC" : ""));
            if (type == 5 && folder.getSize() > 10000L) {
                Db.getInstance().enableStreaming(stmt);
            }
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            if (!allTypes) {
                stmt.setByte(pos++, type);
            }
            stmt.setInt(pos++, folder.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            arrayList = result;
            Object var13_13 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching item list for folder " + folder.getId(), e);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static TypedIdList listByFolder(Folder folder, boolean descending) throws ServiceException {
        TypedIdList typedIdList;
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        TypedIdList result = new TypedIdList();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT id, type FROM " + DbMailItem.getMailItemTableName(folder) + " WHERE " + IN_THIS_MAILBOX_AND + "folder_id = ?" + " ORDER BY date" + (descending ? " DESC" : ""));
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, folder.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(rs.getByte(2), rs.getInt(1));
            }
            typedIdList = result;
            Object var10_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching item list for folder " + folder.getId(), e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return typedIdList;
    }

    private static MailItem.UnderlyingData constructItem(ResultSet rs) throws SQLException {
        return DbMailItem.constructItem(rs, 0);
    }

    static MailItem.UnderlyingData constructItem(ResultSet rs, int offset) throws SQLException {
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = rs.getInt(1 + offset);
        data.type = rs.getByte(2 + offset);
        data.parentId = rs.getInt(3 + offset);
        data.folderId = rs.getInt(4 + offset);
        data.indexId = rs.getString(5 + offset);
        if (rs.wasNull()) {
            data.indexId = null;
        }
        data.imapId = rs.getInt(6 + offset);
        if (rs.wasNull()) {
            data.imapId = -1;
        }
        data.date = rs.getInt(7 + offset);
        data.size = rs.getLong(8 + offset);
        data.locator = rs.getString(9 + offset);
        data.setBlobDigest(rs.getString(10 + offset));
        data.unreadCount = rs.getInt(11 + offset);
        data.flags = rs.getInt(12 + offset);
        data.tags = rs.getLong(13 + offset);
        data.subject = rs.getString(14 + offset);
        data.name = rs.getString(15 + offset);
        data.metadata = rs.getString(16 + offset);
        data.modMetadata = rs.getInt(17 + offset);
        data.modContent = rs.getInt(19 + offset);
        data.dateChanged = rs.getInt(18 + offset);
        if (data.parentId == 0) {
            data.parentId = -1;
        }
        if (data.dateChanged == 0) {
            data.dateChanged = -1;
        }
        return data;
    }

    private static MailItem.UnderlyingData constructRevision(ResultSet rs, MailItem item) throws SQLException {
        MailItem.UnderlyingData data = new MailItem.UnderlyingData();
        data.id = item.getId();
        data.type = item.getType();
        data.parentId = item.getParentId();
        data.folderId = item.getFolderId();
        data.indexId = null;
        data.imapId = -1;
        data.date = rs.getInt(1);
        data.size = rs.getLong(2);
        data.locator = rs.getString(3);
        data.setBlobDigest(rs.getString(4));
        data.unreadCount = item.getUnreadCount();
        data.flags = item.getInternalFlagBitmask() | Flag.BITMASK_UNCACHED;
        data.tags = item.getTagBitmask();
        data.subject = item.getSubject();
        data.name = rs.getString(5);
        data.metadata = rs.getString(6);
        data.modMetadata = rs.getInt(7);
        data.dateChanged = rs.getInt(8);
        data.modContent = rs.getInt(9);
        if (data.parentId <= 0) {
            data.parentId = -1;
        }
        if (data.dateChanged == 0) {
            data.dateChanged = -1;
        }
        return data;
    }

    public static MailItem.UnderlyingData getCalendarItem(Mailbox mbox, String uid) throws ServiceException {
        MailItem.UnderlyingData underlyingData;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            DbPool.Connection conn = mbox.getOperationConnection();
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getCalendarItemTableName(mbox, "ci") + ", " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE ci.uid = ? AND mi.id = ci.item_id AND mi.type IN " + CALENDAR_TYPES + (DebugConfig.disableMailboxGroups ? "" : " AND ci.mailbox_id = ? AND mi.mailbox_id = ci.mailbox_id"));
            int pos = 1;
            stmt.setString(pos++, uid);
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            rs = stmt.executeQuery();
            if (!rs.next()) break block6;
            MailItem.UnderlyingData underlyingData2 = DbMailItem.constructItem(rs);
            Object var8_9 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return underlyingData2;
        }
        try {
            underlyingData = null;
            Object var8_10 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching calendar items for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return underlyingData;
    }

    public static List<MailItem.UnderlyingData> getCalendarItems(Mailbox mbox, byte type, long start, long end, int folderId, int[] excludeFolderIds) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> arrayList;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbMailItem.calendarItemStatement(conn, DB_FIELDS, mbox, type, start, end, folderId, excludeFolderIds);
            rs = stmt.executeQuery();
            ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
            while (rs.next()) {
                result.add(DbMailItem.constructItem(rs));
            }
            arrayList = result;
            Object var14_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching calendar items for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static List<MailItem.UnderlyingData> getCalendarItems(Mailbox mbox, List<String> uids) throws ServiceException {
        ArrayList<MailItem.UnderlyingData> i2;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<MailItem.UnderlyingData> result = new ArrayList<MailItem.UnderlyingData>();
        try {
            for (int i2 = 0; i2 < uids.size(); i2 += Db.getINClauseBatchSize()) {
                int count = Math.min(Db.getINClauseBatchSize(), uids.size() - i2);
                stmt = conn.prepareStatement("UPDATE " + DbMailItem.getMailItemTableName(mbox) + " SET index_id = id" + " WHERE " + IN_THIS_MAILBOX_AND + DbUtil.whereIn("id", count));
                stmt = conn.prepareStatement("SELECT mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getCalendarItemTableName(mbox, "ci") + ", " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE mi.id = ci.item_id AND mi.type IN " + CALENDAR_TYPES + (DebugConfig.disableMailboxGroups ? "" : " AND ci.mailbox_id = ? AND mi.mailbox_id = ci.mailbox_id") + " AND " + DbUtil.whereIn("ci.uid", count));
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                for (int index = i2; index < i2 + count; ++index) {
                    stmt.setString(pos++, uids.get(index));
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    result.add(DbMailItem.constructItem(rs));
                }
                stmt.close();
                stmt = null;
            }
            i2 = result;
            Object var11_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("fetching calendar items for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return i2;
    }

    public static TypedIdList listCalendarItems(Mailbox mbox, byte type, long start, long end, int folderId, int[] excludeFolderIds) throws ServiceException {
        TypedIdList typedIdList;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbMailItem.calendarItemStatement(conn, "mi.id, mi.type", mbox, type, start, end, folderId, excludeFolderIds);
            rs = stmt.executeQuery();
            TypedIdList result = new TypedIdList();
            while (rs.next()) {
                result.add(rs.getByte(2), rs.getInt(1));
            }
            typedIdList = result;
            Object var14_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("listing calendar items for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return typedIdList;
    }

    private static PreparedStatement calendarItemStatement(DbPool.Connection conn, String fields, Mailbox mbox, byte type, long start, long end, int folderId, int[] excludeFolderIds) throws SQLException {
        boolean folderSpecified = folderId != -1;
        String endConstraint = end > 0L ? " AND ci.start_time < ?" : "";
        String startConstraint = start > 0L ? " AND ci.end_time > ?" : "";
        String typeConstraint = type == -1 ? "type IN (11,15)" : DbMailItem.typeIn(type);
        String excludeFolderPart = "";
        if (excludeFolderIds != null && excludeFolderIds.length > 0) {
            excludeFolderPart = " AND " + DbUtil.whereNotIn("folder_id", excludeFolderIds.length);
        }
        PreparedStatement stmt = conn.prepareStatement("SELECT " + fields + " FROM " + DbMailItem.getCalendarItemTableName(mbox, "ci") + ", " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE mi.id = ci.item_id" + endConstraint + startConstraint + " AND mi." + typeConstraint + (DebugConfig.disableMailboxGroups ? "" : " AND ci.mailbox_id = ? AND mi.mailbox_id = ci.mailbox_id") + (folderSpecified ? " AND folder_id = ?" : "") + excludeFolderPart);
        int pos = 1;
        if (end > 0L) {
            stmt.setTimestamp(pos++, new Timestamp(end));
        }
        if (start > 0L) {
            stmt.setTimestamp(pos++, new Timestamp(start));
        }
        pos = DbMailItem.setMailboxId(stmt, mbox, pos);
        if (folderSpecified) {
            stmt.setInt(pos++, folderId);
        }
        if (excludeFolderIds != null) {
            for (int id : excludeFolderIds) {
                stmt.setInt(pos++, id);
            }
        }
        return stmt;
    }

    public static List<Integer> getItemListByDates(Mailbox mbox, byte type, long start, long end, int folderId, boolean descending) throws ServiceException {
        ArrayList<Integer> arrayList;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        boolean allTypes = type == -1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String typeConstraint = allTypes ? "" : "type = ? AND ";
            stmt = conn.prepareStatement("SELECT id FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + IN_THIS_MAILBOX_AND + typeConstraint + "folder_id = ?" + " AND date > ? AND date < ?" + " ORDER BY date" + (descending ? " DESC" : ""));
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            if (!allTypes) {
                stmt.setByte(pos++, type);
            }
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, (int)(start / 1000L));
            stmt.setInt(pos++, (int)(end / 1000L));
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            arrayList = result;
            Object var17_15 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("finding items between dates", e);
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return arrayList;
    }

    public static void addToCalendarItemTable(CalendarItem calItem) throws ServiceException {
        Mailbox mbox = calItem.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        long end = calItem.getEndTime();
        Timestamp startTs = new Timestamp(calItem.getStartTime());
        Timestamp endTs = new Timestamp(end <= 0L ? MAX_DATE : end);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement("INSERT INTO " + DbMailItem.getCalendarItemTableName(mbox) + " (" + mailbox_id + "uid, item_id, start_time, end_time)" + " VALUES (" + (DebugConfig.disableMailboxGroups ? "" : "?, ") + "?, ?, ?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, calItem.getUid());
                stmt.setInt(pos++, calItem.getId());
                stmt.setTimestamp(pos++, startTs);
                stmt.setTimestamp(pos++, endTs);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("writing invite to calendar item table: UID=" + calItem.getUid(), e);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateInCalendarItemTable(CalendarItem calItem) throws ServiceException {
        Mailbox mbox = calItem.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        long end = calItem.getEndTime();
        Timestamp startTs = new Timestamp(calItem.getStartTime());
        Timestamp endTs = new Timestamp(end <= 0L ? MAX_DATE : end);
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        try {
            try {
                String command = Db.supports(Db.Capability.REPLACE_INTO) ? "REPLACE" : "INSERT";
                String mailbox_id = DebugConfig.disableMailboxGroups ? "" : "mailbox_id, ";
                stmt = conn.prepareStatement(command + " INTO " + DbMailItem.getCalendarItemTableName(mbox) + " (" + mailbox_id + "uid, item_id, start_time, end_time)" + " VALUES (" + MAILBOX_ID_VALUE + "?, ?, ?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setString(pos++, calItem.getUid());
                stmt.setInt(pos++, calItem.getId());
                stmt.setTimestamp(pos++, startTs);
                stmt.setTimestamp(pos++, endTs);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (!Db.errorMatches(e, Db.Error.DUPLICATE_ROW)) throw ServiceException.FAILURE("writing invite to calendar item table " + calItem.getUid(), e);
                try {
                    DbPool.closeStatement(stmt);
                    stmt = conn.prepareStatement("UPDATE " + DbMailItem.getCalendarItemTableName(mbox) + " SET item_id = ?, start_time = ?, end_time = ? WHERE " + IN_THIS_MAILBOX_AND + "uid = ?");
                    int pos = 1;
                    stmt.setInt(pos++, calItem.getId());
                    stmt.setTimestamp(pos++, startTs);
                    stmt.setTimestamp(pos++, endTs);
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setString(pos++, calItem.getUid());
                    stmt.executeUpdate();
                }
                catch (SQLException nested) {
                    throw ServiceException.FAILURE("updating data in calendar item table " + calItem.getUid(), nested);
                }
                Object var12_14 = null;
                DbPool.closeStatement(stmt);
                return;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
    }

    public static List<CalendarItem.CalendarMetadata> getCalendarItemMetadata(Folder folder, long start, long end) throws ServiceException {
        Mailbox mbox = folder.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<CalendarItem.CalendarMetadata> result = new ArrayList<CalendarItem.CalendarMetadata>();
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String startConstraint = start > 0L ? " AND ci.end_time > ?" : "";
                String endConstraint = end > 0L ? " AND ci.start_time < ?" : "";
                String folderConstraint = " AND mi.folder_id = ?";
                stmt = conn.prepareStatement("SELECT mi.mailbox_id, mi.id, ci.uid, mi.mod_metadata, mi.mod_content, ci.start_time, ci.end_time FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + ", " + DbMailItem.getCalendarItemTableName(mbox, "ci") + " WHERE mi.mailbox_id = ci.mailbox_id AND mi.id = ci.item_id" + (DebugConfig.disableMailboxGroups ? "" : " AND mi.mailbox_id = ? ") + startConstraint + endConstraint + folderConstraint);
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                if (start > 0L) {
                    stmt.setTimestamp(pos++, new Timestamp(start));
                }
                if (end > 0L) {
                    stmt.setTimestamp(pos++, new Timestamp(end));
                }
                stmt.setInt(pos++, folder.getId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    result.add(new CalendarItem.CalendarMetadata(rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getTimestamp(6).getTime(), rs.getTimestamp(7).getTime()));
                }
                Object var15_13 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("fetching CalendarItem Metadata for mbox " + mbox.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return result;
    }

    public static void consistencyCheck(MailItem item, MailItem.UnderlyingData data, String metadata) throws ServiceException {
        if (item.getId() <= 0) {
            return;
        }
        Mailbox mbox = item.getMailbox();
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        DbPool.Connection conn = mbox.getOperationConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement("SELECT mi.sender, mi.id, mi.type, mi.parent_id, mi.folder_id, mi.index_id, mi.imap_id, mi.date, mi.size, mi.volume_id, mi.blob_digest, mi.unread, mi.flags, mi.tags, mi.subject, mi.name, mi.metadata, mi.mod_metadata, mi.change_date, mi.mod_content FROM " + DbMailItem.getMailItemTableName(mbox, "mi") + " WHERE " + IN_THIS_MAILBOX_AND + "id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, item.getId());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw ServiceException.FAILURE("consistency check failed: " + MailItem.getNameForType(item) + " " + item.getId() + " not found in DB", null);
                }
                MailItem.UnderlyingData dbdata = DbMailItem.constructItem(rs, 1);
                String dbsender = rs.getString(1);
                String dataBlobDigest = data.getBlobDigest();
                String dbdataBlobDigest = dbdata.getBlobDigest();
                String dataSender = item.getSortSender();
                String dbdataSender = dbsender == null ? "" : dbsender;
                String failures = "";
                if (data.id != dbdata.id) {
                    failures = failures + " ID";
                }
                if (data.type != dbdata.type) {
                    failures = failures + " TYPE";
                }
                if (data.folderId != dbdata.folderId) {
                    failures = failures + " FOLDER_ID";
                }
                if (data.indexId != dbdata.indexId) {
                    failures = failures + " INDEX_ID";
                }
                if (data.imapId != dbdata.imapId) {
                    failures = failures + " IMAP_ID";
                }
                if (data.locator != dbdata.locator) {
                    failures = failures + " VOLUME_ID";
                }
                if (data.date != dbdata.date) {
                    failures = failures + " DATE";
                }
                if (data.size != dbdata.size) {
                    failures = failures + " SIZE";
                }
                if (dbdata.type != 4) {
                    if (data.unreadCount != dbdata.unreadCount) {
                        failures = failures + " UNREAD";
                    }
                    if (data.flags != dbdata.flags) {
                        failures = failures + " FLAGS";
                    }
                    if (data.tags != dbdata.tags) {
                        failures = failures + " TAGS";
                    }
                }
                if (data.modMetadata != dbdata.modMetadata) {
                    failures = failures + " MOD_METADATA";
                }
                if (data.dateChanged != dbdata.dateChanged) {
                    failures = failures + " CHANGE_DATE";
                }
                if (data.modContent != dbdata.modContent) {
                    failures = failures + " MOD_CONTENT";
                }
                if (Math.max(data.parentId, -1) != dbdata.parentId) {
                    failures = failures + " PARENT_ID";
                }
                if (!(dataBlobDigest == dbdataBlobDigest || dataBlobDigest != null && dataBlobDigest.equals(dbdataBlobDigest))) {
                    failures = failures + " BLOB_DIGEST";
                }
                if (!(dataSender == dbdataSender || dataSender != null && dataSender.equalsIgnoreCase(dbdataSender))) {
                    failures = failures + " SENDER";
                }
                if (!(data.subject == dbdata.subject || data.subject != null && data.subject.equals(dbdata.subject))) {
                    failures = failures + " SUBJECT";
                }
                if (!(data.name == dbdata.name || data.name != null && data.name.equals(dbdata.name))) {
                    failures = failures + " NAME";
                }
                if (!(metadata == dbdata.metadata || metadata != null && metadata.equals(dbdata.metadata))) {
                    failures = failures + " METADATA";
                }
                if (item instanceof Folder && dbdata.folderId != dbdata.parentId) {
                    failures = failures + " FOLDER!=PARENT";
                }
                if (!failures.equals("")) {
                    throw ServiceException.FAILURE("consistency check failed: " + MailItem.getNameForType(item) + " " + item.getId() + " differs from DB at" + failures, null);
                }
                Object var16_16 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("fetching item " + item.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
    }

    public static String checkSenderLength(String sender) {
        if (sender == null || sender.length() <= 128) {
            return sender;
        }
        return sender.substring(0, 128);
    }

    public static String checkSubjectLength(String subject) throws ServiceException {
        if (subject == null || subject.length() <= 1024) {
            return subject;
        }
        throw ServiceException.FAILURE("subject too long", null);
    }

    public static String checkMetadataLength(String metadata) throws ServiceException {
        if (metadata == null) {
            return null;
        }
        int len = metadata.length();
        if (len > 0x400000) {
            if (StringUtil.isAsciiString(metadata)) {
                if (len > 0x1000000) {
                    throw ServiceException.FAILURE("metadata too long", null);
                }
            } else {
                try {
                    if (metadata.getBytes("utf-8").length > 0x1000000) {
                        throw ServiceException.FAILURE("metadata too long", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return metadata;
    }

    public static String getMailItemTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_MAIL_ITEM);
    }

    public static String getMailItemTableName(MailItem item) {
        return DbMailbox.qualifyTableName(item.getMailbox(), TABLE_MAIL_ITEM);
    }

    public static String getMailItemTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_MAIL_ITEM);
    }

    public static String getMailItemTableName(Mailbox mbox, String alias) {
        return DbMailItem.getMailItemTableName(mbox) + " AS " + alias;
    }

    public static String getRevisionTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_REVISION);
    }

    public static String getRevisionTableName(MailItem item) {
        return DbMailbox.qualifyTableName(item.getMailbox(), TABLE_REVISION);
    }

    public static String getRevisionTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_REVISION);
    }

    public static String getRevisionTableName(Mailbox mbox, String alias) {
        return DbMailItem.getRevisionTableName(mbox) + " AS " + alias;
    }

    public static String getCalendarItemTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_APPOINTMENT);
    }

    public static String getCalendarItemTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_APPOINTMENT);
    }

    public static String getCalendarItemTableName(Mailbox mbox, String alias) {
        return DbMailItem.getCalendarItemTableName(mbox) + " AS " + alias;
    }

    public static String getConversationTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_OPEN_CONVERSATION);
    }

    public static String getConversationTableName(MailItem item) {
        return DbMailbox.qualifyTableName(item.getMailbox(), TABLE_OPEN_CONVERSATION);
    }

    public static String getConversationTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_OPEN_CONVERSATION);
    }

    public static String getConversationTableName(Mailbox mbox, String alias) {
        return DbMailItem.getConversationTableName(mbox) + " AS " + alias;
    }

    public static String getTombstoneTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_TOMBSTONE);
    }

    public static String getTombstoneTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_TOMBSTONE);
    }

    public static Object getSynchronizer(Mailbox mbox) {
        return Db.supports(Db.Capability.ROW_LEVEL_LOCKING) ? new Object() : mbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areTagsetsLoaded(Mailbox mbox) {
        Map<Long, TagsetCache> map = sTagsetCache;
        synchronized (map) {
            return sTagsetCache.containsKey(mbox.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TagsetCache getTagsetCache(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        long mailboxId = mbox.getId();
        Long id = new Long(mailboxId);
        TagsetCache tagsets = null;
        Map<Long, TagsetCache> map = sTagsetCache;
        synchronized (map) {
            tagsets = sTagsetCache.get(id);
        }
        if (tagsets == null) {
            ZimbraLog.cache.info("Loading tagset cache");
            tagsets = new TagsetCache("Mailbox " + mailboxId + " tags");
            tagsets.addTagsets(DbMailbox.getDistinctTagsets(conn, mbox));
            map = sTagsetCache;
            synchronized (map) {
                sTagsetCache.put(id, tagsets);
            }
        }
        return tagsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areFlagsetsLoaded(Mailbox mbox) {
        Map<Long, TagsetCache> map = sFlagsetCache;
        synchronized (map) {
            return sFlagsetCache.containsKey(mbox.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TagsetCache getFlagsetCache(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        long mailboxId = mbox.getId();
        Long id = new Long(mailboxId);
        TagsetCache flagsets = null;
        Map<Long, TagsetCache> map = sFlagsetCache;
        synchronized (map) {
            flagsets = sFlagsetCache.get(id);
        }
        if (flagsets == null) {
            ZimbraLog.cache.info("Loading flagset cache");
            flagsets = new TagsetCache("Mailbox " + mailboxId + " flags");
            flagsets.addTagsets(DbMailbox.getDistinctFlagsets(conn, mbox));
            map = sFlagsetCache;
            synchronized (map) {
                sFlagsetCache.put(id, flagsets);
            }
        }
        return flagsets;
    }

    private static String getIdListForLogging(Collection<Integer> ids) {
        if (ids == null) {
            return null;
        }
        StringBuilder idList = new StringBuilder();
        boolean firstTime = true;
        for (Integer id : ids) {
            if (firstTime) {
                firstTime = false;
            } else {
                idList.append(',');
            }
            idList.append(id);
            if (idList.length() <= 200) continue;
            idList.append("...");
            break;
        }
        return idList.toString();
    }

    public static class LocationCount {
        public int count;
        public long size;

        public LocationCount(int c, long sz) {
            this.count = c;
            this.size = sz;
        }

        public LocationCount(LocationCount lc) {
            this.count = lc.count;
            this.size = lc.size;
        }

        public LocationCount increment(int c, long sz) {
            this.count += c;
            this.size += sz;
            return this;
        }

        public LocationCount increment(LocationCount lc) {
            this.count += lc.count;
            this.size += lc.size;
            return this;
        }
    }
}

