/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.ImapFolder;
import com.zimbra.cs.datasource.ImapMessage;
import com.zimbra.cs.datasource.ImapMessageCollection;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbImapMessage {
    public static final String TABLE_IMAP_MESSAGE = "imap_message";

    public static void storeImapMessage(Mailbox mbox, int localFolderId, long remoteUid, int localItemId, int flags) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ZimbraLog.datasource.debug("Storing IMAP message tracker: mboxId=%d, localFolderId=%d, remoteUid=%d, localItemId=%d flags=%s", mbox.getId(), localFolderId, remoteUid, localItemId, Flag.bitmaskToFlags(flags));
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("INSERT INTO " + DbImapMessage.getTableName(mbox) + " (" + DbMailItem.MAILBOX_ID + "imap_folder_id, uid, item_id, flags) " + "VALUES (" + DbMailItem.MAILBOX_ID_VALUE + "?, ?, ?, ?)");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, localFolderId);
                stmt.setLong(pos++, remoteUid);
                stmt.setInt(pos++, localItemId);
                stmt.setInt(pos++, flags);
                stmt.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to store IMAP message data", e);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setUid(Mailbox mbox, int itemId, long uid) throws ServiceException {
        DbPool.Connection conn;
        block7: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            ZimbraLog.datasource.debug("Updating IMAP message tracker uid: mboxId=%d, localItemId=%d remoteUid=%x", mbox.getId(), itemId, uid);
            conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = DbPool.getConnection(mbox);
                    stmt = conn.prepareStatement("UPDATE " + DbImapMessage.getTableName(mbox) + " SET uid = ?" + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "item_id = ?");
                    int pos = 1;
                    stmt.setLong(pos++, uid);
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, itemId);
                    stmt.executeUpdate();
                    conn.commit();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("Unable to update IMAP message data", e);
                }
                Object var8_7 = null;
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (stmt != null) {
                    DbPool.closeStatement(stmt);
                }
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
        }
        DbPool.quietClose(conn);
    }

    public static long getMinUid(Mailbox mbox, int folderId) throws ServiceException {
        return DbImapMessage.getMinMaxUid(mbox, folderId, "min");
    }

    public static long getMaxUid(Mailbox mbox, int folderId) throws ServiceException {
        return DbImapMessage.getMinMaxUid(mbox, folderId, "max");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getMinMaxUid(Mailbox mbox, int folderId, String minmax) throws ServiceException {
        ZimbraLog.datasource.debug("Getting %s IMAP uid: mboxId=%d, folderId=%d", minmax, mbox.getId(), folderId);
        Object object = DbImapMessage.getSynchronizer(mbox);
        synchronized (object) {
            long l;
            DbPool.Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DbPool.getConnection();
                    stmt = conn.prepareStatement(String.format("SELECT %s FROM %s WHERE mailbox_id = %d AND imap_folder_id = %d AND uid > 0", minmax, DbImapMessage.getTableName(mbox), mbox.getId(), folderId));
                    rs = stmt.executeQuery();
                    l = rs.next() ? rs.getLong(1) : -1L;
                    Object var10_9 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("Unable to execute query", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setFlags(Mailbox mbox, int itemId, int flags) throws ServiceException {
        DbPool.Connection conn;
        block7: {
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
            ZimbraLog.datasource.debug("Updating IMAP message tracker flags: mboxId=%d, localItemId=%d flags=%s", mbox.getId(), itemId, Flag.bitmaskToFlags(flags));
            conn = null;
            PreparedStatement stmt = null;
            try {
                try {
                    conn = DbPool.getConnection(mbox);
                    stmt = conn.prepareStatement("UPDATE " + DbImapMessage.getTableName(mbox) + " SET flags = ?" + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "item_id = ?");
                    int pos = 1;
                    stmt.setInt(pos++, flags);
                    pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                    stmt.setInt(pos++, itemId);
                    stmt.executeUpdate();
                    conn.commit();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("Unable to update IMAP message data", e);
                }
                Object var7_7 = null;
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (stmt != null) {
                    DbPool.closeStatement(stmt);
                }
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.closeStatement(stmt);
        }
        DbPool.quietClose(conn);
    }

    public static void deleteImapMessage(Mailbox mbox, int localFolderId, int localItemId) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ZimbraLog.datasource.debug("Deleting IMAP message tracker: mboxId=%d, localFolderId=%d, msgId=%d", mbox.getId(), localFolderId, localItemId);
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("DELETE FROM " + DbImapMessage.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "imap_folder_id = ? AND item_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, localFolderId);
                stmt.setInt(pos++, localItemId);
                stmt.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to delete IMAP message data", e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
    }

    public static void deleteImapMessages(Mailbox mbox, int localFolderId) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ZimbraLog.datasource.debug("Deleting all IMAP message trackers: mboxId=%d, localFolderId=%d", mbox.getId(), localFolderId);
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("DELETE FROM " + DbImapMessage.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "imap_folder_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, localFolderId);
                stmt.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to delete IMAP message data", e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
    }

    public static int getLocalMessageId(Mailbox mbox, int localFolderId, long remoteUid) throws ServiceException {
        int n;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ZimbraLog.datasource.debug("Getting local message id for tracked message: mboxId=%d, localFolderId=%d, remoteUid=%d", mbox.getId(), localFolderId, remoteUid);
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DbPool.getConnection(mbox);
            stmt = conn.prepareStatement("SELECT item_id FROM " + DbImapMessage.getTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + "imap_folder_id = ? AND uid = ?");
            int pos = 1;
            pos = DbMailItem.setMailboxId(stmt, mbox, pos);
            stmt.setInt(pos++, localFolderId);
            stmt.setLong(pos++, remoteUid);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : 0;
            Object var10_9 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("Unable to get IMAP message data", e);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
        }
        DbPool.quietClose(conn);
        return n;
    }

    /*
     * Exception decompiling
     */
    public static Pair<ImapMessage, Integer> getImapMessage(Mailbox mbox, DataSource ds, int itemId) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ImapMessage> getMovedMessages(Mailbox mbox, DataSource ds, int folderId) throws ServiceException {
        ArrayList<ImapMessage> msgs = new ArrayList<ImapMessage>();
        Object object = DbImapMessage.getSynchronizer(mbox);
        synchronized (object) {
            DbPool.Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DbPool.getConnection();
                    stmt = conn.prepareStatement(String.format("SELECT imap.uid, imap.item_id, imap.flags as tflags, mi.unread, mi.flags  FROM %s imap JOIN %s mi  ON imap.mailbox_id = mi.mailbox_id AND imap.item_id = mi.id  WHERE imap.mailbox_id = %d AND imap.imap_folder_id = %d AND mi.folder_id != %d", DbImapMessage.getTableName(mbox), DbMailItem.getMailItemTableName(mbox), mbox.getId(), folderId, folderId));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        long uid = rs.getLong("uid");
                        int itemId = rs.getInt("item_id");
                        int flags = rs.getInt("flags");
                        int unread = rs.getInt("unread");
                        int tflags = rs.getInt("tflags");
                        flags = unread > 0 ? flags | Flag.BITMASK_UNREAD : flags & ~Flag.BITMASK_UNREAD;
                        msgs.add(new ImapMessage(ds, -1, itemId, tflags, uid, flags));
                    }
                    rs.close();
                    stmt.close();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("Unable to get IMAP message data", e);
                }
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
        }
        return msgs;
    }

    public static ImapMessageCollection getImapMessages(Mailbox mbox, DataSource ds, ImapFolder imapFolder) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ImapMessageCollection imapMessages = new ImapMessageCollection();
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String MBOX_JOIN = DebugConfig.disableMailboxGroups ? "" : "imap.mailbox_id = mi.mailbox_id AND";
                String IN_IMAP_MAILBOX_AND = DebugConfig.disableMailboxGroups ? "" : "imap.mailbox_id = ? AND";
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("SELECT imap.uid, imap.item_id, imap.flags as tflags, mi.unread, mi.flags FROM " + DbImapMessage.getTableName(mbox) + " imap " + "  LEFT OUTER JOIN " + DbMailItem.getMailItemTableName(mbox) + " mi " + "  ON " + MBOX_JOIN + " imap.item_id = mi.id " + "WHERE " + IN_IMAP_MAILBOX_AND + " imap.imap_folder_id = ?");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos++, imapFolder.getItemId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long uid = rs.getLong("uid");
                    int itemId = rs.getInt("item_id");
                    int flags = rs.getInt("flags");
                    int unread = rs.getInt("unread");
                    int tflags = rs.getInt("tflags");
                    flags = unread > 0 ? flags | Flag.BITMASK_UNREAD : flags & ~Flag.BITMASK_UNREAD;
                    imapMessages.add(new ImapMessage(ds, imapFolder.getItemId(), itemId, tflags, uid, flags));
                }
                Object var17_16 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to get IMAP message data", e);
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
        ZimbraLog.datasource.debug("Found %d tracked IMAP messages for %s", imapMessages.size(), imapFolder.getRemoteId());
        return imapMessages;
    }

    public static List<Integer> getNewLocalMessageIds(Mailbox mbox, int folderId) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(mbox));
        ArrayList<Integer> newIds = new ArrayList<Integer>();
        DbPool.Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String MBOX_JOIN = DebugConfig.disableMailboxGroups ? "" : "imap.mailbox_id = mi.mailbox_id AND";
                String IN_MI_MAILBOX_AND = DebugConfig.disableMailboxGroups ? "" : "mi.mailbox_id = ? AND";
                conn = DbPool.getConnection(mbox);
                stmt = conn.prepareStatement("SELECT id FROM " + DbMailItem.getMailItemTableName(mbox) + " mi " + "  LEFT OUTER JOIN " + DbImapMessage.getTableName(mbox) + " imap " + "  ON " + MBOX_JOIN + " imap.item_id = mi.id " + "WHERE " + IN_MI_MAILBOX_AND + " mi.folder_id = ? AND imap.item_id IS NULL " + "AND mi.type IN (" + 5 + ", " + 16 + ")");
                int pos = 1;
                pos = DbMailItem.setMailboxId(stmt, mbox, pos);
                stmt.setInt(pos, folderId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    newIds.add(rs.getInt("id"));
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("Unable to get new local message ids", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            DbPool.quietClose(conn);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        DbPool.quietClose(conn);
        return newIds;
    }

    public static String getTableName(long mailboxId, long groupId) {
        return DbMailbox.qualifyTableName(groupId, TABLE_IMAP_MESSAGE);
    }

    public static String getTableName(Mailbox mbox) {
        return DbMailbox.qualifyTableName(mbox, TABLE_IMAP_MESSAGE);
    }

    private static Object getSynchronizer(Mailbox mbox) {
        return Db.supports(Db.Capability.ROW_LEVEL_LOCKING) ? new Object() : mbox;
    }
}

