/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.mailbox.MailboxManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbConfig {
    private static final String CN_NAME = "name";
    private static final String CN_VALUE = "value";
    private static final String CN_DESCRIPTION = "value";
    private static final String CN_MODIFIED = "modified";
    private static final int CI_NAME = 1;
    private static final int CI_VALUE = 2;
    private static final int CI_DESCRIPTION = 3;
    private static final int CI_MODIFIED = 4;
    private String mDbName;
    private String mDbValue;
    private String mDbDescription;
    private Timestamp mDbModified;

    public static DbConfig set(DbPool.Connection conn, String name, String value) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        Timestamp modified = new Timestamp(System.currentTimeMillis());
        PreparedStatement stmt = null;
        try {
            block5: {
                try {
                    stmt = conn.prepareStatement("UPDATE config SET value = ?, modified = ? WHERE name = ?");
                    stmt.setString(1, value);
                    stmt.setTimestamp(2, modified);
                    stmt.setString(3, name);
                    int numRows = stmt.executeUpdate();
                    if (numRows != 0) break block5;
                    stmt = conn.prepareStatement("INSERT INTO config(name, value, modified) VALUES (?, ?, ?)");
                    stmt.setString(1, name);
                    stmt.setString(2, value);
                    stmt.setTimestamp(3, modified);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("writing config entry: " + name, e);
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeStatement(stmt);
        DbConfig c = new DbConfig();
        c.mDbName = name;
        c.mDbValue = value;
        c.mDbModified = modified;
        return c;
    }

    public static boolean delete(DbPool.Connection conn, String name) throws ServiceException {
        boolean bl;
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM config WHERE name = ?");
            stmt.setString(1, name);
            int num = stmt.executeUpdate();
            bl = num == 1;
            Object var6_6 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("deleting config entry: " + name, e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                DbPool.closeStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeStatement(stmt);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DbConfig get(DbPool.Connection conn, String name) throws ServiceException {
        DbConfig result;
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            DbConfig dbConfig;
            assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
            stmt = null;
            rs = null;
            result = null;
            try {
                try {
                    stmt = conn.prepareStatement("SELECT * FROM config WHERE name = ?");
                    stmt.setString(1, name);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block7;
                    dbConfig = DbConfig.constructConfig(rs);
                    Object var7_7 = null;
                }
                catch (SQLException e) {
                    throw ServiceException.FAILURE("getting config entry: " + name, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                DbPool.closeResults(rs);
                DbPool.closeStatement(stmt);
                throw throwable;
            }
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            return dbConfig;
        }
        Object var7_8 = null;
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return result;
    }

    public static Map<String, DbConfig> getAll(DbPool.Connection conn, Timestamp ts) throws ServiceException {
        assert (Db.supports(Db.Capability.ROW_LEVEL_LOCKING) || Thread.holdsLock(MailboxManager.getInstance()));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, DbConfig> result = new HashMap<String, DbConfig>();
        try {
            try {
                if (ts == null) {
                    stmt = conn.prepareStatement("SELECT * FROM config");
                } else {
                    stmt = conn.prepareStatement("SELECT * FROM config WHERE modified >= ?");
                    stmt.setTimestamp(1, ts);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    DbConfig c = DbConfig.constructConfig(rs);
                    result.put(c.mDbName, c);
                }
                Object var7_7 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting all config entries", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DbPool.closeResults(rs);
            DbPool.closeStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.closeStatement(stmt);
        return result;
    }

    private static DbConfig constructConfig(ResultSet rs) throws SQLException {
        DbConfig c = new DbConfig();
        c.mDbName = rs.getString(1);
        c.mDbValue = rs.getString(2);
        c.mDbDescription = rs.getString(3);
        c.mDbModified = rs.getTimestamp(4);
        return c;
    }

    public String getName() {
        return this.mDbName;
    }

    public String getValue() {
        return this.mDbValue;
    }

    public Timestamp getModified() {
        return this.mDbModified;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("config: {");
        sb.append(CN_NAME).append(": ").append(this.mDbName).append(", ");
        sb.append("value").append(": ").append(this.mDbValue).append(", ");
        sb.append("value").append(": ").append(this.mDbDescription).append(", ");
        sb.append(CN_MODIFIED).append(": ").append(this.mDbModified);
        sb.append("}");
        return sb.toString();
    }
}

