/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbMailItem;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.db.MySQL;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.store.file.BlobConsistencyChecker;
import com.zimbra.cs.store.file.FileBlobStore;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbBlobConsistency {
    public static Collection<BlobConsistencyChecker.BlobInfo> getBlobInfo(DbPool.Connection conn, Mailbox mbox, long minId, long maxId, short volumeId) throws ServiceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BlobConsistencyChecker.BlobInfo> blobs = new ArrayList<BlobConsistencyChecker.BlobInfo>();
        try {
            try {
                stmt = conn.prepareStatement("SELECT id, mod_content, 0, size FROM " + DbMailItem.getMailItemTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + " id BETWEEN " + minId + " AND " + maxId + " AND blob_digest IS NOT NULL " + "AND volume_id = " + volumeId + " UNION " + "SELECT item_id, mod_content, version, size " + "FROM " + DbMailItem.getRevisionTableName(mbox) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + " item_id BETWEEN " + minId + " AND " + maxId + " AND blob_digest IS NOT NULL " + "AND volume_id = " + volumeId);
                if (!DebugConfig.disableMailboxGroups) {
                    stmt.setLong(1, mbox.getId());
                    stmt.setLong(2, mbox.getId());
                }
                Db.getInstance().enableStreaming(stmt);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    BlobConsistencyChecker.BlobInfo info = new BlobConsistencyChecker.BlobInfo();
                    info.itemId = rs.getLong(1);
                    info.modContent = rs.getInt(2);
                    info.version = rs.getInt(3);
                    info.dbSize = rs.getLong(4);
                    info.volumeId = volumeId;
                    info.path = FileBlobStore.getBlobPath(mbox, (int)info.itemId, info.modContent, volumeId);
                    blobs.add(info);
                }
                Object var12_10 = null;
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("getting items with blobs for mailbox " + mbox.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DbPool.closeResults(rs);
            DbPool.quietCloseStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.quietCloseStatement(stmt);
        return blobs;
    }

    public static long getMaxId(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        long l;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT MAX(id) FROM " + DbMailItem.getMailItemTableName(mbox);
            if (!DebugConfig.disableMailboxGroups) {
                sql = sql + " WHERE mailbox_id = " + mbox.getId();
            }
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            rs.next();
            l = rs.getLong(1);
            Object var8_7 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting max id for mailbox " + mbox.getId(), e);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                DbPool.closeResults(rs);
                DbPool.quietCloseStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.quietCloseStatement(stmt);
        return l;
    }

    public static int getNumRows(DbPool.Connection conn, Mailbox mbox, String tableName, String idColName, Collection<Integer> itemIds) throws ServiceException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT COUNT(*) FROM " + DbMailbox.qualifyTableName(mbox, tableName) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + DbUtil.whereIn(idColName, itemIds.size()));
            int i = 1;
            if (!DebugConfig.disableMailboxGroups) {
                stmt.setLong(i++, mbox.getId());
            }
            for (int id : itemIds) {
                stmt.setInt(i++, id);
            }
            rs = stmt.executeQuery();
            rs.next();
            n = rs.getInt(1);
            Object var11_12 = null;
        }
        catch (SQLException e) {
            try {
                throw ServiceException.FAILURE("getting number of rows for matching id's in " + tableName, e);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                DbPool.closeResults(rs);
                DbPool.quietCloseStatement(stmt);
                throw throwable;
            }
        }
        DbPool.closeResults(rs);
        DbPool.quietCloseStatement(stmt);
        return n;
    }

    public static void export(DbPool.Connection conn, Mailbox mbox, String tableName, String idColName, Collection<Integer> itemIds, String path) throws ServiceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (!(Db.getInstance() instanceof MySQL)) {
            throw ServiceException.INVALID_REQUEST("export is only supported for MySQL", null);
        }
        ZimbraLog.sqltrace.info("Exporting %d items in table %s to %s.", itemIds.size(), tableName, path);
        try {
            try {
                stmt = conn.prepareStatement("SELECT * FROM " + DbMailbox.qualifyTableName(mbox, tableName) + " WHERE " + DbMailItem.IN_THIS_MAILBOX_AND + DbUtil.whereIn(idColName, itemIds.size()) + " INTO OUTFILE ?");
                int i = 1;
                if (!DebugConfig.disableMailboxGroups) {
                    stmt.setLong(i++, mbox.getId());
                }
                for (int id : itemIds) {
                    stmt.setInt(i++, id);
                }
                stmt.setString(i++, path);
                rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                throw ServiceException.FAILURE("exporting table " + tableName + " to " + path, e);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            DbPool.closeResults(rs);
            DbPool.quietCloseStatement(stmt);
            throw throwable;
        }
        DbPool.closeResults(rs);
        DbPool.quietCloseStatement(stmt);
    }
}

