/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.db;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.MySQL;
import com.zimbra.cs.mailbox.Mailbox;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.PoolingDataSource;

public abstract class Db {
    private static Db sDatabase;
    private static final int DEFAULT_IN_CLAUSE_BATCH_SIZE = 400;

    public static synchronized Db getInstance() {
        if (sDatabase == null) {
            String className = LC.zimbra_class_database.value();
            if (className != null && !className.equals("")) {
                try {
                    sDatabase = (Db)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    ZimbraLog.system.error((Object)("could not instantiate database configuration '" + className + "'; defaulting to MySQL"), e);
                }
            }
            if (sDatabase == null) {
                sDatabase = new MySQL();
            }
        }
        return sDatabase;
    }

    public static boolean supports(Capability capability) {
        return Db.getInstance().supportsCapability(capability);
    }

    abstract boolean supportsCapability(Capability var1);

    public static boolean errorMatches(SQLException e, Error error) {
        return Db.getInstance().compareError(e, error);
    }

    abstract boolean compareError(SQLException var1, Error var2);

    abstract DbPool.PoolConfig getPoolConfig();

    void startup(PoolingDataSource pool, int poolSize) throws SQLException {
    }

    void shutdown() {
    }

    void postCreate(Connection conn) throws SQLException {
    }

    void postOpen(DbPool.Connection conn) throws SQLException {
    }

    public static void registerDatabaseInterest(DbPool.Connection conn, Mailbox mbox) throws ServiceException {
        try {
            Db.getInstance().registerDatabaseInterest(conn, DbMailbox.getDatabaseName(mbox));
        }
        catch (SQLException e) {
            throw ServiceException.FAILURE("error registering interest in database " + DbMailbox.getDatabaseName(mbox), e);
        }
    }

    void registerDatabaseInterest(DbPool.Connection conn, String dbname) throws SQLException, ServiceException {
    }

    void preClose(DbPool.Connection conn) throws SQLException {
    }

    public abstract boolean databaseExists(DbPool.Connection var1, String var2) throws ServiceException;

    void precreateDatabase(String dbname) {
    }

    void deleteDatabaseFile(String dbname) {
        throw new UnsupportedOperationException("DB is not file-per-database");
    }

    public static String forceIndex(String index) {
        if (index == null || index.trim().equals("")) {
            return "";
        }
        return Db.getInstance().forceIndexClause(index);
    }

    abstract String forceIndexClause(String var1);

    public String scriptCommandDelimiter() {
        return ";";
    }

    protected int getInClauseBatchSize() {
        return 400;
    }

    public static int getINClauseBatchSize() {
        return Db.getInstance().getInClauseBatchSize();
    }

    static String selectBOOLEAN(String clause) {
        if (Db.supports(Capability.BOOLEAN_DATATYPE)) {
            return clause;
        }
        return "CASE WHEN " + clause + " THEN 1 ELSE 0 END";
    }

    static String equalsSTRING(String column) {
        if (Db.supports(Capability.CASE_SENSITIVE_COMPARISON)) {
            return "UPPER(" + column + ") = ?";
        }
        return column + " = ?";
    }

    static String likeSTRING(String column) {
        if (Db.supports(Capability.CASE_SENSITIVE_COMPARISON)) {
            return "UPPER(" + column + ") LIKE ?";
        }
        return column + " LIKE ?";
    }

    static String bitmaskAND(String column) {
        if (Db.supports(Capability.BITWISE_OPERATIONS)) {
            return column + " & ?";
        }
        return "MOD(" + column + " / ?, 2) = 1";
    }

    static String bitmaskAND(String column, long bitmask) {
        if (Db.supports(Capability.BITWISE_OPERATIONS)) {
            return column + " & " + bitmask;
        }
        return "MOD(" + column + " / " + bitmask + ", 2) = 1";
    }

    public void enableStreaming(Statement stmt) throws SQLException {
    }

    public static String clauseIFNULL(String expr1, String expr2) {
        return Db.getInstance().getIFNULLClause(expr1, expr2);
    }

    abstract String getIFNULLClause(String var1, String var2);

    public abstract void flushToDisk();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Capability {
        BITWISE_OPERATIONS,
        BOOLEAN_DATATYPE,
        CASE_SENSITIVE_COMPARISON,
        CAST_AS_BIGINT,
        CLOB_COMPARISON,
        DISABLE_CONSTRAINT_CHECK,
        FILE_PER_DATABASE,
        LIMIT_CLAUSE,
        MULTITABLE_UPDATE,
        ON_DUPLICATE_KEY,
        ON_UPDATE_CASCADE,
        READ_COMMITTED_ISOLATION,
        REPLACE_INTO,
        ROW_LEVEL_LOCKING,
        UNIQUE_NAME_INDEX,
        AVOID_OR_IN_WHERE_CLAUSE,
        REQUEST_UTF8_UNICODE_COLLATION,
        FORCE_INDEX_EVEN_IF_NO_SORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        DEADLOCK_DETECTED,
        DUPLICATE_ROW,
        FOREIGN_KEY_CHILD_EXISTS,
        FOREIGN_KEY_NO_PARENT,
        NO_SUCH_DATABASE,
        NO_SUCH_TABLE;

    }
}

