/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.LockMgr;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;

public class Unlock
extends DavMethod {
    public static final String UNLOCK = "UNLOCK";

    public String getName() {
        return UNLOCK;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        String token = ctxt.getRequest().getHeader("Lock-Token");
        if (token != null) {
            int len = token.length();
            if (token.charAt(0) == '<' && token.charAt(len - 1) == '>') {
                LockMgr.getInstance().deleteLock(ctxt, ctxt.getUri(), token.substring(1, len - 1));
            }
        }
        ctxt.getResponse().setStatus(204);
        ctxt.responseSent();
    }
}

