/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.method.AclReports;
import com.zimbra.cs.dav.service.method.AddressbookMultiget;
import com.zimbra.cs.dav.service.method.AddressbookQuery;
import com.zimbra.cs.dav.service.method.CalendarMultiget;
import com.zimbra.cs.dav.service.method.CalendarQuery;
import com.zimbra.cs.dav.service.method.ExpandProperty;
import com.zimbra.cs.dav.service.method.FreeBusyQuery;
import java.io.IOException;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

public class Report
extends DavMethod {
    public static final String REPORT = "REPORT";
    private static HashMap<QName, DavMethod> sReports = new HashMap();

    public String getName() {
        return REPORT;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        if (!ctxt.hasRequestMessage()) {
            throw new DavException("empty request body", 400, null);
        }
        Document req = ctxt.getRequestMessage();
        Element top = req.getRootElement();
        if (top == null) {
            throw new DavException("empty request body", 400, null);
        }
        QName topName = top.getQName();
        DavMethod report = sReports.get(topName);
        if (report == null) {
            throw new DavException("msg " + top.getName() + " not implemented in REPORT", 400, null);
        }
        if (ctxt.getDepth() != DavContext.Depth.zero) {
            ctxt.getDavResponse().createResponse(ctxt);
        }
        report.handle(ctxt);
        this.sendResponse(ctxt);
    }

    static {
        sReports.put(DavElements.E_CALENDAR_QUERY, new CalendarQuery());
        sReports.put(DavElements.E_CALENDAR_MULTIGET, new CalendarMultiget());
        sReports.put(DavElements.E_FREE_BUSY_QUERY, new FreeBusyQuery());
        sReports.put(DavElements.E_PRINCIPAL_PROPERTY_SEARCH, new AclReports());
        sReports.put(DavElements.E_ACL_PRINCIPAL_PROP_SET, new AclReports());
        sReports.put(DavElements.E_PRINCIPAL_MATCH, new AclReports());
        sReports.put(DavElements.E_PRINCIPAL_SEARCH_PROPERTY_SET, new AclReports());
        sReports.put(DavElements.E_EXPAND_PROPERTY, new ExpandProperty());
        sReports.put(DavElements.CardDav.E_ADDRESSBOOK_QUERY, new AddressbookQuery());
        sReports.put(DavElements.CardDav.E_ADDRESSBOOK_MULTIGET, new AddressbookMultiget());
    }
}

