/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;

public class Put
extends DavMethod {
    public static final String PUT = "PUT";

    public String getName() {
        return PUT;
    }

    public void handle(DavContext ctxt) throws DavException, IOException {
        String user = ctxt.getUser();
        String name = ctxt.getItem();
        if (user == null || name == null) {
            throw new DavException("invalid uri", 406, null);
        }
        Collection col = UrlNamespace.getCollectionAtUrl(ctxt, ctxt.getPath());
        DavResource rs = col.createItem(ctxt, name);
        if (rs.isNewlyCreated()) {
            ctxt.setStatus(201);
        } else {
            ctxt.setStatus(204);
        }
        if (rs.hasEtag()) {
            ctxt.getResponse().setHeader("ETag", rs.getEtag());
        }
    }
}

