/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.property.ResourceProperty;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.DavResponse;
import java.io.IOException;
import java.util.HashSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

public class PropPatch
extends DavMethod {
    public static final String PROPPATCH = "PROPPATCH";

    public String getName() {
        return PROPPATCH;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        if (!ctxt.hasRequestMessage()) {
            throw new DavException("empty request", 400);
        }
        Document req = ctxt.getRequestMessage();
        Element top = req.getRootElement();
        if (!top.getName().equals("propertyupdate")) {
            throw new DavException("msg " + top.getName() + " not allowed in PROPPATCH", 400, null);
        }
        DavResource resource = ctxt.getRequestedResource();
        PropPatch.handlePropertyUpdate(ctxt, top, resource);
        DavResponse resp = ctxt.getDavResponse();
        resp.addResource(ctxt, resource, ctxt.getResponseProp(), false);
        this.sendResponse(ctxt);
    }

    public static void handlePropertyUpdate(DavContext ctxt, Element top, DavResource resource) throws DavException, IOException {
        HashSet<Element> set = new HashSet<Element>();
        HashSet<QName> remove = new HashSet<QName>();
        DavContext.RequestProp rp = new DavContext.RequestProp(true);
        ctxt.setResponseProp(rp);
        for (Object obj : top.elements()) {
            if (!(obj instanceof Element)) continue;
            Element e = (Element)obj;
            boolean isSet = e.getName().equals("set");
            if ((e = e.element(DavElements.E_PROP)) == null) {
                throw new DavException("missing <D:prop> in PROPPATCH", 400, null);
            }
            for (Object propObj : e.elements()) {
                if (!(propObj instanceof Element)) continue;
                Element propElem = (Element)propObj;
                QName propName = propElem.getQName();
                ResourceProperty prop = resource.getProperty(propName);
                if (prop == null || !prop.isProtected()) {
                    if (isSet) {
                        set.add(propElem);
                    } else {
                        remove.add(propName);
                    }
                    rp.addProp(propElem);
                    continue;
                }
                rp.addPropError(propName, new DavException.CannotModifyProtectedProperty(propName));
            }
        }
        resource.patchProperties(ctxt, set, remove);
    }
}

