/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.service.DavMethod;
import com.zimbra.cs.dav.service.DavResponse;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.Element;

public class PropFind
extends DavMethod {
    public static final String PROPFIND = "PROPFIND";

    public String getName() {
        return PROPFIND;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        Document req;
        Element top;
        if (ctxt.hasRequestMessage() && !(top = (req = ctxt.getRequestMessage()).getRootElement()).getName().equals("propfind")) {
            throw new DavException("msg " + top.getName() + " not allowed in PROPFIND", 400, null);
        }
        DavContext.RequestProp reqProp = ctxt.getRequestProp();
        DavResponse resp = ctxt.getDavResponse();
        if (ctxt.getDepth() == DavContext.Depth.one) {
            resp.addResources(ctxt, ctxt.getAllRequestedResources(), reqProp);
        } else {
            DavResource resource = ctxt.getRequestedResource();
            resp.addResource(ctxt, resource, reqProp, false);
        }
        this.sendResponse(ctxt);
    }
}

