/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav.service.method;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.dav.DavContext;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.resource.Collection;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavMethod;
import java.io.IOException;

public class Post
extends DavMethod {
    public static final String POST = "POST";

    public String getName() {
        return POST;
    }

    public void handle(DavContext ctxt) throws DavException, IOException, ServiceException {
        DavResource rs;
        block4: {
            String user = ctxt.getUser();
            String name = ctxt.getItem();
            if (user == null || name == null) {
                throw new DavException("invalid uri", 404);
            }
            rs = null;
            try {
                rs = ctxt.getRequestedResource();
            }
            catch (DavException e) {
                Collection parent = UrlNamespace.getCollectionAtUrl(ctxt, ctxt.getPath());
                if (parent.getUri() != "/") break block4;
                String item = ctxt.getItem();
                if (item.equals("outbox")) {
                    item = "sent";
                }
                rs = UrlNamespace.getResourceAt(ctxt, user, item);
            }
        }
        rs.handlePost(ctxt);
        this.sendResponse(ctxt);
    }
}

